/*
 * Decompiled with CFR 0.152.
 */
package banner.util;

import banner.util.UnmodifiableArraySet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Index<K, V> {
    public static final int defaultInitialMapCapacity = 128;
    public static final float defaultMapLoadFactor = 0.75f;
    public static final int initialSetCapacity = 16;
    public static final float initialSetLoadFactor = 0.75f;
    private Map<K, Set<V>> index;
    private boolean packed;

    public Index() {
        this(128, 0.75f);
    }

    public Index(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public Index(int initialCapacity, float loadFactor) {
        this.index = new HashMap<K, Set<V>>(initialCapacity, loadFactor);
        this.packed = false;
    }

    public void add(K[] keys, V value) {
        for (int i = 0; i < keys.length; ++i) {
            this.add(keys[i], value);
        }
    }

    public void add(K key, V value) {
        if (this.packed) {
            throw new UnsupportedOperationException("Cannot add to a packed Index");
        }
        if (key == null) {
            throw new NullPointerException("Cannot add a null key");
        }
        if (value == null) {
            throw new NullPointerException("Cannot add a null value");
        }
        Set<V> lookupSet = this.index.get(key);
        if (lookupSet == null) {
            lookupSet = new HashSet<V>(16, 0.75f);
        }
        lookupSet.add(value);
        this.index.put(key, lookupSet);
    }

    public Set<V> lookup(K key) {
        if (!this.packed) {
            this.pack();
        }
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        return this.index.get(key);
    }

    public int numKeys() {
        return this.index.size();
    }

    public Set<K> keySet() {
        if (!this.packed) {
            this.pack();
        }
        return this.index.keySet();
    }

    public void pack() {
        this.index = new HashMap<K, Set<Set<V>>>(this.index);
        for (K key : this.index.keySet()) {
            this.index.put(key, new UnmodifiableArraySet<V>(this.index.get(key)));
        }
        this.packed = true;
    }

    public void printStats() {
        int max = Integer.MIN_VALUE;
        int min = Integer.MAX_VALUE;
        int sum = 0;
        Iterator<K> i = this.index.keySet().iterator();
        while (i.hasNext()) {
            int size = this.lookup(i.next()).size();
            sum += size;
            max = Math.max(max, size);
            min = Math.min(min, size);
        }
        System.out.println("\tNumber of keys: " + this.index.size());
        System.out.println("\tMaximum set size: " + max);
        System.out.println("\tAverage set size: " + (double)sum / (double)this.index.size());
        System.out.println("\tMinimum set size: " + min);
    }
}

