/*
 * Decompiled with CFR 0.152.
 */
package banner.types;

import banner.tagging.TagFormat;
import banner.tagging.TagPosition;
import banner.types.EntityIdentification;
import banner.types.EntityType;
import banner.types.Mention;
import banner.types.Token;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Sentence {
    private String sentenceId;
    private String documentId;
    private String text;
    private List<Token> tokens;
    private List<Mention> mentions;
    private Map<Mention, EntityIdentification> identifications;

    public Sentence(String sentenceId, String documentId, String text) {
        if (sentenceId == null) {
            throw new IllegalArgumentException("sentenceId cannot be null");
        }
        this.sentenceId = sentenceId;
        this.documentId = documentId;
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        if ((text = text.trim()).length() == 0) {
            throw new IllegalArgumentException("Text must have length greater than 0");
        }
        this.text = text;
        this.tokens = new ArrayList<Token>();
        this.mentions = new ArrayList<Mention>();
        this.identifications = new HashMap<Mention, EntityIdentification>();
    }

    public void addToken(Token token) {
        if (!token.getSentence().equals(this)) {
            throw new IllegalArgumentException();
        }
        if (!this.tokens.contains(token)) {
            this.tokens.add(token);
        }
    }

    public int countWhitespace(int index) {
        int count = 0;
        index = Math.min(index, this.text.length());
        for (int i = 0; i < index; ++i) {
            if (!Character.isWhitespace(this.text.charAt(i))) continue;
            ++count;
        }
        return count;
    }

    public boolean addMention(Mention mention) {
        if (!mention.getSentence().equals(this)) {
            throw new IllegalArgumentException();
        }
        for (Mention previous : this.mentions) {
            if (!previous.equals(mention) || mention.getProbability() == null) continue;
            if (previous.getProbability() == null || mention.getProbability() > previous.getProbability()) {
                previous.setProbability(mention.getProbability());
            }
            return false;
        }
        return this.mentions.add(mention);
    }

    public boolean removeMention(Mention mention) {
        return this.mentions.remove(mention);
    }

    public void addMentions(List<String> tags, double probability) {
        int size = tags.size();
        if (size != this.tokens.size()) {
            throw new IllegalArgumentException();
        }
        int startIndex = -1;
        EntityType lastType = null;
        EntityType currentType = null;
        for (int i = 0; i < size; ++i) {
            Mention mention;
            String[] split = tags.get(i).split("-");
            TagPosition position = TagPosition.valueOf(split[0]);
            lastType = currentType;
            if (split.length == 2) {
                currentType = EntityType.getType(split[1]);
            }
            if (split.length > 2) {
                throw new IllegalArgumentException("Bad tag: " + tags.get(i));
            }
            if (position == TagPosition.O) {
                if (startIndex != -1) {
                    mention = new Mention(this, startIndex, i, lastType, Mention.MentionType.Found, probability);
                    this.addMention(mention);
                }
                startIndex = -1;
                continue;
            }
            if (position == TagPosition.B) {
                if (startIndex != -1) {
                    mention = new Mention(this, startIndex, i, lastType, Mention.MentionType.Found, probability);
                    this.addMention(mention);
                }
                startIndex = i;
                continue;
            }
            if (position == TagPosition.W) {
                if (startIndex != -1) {
                    mention = new Mention(this, startIndex, i, lastType, Mention.MentionType.Found, probability);
                    this.addMention(mention);
                }
                startIndex = i;
                continue;
            }
            if (startIndex != -1) continue;
            startIndex = i;
        }
        if (startIndex != -1) {
            Mention mention = new Mention(this, startIndex, size, currentType, Mention.MentionType.Found, probability);
            this.addMention(mention);
        }
    }

    public String getSentenceId() {
        return this.sentenceId;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public String getText() {
        return this.text;
    }

    public int getTokenIndex(int charIndex, boolean returnNextIfBoundary) {
        int startToken = -1;
        int endToken = -1;
        for (int i = 0; i < this.tokens.size(); ++i) {
            Token token = this.tokens.get(i);
            if (token.getStart() <= charIndex && (startToken == -1 || this.tokens.get(startToken).getStart() <= token.getStart())) {
                startToken = i;
            }
            if (token.getEnd() <= charIndex || endToken != -1 && this.tokens.get(endToken).getEnd() <= token.getEnd()) continue;
            endToken = i;
        }
        if (returnNextIfBoundary) {
            return startToken;
        }
        return endToken;
    }

    public String getText(int start, int end) {
        return this.text.substring(start, end);
    }

    public List<Token> getTokens() {
        return Collections.unmodifiableList(this.tokens);
    }

    public List<Mention> getMentions() {
        return Collections.unmodifiableList(this.mentions);
    }

    public List<Mention> getMentions(Mention.MentionType mentionType) {
        ArrayList<Mention> mentions2 = new ArrayList<Mention>();
        for (Mention mention : this.mentions) {
            if (!mention.getMentionType().equals((Object)mentionType)) continue;
            mentions2.add(mention);
        }
        return Collections.unmodifiableList(mentions2);
    }

    public List<String> getTokenLabels(TagFormat format, Set<Mention.MentionType> mentionTypes, OverlapOption sameType, OverlapOption differentType) {
        ArrayList<String> labels = new ArrayList<String>();
        if (sameType.equals((Object)OverlapOption.Exception)) {
            if (!differentType.equals((Object)OverlapOption.Exception)) {
                throw new IllegalArgumentException("Not implemented");
            }
            for (int i = 0; i < this.tokens.size(); ++i) {
                List<Mention> tokenMentions = this.getMentions(this.tokens.get(i), mentionTypes);
                if (tokenMentions.size() == 0) {
                    labels.add(TagPosition.O.name());
                    continue;
                }
                if (tokenMentions.size() == 1) {
                    labels.add(TagPosition.getPositionText(format, tokenMentions.get(0), i));
                    continue;
                }
                throw new IllegalArgumentException("Sentence " + this.sentenceId + " contains overlapping mentions");
            }
        } else if (sameType.equals((Object)OverlapOption.Union)) {
            if (!differentType.equals((Object)OverlapOption.Exception)) {
                throw new IllegalArgumentException("Not implemented");
            }
            Sentence union = this.copy(true, true);
            HashSet<Mention> handledMentions = new HashSet<Mention>();
            HashSet<Mention> unhandledMentions = new HashSet<Mention>(union.mentions);
            while (unhandledMentions.size() > 0) {
                Mention mention = (Mention)unhandledMentions.iterator().next();
                handledMentions.add(mention);
                if (mentionTypes.contains((Object)mention.getMentionType())) {
                    HashSet<Mention> overlapping = new HashSet<Mention>();
                    for (Mention mention2 : union.mentions) {
                        if (!mention.overlaps(mention2) || !mention.getEntityType().equals(mention2.getEntityType())) continue;
                        overlapping.add(mention2);
                    }
                    if (overlapping.size() > 1) {
                        int start = Integer.MAX_VALUE;
                        int end = Integer.MIN_VALUE;
                        for (Mention mention2 : overlapping) {
                            start = Math.min(start, mention2.getStart());
                            end = Math.max(end, mention2.getEnd());
                            union.removeMention(mention2);
                        }
                        union.addMention(new Mention(union, start, end, mention.getEntityType(), mention.getMentionType()));
                    }
                }
                unhandledMentions = new HashSet<Mention>(union.getMentions());
                unhandledMentions.removeAll(handledMentions);
            }
            for (int i = 0; i < this.tokens.size(); ++i) {
                List<Mention> tokenMentions = union.getMentions(union.tokens.get(i), mentionTypes);
                if (tokenMentions.size() == 0) {
                    labels.add(TagPosition.O.name());
                    continue;
                }
                if (tokenMentions.size() == 1) {
                    labels.add(TagPosition.getPositionText(format, tokenMentions.get(0), i));
                    continue;
                }
                throw new IllegalArgumentException("Sentence " + this.sentenceId + " contains overlapping mentions");
            }
        } else if (sameType.equals((Object)OverlapOption.Raw)) {
            if (!differentType.equals((Object)OverlapOption.Raw)) {
                throw new IllegalArgumentException("Not implemented");
            }
            for (int i = 0; i < this.tokens.size(); ++i) {
                List<Mention> tokenMentions = this.getMentions(this.tokens.get(i), mentionTypes);
                if (tokenMentions.size() == 0) {
                    labels.add(TagPosition.O.name());
                    continue;
                }
                if (tokenMentions.size() == 1) {
                    labels.add(TagPosition.getPositionText(format, tokenMentions.get(0), i));
                    continue;
                }
                StringBuilder label = new StringBuilder();
                Iterator<Mention> mentionIterator = tokenMentions.iterator();
                label.append(mentionIterator.next());
                while (mentionIterator.hasNext()) {
                    label.append("&");
                    label.append(mentionIterator.next());
                }
                labels.add(label.toString());
            }
        } else {
            throw new IllegalArgumentException("Not implemented");
        }
        return Collections.unmodifiableList(labels);
    }

    public List<Mention> getMentions(Token token, Set<Mention.MentionType> mentionTypes) {
        ArrayList<Mention> mentionsForToken = new ArrayList<Mention>();
        for (Mention mention : this.mentions) {
            if (!mentionTypes.contains((Object)mention.getMentionType()) || !mention.getTokens().contains(token)) continue;
            mentionsForToken.add(mention);
        }
        return Collections.unmodifiableList(mentionsForToken);
    }

    public EntityIdentification setIdentification(Mention mention, EntityIdentification identification) {
        if (!mention.getSentence().equals(this)) {
            throw new IllegalArgumentException();
        }
        return this.identifications.put(mention, identification);
    }

    public EntityIdentification getIdentification(Mention mention) {
        return this.identifications.get(mention);
    }

    public Sentence copy(boolean includeTokens, boolean includeMentions) {
        Sentence sentence2 = new Sentence(this.sentenceId, this.documentId, this.text);
        if (includeTokens) {
            for (Token token : this.tokens) {
                sentence2.tokens.add(new Token(sentence2, token.getStart(), token.getEnd()));
            }
        }
        if (includeMentions) {
            for (Mention mention : this.mentions) {
                sentence2.mentions.add(mention.copy(sentence2));
            }
        }
        return sentence2;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.sentenceId.hashCode();
        result = 31 * result + (this.documentId == null ? 0 : this.documentId.hashCode());
        result = 31 * result + this.text.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Sentence other = (Sentence)obj;
        if (!this.sentenceId.equals(other.sentenceId)) {
            return false;
        }
        if (this.documentId == null ? other.documentId != null : !this.documentId.equals(other.documentId)) {
            return false;
        }
        return this.text.equals(other.text);
    }

    public static enum OverlapOption {
        Exception,
        Union,
        Intersection,
        LayerInsideOut,
        LayerOutsideIn,
        LeftToRight,
        AsSet,
        Raw;

    }
}

