/*
 * Decompiled with CFR 0.152.
 */
package banner.tagging.pipe;

import banner.types.Sentence;
import banner.types.Token;
import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.TokenSequence;
import java.util.List;
import java.util.Map;

public class TokenWeight
extends Pipe {
    private static final long serialVersionUID = 1L;
    private transient Map<String, Double> tokenWeights = null;

    public TokenWeight(Map<String, Double> tokenWeights) {
        this.tokenWeights = tokenWeights;
    }

    public void setTokenWeights(Map<String, Double> tokenWeights) {
        this.tokenWeights = tokenWeights;
    }

    public Instance pipe(Instance carrier) {
        Sentence sentence = (Sentence)carrier.getSource();
        List<Token> tokens = sentence.getTokens();
        TokenSequence data = (TokenSequence)carrier.getData();
        for (int i = 0; i < tokens.size(); ++i) {
            Token bannerToken = tokens.get(i);
            String text = bannerToken.getText();
            cc.mallet.types.Token token = (cc.mallet.types.Token)data.get(i);
            if (this.tokenWeights != null) {
                Double weight = this.tokenWeights.get(text);
                if (weight == null) {
                    token.setFeatureValue("TOKENWEIGHT=", 1.0);
                } else {
                    token.setFeatureValue("TOKENWEIGHT=", weight.doubleValue());
                }
            }
            data.add((Object)token);
        }
        return carrier;
    }
}

