/*
 * Decompiled with CFR 0.152.
 */
package banner.tagging.pipe;

import banner.tagging.TagFormat;
import banner.types.Mention;
import banner.types.Sentence;
import banner.types.Token;
import cc.mallet.pipe.Pipe;
import cc.mallet.types.Alphabet;
import cc.mallet.types.Instance;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.LabelSequence;
import cc.mallet.types.TokenSequence;
import java.util.List;
import java.util.Set;

public class Sentence2TokenSequence
extends Pipe {
    private static final long serialVersionUID = 1L;
    private TagFormat format;
    private Set<Mention.MentionType> mentionTypes;
    private Sentence.OverlapOption sameType;
    private Sentence.OverlapOption differentType;

    public Sentence2TokenSequence(TagFormat format, Set<Mention.MentionType> mentionTypes, Sentence.OverlapOption sameType, Sentence.OverlapOption differentType) {
        super(null, (Alphabet)new LabelAlphabet());
        this.format = format;
        this.mentionTypes = mentionTypes;
        this.sameType = sameType;
        this.differentType = differentType;
    }

    public Instance pipe(Instance carrier) {
        Sentence sentence = (Sentence)carrier.getData();
        List<Token> tokens = sentence.getTokens();
        int size = tokens.size();
        TokenSequence data = new TokenSequence(size);
        LabelSequence target = new LabelSequence((LabelAlphabet)this.getTargetAlphabet(), size);
        List<String> labels = sentence.getTokenLabels(this.format, this.mentionTypes, this.sameType, this.differentType);
        for (int i = 0; i < size; ++i) {
            String text = tokens.get(i).getText();
            data.add((Object)new cc.mallet.types.Token(text));
            target.add((Object)labels.get(i));
        }
        carrier.setData((Object)data);
        carrier.setTarget((Object)target);
        carrier.setSource((Object)sentence);
        return carrier;
    }
}

