/*
 * Decompiled with CFR 0.152.
 */
package banner.postprocessing;

import banner.postprocessing.PostProcessor;
import banner.types.EntityType;
import banner.types.Mention;
import banner.types.Sentence;
import java.util.HashSet;
import java.util.Set;

public class FlattenPostProcessor
implements PostProcessor {
    private FlattenType flattenType;

    public FlattenPostProcessor(FlattenType flattenType) {
        this.flattenType = flattenType;
    }

    @Override
    public void postProcess(Sentence sentence) {
        HashSet<Mention> handledMentions = new HashSet<Mention>();
        HashSet<Mention> unhandledMentions = new HashSet<Mention>(sentence.getMentions());
        while (unhandledMentions.size() > 0) {
            Mention mention = (Mention)unhandledMentions.iterator().next();
            handledMentions.add(mention);
            Set<Mention> overlapping = FlattenPostProcessor.getOverlappingMentions(sentence, mention);
            if (overlapping.size() > 1) {
                this.flattenType.handle(sentence, overlapping);
            }
            unhandledMentions = new HashSet<Mention>(sentence.getMentions());
            unhandledMentions.removeAll(handledMentions);
        }
    }

    private static Set<Mention> getOverlappingMentions(Sentence sentence, Mention mention) {
        HashSet<Mention> overlapping = new HashSet<Mention>();
        for (Mention mention2 : sentence.getMentions()) {
            if (!mention.overlaps(mention2)) continue;
            overlapping.add(mention2);
        }
        return overlapping;
    }

    public static enum FlattenType {
        Union{

            @Override
            public void handle(Sentence sentence, Set<Mention> overlapping) {
                int start = Integer.MAX_VALUE;
                int end = Integer.MIN_VALUE;
                EntityType entityType = null;
                Mention.MentionType mentionType = null;
                for (Mention mention : overlapping) {
                    start = Math.min(start, mention.getStart());
                    end = Math.max(end, mention.getEnd());
                    entityType = mention.getEntityType();
                    mentionType = mention.getMentionType();
                    sentence.removeMention(mention);
                }
                sentence.addMention(new Mention(sentence, start, end, entityType, mentionType));
            }
        }
        ,
        HighestProbability{

            @Override
            public void handle(Sentence sentence, Set<Mention> overlapping) {
                Mention bestMention = null;
                for (Mention mention : overlapping) {
                    if (bestMention != null && !(mention.getProbability() > bestMention.getProbability())) continue;
                    bestMention = mention;
                }
                for (Mention mention : overlapping) {
                    if (mention == bestMention) continue;
                    sentence.removeMention(mention);
                }
            }
        };


        public abstract void handle(Sentence var1, Set<Mention> var2);
    }
}

