/*
 * Decompiled with CFR 0.152.
 */
package banner.normalization;

import banner.tokenization.Tokenizer;
import banner.types.Entity;
import banner.types.EntityName;
import banner.types.EntityType;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Gazetteer {
    private Map<String, Entity> id2EntityMap = new HashMap<String, Entity>();
    private Set<Entity> entities = new HashSet<Entity>();

    public void load(Tokenizer tokenizer, EntityType type, String filename) throws IOException {
        String strLine;
        FileInputStream fstream = new FileInputStream(filename);
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        while ((strLine = br.readLine()) != null) {
            String[] entries = strLine.split("\t");
            Entity ent = new Entity(entries[0], type);
            for (int i = 1; i < entries.length; ++i) {
                EntityName name = new EntityName(ent, entries[i], tokenizer.getTokens(entries[i]));
                ent.addName(name);
            }
            this.addEntity(ent);
        }
        in.close();
    }

    public void load(Tokenizer tokenizer, String namesFilename) throws IOException {
        this.load(tokenizer, namesFilename, null);
    }

    public void load(Tokenizer tokenizer, String namesFilename, EntityFilter entityFilter) throws IOException {
        String strLine;
        BufferedReader nameIn = new BufferedReader(new FileReader(namesFilename));
        HashMap<String, Entity> localId2EntityMap = new HashMap<String, Entity>();
        while ((strLine = nameIn.readLine()) != null) {
            String[] entries = strLine.split("\t");
            String type = entries[0];
            String id = entries[1];
            Entity ent = new Entity(id, EntityType.getType(type));
            for (int i = 1; i < entries.length; ++i) {
                EntityName name = new EntityName(ent, entries[i], tokenizer.getTokens(entries[i]));
                ent.addName(name);
            }
            localId2EntityMap.put(ent.getId(), ent);
        }
        nameIn.close();
        for (String id : localId2EntityMap.keySet()) {
            Entity entity = (Entity)localId2EntityMap.get(id);
            if (entityFilter != null && !entityFilter.include(entity)) continue;
            this.addEntity(entity);
        }
    }

    protected void addEntity(Entity entity) {
        this.id2EntityMap.put(entity.getId(), entity);
        this.entities.add(entity);
    }

    public Entity getEntity(String id) {
        return this.id2EntityMap.get(id);
    }

    public Set<Entity> getEntities() {
        return Collections.unmodifiableSet(this.entities);
    }

    public void write(String namesFilename) throws IOException {
        BufferedWriter nameOut = new BufferedWriter(new FileWriter(namesFilename));
        for (Entity currEnt : this.entities) {
            nameOut.write(currEnt.getEntityType().getText() + "\t");
            nameOut.write(currEnt.getId() + "\t");
            for (EntityName name : currEnt.getNames()) {
                nameOut.write(name.getName() + "\t");
            }
            nameOut.write("\n");
        }
        nameOut.close();
    }

    public static interface EntityFilter {
        public boolean include(Entity var1);
    }
}

