/*
 * Decompiled with CFR 0.152.
 */
package banner.eval.uima;

import banner.eval.BANNER;
import banner.postprocessing.PostProcessor;
import banner.tagging.CRFTagger;
import banner.tagging.dictionary.DictionaryTagger;
import banner.tokenization.Tokenizer;
import banner.types.Mention;
import banner.types.Sentence;
import dragon.nlp.tool.Lemmatiser;
import dragon.nlp.tool.Tagger;
import dragon.nlp.tool.lemmatiser.EngLemmatiser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.configuration.XMLConfiguration;

public class BANNERWrapper {
    Tokenizer tokenizer;
    DictionaryTagger dictionary;
    HierarchicalConfiguration config;
    EngLemmatiser lemmatiser;
    Tagger posTagger;
    CRFTagger tagger;
    PostProcessor postProcessor;
    private final String configPrefix = "config/";
    private final String modelPrefix = "output/";

    public Map<String, String> getAnnotations(String docText) {
        HashMap<String, String> annotSpans = new HashMap<String, String>();
        Scanner sc = new Scanner(docText);
        int count = 0;
        while (sc.hasNextLine()) {
            String line = sc.nextLine().trim();
            if (line.length() > 0) {
                Sentence sentence = new Sentence(Integer.toString(count), "", line);
                sentence = BANNER.process(this.tagger, this.tokenizer, this.postProcessor, sentence);
                for (Mention mention : sentence.getMentions()) {
                    annotSpans.put(mention.getText(), mention.getEntityType().getText());
                }
            }
            count += line.length() + 1;
        }
        return annotSpans;
    }

    public InputStream getStream(String path) {
        URL url = this.getClass().getClassLoader().getResource(path);
        try {
            return url.openStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getFile(String path) {
        URL url = this.getClass().getClassLoader().getResource(path);
        System.out.println("URL:" + url.getFile());
        return url.getFile();
    }

    public void initializeModel(String configFile, String modelFile) throws ConfigurationException {
        long start = System.currentTimeMillis();
        System.out.println("modelFile: " + modelFile);
        System.out.println("configFile: " + configFile);
        this.config = new XMLConfiguration(this.getFile("config/" + configFile));
        this.tokenizer = BANNER.getTokenizer(this.config);
        this.dictionary = BANNER.getDictionary(this.config);
        this.lemmatiser = BANNER.getLemmatiser(this.config);
        this.posTagger = BANNER.getPosTagger(this.config);
        this.postProcessor = BANNER.getPostProcessor(this.config);
        SubnodeConfiguration localConfig = this.config.configurationAt(BANNER.class.getPackage().getName());
        try {
            System.out.println(modelFile);
            this.tagger = CRFTagger.load(this.getClass().getClassLoader().getResource("output/" + modelFile).openStream(), (Lemmatiser)this.lemmatiser, this.posTagger, this.dictionary);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Loaded model: " + (System.currentTimeMillis() - start) + "ms");
    }

    public void initialize(String configFilePath, String modelFilePath) throws IOException, ConfigurationException {
        String fullConfigFilePath = "config/" + configFilePath;
        String fullModelFilePath = "output/" + modelFilePath;
        File configFile = new File(fullConfigFilePath);
        File modelFile = new File(fullModelFilePath);
        System.out.println("test path: " + configFile.getAbsolutePath());
        System.out.println("test path: " + modelFile.getAbsolutePath());
        System.out.println("Reading model from file: " + fullModelFilePath);
        System.out.println("Reading config from file: " + fullConfigFilePath);
        this.initializeModel(configFilePath, modelFilePath);
    }

    public static void main(String[] args) {
        String question = "Does BRCA1 cause mad cow disease?";
        BANNERWrapper bw = new BANNERWrapper();
        String configPath = "config/banner_AZDC.xml";
        String modelPath = "output/model_AZDC.bin";
        try {
            bw.initialize(configPath, modelPath);
        }
        catch (ConfigurationException e) {
            System.err.println("configuration exception");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("io exception");
            e.printStackTrace();
        }
        System.out.println("Tag diseases:");
        Map<String, String> diseasesAnnots = bw.getAnnotations(question);
        Iterator<String> iterator = diseasesAnnots.keySet().iterator();
        while (iterator.hasNext()) {
            String k;
            String mentionText = k = iterator.next();
            String type = diseasesAnnots.get(k);
            System.out.println("keyterm: " + mentionText + "type: " + type);
        }
        bw = new BANNERWrapper();
        configPath = "config/banner_BC2GM.xml";
        modelPath = "output/model_BC2GM.bin";
        try {
            bw.initialize(configPath, modelPath);
        }
        catch (ConfigurationException e) {
            System.err.println("configuration exception");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("io exception");
            e.printStackTrace();
        }
        System.out.println("Tag genes:");
        Map<String, String> geneAnnots = bw.getAnnotations(question);
        Iterator<String> iterator2 = geneAnnots.keySet().iterator();
        while (iterator2.hasNext()) {
            String k;
            String mentionText = k = iterator2.next();
            String type = geneAnnots.get(k);
            System.out.println("keyterm: " + mentionText + "type: " + type);
        }
    }
}

