/*
 * Decompiled with CFR 0.152.
 */
package banner.annotation;

import banner.annotation.Annotation;
import banner.annotation.Concept;
import banner.annotation.ConceptName;
import banner.annotation.Text;
import banner.tokenization.SimpleTokenizer;
import banner.tokenization.Tokenizer;
import banner.util.IndexedMetricSetSimilarity;
import banner.util.RankedList;
import banner.util.SetSimilarityMetric;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntIterator;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class BEAT
extends JFrame
implements ActionListener,
CaretListener {
    private static final String[] annotationColumnNames = new String[]{"Start", "End", "Text", "Type", "Concept", "Action"};
    private static final String[] conceptColumnNames = new String[]{"Match", "Name", "ID", "Select"};
    private static final int conceptLookupResults = 100;
    private static final String punctuation = "`~!@#$%^&*()-\u2013=_+[]\\{}|;':\",./<>?";
    private static final Tokenizer tokenizer = new SimpleTokenizer();
    private JLabel progressLabel;
    private JLabel textFileLabel;
    private JTextField textFileField;
    private JLabel annotationFileLabel;
    private JTextField annotationFileField;
    private JLabel identifierLabel;
    private JTextField identifierField;
    private JLabel textLabel;
    private JTextArea textArea;
    private JLabel anotationLabel;
    private JTable annotationTable;
    private JCheckBox completeCheckBox;
    private JLabel conceptLabel;
    private JTextField conceptLookupField;
    private JTable conceptTable;
    private JButton previousButton;
    private JButton nextButton;
    private int current;
    private int selectionStart;
    private int selectionEnd;
    private String selectionType;
    private String completedTextsFilename;
    private String annotationsFilename;
    private List<String> incompleteTextIds;
    private Map<String, Text> texts;
    private Map<String, List<Annotation>> annotations;
    private List<String> semanticTypes;
    private Map<String, Concept> concepts;
    private Map<String, List<ConceptName>> conceptNames;
    private IndexedMetricSetSimilarity<String, ConceptName> identifier;
    private RankedList<ConceptName> lookupNames;

    public static void main(String[] args) {
        if (args.length != 5 || args[0].toLowerCase().endsWith("help")) {
            System.out.println("Usage: BEAT <text file> <completed file> <annotation file> <concepts file> <concepts names file>");
            return;
        }
        String textsFilename = args[0];
        String completedTextsFilename = args[1];
        String annotationsFilename = args[2];
        String conceptsFilename = args[3];
        String conceptNamesFilename = args[4];
        final BEAT beat = new BEAT(textsFilename, completedTextsFilename, annotationsFilename, conceptsFilename, conceptNamesFilename);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UIManager.put("swing.boldMetal", Boolean.FALSE);
                beat.setVisible(true);
            }
        });
    }

    public BEAT(String textsFilename, String completedTextsFilename, String annotationsFilename, String conceptsFilename, String conceptNamesFilename) {
        this.completedTextsFilename = completedTextsFilename;
        this.annotationsFilename = annotationsFilename;
        this.incompleteTextIds = new ArrayList<String>();
        this.texts = new HashMap<String, Text>();
        this.annotations = new HashMap<String, List<Annotation>>();
        this.concepts = new HashMap<String, Concept>();
        this.semanticTypes = new ArrayList<String>();
        this.conceptNames = new HashMap<String, List<ConceptName>>();
        try {
            Text.loadTexts(textsFilename, completedTextsFilename, this.incompleteTextIds, this.texts);
            Concept.loadConcepts(conceptsFilename, this.concepts);
            Annotation.loadAnnotations(annotationsFilename, this.texts, this.concepts, this.annotations);
            ConceptName.loadConceptNames(conceptNamesFilename, this.concepts, this.conceptNames);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        this.getSemanticTypes();
        this.identifier = new IndexedMetricSetSimilarity<String, ConceptName>(SetSimilarityMetric.BooleanXJaccard, 100){

            @Override
            protected String transform(String element) {
                if ((element = element.trim()).length() == 1 && BEAT.punctuation.contains(element)) {
                    return null;
                }
                element = element.toLowerCase();
                return element;
            }
        };
        this.lookupNames = new RankedList(100);
        for (List<ConceptName> names : this.conceptNames.values()) {
            for (ConceptName name : names) {
                List<String> tokens = tokenizer.getTokens(name.getName());
                this.identifier.addValue(tokens, name);
            }
        }
        this.current = -1;
        this.selectionStart = -1;
        this.selectionEnd = -1;
        this.selectionType = null;
        this.initComponents();
        this.initLayout();
        this.setTitle("BEAT Entity Annotation Tool");
        this.textFileField.setText(textsFilename);
        this.annotationFileField.setText(annotationsFilename);
        this.identifierField.setEnabled(true);
        this.textArea.setEnabled(true);
        this.annotationTable.setEnabled(true);
        this.previousButton.setEnabled(true);
        this.nextButton.setEnabled(true);
        this.current = 0;
        this.changeText();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new SaveAnnotationsWindowAdapter());
        this.pack();
    }

    private void initComponents() {
        this.progressLabel = new JLabel("?/?");
        this.textFileLabel = new JLabel("Text file:");
        this.textFileField = new JTextField();
        this.textFileField.setEditable(false);
        this.annotationFileLabel = new JLabel("Annotation file:");
        this.annotationFileField = new JTextField();
        this.annotationFileField.setEditable(false);
        this.completeCheckBox = new JCheckBox("Annotation of this text is complete");
        this.identifierLabel = new JLabel("Identifier:");
        this.identifierField = new JTextField();
        this.identifierField.setEditable(false);
        this.identifierField.setEnabled(false);
        this.textLabel = new JLabel("Text:");
        this.textArea = new JTextArea();
        this.textArea.setEnabled(false);
        this.anotationLabel = new JLabel("Annotations:");
        this.setupAnnotationTable();
        this.conceptLabel = new JLabel("Concept:");
        this.conceptLookupField = new JTextField();
        this.conceptLookupField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                BEAT.this.doConceptLookup();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                BEAT.this.doConceptLookup();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                BEAT.this.doConceptLookup();
            }
        });
        this.setupConceptTable();
        this.previousButton = new JButton("Previous");
        this.previousButton.setMnemonic(80);
        this.previousButton.addActionListener(this);
        this.previousButton.setEnabled(false);
        this.nextButton = new JButton("Next");
        this.nextButton.setMnemonic(78);
        this.nextButton.addActionListener(this);
        this.nextButton.setEnabled(false);
        this.textArea.addCaretListener(this);
        this.textArea.setColumns(30);
        this.textArea.setLineWrap(true);
        this.textArea.setRows(8);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setEditable(false);
        Font defaultFont = this.textArea.getFont();
        Font newFont = new Font(defaultFont.getFontName(), 1, defaultFont.getSize() + 4);
        this.textArea.setFont(newFont);
    }

    private void setupAnnotationTable() {
        this.annotationTable = new JTable(new AnnotationTableModel());
        this.annotationTable.setSelectionMode(0);
        TableColumnModel columnModel = this.annotationTable.getColumnModel();
        JComboBox<String> comboBox = new JComboBox<String>();
        for (String type : this.semanticTypes) {
            comboBox.addItem(type);
        }
        columnModel.getColumn(3).setCellEditor(new DefaultCellEditor(comboBox));
        columnModel.getColumn(4).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                JComponent c = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
                if (row == 0) {
                    if (BEAT.this.selectionStart == -1 || BEAT.this.selectionEnd == -1) {
                        BEAT.this.conceptLookupField.setText(null);
                        BEAT.this.clearConceptTable();
                    } else {
                        String textId = (String)BEAT.this.incompleteTextIds.get(BEAT.this.current);
                        Text text = (Text)BEAT.this.texts.get(textId);
                        String annotatedText = text.getText().substring(BEAT.this.selectionStart, BEAT.this.selectionEnd);
                        BEAT.this.conceptLookupField.setText(annotatedText);
                        BEAT.this.doConceptLookup();
                    }
                } else {
                    List annotationList = (List)BEAT.this.annotations.get(BEAT.this.incompleteTextIds.get(BEAT.this.current));
                    Annotation annotation = (Annotation)annotationList.get(row - 1);
                    c.setToolTipText(BEAT.this.getConceptTooltip(annotation.getConceptId()));
                }
                return c;
            }
        });
        columnModel.getColumn(5).setCellRenderer(new ButtonRenderer());
        columnModel.getColumn(5).setCellEditor(new AnnotationButtonEditor(this.annotationTable));
        this.annotationTable.setCellSelectionEnabled(true);
        this.annotationTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                boolean mouseReleased;
                boolean bl = mouseReleased = !e.getValueIsAdjusting();
                if (mouseReleased) {
                    int annotationRow = BEAT.this.annotationTable.getSelectedRow();
                    System.out.println("Selected row: " + annotationRow);
                    if (annotationRow < 1) {
                        return;
                    }
                    List annotationList = (List)BEAT.this.annotations.get(BEAT.this.incompleteTextIds.get(BEAT.this.current));
                    Annotation annotation = (Annotation)annotationList.get(annotationRow - 1);
                    Text text = (Text)BEAT.this.texts.get(BEAT.this.incompleteTextIds.get(BEAT.this.current));
                    String lookupText = text.getText().substring(annotation.getStart(), annotation.getEnd());
                    BEAT.this.conceptLookupField.setText(lookupText);
                }
            }
        });
    }

    private void setupConceptTable() {
        this.conceptTable = new JTable(new ConceptTableModel());
        this.conceptTable.setSelectionMode(0);
        TableColumnModel columnModel = this.conceptTable.getColumnModel();
        columnModel.getColumn(2).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                JComponent c = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
                RowSorter<? extends TableModel> sorter = table.getRowSorter();
                row = sorter.convertRowIndexToModel(row);
                ConceptName name = (ConceptName)BEAT.this.lookupNames.getObject(row);
                c.setToolTipText(BEAT.this.getConceptTooltip(name.getConceptId()));
                return c;
            }
        });
        columnModel.getColumn(3).setCellRenderer(new ButtonRenderer());
        columnModel.getColumn(3).setCellEditor(new ConceptButtonEditor(this.conceptTable));
        this.conceptTable.setCellSelectionEnabled(true);
        this.conceptTable.setAutoCreateRowSorter(true);
    }

    private String getConceptTooltip(String conceptId) {
        if (conceptId == null) {
            return null;
        }
        Concept concept = this.concepts.get(conceptId);
        StringBuilder tooltip = new StringBuilder();
        tooltip.append("<html>");
        tooltip.append(concept.getId());
        tooltip.append(": ");
        tooltip.append(concept.getDescription());
        List<ConceptName> names = this.conceptNames.get(conceptId);
        for (ConceptName name : names) {
            tooltip.append("<br>");
            tooltip.append(name.getName());
        }
        tooltip.append("</html>");
        return tooltip.toString();
    }

    private void initLayout() {
        JPanel pane = new JPanel();
        pane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.ipadx = 5;
        c.ipady = 5;
        c.gridx = 2;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 22;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        pane.add((Component)this.progressLabel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 21;
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        pane.add((Component)this.textFileLabel, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.anchor = 21;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        pane.add((Component)this.textFileField, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 21;
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        pane.add((Component)this.annotationFileLabel, c);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.anchor = 21;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        pane.add((Component)this.annotationFileField, c);
        JSplitPane splitPane = new JSplitPane(1, this.getTextAndAnnotationPane(), this.getConceptPane());
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 3;
        c.gridheight = 1;
        c.anchor = 10;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        pane.add((Component)splitPane, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 21;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        pane.add((Component)this.previousButton, c);
        c.gridx = 2;
        c.gridy = 4;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 22;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        pane.add((Component)this.nextButton, c);
        this.getContentPane().add((Component)pane, "Center");
    }

    private JComponent getTextAndAnnotationPane() {
        GridBagConstraints c = new GridBagConstraints();
        c.ipadx = 5;
        c.ipady = 5;
        JPanel textPane = new JPanel();
        textPane.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 21;
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        textPane.add((Component)this.identifierLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 21;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        textPane.add((Component)this.identifierField, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.anchor = 21;
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        textPane.add((Component)this.textLabel, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.anchor = 10;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        textPane.add((Component)new JScrollPane(this.textArea), c);
        JPanel annotationPane = new JPanel();
        annotationPane.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 21;
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        annotationPane.add((Component)this.anotationLabel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 10;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        annotationPane.add((Component)new JScrollPane(this.annotationTable), c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 21;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        annotationPane.add((Component)this.completeCheckBox, c);
        return new JSplitPane(0, textPane, annotationPane);
    }

    private JComponent getConceptPane() {
        JPanel conceptPane = new JPanel();
        conceptPane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.ipadx = 5;
        c.ipady = 5;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 21;
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        conceptPane.add((Component)this.conceptLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 21;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        conceptPane.add((Component)this.conceptLookupField, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.anchor = 10;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        conceptPane.add((Component)new JScrollPane(this.conceptTable), c);
        return conceptPane;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.nextButton) {
            Annotation.saveAnnotations(this.annotationsFilename, this.texts, this.annotations);
            String textId = this.incompleteTextIds.get(this.current);
            boolean complete = this.completeCheckBox.isSelected();
            this.texts.get(textId).setComplete(complete);
            Text.saveTextCompletion(this.completedTextsFilename, this.texts);
            ++this.current;
            this.changeText();
        } else if (event.getSource() == this.previousButton) {
            Annotation.saveAnnotations(this.annotationsFilename, this.texts, this.annotations);
            String textId = this.incompleteTextIds.get(this.current);
            boolean complete = this.completeCheckBox.isSelected();
            this.texts.get(textId).setComplete(complete);
            Text.saveTextCompletion(this.completedTextsFilename, this.texts);
            --this.current;
            this.changeText();
        }
    }

    private void doConceptLookup() {
        String lookupText = this.conceptLookupField.getText();
        if (lookupText == null) {
            this.clearConceptTable();
            return;
        }
        if ((lookupText = lookupText.trim()).length() == 0) {
            this.clearConceptTable();
            return;
        }
        List<String> tokens = tokenizer.getTokens(lookupText);
        if (tokens == null || tokens.size() == 0) {
            this.clearConceptTable();
            return;
        }
        this.lookupNames = this.identifier.indexMatch(tokens);
        ((ConceptTableModel)this.conceptTable.getModel()).fireTableDataChanged();
    }

    private void clearConceptTable() {
        this.lookupNames = new RankedList(100);
        ((ConceptTableModel)this.conceptTable.getModel()).fireTableDataChanged();
    }

    @Override
    public void caretUpdate(CaretEvent arg0) {
        int start = this.textArea.getSelectionStart();
        int end = this.textArea.getSelectionEnd();
        String text = this.textArea.getSelectedText();
        if (text != null) {
            text = text.trim();
        }
        if (end <= start || text != null && text.length() == 0) {
            if (this.selectionStart != -1 || this.selectionEnd != -1) {
                this.selectionStart = -1;
                this.selectionEnd = -1;
                ((AnnotationTableModel)this.annotationTable.getModel()).fireTableDataChanged();
            }
            return;
        }
        System.out.println("Selected: " + start + " - " + end + " = " + text);
        this.selectionStart = start;
        this.selectionEnd = end;
        this.selectionType = this.semanticTypes.get(0);
        ((AnnotationTableModel)this.annotationTable.getModel()).fireTableDataChanged();
    }

    private void getSemanticTypes() {
        final TObjectIntHashMap semanticTypesMap = new TObjectIntHashMap();
        for (Concept concept : this.concepts.values()) {
            String semanticType = concept.getType();
            if (semanticTypesMap.contains((Object)semanticType)) {
                semanticTypesMap.increment((Object)semanticType);
                continue;
            }
            semanticTypesMap.put((Object)semanticType, 1);
        }
        TObjectIntIterator iterator = semanticTypesMap.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            this.semanticTypes.add((String)iterator.key());
        }
        Collections.sort(this.semanticTypes, new Comparator<String>(){

            @Override
            public int compare(String type1, String type2) {
                int type1Count = semanticTypesMap.get((Object)type1);
                int type2Count = semanticTypesMap.get((Object)type2);
                return type2Count - type1Count;
            }
        });
    }

    private void changeText() {
        if (this.current < 0) {
            this.current = this.incompleteTextIds.size() - 1;
        }
        this.current %= this.incompleteTextIds.size();
        this.progressLabel.setText("" + (this.current + 1) + "/" + this.incompleteTextIds.size());
        String textId = this.incompleteTextIds.get(this.current);
        System.out.println("Current: " + textId);
        Text text = this.texts.get(textId);
        this.identifierField.setText(textId);
        this.textArea.setText(text.getText());
        this.completeCheckBox.setSelected(true);
        ((AnnotationTableModel)this.annotationTable.getModel()).fireTableDataChanged();
        this.conceptLookupField.setText(null);
        this.clearConceptTable();
        this.completeCheckBox.setSelected(false);
        this.completeCheckBox.doClick();
    }

    private class ButtonRenderer
    implements TableCellRenderer {
        JButton button = new JButton();

        private ButtonRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.button.setText(value.toString());
            return this.button;
        }
    }

    private class ConceptButtonEditor
    extends TableButtonEditor {
        public ConceptButtonEditor(JTable table) {
            super(table);
        }

        @Override
        public void buttonPush(int row, int column) {
            ConceptName name = (ConceptName)BEAT.this.lookupNames.getObject(row);
            int annotationRow = BEAT.this.annotationTable.getSelectedRow();
            System.out.println("Selected concept " + name.getConceptId() + " from name " + name.getName() + " to put into row " + annotationRow);
            if (annotationRow < 1) {
                return;
            }
            List annotationList = (List)BEAT.this.annotations.get(BEAT.this.incompleteTextIds.get(BEAT.this.current));
            Annotation annotation = (Annotation)annotationList.get(annotationRow - 1);
            annotation.setConceptId(name.getConceptId());
            ((AnnotationTableModel)BEAT.this.annotationTable.getModel()).fireTableCellUpdated(annotationRow, 4);
        }
    }

    private class AnnotationButtonEditor
    extends TableButtonEditor {
        public AnnotationButtonEditor(JTable table) {
            super(table);
        }

        @Override
        public void buttonPush(int row, int column) {
            boolean update = false;
            if (column == 5) {
                String id = (String)BEAT.this.incompleteTextIds.get(BEAT.this.current);
                List annotationList = (List)BEAT.this.annotations.get(id);
                if (row == 0) {
                    if (BEAT.this.selectionStart != -1 && BEAT.this.selectionEnd != -1) {
                        Annotation annotation = new Annotation(BEAT.this.selectionStart, BEAT.this.selectionEnd, id, BEAT.this.selectionType, null);
                        annotationList.add(annotation);
                        Collections.sort(annotationList);
                        update = true;
                        BEAT.this.textArea.getCaret().setDot(0);
                    }
                } else {
                    annotationList.remove(row - 1);
                    update = true;
                }
            }
            this.stopCellEditing();
            if (update) {
                ((AnnotationTableModel)BEAT.this.annotationTable.getModel()).fireTableDataChanged();
            }
        }
    }

    private abstract class TableButtonEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JTable table;
        JButton button = new JButton();
        int clickCountToStart = 1;

        public TableButtonEditor(JTable table) {
            this.table = table;
            this.button.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = this.table.getEditingRow();
            RowSorter<? extends TableModel> sorter = this.table.getRowSorter();
            if (sorter != null) {
                row = sorter.convertRowIndexToModel(row);
            }
            int column = this.table.getEditingColumn();
            System.out.printf("row = %d  col = %d%n", row, column);
            this.buttonPush(row, column);
        }

        public abstract void buttonPush(int var1, int var2);

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.button.setText(value.toString());
            return this.button;
        }

        @Override
        public Object getCellEditorValue() {
            return this.button.getText();
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= this.clickCountToStart;
            }
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            return super.stopCellEditing();
        }

        @Override
        public void cancelCellEditing() {
            super.cancelCellEditing();
        }
    }

    private class ConceptTableModel
    extends AbstractTableModel {
        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ConceptName name = (ConceptName)BEAT.this.lookupNames.getObject(rowIndex);
            switch (columnIndex) {
                case 0: {
                    double match = BEAT.this.lookupNames.getValue(rowIndex);
                    return String.format("%6.4f", match);
                }
                case 1: {
                    return name.getName();
                }
                case 2: {
                    return name.getConceptId();
                }
                case 3: {
                    return "Select";
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public int getRowCount() {
            return BEAT.this.lookupNames.size();
        }

        @Override
        public String getColumnName(int col) {
            return conceptColumnNames[col];
        }

        @Override
        public int getColumnCount() {
            return conceptColumnNames.length;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: {
                    return String.class;
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 3;
        }
    }

    private class AnnotationTableModel
    extends AbstractTableModel {
        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 5) {
                return rowIndex == 0 ? "Add" : "Remove";
            }
            if (BEAT.this.current == -1) {
                return null;
            }
            if (rowIndex == 0) {
                if (BEAT.this.selectionStart == -1 || BEAT.this.selectionEnd == -1) {
                    return null;
                }
                String id = (String)BEAT.this.incompleteTextIds.get(BEAT.this.current);
                Text text = (Text)BEAT.this.texts.get(id);
                switch (columnIndex) {
                    case 0: {
                        return BEAT.this.selectionStart;
                    }
                    case 1: {
                        return BEAT.this.selectionEnd;
                    }
                    case 2: {
                        return text.getText().substring(BEAT.this.selectionStart, BEAT.this.selectionEnd);
                    }
                    case 3: {
                        return BEAT.this.selectionType;
                    }
                    case 4: {
                        return null;
                    }
                }
                throw new IllegalArgumentException();
            }
            List annotationList = (List)BEAT.this.annotations.get(BEAT.this.incompleteTextIds.get(BEAT.this.current));
            Annotation annotation = (Annotation)annotationList.get(rowIndex - 1);
            int start = annotation.getStart();
            int end = annotation.getEnd();
            String id = (String)BEAT.this.incompleteTextIds.get(BEAT.this.current);
            Text text = (Text)BEAT.this.texts.get(id);
            switch (columnIndex) {
                case 0: {
                    return start;
                }
                case 1: {
                    return end;
                }
                case 2: {
                    return text.getText().substring(start, end);
                }
                case 3: {
                    return annotation.getSemanticType();
                }
                case 4: {
                    return annotation.getConceptId();
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            System.out.println("Setting value at " + row + "," + col + " to " + value);
            if (col != 3) {
                return;
            }
            if (row == 0) {
                if (value == null) {
                    BEAT.this.selectionType = null;
                } else {
                    BEAT.this.selectionType = value.toString();
                }
            } else {
                List annotationList = (List)BEAT.this.annotations.get(BEAT.this.incompleteTextIds.get(BEAT.this.current));
                Annotation annotation = (Annotation)annotationList.get(row - 1);
                String semanticType = value.toString();
                annotation.setSemanticType(semanticType);
                this.fireTableCellUpdated(row, col);
            }
        }

        @Override
        public int getRowCount() {
            if (BEAT.this.current == -1) {
                return 0;
            }
            String id = (String)BEAT.this.incompleteTextIds.get(BEAT.this.current);
            return ((List)BEAT.this.annotations.get(id)).size() + 1;
        }

        @Override
        public String getColumnName(int col) {
            return annotationColumnNames[col];
        }

        @Override
        public int getColumnCount() {
            return annotationColumnNames.length;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Integer.class;
                }
                case 1: {
                    return Integer.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: {
                    return String.class;
                }
                case 4: {
                    return String.class;
                }
                case 5: {
                    return String.class;
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 3 || columnIndex == 5;
        }
    }

    private class SaveAnnotationsWindowAdapter
    extends WindowAdapter {
        private SaveAnnotationsWindowAdapter() {
        }

        @Override
        public void windowClosed(WindowEvent arg0) {
            System.exit(0);
        }

        @Override
        public void windowClosing(WindowEvent arg0) {
            Annotation.saveAnnotations(BEAT.this.annotationsFilename, BEAT.this.texts, BEAT.this.annotations);
            Text.saveTextCompletion(BEAT.this.completedTextsFilename, BEAT.this.texts);
            BEAT.this.setVisible(false);
            BEAT.this.dispose();
        }
    }
}

