/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.annotationremoval;

import java.util.ArrayList;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.cas.Type;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ResourceMetaData(name="JCoRe Annotation Removal AE", description="Removes annotations from the CAS that belong to one of the types specified as a parameter value in the descriptor.", vendor="JULIE Lab Jena, Germany")
public class AnnotationRemovalAnnotator
extends JCasAnnotator_ImplBase {
    public static final String PARAM_ANNOTATION_TYPES = "AnnotationTypes";
    private static final Logger log = LoggerFactory.getLogger(AnnotationRemovalAnnotator.class);
    @ConfigurationParameter(name="AnnotationTypes", description="List of qualified UIMA type names for which all annotations should be removed from each CAS.")
    private String[] annotationTypesForRemoval;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        this.annotationTypesForRemoval = (String[])aContext.getConfigParameterValue(PARAM_ANNOTATION_TYPES);
        if (this.annotationTypesForRemoval.length == 0) {
            throw new ResourceInitializationException((Throwable)new IllegalArgumentException("The list of annotations for removal, given through parameter 'AnnotationTypes' is empty."));
        }
    }

    public void process(JCas aJCas) {
        ArrayList removalList = new ArrayList();
        for (String annotationTypeName : this.annotationTypesForRemoval) {
            Type type = aJCas.getTypeSystem().getType(annotationTypeName);
            aJCas.getAnnotationIndex(type).forEach(removalList::add);
            removalList.forEach(TOP::removeFromIndexes);
        }
    }
}

