/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.acronyms;

import de.julielab.java.utilities.FileUtilities;
import de.julielab.jcore.types.Abbreviation;
import de.julielab.jcore.types.AbbreviationLongform;
import de.julielab.jcore.utility.JCoReTools;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ResourceMetaData(name="JCoRe Acronym Writer", description="Writes acronym annotation to a text file.")
public class AcronymWriter
extends JCasAnnotator_ImplBase {
    private static final Logger log = LoggerFactory.getLogger(AcronymWriter.class);
    public static final String PARAM_OUTPUTFILE = "OutputFile";
    @ConfigurationParameter(name="OutputFile")
    private String outputFile;
    private OutputStream os;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.outputFile = (String)aContext.getConfigParameterValue(PARAM_OUTPUTFILE);
        try {
            this.os = FileUtilities.getOutputStreamToFile((File)new File(this.outputFile));
        }
        catch (IOException e) {
            log.error("Could not initialize acronym writer", (Throwable)e);
            throw new ResourceInitializationException((Throwable)e);
        }
        log.trace("AcronymWriter successfully initialized.");
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        log.trace("Processing with AcronymWriter");
        try {
            String pubmedId = JCoReTools.getDocId((JCas)jcas);
            FSIterator it = jcas.getAnnotationIndex(Abbreviation.type).iterator();
            HashMap<AbbreviationLongform, Object> fullForms = new HashMap<AbbreviationLongform, Object>();
            int abbrCount = 0;
            while (it.hasNext()) {
                Abbreviation abbr = (Abbreviation)it.next();
                AbbreviationLongform textReference = abbr.getTextReference();
                String abbrId = "A" + abbrCount;
                Object fullformId = (String)fullForms.get(textReference);
                if (fullformId == null) {
                    fullformId = "F" + abbrCount;
                    fullForms.put(textReference, fullformId);
                    IOUtils.write((String)(String.join((CharSequence)"\t", new CharSequence[]{pubmedId, fullformId, String.valueOf(textReference.getBegin()), String.valueOf(textReference.getEnd())}) + "\n"), (OutputStream)this.os, (String)"UTF-8");
                }
                IOUtils.write((String)(String.join((CharSequence)"\t", new CharSequence[]{pubmedId, abbrId, String.valueOf(abbr.getBegin()), String.valueOf(abbr.getEnd()), fullformId}) + "\n"), (OutputStream)this.os, (String)"UTF-8");
                ++abbrCount;
            }
        }
        catch (IOException | CASRuntimeException e) {
            log.error("Exception while writing acronyms", e);
            throw new AnalysisEngineProcessException(e);
        }
        catch (Throwable t) {
            log.error("Exception while writing acronyms", t);
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        try {
            this.os.close();
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }
}

