/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.acronymtagger.main;

import de.julielab.jcore.types.Abbreviation;
import de.julielab.jcore.types.AbbreviationLongform;
import de.julielab.jcore.utility.index.Comparators;
import de.julielab.jcore.utility.index.IndexTermGenerator;
import de.julielab.jcore.utility.index.JCoReTreeMapAnnotationIndex;
import de.julielab.jcore.utility.index.TermGenerators;
import java.util.Comparator;
import java.util.HashSet;
import java.util.stream.Stream;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class Postprocessing {
    private static final Comparator<Long> overlapComparator = Comparators.longOverlapComparator();
    private static final TermGenerators.LongOffsetIndexTermGenerator termGenerator = TermGenerators.longOffsetTermGenerator();

    public static void doPostprocessing(JCas jcas) {
        JCoReTreeMapAnnotationIndex acronymIndex = new JCoReTreeMapAnnotationIndex(overlapComparator, (IndexTermGenerator)termGenerator, (IndexTermGenerator)termGenerator);
        acronymIndex.index(jcas, Abbreviation.type);
        Postprocessing.unifyForLongestAcronym(jcas, (JCoReTreeMapAnnotationIndex<Long, Abbreviation>)acronymIndex);
        Postprocessing.removeAcronymsOnFullforms(jcas, (JCoReTreeMapAnnotationIndex<Long, Abbreviation>)acronymIndex);
    }

    private static void removeAcronymsOnFullforms(JCas jcas, JCoReTreeMapAnnotationIndex<Long, Abbreviation> acronymIndex) {
        HashSet toRemove = new HashSet();
        for (Annotation longForm : jcas.getAnnotationIndex(AbbreviationLongform.type)) {
            Stream overlappedAbbreviations = acronymIndex.search((Comparable)((Long)termGenerator.asKey(longForm)));
            overlappedAbbreviations.forEach(toRemove::add);
        }
        for (Abbreviation a : toRemove) {
            a.removeFromIndexes();
        }
    }

    private static void unifyForLongestAcronym(JCas jcas, JCoReTreeMapAnnotationIndex<Long, Abbreviation> acronymIndex) {
        HashSet toRemove = new HashSet();
        for (Abbreviation a : jcas.getAnnotationIndex(Abbreviation.type)) {
            Stream overlappingAbbreviations = acronymIndex.search((Annotation)a);
            overlappingAbbreviations.filter(oa -> !oa.equals((Object)a)).forEach(overlappingAbbreviation -> {
                if (overlappingAbbreviation != null) {
                    AbbreviationLongform aFull = a.getTextReference();
                    AbbreviationLongform oFull = overlappingAbbreviation.getTextReference();
                    if (overlapComparator.compare((Long)termGenerator.asKey((Annotation)aFull), (Long)termGenerator.asKey((Annotation)oFull)) != 0) {
                        int overlappingLength;
                        int aLength = a.getEnd() - a.getBegin();
                        if (aLength > (overlappingLength = overlappingAbbreviation.getEnd() - overlappingAbbreviation.getBegin())) {
                            toRemove.add(overlappingAbbreviation);
                        }
                        if (overlappingLength > aLength) {
                            toRemove.add(a);
                        }
                    }
                }
            });
        }
        for (Abbreviation a : toRemove) {
            a.removeFromIndexes();
        }
    }
}

