/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.acronymtagger.entries;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class FullformEntry
implements Serializable {
    static final long serialVersionUID = 3L;
    public int year;
    public int count;
    public HashSet<String> meshTerms;
    public HashSet<String> unnormalizedForms;

    protected FullformEntry() {
        this.year = 10000;
        this.count = 1;
    }

    protected FullformEntry(int y, Set<String> m, Set<String> f) {
        this.year = y;
        this.meshTerms = new HashSet<String>(m);
        this.count = 1;
        this.unnormalizedForms = new HashSet<String>(f);
    }

    protected FullformEntry(int y, int c, Set<String> m, Set<String> f) {
        this.year = y;
        this.count = c;
        this.meshTerms = new HashSet<String>(m);
        this.unnormalizedForms = new HashSet<String>(f);
    }

    protected String getString() {
        StringBuffer s = new StringBuffer("\t" + this.year + "\t" + this.count);
        for (String mesh : this.meshTerms) {
            s.append("\t");
            s.append(mesh);
        }
        s.append("\t#");
        for (String form : this.unnormalizedForms) {
            s.append("\t");
            s.append(form);
        }
        return s + "\n";
    }

    protected String getHTMLString(boolean includeMeshs) {
        Iterator<String> formIter;
        StringBuffer s = new StringBuffer("<td>" + this.year + "</td><td>" + this.count + "</td><td>");
        if (includeMeshs) {
            Iterator<String> meshIter = this.meshTerms.iterator();
            if (meshIter.hasNext()) {
                s.append(meshIter.next());
            }
            while (meshIter.hasNext()) {
                String m = meshIter.next();
                s.append("<br>" + m);
            }
            s.append("</td><td>");
        }
        if ((formIter = this.unnormalizedForms.iterator()).hasNext()) {
            s.append(formIter.next());
        }
        while (formIter.hasNext()) {
            String f = formIter.next();
            s.append("<br>" + f);
        }
        s.append("</td>");
        return s.toString();
    }
}

