/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.ace;

import de.julielab.jcore.types.Annotation;
import de.julielab.jcore.types.ArgumentMention;
import de.julielab.jcore.types.RelationMention;
import de.julielab.jcore.types.ValueMention;
import de.julielab.jcore.types.ace.Anchor;
import de.julielab.jcore.types.ace.Document;
import de.julielab.jcore.types.ace.Entity;
import de.julielab.jcore.types.ace.EntityAttribute;
import de.julielab.jcore.types.ace.EntityMention;
import de.julielab.jcore.types.ace.Event;
import de.julielab.jcore.types.ace.EventArgument;
import de.julielab.jcore.types.ace.EventMention;
import de.julielab.jcore.types.ace.EventMentionArgument;
import de.julielab.jcore.types.ace.Head;
import de.julielab.jcore.types.ace.LDC_Scope;
import de.julielab.jcore.types.ace.Name;
import de.julielab.jcore.types.ace.Relation;
import de.julielab.jcore.types.ace.RelationArgument;
import de.julielab.jcore.types.ace.RelationMentionArgument;
import de.julielab.jcore.types.ace.SourceFile;
import de.julielab.jcore.types.ace.Timex2;
import de.julielab.jcore.types.ace.Timex2Mention;
import de.julielab.jcore.types.ace.Value;
import de.julielab.jcore.utility.JCoReAnnotationTools;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.util.Progress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AceReader
extends CollectionReader_ImplBase {
    private int startEndFailureCounter = 0;
    private int validDocumentCounter = 0;
    private int invalidDocumentCounter = 0;
    private boolean generateJulesTypes = true;
    Hashtable<String, String> mappings;
    Hashtable<String, Annotation> ids = new Hashtable();
    private String documentText = "";
    private List<File> files;
    private static Logger logger = LoggerFactory.getLogger(AceReader.class);
    public static final String PARAM_INPUTDIR = "inputDirectory";
    private int currentIndex;
    private DocumentBuilder builder;
    public static final String ELEMENT_ENTITY = "entity";
    public static final String ELEMENT_DOCUMENT = "document";
    public static final String ELEMENT_ENTITY_MENTION = "entity_mention";
    public static final String ELEMENT_SOURCE_FILE = "source_file";
    public static final String ELEMENT_EXTENT = "extent";
    public static final String ELEMENT_HEAD = "head";
    public static final String ELEMENT_CHARSEQ = "charseq";
    public static final String ELEMENT_ENTITY_ATTRIBUTES = "entity_attributes";
    public static final String ELEMENT_NAME = "name";
    public static final String ELEMENT_VALUE = "value";
    public static final String ELEMENT_TIMEX2 = "timex2";
    public static final String ELEMENT_VALUE_MENTION = "value_mention";
    public static final String ELEMENT_ANCHOR = "anchor";
    public static final String ELEMENT_LDC_SCOPE = "ldc_scope";
    public static final String ELEMENT_TIMEX2_MENTION = "timex2_mention";
    public static final String ELEMENT_RELATION = "relation";
    public static final String ELEMENT_EVENT = "event";
    public static final String ELEMENT_RELATION_ARGUMENT = "relation_argument";
    public static final String ELEMENT_EVENT_ARGUMENT = "event_argument";
    public static final String ELEMENT_EVENT_MENTION = "event_mention";
    public static final String ELEMENT_RELATION_MENTION = "relation_mention";
    public static final String ELEMENT_RELATION_MENTION_ARGUMENT = "relation_mention_argument";
    public static final String ELEMENT_EVENT_MENTION_ARGUMENT = "event_mention_argument";
    public static final String ELEMENT_BODY = "BODY";
    public static final String ELEMENT_TEXT = "TEXT";
    public static final String ITEM_START = "START";
    public static final String ITEM_END = "END";
    public static final String ITEM_ID = "ID";
    public static final String ITEM_MOD = "MOD";
    public static final String ITEM_COMMENT = "COMMENT";
    public static final String ITEM_ANCHOR_VAL = "ANCHOR_VAL";
    public static final String ITEM_VAL = "VAL";
    public static final String ITEM_SET = "SET";
    public static final String ITEM_NON_SPECIFIC = "NON_SPECIFIC";
    public static final String ITEM_ANCHOR_DIR = "ANCHOR_DIR";
    public static final String ITEM_LEVEL = "LEVEL";
    public static final String ITEM_TYPE = "TYPE";
    public static final String ITEM_SOURCE = "SOURCE";
    public static final String ITEM_AUTHOR = "AUTHOR";
    public static final String ITEM_ENCODING = "ENCODING";
    public static final String ITEM_SUBTYPE = "SUBTYPE";
    public static final String ITEM_LDCTYPE = "LDCTYPE";
    public static final String ITEM_LDCATR = "LDCATR";
    public static final String ITEM_METONYMY_MENTION = "METONYMY_MENTION";
    public static final String ITEM_TENSE = "TENSE";
    public static final String ITEM_MODALITY = "MODALITY";
    public static final String ITEM_POLARITY = "POLARITY";
    public static final String ITEM_GENERICITY = "GENERICITY";
    public static final String ITEM_CLASS = "CLASS";
    public static final String ITEM_REFID = "REFID";
    public static final String ITEM_ROLE = "ROLE";
    public static final String ITEM_URI = "URI";
    public static final String ITEM_DOCID = "DOCID";
    public static final String ITEM_LEXICALCONDITION = "LEXICALCONDITION";

    public void getNext(CAS cas) throws IOException, CollectionException {
        JCas jcas;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            this.builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            logger.error("getNext(CAS): " + e.getMessage() + "\nERROR! No builder available\n" + e.getStackTrace());
        }
        if (this.files == null) {
            this.files = this.getFilesFromInputDirectory();
        }
        try {
            jcas = cas.getJCas();
        }
        catch (CASException e) {
            throw new CollectionException((Throwable)e);
        }
        File apfXmlFile = this.files.get(this.currentIndex++);
        logger.info("getNext(CAS) - Reading file " + apfXmlFile.getName());
        FileInputStream apfXmlFis = new FileInputStream(apfXmlFile);
        FileInputStream sgmFis = null;
        String sgmFileName = this.getSgmFileName(apfXmlFile.getName());
        try {
            File sgmFile = this.getSgmFileFromInputDirectory(sgmFileName);
            logger.info("getNext(CAS) - Reading source file " + sgmFile.getName());
            org.w3c.dom.Document sgmDomDocument = this.builder.parse(sgmFile);
            this.setDocumentText(jcas, sgmDomDocument);
            org.w3c.dom.Document apfXmlDomDocument = this.builder.parse(apfXmlFile);
            this.addSourceFileInformation(apfXmlDomDocument, jcas);
            if (this.generateJulesTypes) {
                this.generateJulesTypes(jcas);
            }
        }
        catch (SAXException e1) {
            logger.error("getNext(CAS): " + e1.getMessage() + "\n" + e1.getStackTrace());
        }
        catch (IndexOutOfBoundsException e2) {
            logger.error("getNext(CAS): " + e2.getMessage() + "\n" + e2.getStackTrace());
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        apfXmlFis.close();
        if (sgmFis != null) {
            sgmFis.close();
        }
        if (this.startEndFailureCounter > 0) {
            System.out.println("ATTENTION! There have been " + this.startEndFailureCounter + " start-end-failures. Check the logger for more information!\n\n");
            ++this.invalidDocumentCounter;
        } else {
            ++this.validDocumentCounter;
        }
        System.out.println("\n\nValid Documents: " + this.validDocumentCounter);
        System.out.println("Invalid Documents: " + this.invalidDocumentCounter);
        this.startEndFailureCounter = 0;
    }

    public void generateJulesTypes(JCas jcas) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        logger.info("Generating Jules Entities");
        this.generateEntities(jcas);
        logger.info("Generating Jules Values");
        this.generateValues(jcas);
        logger.info("Generating Jules Timex2");
        this.generateTimex2(jcas);
        logger.info("Generating Jules Relations");
        this.generateRelation(jcas);
        logger.info("Generating Jules Events");
        this.generateEvents(jcas);
    }

    private void generateEvents(JCas jcas) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        AnnotationIndex eventmentionIndex = jcas.getJFSIndexRepository().getAnnotationIndex(EventMention.type);
        for (EventMention em : eventmentionIndex) {
            String type = "de.julielab.jcore.types.ace." + em.getEvent_ref().getAce_type();
            de.julielab.jcore.types.EventMention event = (de.julielab.jcore.types.EventMention)JCoReAnnotationTools.getAnnotationByClassName((JCas)jcas, (String)type);
            event.setBegin(em.getBegin());
            event.setEnd(em.getEnd());
            event.setSpecificType(em.getEvent_ref().getAce_subtype());
            event.setGenericity(em.getEvent_ref().getGenericity());
            event.setModality(em.getEvent_ref().getModality());
            event.setTense(em.getEvent_ref().getTense());
            event.setPolarity(em.getEvent_ref().getPolarity());
            FSArray eventmention_args = em.getArguments();
            FSArray event_args = new FSArray(jcas, eventmention_args.size());
            for (int i = 0; i < eventmention_args.size(); ++i) {
                EventMentionArgument orignial_arg = (EventMentionArgument)eventmention_args.get(i);
                ArgumentMention event_arg = new ArgumentMention(jcas);
                event_arg.setRef(this.ids.get(orignial_arg.getRefid()));
                event_arg.setRole(orignial_arg.getAce_role());
                event_arg.setBegin(orignial_arg.getBegin());
                event_arg.setEnd(orignial_arg.getEnd());
                event_arg.addToIndexes();
                event_args.set(i, (FeatureStructure)event_arg);
            }
            event_args.addToIndexes();
            event.setArguments(event_args);
            event.setBegin(em.getAnchor().getBegin());
            event.setEnd(em.getAnchor().getEnd());
            event.setId(em.getId());
            event.addToIndexes();
        }
    }

    private void generateRelation(JCas jcas) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        AnnotationIndex relationmentionIndex = jcas.getJFSIndexRepository().getAnnotationIndex(de.julielab.jcore.types.ace.RelationMention.type);
        FSIterator relationmentionIterator = relationmentionIndex.iterator();
        RelationMentionArgument arg1 = null;
        RelationMentionArgument arg2 = null;
        while (relationmentionIterator.hasNext()) {
            de.julielab.jcore.types.ace.RelationMention rl = (de.julielab.jcore.types.ace.RelationMention)relationmentionIterator.next();
            RelationMentionArgument node1 = rl.getArguments(0);
            if (node1.getAce_role().equals("Arg-1")) {
                arg1 = node1;
            } else {
                arg2 = node1;
            }
            RelationMentionArgument node2 = rl.getArguments(1);
            if (node2.getAce_role().equals("Arg-1")) {
                arg1 = node2;
            } else {
                arg2 = node2;
            }
            boolean inverse = arg1.getBegin() < arg2.getBegin() ? false : arg1.getBegin() != arg2.getBegin() || arg1.getEnd() <= arg2.getEnd();
            String type = "de.julielab.jcore.types.ace." + this.mappings.get(rl.getRelation_ref().getAce_type());
            if (inverse) {
                type = type + "_Inverse";
            }
            RelationMention relation = (RelationMention)JCoReAnnotationTools.getAnnotationByClassName((JCas)jcas, (String)type);
            String subtype = rl.getRelation_ref().getAce_subtype();
            relation.setSpecificType(subtype);
            relation.setBegin(rl.getBegin());
            relation.setEnd(rl.getEnd());
            relation.setModality(rl.getRelation_ref().getModality());
            relation.setTense(rl.getRelation_ref().getTense());
            relation.setId(rl.getId());
            FSArray arguments = new FSArray(jcas, 2);
            ArgumentMention mentionarg1 = new ArgumentMention(jcas);
            ArgumentMention mentionarg2 = new ArgumentMention(jcas);
            if (inverse) {
                mentionarg1.setRef(this.ids.get(arg2.getRefid()));
                mentionarg1.setRole("arg1");
                mentionarg2.setRef(this.ids.get(arg1.getRefid()));
                mentionarg2.setRole("arg2");
            } else {
                mentionarg1.setRef(this.ids.get(arg1.getRefid()));
                mentionarg1.setRole("arg1");
                mentionarg2.setRef(this.ids.get(arg2.getRefid()));
                mentionarg2.setRole("arg2");
            }
            mentionarg1.addToIndexes();
            mentionarg2.addToIndexes();
            arguments.set(0, (FeatureStructure)mentionarg1);
            arguments.set(1, (FeatureStructure)mentionarg2);
            arguments.addToIndexes();
            relation.setArguments(arguments);
            relation.addToIndexes();
        }
    }

    private void generateEntities(JCas jcas) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        AnnotationIndex entitymentionIndex = jcas.getJFSIndexRepository().getAnnotationIndex(EntityMention.type);
        for (EntityMention em : entitymentionIndex) {
            String type = "de.julielab.jcore.types.ace." + em.getEntity_ref().getAce_type();
            String subtype = em.getEntity_ref().getAce_subtype();
            de.julielab.jcore.types.EntityMention entity = (de.julielab.jcore.types.EntityMention)JCoReAnnotationTools.getAnnotationByClassName((JCas)jcas, (String)type);
            entity.setSpecificType(subtype);
            entity.setHead(new Annotation(jcas, em.getHead().getBegin(), em.getHead().getEnd()));
            entity.setMentionLevel(em.getMention_type());
            entity.setBegin(em.getBegin());
            entity.setEnd(em.getEnd());
            entity.setId(em.getId());
            entity.addToIndexes();
            this.ids.put(em.getId(), (Annotation)entity);
        }
    }

    private void generateTimex2(JCas jcas) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        AnnotationIndex timex2Index = jcas.getJFSIndexRepository().getAnnotationIndex(Timex2.type);
        for (Timex2 timex2 : timex2Index) {
            FSArray timex2Mentions = timex2.getMentions();
            for (int i = 0; i < timex2Mentions.size(); ++i) {
                Timex2Mention timex2mention = (Timex2Mention)timex2Mentions.get(i);
                de.julielab.jcore.types.Timex2Mention current = (de.julielab.jcore.types.Timex2Mention)JCoReAnnotationTools.getAnnotationByClassName((JCas)jcas, (String)"de.julielab.jcore.types.Timex2Mention");
                current.setBegin(timex2mention.getBegin());
                current.setEnd(timex2mention.getEnd());
                current.setId(timex2mention.getId());
                current.addToIndexes();
                this.ids.put(timex2mention.getId(), (Annotation)current);
            }
        }
    }

    private void generateValues(JCas jcas) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        AnnotationIndex valueIndex = jcas.getJFSIndexRepository().getAnnotationIndex(Value.type);
        for (Value value : valueIndex) {
            FSArray valuementions = value.getMentions();
            for (int i = 0; i < valuementions.size(); ++i) {
                de.julielab.jcore.types.ace.ValueMention valueMention = (de.julielab.jcore.types.ace.ValueMention)valuementions.get(i);
                String type = "de.julielab.jcore.types.ace." + this.mappings.get(value.getAce_type());
                String subtype = value.getAce_subtype();
                ValueMention current = (ValueMention)JCoReAnnotationTools.getAnnotationByClassName((JCas)jcas, (String)type);
                current.setSpecificType(subtype);
                current.setBegin(valueMention.getBegin());
                current.setEnd(valueMention.getEnd());
                current.setId(valueMention.getId());
                current.addToIndexes();
                this.ids.put(valueMention.getId(), (Annotation)current);
            }
        }
    }

    public void writeFailureFile(String fileName) {
        String failureFilePath = "src/test/resources/failureFile";
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(failureFilePath, true)));
            out.write(fileName);
            out.write("\n");
            out.close();
        }
        catch (Exception e) {
            System.err.println("ERROR! ");
            e.printStackTrace();
        }
    }

    public void setDocumentText(JCas jcas, org.w3c.dom.Document sgmDomDocument) {
        Element documentNode = sgmDomDocument.getDocumentElement();
        this.documentText = documentNode.getTextContent();
        this.documentText = this.replaceWhiteChar(this.documentText);
        jcas.setDocumentText(this.documentText);
    }

    private String replaceWhiteChar(String inputDocumentText) {
        String documentText = inputDocumentText;
        documentText = documentText.replaceAll("\n", " ");
        documentText = documentText.replaceAll("\t", " ");
        documentText = documentText.replaceAll("\r", " ");
        documentText = documentText.replaceAll("\f", " ");
        return documentText;
    }

    public String getSgmFileName(String apfXmlFileName) {
        String sgmFileName = apfXmlFileName.substring(0, apfXmlFileName.length() - 7);
        sgmFileName = sgmFileName + "sgm";
        return sgmFileName;
    }

    public void addTimex2Information(Node timex2Node, Timex2 aceTimex2, JCas jcas) {
        this.setTimex2Attributes(aceTimex2, timex2Node);
        FSArray timex2MentionFSArray = this.getTimex2MentionFSArray(timex2Node, jcas);
        aceTimex2.setMentions(timex2MentionFSArray);
        aceTimex2.addToIndexes();
    }

    public void addRelationInformation(Node relationNode, Relation aceRelation, JCas jcas) {
        this.setRelationAttributes(aceRelation, relationNode);
        FSArray relationArgumentFSArray = this.getRelationArgumentFSArray(relationNode, jcas);
        FSArray relationMentionFSArray = this.getRelationMentionFSArray(relationNode, aceRelation, jcas);
        aceRelation.setArguments(relationArgumentFSArray);
        aceRelation.setMentions(relationMentionFSArray);
        aceRelation.addToIndexes();
    }

    public void addEventInformation(Node eventNode, Event aceEvent, JCas jcas) {
        this.setEventAttributes(aceEvent, eventNode);
        FSArray eventArgumentFSArray = this.getEventArgumentFSArray(eventNode, jcas);
        FSArray eventMentionFSArray = this.getEventMentionFSArray(eventNode, aceEvent, jcas);
        aceEvent.setArguments(eventArgumentFSArray);
        aceEvent.setMentions(eventMentionFSArray);
    }

    public String retrieveAttribute(Node node, String attributeName) {
        String attributeValue = "";
        try {
            attributeValue = node.getAttributes().getNamedItem(attributeName).getNodeValue();
        }
        catch (Exception e) {
            logger.info("retrieveAttribute(Node, String): " + e.getMessage() + "\nATTENTION! Node " + node.getNodeName() + " has no " + attributeName + " attribute!");
        }
        return attributeValue;
    }

    public void addValueInformation(Node valueNode, Value aceValue, JCas jcas) {
        this.setValueAttributes(aceValue, valueNode);
        FSArray valueMentionFSArray = this.getValueMentionFSArray(valueNode, jcas);
        aceValue.setMentions(valueMentionFSArray);
        aceValue.addToIndexes();
    }

    public void addEntityInformation(Node entityNode, Entity aceEntity, JCas jcas) {
        this.setEntityAttributes(aceEntity, entityNode);
        FSArray entityMentionFSArray = this.getEntityMentionFSArray(entityNode, aceEntity, jcas);
        FSArray entityAttributesFSArray = this.getEntityAttributesFSArray(entityNode, jcas);
        aceEntity.setEntity_mentions(entityMentionFSArray);
        aceEntity.setEntity_attributes(entityAttributesFSArray);
        aceEntity.addToIndexes();
    }

    public FSArray getEntityAttributesFSArray(Node entityNode, JCas jcas) {
        NodeList children = entityNode.getChildNodes();
        ArrayList<Node> attributesNodeArrayList = this.getSpecificNodeArrayList(children, ELEMENT_ENTITY_ATTRIBUTES);
        FSArray entityAttributesFSArray = new FSArray(jcas, attributesNodeArrayList.size());
        for (int i = 0; i < attributesNodeArrayList.size(); ++i) {
            Node entityAttributesNode = attributesNodeArrayList.get(i);
            EntityAttribute entityAttribute = new EntityAttribute(jcas);
            this.setEntityAttributesInformation(entityAttribute, entityAttributesNode, jcas);
            entityAttribute.addToIndexes();
            entityAttributesFSArray.set(i, (FeatureStructure)entityAttribute);
        }
        entityAttributesFSArray.addToIndexes();
        return entityAttributesFSArray;
    }

    public void setEntityAttributesInformation(EntityAttribute entityAttributes, Node entityAttributesNode, JCas jcas) {
        ArrayList<Object> nameNodeArrayList = new ArrayList();
        NodeList children = entityAttributesNode.getChildNodes();
        nameNodeArrayList = this.getSpecificNodeArrayList(children, ELEMENT_NAME);
        FSArray nameFSArray = new FSArray(jcas, nameNodeArrayList.size());
        for (int i = 0; i < nameNodeArrayList.size(); ++i) {
            Node nameNode = (Node)nameNodeArrayList.get(i);
            Name julesName = new Name(jcas);
            this.setJulesNameName(julesName, nameNode);
            this.setJulesNameStartEnd(julesName, nameNode);
            julesName.addToIndexes();
            nameFSArray.set(i, (FeatureStructure)julesName);
        }
        nameFSArray.addToIndexes();
        entityAttributes.setNames(nameFSArray);
    }

    public void setJulesNameStartEnd(Name julesName, Node nameNode) {
        NodeList children = nameNode.getChildNodes();
        ArrayList<Node> charseqNodeArrayList = this.getSpecificNodeArrayList(children, ELEMENT_CHARSEQ);
        Node charseqNode = charseqNodeArrayList.get(0);
        int nameStart = Integer.parseInt(charseqNode.getAttributes().getNamedItem(ITEM_START).getNodeValue());
        int nameEnd = Integer.parseInt(charseqNode.getAttributes().getNamedItem(ITEM_END).getNodeValue());
        this.validateStartEnd(nameStart, nameEnd, charseqNode);
        julesName.setBegin(nameStart);
        julesName.setEnd(nameEnd + 1);
    }

    public void setValueMentionStartEnd(de.julielab.jcore.types.ace.ValueMention valueMention, Node valueMentionNode) {
        int valueMentionStart = this.retrieveStartEndValue(valueMentionNode, ITEM_START);
        int valueMentionEnd = this.retrieveStartEndValue(valueMentionNode, ITEM_END);
        this.validateStartEnd(valueMentionStart, valueMentionEnd, this.getMentionCharseqNode(valueMentionNode));
        valueMention.setBegin(valueMentionStart);
        valueMention.setEnd(valueMentionEnd + 1);
    }

    public void setRelationMentionStartEnd(de.julielab.jcore.types.ace.RelationMention relationMention, Node relationMentionNode) {
        int relationMentionStart = this.retrieveStartEndValue(relationMentionNode, ITEM_START);
        int relationMentionEnd = this.retrieveStartEndValue(relationMentionNode, ITEM_END);
        this.validateStartEnd(relationMentionStart, relationMentionEnd, this.getMentionCharseqNode(relationMentionNode));
        relationMention.setBegin(relationMentionStart);
        relationMention.setEnd(relationMentionEnd + 1);
    }

    public void setRelationMentionArgumentStartEnd(RelationMentionArgument relationMentionArgument, Node relationMentionArgumentNode) {
        int relationMentionArgumentStart = this.retrieveStartEndValue(relationMentionArgumentNode, ITEM_START);
        int relationMentionArgumentEnd = this.retrieveStartEndValue(relationMentionArgumentNode, ITEM_END);
        this.validateStartEnd(relationMentionArgumentStart, relationMentionArgumentEnd, this.getMentionCharseqNode(relationMentionArgumentNode));
        relationMentionArgument.setBegin(relationMentionArgumentStart);
        relationMentionArgument.setEnd(relationMentionArgumentEnd + 1);
    }

    public void setEventMentiuonStartEnd(EventMention eventMention, Node eventMentionNode) {
        int eventMentionStart = this.retrieveStartEndValue(eventMentionNode, ITEM_START);
        int eventMentionEnd = this.retrieveStartEndValue(eventMentionNode, ITEM_END);
        this.validateStartEnd(eventMentionStart, eventMentionEnd, this.getMentionCharseqNode(eventMentionNode));
        eventMention.setBegin(eventMentionStart);
        eventMention.setEnd(eventMentionEnd + 1);
    }

    public void setEventMentionArgumentStartEnd(EventMentionArgument eventMentionArgument, Node eventMentionArgumentNode) {
        int eventMentionArgumentStart = this.retrieveStartEndValue(eventMentionArgumentNode, ITEM_START);
        int eventMentionArgumentEnd = this.retrieveStartEndValue(eventMentionArgumentNode, ITEM_END);
        this.validateStartEnd(eventMentionArgumentStart, eventMentionArgumentEnd, this.getMentionCharseqNode(eventMentionArgumentNode));
        eventMentionArgument.setBegin(eventMentionArgumentStart);
        eventMentionArgument.setEnd(eventMentionArgumentEnd + 1);
    }

    public int retrieveStartEndValue(Node node, String itemName) {
        int value = 0;
        NodeList children = node.getChildNodes();
        ArrayList<Node> extentNodeArrayList = this.getSpecificNodeArrayList(children, ELEMENT_EXTENT);
        Node extentNode = extentNodeArrayList.get(0);
        children = extentNode.getChildNodes();
        ArrayList<Node> charseqNodeArrayList = this.getSpecificNodeArrayList(children, ELEMENT_CHARSEQ);
        Node charseqNode = charseqNodeArrayList.get(0);
        try {
            value = Integer.parseInt(charseqNode.getAttributes().getNamedItem(itemName).getNodeValue());
        }
        catch (Exception e) {
            logger.info("retrieveStartEndValue(Node, String): " + e.getMessage() + "\nATTENTION! The node " + node.getNodeName() + "has insufficient start/end information!");
        }
        return value;
    }

    public void setTimex2MentionStartEnd(Timex2Mention timex2Mention, Node timex2MentionNode) {
        int timex2MentionStart = this.retrieveStartEndValue(timex2MentionNode, ITEM_START);
        int timex2MentionEnd = this.retrieveStartEndValue(timex2MentionNode, ITEM_END);
        this.validateStartEnd(timex2MentionStart, timex2MentionEnd, this.getMentionCharseqNode(timex2MentionNode));
        timex2Mention.setBegin(timex2MentionStart);
        timex2Mention.setEnd(timex2MentionEnd + 1);
    }

    public void setEventMentionAnchorStartEnd(Anchor eventMentionAnchor, Node anchorNode) {
        NodeList children = anchorNode.getChildNodes();
        ArrayList<Node> charseqNodeArrayList = this.getSpecificNodeArrayList(children, ELEMENT_CHARSEQ);
        Node charseqNode = charseqNodeArrayList.get(0);
        int anchorStart = Integer.parseInt(charseqNode.getAttributes().getNamedItem(ITEM_START).getNodeValue());
        int anchorEnd = Integer.parseInt(charseqNode.getAttributes().getNamedItem(ITEM_END).getNodeValue());
        this.validateStartEnd(anchorStart, anchorEnd, charseqNode);
        eventMentionAnchor.setBegin(anchorStart);
        eventMentionAnchor.setEnd(anchorEnd + 1);
    }

    public void setEventMentionLDCScopeStartEnd(LDC_Scope eventMentionLDCScope, Node LDCScopeNode) {
        NodeList children = LDCScopeNode.getChildNodes();
        ArrayList<Node> charseqNodeArrayList = this.getSpecificNodeArrayList(children, ELEMENT_CHARSEQ);
        Node charseqNode = charseqNodeArrayList.get(0);
        int LDCScopeStart = Integer.parseInt(charseqNode.getAttributes().getNamedItem(ITEM_START).getNodeValue());
        int LDCScopeEnd = Integer.parseInt(charseqNode.getAttributes().getNamedItem(ITEM_END).getNodeValue());
        this.validateStartEnd(LDCScopeStart, LDCScopeEnd, charseqNode);
        eventMentionLDCScope.setBegin(LDCScopeStart);
        eventMentionLDCScope.setEnd(LDCScopeEnd + 1);
    }

    public void setJulesNameName(Name julesName, Node nameNode) {
        String name = "";
        try {
            name = nameNode.getAttributes().getNamedItem("NAME").getNodeValue();
            julesName.setName(name);
        }
        catch (Exception e) {
            logger.info("setJulesNameName(ace.Name, Node): " + e.getMessage() + "\nATTENTION! Entity attribute has no name.");
        }
    }

    public FSArray getEntityMentionFSArray(Node entityNode, Entity aceEntity, JCas jcas) {
        NodeList children = entityNode.getChildNodes();
        ArrayList<Node> entityMentionNodeArrayList = this.getSpecificNodeArrayList(children, ELEMENT_ENTITY_MENTION);
        FSArray entityMentionFSArray = new FSArray(jcas, entityMentionNodeArrayList.size());
        for (int i = 0; i < entityMentionNodeArrayList.size(); ++i) {
            Node entityMentionNode = entityMentionNodeArrayList.get(i);
            EntityMention entityMention = new EntityMention(jcas);
            this.setEntityMentionAttributes(entityMention, entityMentionNode);
            this.setEntityMentionStartEnd(entityMention, entityMentionNode);
            entityMention.setEntity_ref(aceEntity);
            this.setEntityMentionHead(entityMention, entityMentionNode, jcas);
            entityMention.addToIndexes();
            entityMentionFSArray.set(i, (FeatureStructure)entityMention);
        }
        entityMentionFSArray.addToIndexes();
        return entityMentionFSArray;
    }

    public FSArray getTimex2MentionFSArray(Node timex2Node, JCas jcas) {
        NodeList children = timex2Node.getChildNodes();
        ArrayList<Node> timex2MentionNodeArrayList = this.getSpecificNodeArrayList(children, ELEMENT_TIMEX2_MENTION);
        FSArray timex2MentionFSArray = new FSArray(jcas, timex2MentionNodeArrayList.size());
        for (int i = 0; i < timex2MentionNodeArrayList.size(); ++i) {
            Node timex2MentionNode = timex2MentionNodeArrayList.get(i);
            Timex2Mention timex2Mention = new Timex2Mention(jcas);
            this.setTimex2MentionAttributes(timex2Mention, timex2MentionNode);
            this.setTimex2MentionStartEnd(timex2Mention, timex2MentionNode);
            timex2Mention.addToIndexes();
            timex2MentionFSArray.set(i, (FeatureStructure)timex2Mention);
        }
        timex2MentionFSArray.addToIndexes();
        return timex2MentionFSArray;
    }

    public FSArray getRelationArgumentFSArray(Node relationNode, JCas jcas) {
        NodeList children = relationNode.getChildNodes();
        ArrayList<Node> relationArgumentNodeArrayList = this.getSpecificNodeArrayList(children, ELEMENT_RELATION_ARGUMENT);
        FSArray relationArgumentFSArray = new FSArray(jcas, relationArgumentNodeArrayList.size());
        for (int i = 0; i < relationArgumentNodeArrayList.size(); ++i) {
            Node relationArgumentNode = relationArgumentNodeArrayList.get(i);
            RelationArgument relationArgument = new RelationArgument(jcas);
            this.setRelationArgumentAttributes(relationArgument, relationArgumentNode);
            relationArgument.addToIndexes();
            relationArgumentFSArray.set(i, (FeatureStructure)relationArgument);
        }
        relationArgumentFSArray.addToIndexes();
        return relationArgumentFSArray;
    }

    public FSArray getEventArgumentFSArray(Node eventNode, JCas jcas) {
        NodeList children = eventNode.getChildNodes();
        ArrayList<Node> eventArgumentNodeArrayList = this.getSpecificNodeArrayList(children, ELEMENT_EVENT_ARGUMENT);
        FSArray eventArgumentFSArray = new FSArray(jcas, eventArgumentNodeArrayList.size());
        for (int i = 0; i < eventArgumentNodeArrayList.size(); ++i) {
            Node eventArgumentNode = eventArgumentNodeArrayList.get(i);
            EventArgument eventArgument = new EventArgument(jcas);
            this.setEventArgumentAttributes(eventArgument, eventArgumentNode);
            eventArgument.addToIndexes();
            eventArgumentFSArray.set(i, (FeatureStructure)eventArgument);
        }
        eventArgumentFSArray.addToIndexes();
        return eventArgumentFSArray;
    }

    public FSArray getEventMentionFSArray(Node eventNode, Event aceEvent, JCas jcas) {
        NodeList children = eventNode.getChildNodes();
        ArrayList<Node> eventMentionNodeArrayList = this.getSpecificNodeArrayList(children, ELEMENT_EVENT_MENTION);
        FSArray eventMentionFSArray = new FSArray(jcas, eventMentionNodeArrayList.size());
        for (int i = 0; i < eventMentionNodeArrayList.size(); ++i) {
            Node eventMentionNode = eventMentionNodeArrayList.get(i);
            EventMention eventMention = new EventMention(jcas);
            this.setEventMentionAttributes(eventMention, eventMentionNode);
            this.setEventMentiuonStartEnd(eventMention, eventMentionNode);
            this.setEventMentionLDCScope(eventMention, eventMentionNode, jcas);
            eventMention.setEvent_ref(aceEvent);
            this.setEventMentionAnchor(eventMention, eventMentionNode, jcas);
            FSArray eventMentionArgumentFSArray = this.getEventMentionArgumentFSArray(eventMentionNode, jcas);
            eventMention.setArguments(eventMentionArgumentFSArray);
            eventMention.addToIndexes();
            eventMentionFSArray.set(i, (FeatureStructure)eventMention);
        }
        eventMentionFSArray.addToIndexes();
        return eventMentionFSArray;
    }

    public FSArray getRelationMentionFSArray(Node relationNode, Relation aceRelation, JCas jcas) {
        NodeList children = relationNode.getChildNodes();
        ArrayList<Node> relationMentionNodeArrayList = this.getSpecificNodeArrayList(children, ELEMENT_RELATION_MENTION);
        FSArray relationMentionFSArray = new FSArray(jcas, relationMentionNodeArrayList.size());
        for (int i = 0; i < relationMentionNodeArrayList.size(); ++i) {
            Node relationMentionNode = relationMentionNodeArrayList.get(i);
            de.julielab.jcore.types.ace.RelationMention relationMention = new de.julielab.jcore.types.ace.RelationMention(jcas);
            this.setRelationMentionAttributes(relationMention, relationMentionNode);
            this.setRelationMentionStartEnd(relationMention, relationMentionNode);
            relationMention.setRelation_ref(aceRelation);
            FSArray relationMentionArgumentFSArray = this.getRelationMentionArgumentFSArray(relationMentionNode, jcas);
            relationMention.setArguments(relationMentionArgumentFSArray);
            relationMention.addToIndexes();
            relationMentionFSArray.set(i, (FeatureStructure)relationMention);
        }
        relationMentionFSArray.addToIndexes();
        return relationMentionFSArray;
    }

    public FSArray getRelationMentionArgumentFSArray(Node relationMentionNode, JCas jcas) {
        NodeList children = relationMentionNode.getChildNodes();
        ArrayList<Node> relationMentionArgumentNodeArrayList = this.getSpecificNodeArrayList(children, ELEMENT_RELATION_MENTION_ARGUMENT);
        FSArray relationMentionArgumentFSArray = new FSArray(jcas, relationMentionArgumentNodeArrayList.size());
        for (int i = 0; i < relationMentionArgumentNodeArrayList.size(); ++i) {
            Node relationMentionArgumentNode = relationMentionArgumentNodeArrayList.get(i);
            RelationMentionArgument relationMentionArgument = new RelationMentionArgument(jcas);
            this.setRelationMentionArgumentAttributes(relationMentionArgument, relationMentionArgumentNode);
            this.setRelationMentionArgumentStartEnd(relationMentionArgument, relationMentionArgumentNode);
            relationMentionArgument.addToIndexes();
            relationMentionArgumentFSArray.set(i, (FeatureStructure)relationMentionArgument);
        }
        relationMentionArgumentFSArray.addToIndexes();
        return relationMentionArgumentFSArray;
    }

    public FSArray getEventMentionArgumentFSArray(Node eventMentionNode, JCas jcas) {
        NodeList children = eventMentionNode.getChildNodes();
        ArrayList<Node> eventMentionArgumentNodeArrayList = this.getSpecificNodeArrayList(children, ELEMENT_EVENT_MENTION_ARGUMENT);
        FSArray eventMentionArgumentFSArray = new FSArray(jcas, eventMentionArgumentNodeArrayList.size());
        for (int i = 0; i < eventMentionArgumentNodeArrayList.size(); ++i) {
            Node eventMentionArgumentNode = eventMentionArgumentNodeArrayList.get(i);
            EventMentionArgument eventMentionArgument = new EventMentionArgument(jcas);
            this.setEventMentionArgumentAttributes(eventMentionArgument, eventMentionArgumentNode);
            this.setEventMentionArgumentStartEnd(eventMentionArgument, eventMentionArgumentNode);
            eventMentionArgument.addToIndexes();
            eventMentionArgumentFSArray.set(i, (FeatureStructure)eventMentionArgument);
        }
        eventMentionArgumentFSArray.addToIndexes();
        return eventMentionArgumentFSArray;
    }

    public void setEntityAttributes(Entity aceEntity, Node entityNode) {
        String entityID = this.retrieveAttribute(entityNode, ITEM_ID);
        String entityAceType = this.retrieveAttribute(entityNode, ITEM_TYPE);
        String entityAceSubtype = this.retrieveAttribute(entityNode, ITEM_SUBTYPE);
        String entityAceClass = this.retrieveAttribute(entityNode, ITEM_CLASS);
        aceEntity.setId(entityID);
        aceEntity.setAce_type(entityAceType);
        aceEntity.setAce_subtype(entityAceSubtype);
        aceEntity.setAce_class(entityAceClass);
    }

    public void setValueAttributes(Value aceValue, Node valueNode) {
        String valueID = this.retrieveAttribute(valueNode, ITEM_ID);
        String valueAceType = this.retrieveAttribute(valueNode, ITEM_TYPE);
        String valueAceSubtype = this.retrieveAttribute(valueNode, ITEM_SUBTYPE);
        aceValue.setId(valueID);
        aceValue.setAce_type(valueAceType);
        aceValue.setAce_subtype(valueAceSubtype);
    }

    public void setRelationAttributes(Relation aceRelation, Node relationNode) {
        String relationID = this.retrieveAttribute(relationNode, ITEM_ID);
        String relationType = this.retrieveAttribute(relationNode, ITEM_TYPE);
        String relationSubtype = this.retrieveAttribute(relationNode, ITEM_SUBTYPE);
        String relationTense = this.retrieveAttribute(relationNode, ITEM_TENSE);
        String relationModality = this.retrieveAttribute(relationNode, ITEM_MODALITY);
        aceRelation.setId(relationID);
        aceRelation.setAce_type(relationType);
        aceRelation.setAce_subtype(relationSubtype);
        aceRelation.setTense(relationTense);
        aceRelation.setModality(relationModality);
    }

    public void setEventAttributes(Event aceEvent, Node eventNode) {
        String eventID = this.retrieveAttribute(eventNode, ITEM_ID);
        String eventType = this.retrieveAttribute(eventNode, ITEM_TYPE);
        String eventSubtype = this.retrieveAttribute(eventNode, ITEM_SUBTYPE);
        String eventModality = this.retrieveAttribute(eventNode, ITEM_MODALITY);
        String eventPolarity = this.retrieveAttribute(eventNode, ITEM_POLARITY);
        String eventGenericity = this.retrieveAttribute(eventNode, ITEM_GENERICITY);
        String eventTense = this.retrieveAttribute(eventNode, ITEM_TENSE);
        aceEvent.setId(eventID);
        aceEvent.setAce_type(eventType);
        aceEvent.setAce_subtype(eventSubtype);
        aceEvent.setModality(eventModality);
        aceEvent.setPolarity(eventPolarity);
        aceEvent.setGenericity(eventGenericity);
        aceEvent.setTense(eventTense);
    }

    public void setTimex2Attributes(Timex2 aceTimex2, Node timex2Node) {
        String timex2ID = this.retrieveAttribute(timex2Node, ITEM_ID);
        String timex2Mod = this.retrieveAttribute(timex2Node, ITEM_MOD);
        String timex2Comment = this.retrieveAttribute(timex2Node, ITEM_COMMENT);
        String timex2AnchorVal = this.retrieveAttribute(timex2Node, ITEM_ANCHOR_VAL);
        String timex2Val = this.retrieveAttribute(timex2Node, ITEM_VAL);
        String timex2Set = this.retrieveAttribute(timex2Node, ITEM_SET);
        String timex2NonSpecific = this.retrieveAttribute(timex2Node, ITEM_NON_SPECIFIC);
        String timex2AnchorDir = this.retrieveAttribute(timex2Node, ITEM_ANCHOR_DIR);
        aceTimex2.setId(timex2ID);
        aceTimex2.setMod(timex2Mod);
        aceTimex2.setComment(timex2Comment);
        aceTimex2.setAnchor_val(timex2AnchorVal);
        aceTimex2.setVal(timex2Val);
        aceTimex2.setSet(timex2Set);
        aceTimex2.setNon_specific(timex2NonSpecific);
        aceTimex2.setAnchor_dir(timex2AnchorDir);
    }

    public void setTimex2MentionAttributes(Timex2Mention timex2Mention, Node timex2MentionNode) {
        String timex2MentionID = this.retrieveAttribute(timex2MentionNode, ITEM_ID);
        timex2Mention.setId(timex2MentionID);
    }

    public void setRelationMentionArgumentAttributes(RelationMentionArgument relationMentionArgument, Node relationMentionArgumentNode) {
        String relationMentionArgumentRefID = this.retrieveAttribute(relationMentionArgumentNode, ITEM_REFID);
        String relationMentionArgumentRole = this.retrieveAttribute(relationMentionArgumentNode, ITEM_ROLE);
        relationMentionArgument.setRefid(relationMentionArgumentRefID);
        relationMentionArgument.setAce_role(relationMentionArgumentRole);
    }

    public void setEventMentionArgumentAttributes(EventMentionArgument eventMentionArgument, Node eventMentionArgumentNode) {
        String eventMentionArgumentRefID = this.retrieveAttribute(eventMentionArgumentNode, ITEM_REFID);
        String eventMentionArgumentRole = this.retrieveAttribute(eventMentionArgumentNode, ITEM_ROLE);
        eventMentionArgument.setRefid(eventMentionArgumentRefID);
        eventMentionArgument.setAce_role(eventMentionArgumentRole);
    }

    public void setSourceFileAttributes(SourceFile aceSourceFile, Node sourceFileNode) {
        String sourceFileUri = this.retrieveAttribute(sourceFileNode, ITEM_URI);
        String sourceFileType = this.retrieveAttribute(sourceFileNode, ITEM_TYPE);
        String sourceFileSource = this.retrieveAttribute(sourceFileNode, ITEM_SOURCE);
        String sourceFileAuthor = this.retrieveAttribute(sourceFileNode, ITEM_AUTHOR);
        String sourceFileEncoding = this.retrieveAttribute(sourceFileNode, ITEM_ENCODING);
        aceSourceFile.setUri(sourceFileUri);
        aceSourceFile.setAce_type(sourceFileType);
        aceSourceFile.setSource(sourceFileSource);
        aceSourceFile.setAuthor(sourceFileAuthor);
        aceSourceFile.setEncoding(sourceFileEncoding);
    }

    public void setEntityMentionAttributes(EntityMention entityMention, Node entityMentionNode) {
        String entityMentionID = this.retrieveAttribute(entityMentionNode, ITEM_ID);
        String entityMentionType = this.retrieveAttribute(entityMentionNode, ITEM_TYPE);
        String entityMentionLDCType = this.retrieveAttribute(entityMentionNode, ITEM_LDCTYPE);
        String entityMentionRole = this.retrieveAttribute(entityMentionNode, ITEM_ROLE);
        String entityMentionMetonymyMention = this.retrieveAttribute(entityMentionNode, ITEM_METONYMY_MENTION);
        String entityMentionLDCAtr = this.retrieveAttribute(entityMentionNode, ITEM_LDCATR);
        entityMention.setId(entityMentionID);
        entityMention.setMention_type(entityMentionType);
        entityMention.setMention_ldctype(entityMentionLDCType);
        entityMention.setAce_role(entityMentionRole);
        entityMention.setMetonymy_mention(entityMentionMetonymyMention);
        entityMention.setLdcatr(entityMentionLDCAtr);
    }

    public void setRelationArgumentAttributes(RelationArgument relationArgument, Node relationArgumentNode) {
        String relationArgumentREFID = this.retrieveAttribute(relationArgumentNode, ITEM_REFID);
        String relationArgumentRole = this.retrieveAttribute(relationArgumentNode, ITEM_ROLE);
        relationArgument.setRefid(relationArgumentREFID);
        relationArgument.setAce_role(relationArgumentRole);
    }

    public void setEventArgumentAttributes(EventArgument eventArgument, Node eventArgumentNode) {
        String eventArgumentRefID = this.retrieveAttribute(eventArgumentNode, ITEM_REFID);
        String eventArgumentRole = this.retrieveAttribute(eventArgumentNode, ITEM_ROLE);
        String eventArgumentType = this.retrieveAttribute(eventArgumentNode, ITEM_TYPE);
        eventArgument.setRefid(eventArgumentRefID);
        eventArgument.setAce_role(eventArgumentRole);
        eventArgument.setAce_type(eventArgumentType);
    }

    public void setEventMentionAttributes(EventMention eventMention, Node eventMentionNode) {
        String eventMentionID = this.retrieveAttribute(eventMentionNode, ITEM_ID);
        String eventMentionLevel = this.retrieveAttribute(eventMentionNode, ITEM_LEVEL);
        eventMention.setId(eventMentionID);
        eventMention.setLevel(eventMentionLevel);
    }

    public void setEventMentionAnchor(EventMention eventMention, Node eventMentionNode, JCas jcas) {
        NodeList children = eventMentionNode.getChildNodes();
        ArrayList<Node> anchorNodeArrayList = this.getSpecificNodeArrayList(children, ELEMENT_ANCHOR);
        Node anchorNode = anchorNodeArrayList.get(0);
        Anchor eventMentionAnchor = new Anchor(jcas);
        try {
            this.setEventMentionAnchorStartEnd(eventMentionAnchor, anchorNode);
        }
        catch (Exception e) {
            logger.info("setEventMentionAnchor(ace.EventMention, Node, JCas): " + e.getMessage() + "\nATTENTION! Couldn't retrieve the start-end-information of " + anchorNode.getNodeName() + "!");
        }
        eventMentionAnchor.addToIndexes();
        eventMention.setAnchor(eventMentionAnchor);
    }

    public void setEventMentionLDCScope(EventMention eventMention, Node eventMentionNode, JCas jcas) {
        NodeList children = eventMentionNode.getChildNodes();
        ArrayList<Node> LDCScopeNodeArrayList = this.getSpecificNodeArrayList(children, ELEMENT_LDC_SCOPE);
        Node LDCScopeNode = LDCScopeNodeArrayList.get(0);
        LDC_Scope eventMentionLDCScope = new LDC_Scope(jcas);
        try {
            this.setEventMentionLDCScopeStartEnd(eventMentionLDCScope, LDCScopeNode);
        }
        catch (Exception e) {
            logger.info("setEventMentionAnchor(ace.EventMention, Node, JCas): " + e.getMessage() + "\nATTENTION! Couldn't retrieve the start-end-information of " + LDCScopeNode.getNodeName() + "!");
        }
        eventMentionLDCScope.addToIndexes();
        eventMention.setLdc_scope(eventMentionLDCScope);
    }

    public void setRelationMentionAttributes(de.julielab.jcore.types.ace.RelationMention relationMention, Node relationMentionNode) {
        String relationMentionID = this.retrieveAttribute(relationMentionNode, ITEM_ID);
        String relationMentionLexCond = this.retrieveAttribute(relationMentionNode, ITEM_LEXICALCONDITION);
        relationMention.setId(relationMentionID);
        relationMention.setLexical_condition(relationMentionLexCond);
    }

    public void setValueMentionAttributes(de.julielab.jcore.types.ace.ValueMention valueMention, Node valueMentionNode) {
        String valueMentionID = this.retrieveAttribute(valueMentionNode, ITEM_ID);
        valueMention.setId(valueMentionID);
    }

    public FSArray getValueMentionFSArray(Node valueNode, JCas jcas) {
        NodeList children = valueNode.getChildNodes();
        ArrayList<Node> valueMentionNodeArrayList = this.getSpecificNodeArrayList(children, ELEMENT_VALUE_MENTION);
        FSArray valueMentionFSArray = new FSArray(jcas, valueMentionNodeArrayList.size());
        for (int i = 0; i < valueMentionNodeArrayList.size(); ++i) {
            Node valueMentionNode = valueMentionNodeArrayList.get(i);
            de.julielab.jcore.types.ace.ValueMention valueMention = new de.julielab.jcore.types.ace.ValueMention(jcas);
            this.setValueMentionAttributes(valueMention, valueMentionNode);
            this.setValueMentionStartEnd(valueMention, valueMentionNode);
            valueMention.addToIndexes();
            valueMentionFSArray.set(i, (FeatureStructure)valueMention);
        }
        valueMentionFSArray.addToIndexes();
        return valueMentionFSArray;
    }

    public void setEntityMentionHead(EntityMention entityMention, Node entityMentionNode, JCas jcas) {
        try {
            Head entityMentionHead = new Head(jcas);
            this.getHeadInformation(entityMentionHead, entityMentionNode);
            entityMention.setHead(entityMentionHead);
        }
        catch (Exception e) {
            logger.info("setEntityMentionHead(ace.EntityMention, Node, JCas): " + e.getMessage() + "\nAttention! Entity mention head information couldn't be retrieved!");
        }
    }

    public void setEntityMentionStartEnd(EntityMention entityMention, Node entityMentionNode) {
        int entityMentionStart = this.retrieveStartEndValue(entityMentionNode, ITEM_START);
        int entityMentionEnd = this.retrieveStartEndValue(entityMentionNode, ITEM_END);
        this.validateStartEnd(entityMentionStart, entityMentionEnd, this.getMentionCharseqNode(entityMentionNode));
        entityMention.setBegin(entityMentionStart);
        entityMention.setEnd(entityMentionEnd + 1);
    }

    public void getHeadInformation(Head entityMentionHead, Node entityMentionNode) {
        int headStart = 0;
        int headEnd = 0;
        NodeList children = entityMentionNode.getChildNodes();
        ArrayList<Node> auxiliaryArrayList = this.getSpecificNodeArrayList(children, ELEMENT_HEAD);
        Node headNode = auxiliaryArrayList.get(0);
        children = headNode.getChildNodes();
        auxiliaryArrayList = this.getSpecificNodeArrayList(children, ELEMENT_CHARSEQ);
        Node charseqNode = auxiliaryArrayList.get(0);
        try {
            headStart = Integer.parseInt(this.retrieveAttribute(charseqNode, ITEM_START));
            headEnd = Integer.parseInt(this.retrieveAttribute(charseqNode, ITEM_END));
            this.validateStartEnd(headStart, headEnd, charseqNode);
        }
        catch (Exception e) {
            logger.info("getHeadInformation(ace.Head, Node): " + e.getMessage() + "\nATTENTION! The node " + entityMentionNode.getNodeName() + " has no valid head information.");
        }
        entityMentionHead.setBegin(headStart);
        entityMentionHead.setEnd(headEnd + 1);
        entityMentionHead.addToIndexes();
    }

    public ArrayList<Node> getSpecificNodeArrayList(NodeList children, String elementName) {
        Node child = null;
        ArrayList<Node> specificNodeArrayList = new ArrayList<Node>();
        for (int i = 0; i < children.getLength(); ++i) {
            child = children.item(i);
            if (!child.getNodeName().equals(elementName)) continue;
            specificNodeArrayList.add(child);
        }
        return specificNodeArrayList;
    }

    public void addDocumentInformation(Node documentNode, Document aceDocument, JCas jcas) {
        try {
            String docID = this.retrieveAttribute(documentNode, ITEM_DOCID);
            FSArray entityFSArray = this.getEntityFSArray(documentNode, jcas);
            FSArray valueFSArray = this.getValueFSArray(documentNode, jcas);
            FSArray timex2FSArray = this.getTimex2FSArray(documentNode, jcas);
            FSArray relationFSArray = this.getRelationFSArray(documentNode, jcas);
            FSArray eventFSArray = this.getEventFSArray(documentNode, jcas);
            aceDocument.setDocid(docID);
            aceDocument.setEntities(entityFSArray);
            aceDocument.setValues(valueFSArray);
            aceDocument.setTimex2(timex2FSArray);
            aceDocument.setRelations(relationFSArray);
            aceDocument.setEvents(eventFSArray);
            aceDocument.addToIndexes();
        }
        catch (Exception e) {
            logger.error("addDocumentInformation(Node, ace.Document, JCas): " + e.getMessage() + "\nATTENTION! Document information couldn't be retrieved!\n" + e.getStackTrace());
        }
    }

    public FSArray getEntityFSArray(Node documentNode, JCas jcas) {
        NodeList children = documentNode.getChildNodes();
        ArrayList<Node> entityNodeArrayList = this.getSpecificNodeArrayList(children, ELEMENT_ENTITY);
        FSArray entityFSArray = new FSArray(jcas, entityNodeArrayList.size());
        for (int i = 0; i < entityNodeArrayList.size(); ++i) {
            Entity aceEntity = new Entity(jcas);
            Node entityNode = entityNodeArrayList.get(i);
            this.addEntityInformation(entityNode, aceEntity, jcas);
            entityFSArray.set(i, (FeatureStructure)aceEntity);
        }
        entityFSArray.addToIndexes();
        return entityFSArray;
    }

    public FSArray getValueFSArray(Node documentNode, JCas jcas) {
        NodeList children = documentNode.getChildNodes();
        ArrayList<Node> valueNodeArrayList = this.getSpecificNodeArrayList(children, ELEMENT_VALUE);
        FSArray valueFSArray = new FSArray(jcas, valueNodeArrayList.size());
        for (int i = 0; i < valueNodeArrayList.size(); ++i) {
            Value aceValue = new Value(jcas);
            Node valueNode = valueNodeArrayList.get(i);
            this.addValueInformation(valueNode, aceValue, jcas);
            valueFSArray.set(i, (FeatureStructure)aceValue);
        }
        valueFSArray.addToIndexes();
        return valueFSArray;
    }

    public FSArray getTimex2FSArray(Node documentNode, JCas jcas) {
        NodeList children = documentNode.getChildNodes();
        ArrayList<Node> timex2NodeArrayList = this.getSpecificNodeArrayList(children, ELEMENT_TIMEX2);
        FSArray timex2FSArray = new FSArray(jcas, timex2NodeArrayList.size());
        for (int i = 0; i < timex2NodeArrayList.size(); ++i) {
            Timex2 aceTimex2 = new Timex2(jcas);
            Node timex2Node = timex2NodeArrayList.get(i);
            this.addTimex2Information(timex2Node, aceTimex2, jcas);
            timex2FSArray.set(i, (FeatureStructure)aceTimex2);
        }
        timex2FSArray.addToIndexes();
        return timex2FSArray;
    }

    public FSArray getRelationFSArray(Node documentNode, JCas jcas) {
        NodeList children = documentNode.getChildNodes();
        ArrayList<Node> relationNodeArrayList = this.getSpecificNodeArrayList(children, ELEMENT_RELATION);
        FSArray relationFSArray = new FSArray(jcas, relationNodeArrayList.size());
        for (int i = 0; i < relationNodeArrayList.size(); ++i) {
            Relation aceRelation = new Relation(jcas);
            Node relationNode = relationNodeArrayList.get(i);
            this.addRelationInformation(relationNode, aceRelation, jcas);
            relationFSArray.set(i, (FeatureStructure)aceRelation);
        }
        relationFSArray.addToIndexes();
        return relationFSArray;
    }

    public FSArray getEventFSArray(Node documentNode, JCas jcas) {
        NodeList children = documentNode.getChildNodes();
        ArrayList<Node> eventNodeArrayList = this.getSpecificNodeArrayList(children, ELEMENT_EVENT);
        FSArray eventFSArray = new FSArray(jcas, eventNodeArrayList.size());
        for (int i = 0; i < eventNodeArrayList.size(); ++i) {
            Event aceEvent = new Event(jcas);
            Node eventNode = eventNodeArrayList.get(i);
            this.addEventInformation(eventNode, aceEvent, jcas);
            aceEvent.addToIndexes();
            eventFSArray.set(i, (FeatureStructure)aceEvent);
        }
        eventFSArray.addToIndexes();
        return eventFSArray;
    }

    public void addSourceFileInformation(org.w3c.dom.Document domDocument, JCas jcas) {
        NodeList sourceFileNodeList = domDocument.getElementsByTagName(ELEMENT_SOURCE_FILE);
        for (int i = 0; i < sourceFileNodeList.getLength(); ++i) {
            Node sourceFileNode = sourceFileNodeList.item(i);
            SourceFile aceSourceFile = new SourceFile(jcas);
            this.setSourceFileAttributes(aceSourceFile, sourceFileNode);
            FSArray documentsFSArray = this.getDocumentFSArray(sourceFileNode, jcas);
            aceSourceFile.setDocuments(documentsFSArray);
            aceSourceFile.addToIndexes();
        }
    }

    public FSArray getDocumentFSArray(Node sourceFileNode, JCas jcas) {
        NodeList children = sourceFileNode.getChildNodes();
        ArrayList<Node> documentNodeArrayList = this.getSpecificNodeArrayList(children, ELEMENT_DOCUMENT);
        FSArray documentFSArray = new FSArray(jcas, documentNodeArrayList.size());
        for (int i = 0; i < documentNodeArrayList.size(); ++i) {
            try {
                Document aceDocument = new Document(jcas);
                Node documentNode = documentNodeArrayList.get(i);
                this.addDocumentInformation(documentNode, aceDocument, jcas);
                documentFSArray.set(i, (FeatureStructure)aceDocument);
                continue;
            }
            catch (Exception e) {
                logger.info("getDocumentFSArray(Node, JCas): " + e.getMessage() + "\nATTENTION! No document information could be retrieved.");
            }
        }
        documentFSArray.addToIndexes();
        return documentFSArray;
    }

    public void initialize() {
        UimaContext aContext = this.getUimaContext();
        if ((Boolean)aContext.getConfigParameterValue("generateJulesTypes") != null) {
            this.generateJulesTypes = (Boolean)aContext.getConfigParameterValue("generateJulesTypes");
        }
        this.generateMappings();
        logger.info("initialize() - Initializing Ace Reader...");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            this.builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            logger.error("initialize(): " + e.getMessage() + "\n" + e.getStackTrace());
        }
        this.files = this.getFilesFromInputDirectory();
    }

    private void generateMappings() {
        this.mappings = new Hashtable();
        this.mappings.put("PART-WHOLE", "PART_WHOLE");
        this.mappings.put("PER-SOC", "PER_SOC");
        this.mappings.put("ORG-AFF", "ORG_AFF");
        this.mappings.put("GEN-AFF", "GEN_AFF");
        this.mappings.put("ART", "ART");
        this.mappings.put("PHYS", "PHYS");
        this.mappings.put("Numeric", "Numeric");
        this.mappings.put("Sentence", "SentenceACE");
        this.mappings.put("Contact-Info", "Contact_Info");
        this.mappings.put("Crime", "Crime");
        this.mappings.put("Job-Title", "Job_Title");
    }

    public void close() throws IOException {
    }

    public Progress[] getProgress() {
        return null;
    }

    public boolean hasNext() throws IOException, CollectionException {
        return this.currentIndex < this.files.size();
    }

    private List<File> getFilesFromInputDirectory() {
        ArrayList<File> documentFiles = new ArrayList<File>();
        File directory = new File(((String)this.getConfigParameterValue(PARAM_INPUTDIR)).trim());
        if (!directory.exists() || !directory.isDirectory()) {
            logger.info("getFilesFromInputDirectory(): ERROR! Input directory doesn't exist or is not a directory.");
            return null;
        }
        File[] dirFiles = directory.listFiles();
        for (int i = 0; i < dirFiles.length; ++i) {
            if (dirFiles[i].isDirectory() || !dirFiles[i].getAbsolutePath().endsWith("apf.xml")) continue;
            logger.info("getFilesFromInputDirectory():  FILE NAME: " + dirFiles[i].toString());
            documentFiles.add(dirFiles[i]);
            System.out.println(dirFiles[i]);
        }
        return documentFiles;
    }

    private File getSgmFileFromInputDirectory(String sgmFileName) {
        File sgmFile = null;
        File directory = new File(((String)this.getConfigParameterValue(PARAM_INPUTDIR)).trim());
        if (!directory.exists() || !directory.isDirectory()) {
            logger.error("getSgmFileFromInputDirectory(): ERROR! Input directory doesn't exist or is not a directory.");
            return null;
        }
        File[] dirFiles = directory.listFiles();
        for (int i = 0; i < dirFiles.length; ++i) {
            if (dirFiles[i].isDirectory() || !dirFiles[i].getAbsolutePath().endsWith(sgmFileName)) continue;
            sgmFile = dirFiles[i];
            break;
        }
        return sgmFile;
    }

    private void validateStartEnd(int start, int end, Node charseqNode) {
        String retrievedTextSpan;
        String charseqTextSpan = charseqNode.getTextContent();
        boolean spansEqual = (charseqTextSpan = this.replaceWhiteChar(charseqTextSpan)).equals(retrievedTextSpan = this.documentText.substring(start, end + 1));
        if (!spansEqual) {
            logger.error("validateStartEnd(int, int, Node): wrong start-end-information!\nSTART: " + start + "\nEND: " + end + "\ncharseq text span: " + charseqTextSpan + "\nretrieved text span: " + retrievedTextSpan);
            ++this.startEndFailureCounter;
        }
    }

    private Node getMentionCharseqNode(Node mentionNode) {
        NodeList children = mentionNode.getChildNodes();
        ArrayList<Node> extentNodeArrayList = this.getSpecificNodeArrayList(children, ELEMENT_EXTENT);
        Node extentNode = extentNodeArrayList.get(0);
        children = extentNode.getChildNodes();
        ArrayList<Node> charseqNodeArrayList = this.getSpecificNodeArrayList(children, ELEMENT_CHARSEQ);
        Node charseqNode = charseqNodeArrayList.get(0);
        return charseqNode;
    }
}

