/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.ipc.javabridge;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ErrorStreamConsumer
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(ErrorStreamConsumer.class);
    private InputStream is;
    private String terminationSignal;
    private Thread bridgeThread;

    ErrorStreamConsumer(InputStream is, String terminationSignal, Thread bridgeThread) {
        this.is = is;
        this.terminationSignal = terminationSignal;
        this.bridgeThread = bridgeThread;
    }

    public void close() throws IOException {
        this.is.close();
        this.interrupt();
    }

    @Override
    public void run() {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(this.is));){
            String line;
            boolean stop = false;
            while (!stop && (line = br.readLine()) != null) {
                log.error(line);
                if (this.terminationSignal == null || !line.contains(this.terminationSignal)) continue;
                stop = true;
                log.error("The external program did output the termination signal '" + this.terminationSignal + "' in its error output stream. Check the error log for more information.");
                this.bridgeThread.interrupt();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        log.debug("Error stream thread terminates.");
    }
}

