/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.ipc.javabridge;

import de.julielab.ipc.javabridge.Reader;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryReader
extends Reader<byte[]> {
    private static final Logger log = LoggerFactory.getLogger(BinaryReader.class);
    private static final int INT_SIZE = 4;
    private List<byte[]> messageBuffer;
    private List<Integer> messageBufferSizes;
    private boolean gzipReceived;

    public BinaryReader(InputStream is, String externalProgramReadySignal, boolean gzipReceived) {
        super(is, null, externalProgramReadySignal);
        this.gzipReceived = gzipReceived;
    }

    @Override
    public void run() {
        this.setName("BinaryReaderThread");
        log.debug("Starting binary reader thread");
        try {
            int lastReadSize;
            if (this.externalProgramReadySignal != null) {
                log.debug("Waiting for the signal that the external program is ready ('{}')", (Object)this.externalProgramReadySignal);
                String lastLine = "";
                StringBuffer sb = new StringBuffer();
                byte[] eol = System.getProperty("line.separator").getBytes(StandardCharsets.UTF_8);
                ByteBuffer buffer = ByteBuffer.allocate(8192);
                while (!lastLine.equals(this.externalProgramReadySignal)) {
                    boolean foundEol = false;
                    while (!foundEol) {
                        buffer.put((byte)this.is.read());
                        if (buffer.position() <= eol.length) continue;
                        foundEol = true;
                        for (int i = 0; i < eol.length && foundEol; foundEol &= eol[i] == buffer.get(i + buffer.position() - eol.length), ++i) {
                        }
                        if (!foundEol) continue;
                        byte[] bytes = new byte[buffer.position() - eol.length];
                        int length = buffer.position() - eol.length;
                        buffer.position(0);
                        buffer.get(bytes, 0, length);
                        lastLine = new String(bytes, StandardCharsets.UTF_8);
                    }
                    buffer.position(0);
                    if (lastLine.equals(this.externalProgramReadySignal)) continue;
                    log.debug("Received non-ready signal line '{}'", (Object)lastLine);
                }
                log.debug("Received ready signal");
            }
            Supplier<byte[]> bufferSupplier = () -> new byte[8192];
            byte[] buffer = bufferSupplier.get();
            int bytesReadInCurrentMessage = 0;
            int currentMessageLength = -1;
            this.messageBuffer = new ArrayList<byte[]>();
            this.messageBufferSizes = new ArrayList<Integer>();
            long time = -1L;
            while ((lastReadSize = this.is.read(buffer)) != -1) {
                if (time == -1L) {
                    time = System.currentTimeMillis();
                }
                log.trace("Received: {} bytes, total: {}", (Object)lastReadSize, (Object)(bytesReadInCurrentMessage += lastReadSize));
                this.messageBufferSizes.add(lastReadSize);
                this.messageBuffer.add(buffer);
                if (currentMessageLength == -1 && bytesReadInCurrentMessage >= 4) {
                    currentMessageLength = this.readMessageLength();
                }
                while (currentMessageLength != -1 && bytesReadInCurrentMessage - 4 >= currentMessageLength) {
                    byte[] currentMessage = this.assembleCurrentMessage(currentMessageLength);
                    if (this.gzipReceived) {
                        ByteArrayInputStream bais = new ByteArrayInputStream(currentMessage);
                        BufferedInputStream bis = new BufferedInputStream(new GZIPInputStream(bais));
                        currentMessage = IOUtils.toByteArray((InputStream)bis);
                    }
                    this.inputDeque.add(currentMessage);
                    log.trace("Added message of length {} bytes to the queue", (Object)currentMessage.length);
                    time = System.currentTimeMillis() - time;
                    log.trace("Retrieving and assembling last message took {}ms", (Object)time);
                    time = System.currentTimeMillis();
                    bytesReadInCurrentMessage = this.messageBufferSizes.isEmpty() ? 0 : this.messageBufferSizes.stream().reduce(0, (a, b) -> a + b);
                    currentMessageLength = this.readMessageLength();
                }
                buffer = bufferSupplier.get();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        log.debug("BinaryReader thread terminates.");
    }

    private byte[] assembleCurrentMessage(int currentMessageLength) {
        byte[] currentMessage = new byte[currentMessageLength];
        int copied = 0;
        int prologPast = 0;
        boolean clearBuffer = true;
        for (int i = 0; i < this.messageBuffer.size(); ++i) {
            byte[] b = this.messageBuffer.get(i);
            Integer readBytesLength = this.messageBufferSizes.get(i);
            int prologInCurrentBuffer = 0;
            if (readBytesLength > 4 && prologPast == 0) {
                prologInCurrentBuffer = prologPast = 4;
            } else {
                if (prologPast < 4 && prologPast + readBytesLength <= 4) {
                    prologPast += readBytesLength.intValue();
                    continue;
                }
                if (prologPast < 4) {
                    int missingPrologSize = 4 - prologPast;
                    prologPast += missingPrologSize;
                    prologInCurrentBuffer = missingPrologSize;
                }
            }
            int toCopy = Math.min(currentMessageLength - copied, readBytesLength - prologInCurrentBuffer);
            System.arraycopy(b, prologInCurrentBuffer, currentMessage, copied, toCopy);
            copied += toCopy;
            if (toCopy + prologInCurrentBuffer >= readBytesLength) continue;
            clearBuffer = false;
            int byteLength = readBytesLength - (toCopy + prologInCurrentBuffer);
            byte[] nextMessageBegin = new byte[byteLength];
            System.arraycopy(b, toCopy + prologInCurrentBuffer, nextMessageBegin, 0, byteLength);
            ArrayList<byte[]> newMessageBuffer = new ArrayList<byte[]>(this.messageBuffer.size());
            ArrayList<Integer> newMessageBufferSizes = new ArrayList<Integer>(this.messageBufferSizes.size());
            newMessageBuffer.add(nextMessageBegin);
            newMessageBufferSizes.add(byteLength);
            for (int j = i + 1; j < this.messageBuffer.size(); ++j) {
                newMessageBuffer.add(this.messageBuffer.get(j));
                newMessageBufferSizes.add(this.messageBufferSizes.get(j));
            }
            this.messageBuffer = newMessageBuffer;
            this.messageBufferSizes = newMessageBufferSizes;
            log.trace("Remaining message buffer length: {}", (Object)this.messageBuffer.get(0).length);
            break;
        }
        if (clearBuffer) {
            this.messageBuffer.clear();
            this.messageBufferSizes.clear();
        }
        log.trace("Copied {} bytes for the current message", (Object)copied);
        return currentMessage;
    }

    private int readMessageLength() {
        if (!this.messageBuffer.isEmpty() && this.messageBufferSizes.stream().reduce(0, (a, b) -> a + b) >= 4) {
            byte[] intBytes = new byte[4];
            int pos = 0;
            for (int i = 0; i < this.messageBuffer.size(); ++i) {
                byte[] b2 = this.messageBuffer.get(i);
                Integer readBytesLength = this.messageBufferSizes.get(i);
                int toCopy = Math.min(readBytesLength, intBytes.length - pos);
                System.arraycopy(b2, 0, intBytes, pos, toCopy);
                if ((pos += toCopy) >= 4) break;
            }
            int currentMessageLength = (intBytes[0] & 0xFF) << 24 | (intBytes[1] & 0xFF) << 16 | (intBytes[2] & 0xFF) << 8 | intBytes[3] & 0xFF;
            log.trace("Current message size is {} bytes", (Object)currentMessageLength);
            return currentMessageLength;
        }
        return -1;
    }
}

