/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jules.ae.genemapping.utils;

import java.util.ArrayList;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);

    public static TreeSet<String> getCommonWords(String[] firstArray, String[] secondArray) {
        TreeSet<String> firstSet = new TreeSet<String>();
        for (int i = 0; i < firstArray.length; ++i) {
            firstSet.add(firstArray[i]);
        }
        TreeSet<String> secondSet = new TreeSet<String>();
        for (int i = 0; i < secondArray.length; ++i) {
            secondSet.add(secondArray[i]);
        }
        TreeSet<String> intersection = new TreeSet<String>((SortedSet<String>)firstSet);
        intersection.retainAll(secondSet);
        return intersection;
    }

    public static TreeSet<String> getDifferentWords(String[] firstArray, String[] secondArray) {
        TreeSet<String> firstSet = new TreeSet<String>();
        for (int i = 0; i < firstArray.length; ++i) {
            firstSet.add(firstArray[i]);
        }
        TreeSet<String> secondSet = new TreeSet<String>();
        for (int i = 0; i < secondArray.length; ++i) {
            secondSet.add(secondArray[i]);
        }
        TreeSet<String> different = new TreeSet<String>((SortedSet<String>)firstSet);
        different.removeAll(secondSet);
        return different;
    }

    public static double getOverlapRatio(String first, String second) {
        String[] firstArray = first.split(" ");
        String[] secondArray = second.split(" ");
        int firstLength = firstArray.length;
        int secondLength = secondArray.length;
        int commonWords = Utils.getCommonWords(firstArray, secondArray).size();
        double firstRatio = (double)commonWords / (double)firstLength;
        double secondRatio = (double)commonWords / (double)secondLength;
        return Math.min(firstRatio, secondRatio);
    }

    public static ArrayList<String> makeBigrams(String term) {
        String[] split = term.split(" ");
        ArrayList<String> bigrams = new ArrayList<String>();
        for (int i = 1; i < split.length; ++i) {
            Object bigram = split[i - 1] + " " + split[i];
            bigram = ((String)bigram).trim();
            bigrams.add((String)bigram);
        }
        return bigrams;
    }

    public static String makeUnderScoreBigrams(String term) {
        String[] split = term.split(" ");
        Object bigrams = "";
        if (split.length == 1) {
            bigrams = term;
        } else {
            for (int i = 1; i < split.length; ++i) {
                String bigram = split[i - 1] + "_" + split[i];
                bigrams = (String)bigrams + bigram + " ";
            }
        }
        return ((String)bigrams).trim();
    }
}

