/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jules.ae.genemapping.utils;

import de.julielab.jcore.types.EntityMention;
import de.julielab.jcore.types.Header;
import de.julielab.jcore.types.Token;
import de.julielab.jcore.utility.JCoReAnnotationTools;
import de.julielab.jules.ae.genemapping.utils.UIMAUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tartarus.snowball.SnowballProgram;
import org.tartarus.snowball.ext.EnglishStemmer;

public class ContextUtils {
    public static final String[] STOPWORDS = new String[]{"a", "about", "above", "across", "after", "afterwards", "again", "against", "all", "almost", "alone", "along", "already", "also", "although", "always", "am", "among", "amongst", "amoungst", "amount", "an", "and", "another", "any", "anyhow", "anyone", "anything", "anyway", "anywhere", "are", "around", "as", "at", "back", "be", "became", "because", "become", "becomes", "becoming", "been", "before", "beforehand", "behind", "being", "below", "beside", "besides", "between", "beyond", "bill", "both", "bottom", "but", "by", "call", "can", "cannot", "cant", "co", "computer", "con", "could", "couldnt", "cry", "de", "describe", "detail", "do", "done", "down", "due", "during", "each", "eg", "eight", "either", "eleven", "else", "elsewhere", "empty", "enough", "etc", "even", "ever", "every", "everyone", "everything", "everywhere", "except", "few", "fifteen", "fify", "fill", "find", "fire", "first", "five", "for", "former", "formerly", "forty", "found", "four", "from", "front", "full", "further", "get", "give", "go", "had", "has", "hasnt", "have", "he", "hence", "her", "here", "hereafter", "hereby", "herein", "hereupon", "hers", "herself", "him", "himself", "his", "how", "however", "hundred", "ie", "if", "in", "inc", "indeed", "interest", "into", "is", "it", "its", "itself", "keep", "last", "latter", "latterly", "least", "less", "ltd", "made", "many", "may", "me", "meanwhile", "might", "mill", "mine", "more", "moreover", "most", "mostly", "move", "much", "must", "my", "myself", "name", "namely", "neither", "never", "nevertheless", "next", "nine", "no", "nobody", "none", "noone", "nor", "not", "nothing", "now", "nowhere", "of", "off", "often", "on", "once", "one", "only", "onto", "or", "other", "others", "otherwise", "our", "ours", "ourselves", "out", "over", "own", "part", "per", "perhaps", "please", "put", "rather", "re", "same", "see", "seem", "seemed", "seeming", "seems", "serious", "several", "she", "should", "show", "side", "since", "sincere", "six", "sixty", "so", "some", "somehow", "someone", "something", "sometime", "sometimes", "somewhere", "still", "such", "system", "take", "ten", "than", "that", "the", "their", "them", "themselves", "then", "thence", "there", "thereafter", "thereby", "therefore", "therein", "thereupon", "these", "they", "thick", "thin", "third", "this", "those", "though", "three", "through", "throughout", "thru", "thus", "to", "together", "too", "top", "toward", "towards", "twelve", "twenty", "two", "un", "under", "until", "up", "upon", "us", "very", "via", "was", "we", "well", "were", "what", "whatever", "when", "whence", "whenever", "where", "whereafter", "whereas", "whereby", "wherein", "whereupon", "wherever", "whether", "which", "while", "whither", "who", "whoever", "whole", "whom", "whose", "why", "will", "with", "within", "without", "would", "yet", "you", "your", "yours", "yourself", "yourselves"};
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextUtils.class);

    public static TokenStream getStemmingStream(String input) {
        StandardAnalyzer analyzer = new StandardAnalyzer(CharArraySet.copy(new HashSet<String>(Arrays.asList(STOPWORDS))));
        SnowballFilter stemmer = new SnowballFilter(analyzer.tokenStream("", (Reader)new StringReader(input)), (SnowballProgram)new EnglishStemmer());
        return stemmer;
    }

    public static String makeContextTypes(String context) throws IOException {
        StringBuilder ret = new StringBuilder();
        HashSet<String> contextTypes = new HashSet<String>();
        try (TokenStream ts = ContextUtils.getStemmingStream(context);){
            CharTermAttribute cta = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
            while (ts.incrementToken()) {
                String token = cta.toString();
                if (context.contains(token)) continue;
                ret.append(token);
                ret.append(" ");
                contextTypes.add(token);
            }
            ret.deleteCharAt(ret.length() - 1);
        }
        return ret.toString();
    }

    public static String makeContextTokens(String context) throws IOException {
        StringBuilder ret = new StringBuilder();
        try (TokenStream ts = ContextUtils.getStemmingStream(context);){
            ts.reset();
            CharTermAttribute cta = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
            while (ts.incrementToken()) {
                String token = cta.toString();
                ret.append(token);
                ret.append(" ");
            }
        }
        if (ret.length() > 0) {
            ret.deleteCharAt(ret.length() - 1);
        }
        return ret.toString();
    }

    public static BooleanQuery makeContextQuery(JCas aJCas) throws IOException {
        String contextString = "";
        contextString = aJCas.getDocumentText();
        if (contextString == null || contextString.length() == 0) {
            LOGGER.error("ContextString for the Query is empty");
            return null;
        }
        LOGGER.debug("semantic index search context: " + contextString);
        return ContextUtils.makeContextQuery(contextString.trim());
    }

    public static BooleanQuery makeContextQuery(JCas aJCas, int windowSize, EntityMention entity) throws IOException {
        LOGGER.debug("Making context query");
        String contextString = ContextUtils.makeContext(aJCas, windowSize, entity);
        return ContextUtils.makeContextQuery(contextString.trim());
    }

    public static String makeContext(JCas aJCas, int windowSize, EntityMention entity) {
        LOGGER.debug("Making context");
        StringBuilder contextString = new StringBuilder();
        try {
            FSIterator cursor = aJCas.getAnnotationIndex(Token.type).iterator();
            if (!cursor.hasNext()) {
                FSIterator headerIt = aJCas.getAnnotationIndex(Header.type).iterator();
                Header header = null;
                if (headerIt.hasNext()) {
                    header = (Header)headerIt.next();
                }
                String docId = header != null ? header.getDocId() : "<unknown>";
                LOGGER.warn("The document with ID {} does not have any tokens. Cannot create context on token basis, resorting to character-based context.", (Object)docId);
                int characterWindowSize = 5 * windowSize;
                LOGGER.warn("Converting token window size of {} to character window size of {} (larger by factor 5)", (Object)windowSize, (Object)characterWindowSize);
                int contextAffixSize = (characterWindowSize - (entity.getEnd() - entity.getBegin())) / 2;
                int contextStart = Math.max(0, entity.getBegin() - contextAffixSize);
                int contextEnd = Math.min(aJCas.getDocumentText().length(), entity.getEnd() + contextAffixSize + 1);
                return aJCas.getDocumentText().substring(contextStart, contextEnd).trim();
            }
            Token actual_token = null;
            ArrayList entityTokens = (ArrayList)UIMAUtils.getAnnotations(aJCas, (Annotation)entity, Token.class);
            actual_token = entityTokens != null && entityTokens.size() > 0 ? (Token)entityTokens.get(0) : UIMAUtils.getContainingAnnotation(aJCas, (Annotation)entity, Token.class);
            if (actual_token == null) {
                actual_token = (Token)JCoReAnnotationTools.getOverlappingAnnotation((JCas)aJCas, (String)Token.class.getCanonicalName(), (int)entity.getBegin(), (int)entity.getEnd());
            }
            cursor.moveTo((FeatureStructure)actual_token);
            int stopNumber = 0;
            int tokensBefore = 0;
            int maxClauseCount = BooleanQuery.getMaxClauseCount();
            if (windowSize > 0) {
                tokensBefore = windowSize / 2;
                stopNumber = windowSize;
            } else {
                tokensBefore = maxClauseCount / 2;
                stopNumber = maxClauseCount;
            }
            while (cursor.isValid() && tokensBefore > 0) {
                --tokensBefore;
                cursor.moveToPrevious();
            }
            if (!cursor.isValid()) {
                cursor.moveToFirst();
            }
            for (int stop = 0; cursor.hasNext() && stop < stopNumber; ++stop) {
                Token token = (Token)cursor.next();
                contextString.append(token.getCoveredText());
                contextString.append(" ");
            }
        }
        catch (Exception e) {
            String docId = null;
            FSIterator it = aJCas.getAnnotationIndex(Header.type).iterator();
            if (it.hasNext()) {
                Header h = (Header)it.next();
                docId = h.getDocId();
            }
            LOGGER.error("Error while running MakeContextQuery on document with ID {} on entity {}: {}", new Object[]{docId, entity, e});
            e.printStackTrace();
        }
        if (contextString == null || contextString.length() == 0) {
            LOGGER.error("ContextString for the Query is empty");
            return null;
        }
        LOGGER.debug("semantic index search context: " + contextString);
        LOGGER.debug("----" + contextString + "-----");
        return contextString.toString();
    }

    private static void between(int begin, int end) {
    }

    public static BooleanQuery makeContextQuery(String context) throws IOException {
        BooleanQuery.Builder contextQuery = new BooleanQuery.Builder();
        int maxClauseCount = BooleanQuery.getMaxClauseCount();
        try (TokenStream ts = ContextUtils.getStemmingStream(context);){
            ts.reset();
            CharTermAttribute cta = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
            int added = 0;
            while (ts.incrementToken()) {
                if (added < maxClauseCount - 1) {
                    contextQuery.add((Query)new TermQuery(new Term("indexed_context", cta.toString())), BooleanClause.Occur.SHOULD);
                    ++added;
                    continue;
                }
                LOGGER.warn("makeContextQuery() - context too long, cut after " + maxClauseCount + " tokens");
                break;
            }
        }
        LOGGER.debug("makeContextQuery() - query for disambiguation: " + contextQuery);
        return contextQuery.build();
    }
}

