/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jules.ae.genemapping.scoring;

import com.wcohen.ss.AbstractStringDistance;
import com.wcohen.ss.BasicStringWrapper;
import com.wcohen.ss.api.StringWrapper;
import java.io.Serializable;
import java.util.HashMap;

public class TokenJaroSimilarity
extends AbstractStringDistance
implements Serializable {
    private static final long serialVersionUID = 1L;

    public String toString() {
        return "[Jaro]";
    }

    public double tokenScore(String first, String second) {
        String token;
        int i;
        int replacement = 0;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String[] firstArray = first.split(" ");
        String[] secondArray = second.split(" ");
        StringBuffer term1 = new StringBuffer();
        StringBuffer term2 = new StringBuffer();
        term1.append("0");
        term2.append("0");
        for (i = 0; i < firstArray.length; ++i) {
            token = firstArray[i];
            if (map.containsKey(token)) {
                term1.append(((Integer)map.get(token)).toString());
                continue;
            }
            term1.append(++replacement);
            map.put(token, replacement);
        }
        for (i = 0; i < secondArray.length; ++i) {
            token = secondArray[i];
            if (map.containsKey(token)) {
                term2.append(((Integer)map.get(token)).toString());
                continue;
            }
            term2.append(++replacement);
            map.put(token, replacement);
        }
        String s1 = term1.toString().trim();
        String s2 = term2.toString().trim();
        return this.score(this.prepare(s1), this.prepare(s2));
    }

    public int getTokenTranspositions(String first, String second) {
        String token;
        int i;
        int replacement = 1;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String[] firstArray = first.split(" ");
        String[] secondArray = second.split(" ");
        StringBuffer term1 = new StringBuffer();
        StringBuffer term2 = new StringBuffer();
        term1.append("0");
        term2.append("0");
        for (i = 0; i < firstArray.length; ++i) {
            token = firstArray[i];
            if (map.containsKey(token)) {
                term1.append(((Integer)map.get(token)).toString());
                continue;
            }
            term1.append(++replacement);
            map.put(token, replacement);
        }
        for (i = 0; i < secondArray.length; ++i) {
            token = secondArray[i];
            if (map.containsKey(token)) {
                term2.append(((Integer)map.get(token)).toString());
                continue;
            }
            term2.append(++replacement);
            map.put(token, replacement);
        }
        String s1 = term1.toString().trim();
        String s2 = term2.toString().trim();
        return this.getTransposition(this.prepare(s1), this.prepare(s2));
    }

    public double score(StringWrapper s, StringWrapper t) {
        String str1 = s.unwrap();
        String str2 = t.unwrap();
        int halflen = this.halfLengthOfShorter(str1, str2);
        String common1 = this.commonChars(str1, str2, halflen);
        String common2 = this.commonChars(str2, str1, halflen);
        if (common1.length() != common2.length()) {
            return 0.0;
        }
        if (common1.length() == 0 || common2.length() == 0) {
            return 0.0;
        }
        int transpositions = this.transpositions(common1, common2);
        double dist = ((double)common1.length() / (double)str1.length() + (double)common2.length() / (double)str2.length() + (double)(common1.length() - transpositions) / (double)common1.length()) / 3.0;
        return dist;
    }

    public int getTransposition(StringWrapper s, StringWrapper t) {
        String str1 = s.unwrap();
        String str2 = t.unwrap();
        int halflen = this.halfLengthOfShorter(str1, str2);
        String common1 = this.commonChars(str1, str2, halflen);
        String common2 = this.commonChars(str2, str1, halflen);
        int res = 0;
        int trans = this.transpositions(common1, common2);
        res = this.score(s, t) == 0.0 && trans == 0 ? -1 : trans;
        return res;
    }

    public String explainScore(StringWrapper s, StringWrapper t) {
        String str1 = s.unwrap();
        String str2 = t.unwrap();
        int halflen = this.halfLengthOfShorter(str1, str2);
        String common1 = this.commonChars(str1, str2, halflen);
        String common2 = this.commonChars(str2, str1, halflen);
        if (common1.length() != common2.length()) {
            return "common1!=common2: '" + common1 + "' != '" + common2 + "'\nscore: " + this.score(s, t) + "\n";
        }
        if (common1.length() == 0 || common2.length() == 0) {
            return "|commoni|=0: common1='" + common1 + "' common2='" + common2 + "'\nscore: " + this.score(s, t) + "\n";
        }
        int transpositions = this.transpositions(common1, common2);
        String explanation = "common1: '" + common1 + "'\ncommon2: '" + common2 + "'\ntranspositions: " + transpositions + "\n";
        return explanation + "internal score: " + this.score(s, t) + "\n";
    }

    private int halfLengthOfShorter(String str1, String str2) {
        return str1.length() > str2.length() ? str2.length() / 2 + 1 : str1.length() / 2 + 1;
    }

    private String commonChars(String s, String t, int halflen) {
        StringBuilder common = new StringBuilder();
        StringBuilder copy = new StringBuilder(t);
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            boolean foundIt = false;
            for (int j = Math.max(0, i - halflen); !foundIt && j < Math.min(i + halflen, t.length()); ++j) {
                if (copy.charAt(j) != ch) continue;
                foundIt = true;
                common.append(ch);
                copy.setCharAt(j, '*');
            }
        }
        return common.toString();
    }

    public int transpositions(String common1, String common2) {
        int transpositions = 0;
        int len = Math.min(common1.length(), common2.length());
        for (int i = 0; i < len; ++i) {
            if (common1.charAt(i) == common2.charAt(i)) continue;
            ++transpositions;
        }
        return transpositions /= 2;
    }

    public StringWrapper prepare(String s) {
        return new BasicStringWrapper(s.toLowerCase());
    }

    public static void main(String[] argv) {
        System.out.println(new TokenJaroSimilarity().getTokenTranspositions("il 12 a b", "il receptor 12"));
    }
}

