/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jules.ae.genemapping.scoring;

import de.julielab.jules.ae.genemapping.scoring.Scorer;
import org.apache.commons.lang.StringUtils;

public class LevenshteinScorer
extends Scorer {
    @Override
    public double getScore(String term1, String term2) throws RuntimeException {
        if (this.isPerfectMatch(term1, term2)) {
            return 9999.0;
        }
        double distance = StringUtils.getLevenshteinDistance((String)term1, (String)term2);
        double normalizedDistance = distance / Math.max((double)term1.length(), (double)term2.length());
        return 1.0 - normalizedDistance;
    }

    @Override
    public String info() {
        return "Normalized Levenshtein Similarity Scorer";
    }

    @Override
    public int getScorerType() {
        return 4;
    }
}

