/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jules.ae.genemapping.mappingcores;

import de.julielab.jules.ae.genemapping.CandidateRetrieval;
import de.julielab.jules.ae.genemapping.DocumentMappingResult;
import de.julielab.jules.ae.genemapping.GeneMappingConfiguration;
import de.julielab.jules.ae.genemapping.LuceneCandidateRetrieval;
import de.julielab.jules.ae.genemapping.MentionMappingResult;
import de.julielab.jules.ae.genemapping.SynHit;
import de.julielab.jules.ae.genemapping.disambig.SemanticDisambiguation;
import de.julielab.jules.ae.genemapping.disambig.WeepingTreeDisambiguation;
import de.julielab.jules.ae.genemapping.disambig.WeepingTreeDocumentDisambiguationData;
import de.julielab.jules.ae.genemapping.genemodel.GeneDocument;
import de.julielab.jules.ae.genemapping.genemodel.GeneMention;
import de.julielab.jules.ae.genemapping.mappingcores.MappingCore;
import de.julielab.jules.ae.genemapping.utils.GeneMappingException;
import de.julielab.jules.ae.genemapping.utils.norm.TermNormalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class WeepingTreeMappingCore
implements MappingCore {
    public static final String TAX_IDS = "filter_tax_ids";
    private final Set<String> filterTaxIds;
    private final WeepingTreeDisambiguation disambiguation;
    private TermNormalizer normalizer = new TermNormalizer();
    private LuceneCandidateRetrieval candidateRetrieval;

    public WeepingTreeMappingCore(GeneMappingConfiguration configuration) throws GeneMappingException {
        this.candidateRetrieval = new LuceneCandidateRetrieval(configuration);
        this.filterTaxIds = Stream.of(configuration.getProperty(TAX_IDS, "").split(",")).map(String::trim).filter(Predicate.not(String::isBlank)).collect(Collectors.toSet());
        if (this.filterTaxIds.isEmpty()) {
            throw new GeneMappingException("Missing configuration property 'filter_tax_ids'. You must specify at least one taxonomy ID to which all gene mentions should be mapped. You can specify multiple possibilities by providing a comma separated list of tax IDs.");
        }
        this.disambiguation = new WeepingTreeDisambiguation(configuration);
    }

    @Override
    public MentionMappingResult map(GeneMention geneMention) throws GeneMappingException {
        List<SynHit> candidates = this.candidateRetrieval.getCandidates(geneMention);
        MentionMappingResult mappingResult = new MentionMappingResult();
        mappingResult.originalCandidates = candidates;
        mappingResult.bestCandidate = this.getBestSynonyms(candidates, this.filterTaxIds);
        mappingResult.mappedMention = geneMention;
        mappingResult.resultEntries = MentionMappingResult.REJECTION;
        geneMention.setMentionMappingResult(mappingResult);
        return mappingResult;
    }

    private List<SynHit> getBestSynonyms(List<SynHit> candidates, Set<String> taxonomyIDs) {
        if (candidates.isEmpty()) {
            return Collections.emptyList();
        }
        double bestScore = candidates.get(0).getMentionScore();
        ArrayList<SynHit> ret = new ArrayList<SynHit>();
        List candidatesForTaxIds = IntStream.range(0, candidates.size()).filter(i -> {
            if (!taxonomyIDs.isEmpty()) {
                Optional<String> foundTaxId = ((SynHit)candidates.get(i)).getTaxIds().stream().filter(taxonomyIDs::contains).findAny();
                return foundTaxId.isPresent();
            }
            return true;
        }).mapToObj(candidates::get).collect(Collectors.toList());
        if (candidatesForTaxIds.isEmpty()) {
            return Collections.emptyList();
        }
        ret.add((SynHit)candidatesForTaxIds.get(0));
        for (int i2 = 1; i2 < candidatesForTaxIds.size() && ((SynHit)candidatesForTaxIds.get(i2)).getMentionScore() == ((SynHit)candidatesForTaxIds.get(0)).getMentionScore(); ++i2) {
            ret.add((SynHit)candidatesForTaxIds.get(i2));
        }
        List hitsWithBestScore = candidatesForTaxIds.stream().filter(c -> c.getMentionScore() == bestScore).collect(Collectors.toList());
        for (SynHit bestHit : hitsWithBestScore) {
            for (String tax : taxonomyIDs) {
                try {
                    bestHit.setTaxId(tax);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        return hitsWithBestScore.stream().filter(syn -> syn.getTaxId() != null).collect(Collectors.toList());
    }

    @Override
    public SemanticDisambiguation getSemanticDisambiguation() {
        return null;
    }

    @Override
    public CandidateRetrieval getCandidateRetrieval() {
        return this.candidateRetrieval;
    }

    @Override
    public TermNormalizer getTermNormalizer() {
        return this.normalizer;
    }

    @Override
    public DocumentMappingResult map(GeneDocument document) throws GeneMappingException {
        for (GeneMention gm : document.getGenesIterable()) {
            gm.setNormalizer(this.normalizer);
            this.map(gm);
        }
        return this.disambiguation.disambiguateDocument(new WeepingTreeDocumentDisambiguationData(document, this.filterTaxIds));
    }
}

