/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jules.ae.genemapping.index;

import de.julielab.jules.ae.genemapping.CandidateFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContextGenerator {
    private HashMap<String, String> id2go = new HashMap();
    private HashMap<String, String> go2syns = new HashMap();
    private HashMap<String, String> id2summary = new HashMap();
    private HashMap<String, String> id2designations = new HashMap();
    private HashMap<String, String> id2upContext = new HashMap();
    private HashMap<String, String> id2intact = new HashMap();
    private HashMap<String, String> id2generif = new HashMap();
    private HashMap<String, String> gene2syns = new HashMap();

    public ContextGenerator(String resourcesDir, String db) throws FileNotFoundException, IOException {
        File id2EgDesignationFile;
        File id2InteractFile;
        File id2UniprotContextFile;
        File go2SynFile;
        File id2GoFile;
        String idType = "";
        if (db.equals("gene")) {
            idType = "eg";
        } else if (db.equals("protein")) {
            idType = "up";
        }
        File id2SummaryFile = new File(resourcesDir + idType + "2summary");
        if (!id2SummaryFile.isFile()) {
            System.err.println("Could not find file " + id2SummaryFile.getAbsolutePath());
            System.exit(-1);
        }
        if (!(id2GoFile = new File(resourcesDir + idType + "2go")).isFile()) {
            System.err.println("Could not find id2GoFile (" + idType + "2go)");
            System.exit(-1);
        }
        if (!(go2SynFile = new File(resourcesDir + "go_all")).isFile()) {
            System.err.println("Could not find go2SynFile (go_all)");
            System.exit(-1);
        }
        if (!(id2UniprotContextFile = new File(resourcesDir + idType + "2freetext_chromo.context")).isFile()) {
            System.err.println("Could not find id2uniprotContextFile (" + idType + "2freetext_chromo.context)");
            System.exit(-1);
        }
        if (!(id2InteractFile = new File(resourcesDir + idType + "2interaction")).isFile()) {
            System.err.println("Could not find id2InteractFile (" + idType + "2interaction)");
            System.exit(-1);
        }
        if (!(id2EgDesignationFile = new File(resourcesDir + idType + "2designation")).isFile()) {
            System.err.println("Could not find id2DesignationFile (" + idType + "2designation)");
            System.exit(-1);
        }
        this.readId2summaryFile(id2SummaryFile);
        this.readId2GoFile(id2GoFile);
        this.readGo2SynFile(go2SynFile);
        this.readId2UniprotContextFile(id2UniprotContextFile);
        this.readId2IntactFile(id2InteractFile);
        this.readId2EgDesignationFile(id2EgDesignationFile);
    }

    public String getContext(String id) {
        Object context = " ";
        if (this.id2upContext.get(id) != null) {
            context = (String)context + this.id2upContext.get(id);
        }
        if (this.id2designations.get(id) != null) {
            context = (String)context + " " + this.id2designations.get(id);
        }
        if (this.id2summary.get(id) != null) {
            context = (String)context + " " + this.id2summary.get(id);
        }
        if (this.id2generif.get(id) != null) {
            context = (String)context + " " + this.id2generif.get(id);
        }
        if (this.id2intact.get(id) != null) {
            context = (String)context + " " + this.id2intact.get(id);
        }
        if (this.id2go.get(id) != null) {
            String goCodes = this.id2go.get(id);
            String[] codes = goCodes.split("\\|");
            String code = "";
            String syn = "";
            for (int i = 0; i < codes.length; ++i) {
                code = codes[i];
                if (this.go2syns.get(code) == null) continue;
                syn = this.go2syns.get(code);
                syn = syn.replaceAll("\\|", " ");
                context = (String)context + " " + syn;
            }
        }
        if (this.gene2syns.get(id) != null) {
            String syn = this.gene2syns.get(id);
            syn = syn.replaceAll("\\|", " ");
            context = (String)context + " " + syn;
        }
        return ((String)context).trim();
    }

    private void readId2GoFile(File goFile) throws IOException {
        BufferedReader goReader = new BufferedReader(new FileReader(goFile));
        String line = "";
        while ((line = goReader.readLine()) != null) {
            if (line.startsWith("#")) continue;
            String[] values = line.split("\t");
            if (values.length != 2) {
                System.err.println("ERR: goFile not in expected format. \ncritical line: " + line);
                System.exit(-1);
            }
            String id = values[0];
            String go = values[1].trim();
            if (this.id2go.containsKey(id)) {
                Object goCodes = this.id2go.get(id);
                goCodes = (String)goCodes + "|" + go;
                this.id2go.put(id, ((String)goCodes).trim());
                continue;
            }
            this.id2go.put(id, go);
        }
        goReader.close();
        System.out.println("Done processing id2go file.");
    }

    private void readGo2SynFile(File goFile) throws IOException {
        BufferedReader goReader = new BufferedReader(new FileReader(goFile));
        String line = "";
        while ((line = goReader.readLine()) != null) {
            if (line.startsWith("#")) continue;
            String[] values = line.split("\t");
            if (values.length != 2) {
                System.err.println("ERR: go2syns not in expected format. \ncritical line: " + line);
                System.exit(-1);
            }
            String go = values[0];
            String syns = values[1].trim();
            this.go2syns.put(go, syns);
        }
        goReader.close();
        System.out.println("Done processing go2syns file.");
    }

    private void readGene2SynsFile(File geneFile) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(geneFile));
        String line = "";
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#")) continue;
            String[] values = line.split("\t");
            if (values.length != 2) {
                System.err.println("ERR: gene2syns not in expected format. \ncritical line: " + line);
                System.exit(-1);
            }
            String syn = values[0].trim();
            String gene = values[1];
            if (this.gene2syns.containsKey(gene)) {
                Object syns = this.gene2syns.get(gene);
                syns = (String)syns + " " + syn;
                this.gene2syns.put(gene, (String)syns);
                continue;
            }
            this.gene2syns.put(gene, syn);
        }
        reader.close();
        System.out.println("Done processing gene2syns file.");
    }

    private void readId2summaryFile(File id2sumFile) throws IOException {
        BufferedReader id2sumReader = new BufferedReader(new FileReader(id2sumFile));
        String line = "";
        while ((line = id2sumReader.readLine()) != null) {
            if (line.startsWith("#")) continue;
            String[] values = line.split("\t");
            if (values.length != 2) {
                System.err.println("ERR: id2summary not in expected format. \ncritical line: " + line);
                System.exit(-1);
            }
            String id = values[0];
            String summary = values[1].trim();
            this.id2summary.put(id, summary);
        }
        id2sumReader.close();
        System.out.println("Done processing id2summary file.");
    }

    private void readId2UniprotContextFile(File id2upContextFile) throws IOException {
        BufferedReader id2upContextReader = new BufferedReader(new FileReader(id2upContextFile));
        String line = "";
        while ((line = id2upContextReader.readLine()) != null) {
            String[] values = line.split("\t");
            if (line.startsWith("#")) continue;
            if (values.length != 2) {
                System.err.println("ERR: id2upContext not in expected format. \ncritical line: " + line);
                System.exit(-1);
            }
            String id = values[0];
            Object upContext = values[1].trim();
            if (this.id2upContext.containsKey(id)) {
                upContext = (String)upContext + " " + this.id2upContext.get(id);
                this.id2upContext.put(id, (String)upContext);
                continue;
            }
            this.id2upContext.put(id, (String)upContext);
        }
        id2upContextReader.close();
        System.out.println("Done processing id2upContext file.");
    }

    private void readId2EgDesignationFile(File id2DesignFile) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(id2DesignFile));
        String line = "";
        CandidateFilter cf = new CandidateFilter();
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#")) continue;
            String[] values = line.split("\t");
            if (values.length != 2) {
                System.err.println("ERR: id2designate not in expected format. \ncritical line: " + line);
                System.exit(-1);
            }
            String id = values[0];
            Pattern p = cf.patternDomainFamilies;
            Object designation = values[1].trim();
            Matcher m = p.matcher((CharSequence)designation);
            if (m.matches() || (m = (p = cf.patternUnspecifieds).matcher((CharSequence)designation)).matches()) continue;
            if (this.id2designations.containsKey(id)) {
                designation = (String)designation + " " + this.id2designations.get(id);
                this.id2designations.put(id, (String)designation);
                continue;
            }
            this.id2designations.put(id, (String)designation);
        }
        reader.close();
        System.out.println("Done processing id2designations file.");
    }

    private void readId2GeneRifFile(File geneRifFile) throws IOException {
        BufferedReader id2geneRifReader = new BufferedReader(new FileReader(geneRifFile));
        String line = "";
        while ((line = id2geneRifReader.readLine()) != null) {
            String[] values = line.split("\t");
            if (values.length != 2) {
                System.err.println("ERR: id2upContext not in expected format. \ncritical line: " + line);
                System.exit(-1);
            }
            String id = values[0];
            Object geneRifContext = values[1].trim();
            if (this.id2generif.containsKey(id)) {
                geneRifContext = (String)geneRifContext + " " + this.id2generif.get(id);
                this.id2generif.put(id, (String)geneRifContext);
                continue;
            }
            this.id2generif.put(id, (String)geneRifContext);
        }
        id2geneRifReader.close();
        System.out.println("Done processing id2GeneRif file.");
    }

    private void readId2IntactFile(File geneInteractFile) throws IOException {
        BufferedReader id2IntactReader = new BufferedReader(new FileReader(geneInteractFile));
        String line = "";
        while ((line = id2IntactReader.readLine()) != null) {
            String[] values = line.split("\t");
            if (values.length != 2) {
                System.err.println("ERR: id2upContext not in expected format. \ncritical line: " + line);
                System.exit(-1);
            }
            String id = values[0];
            Object geneIntactContext = values[1].trim();
            if (this.id2intact.containsKey(id)) {
                geneIntactContext = (String)geneIntactContext + " " + this.id2intact.get(id);
                this.id2intact.put(id, (String)geneIntactContext);
                continue;
            }
            this.id2intact.put(id, (String)geneIntactContext);
        }
        id2IntactReader.close();
        System.out.println("Done processing id2Intact file.");
    }
}

