/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jules.ae.genemapping.genemodel;

import de.julielab.jules.ae.genemapping.utils.norm.TermNormalizer;
import java.util.List;
import java.util.stream.Collectors;

public class GeneName {
    private String normalizedText;
    private List<String> normalizedTextVariant;
    private TermNormalizer normalizer;
    private String text;

    public GeneName(String text, TermNormalizer normalizer) {
        this.text = text;
        this.normalizer = normalizer;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeneName other = (GeneName)obj;
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }

    public String getNormalizedText() {
        if (null == this.normalizedText) {
            this.normalizedText = this.getNormalizer().normalize(this.text);
        }
        return this.normalizedText;
    }

    public List<String> getNormalizedTextVariant() {
        if (null == this.normalizedTextVariant) {
            this.normalizedTextVariant = this.getNormalizer().generateVariants(this.text).stream().map(this.getNormalizer()::normalize).collect(Collectors.toList());
        }
        return this.normalizedTextVariant;
    }

    public TermNormalizer getNormalizer() {
        return this.normalizer;
    }

    public String getText() {
        return this.text;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public void setNormalizer(TermNormalizer normalizer) {
        this.normalizer = normalizer;
    }

    public void setText(String text) {
        this.text = text;
    }
}

