/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jules.ae.genemapping.genemodel;

import cc.mallet.types.FeatureVector;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import de.julielab.java.utilities.prerequisites.PrerequisiteChecker;
import de.julielab.java.utilities.spanutils.Span;
import de.julielab.jules.ae.genemapping.MentionMappingResult;
import de.julielab.jules.ae.genemapping.SynHit;
import de.julielab.jules.ae.genemapping.genemodel.GeneDocument;
import de.julielab.jules.ae.genemapping.genemodel.GeneName;
import de.julielab.jules.ae.genemapping.genemodel.GeneSpeciesOccurrence;
import de.julielab.jules.ae.genemapping.genemodel.PosTag;
import de.julielab.jules.ae.genemapping.utils.norm.TermNormalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang3.Range;
import org.apache.lucene.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneMention
implements Span {
    private static final Logger log = LoggerFactory.getLogger(GeneMention.class);
    public static final String NOID = "NoId";
    private Object originalMappedObject;
    private String docId;
    private GeneName geneName;
    private String id = "NoId";
    private TermNormalizer normalizer;
    private Range<Integer> offsets;
    private String text;
    private String goldTaxonomyId;
    private String taxonomyId;
    private Map<String, Double> taxonomyScores;
    private GeneSpeciesOccurrence taxonomyReliability;
    private Multimap<String, GeneSpeciesOccurrence> taxonomyCandidates = HashMultimap.create();
    private String documentContext;
    private Query contextQuery;
    private GeneTagger tagger;
    private SpecificType specificType = SpecificType.GENE;
    private double specificTypeConfidence;
    private MentionMappingResult mentionMappingResult;
    private GeneDocument geneDocument;
    private List<String> taggingModifiers;
    private GeneMention parent;
    private List<PosTag> posTags;
    private FeatureVector featureVector;
    private String reducedNameForExactMatch;

    public Object getOriginalMappedObject() {
        return this.originalMappedObject;
    }

    public void setOriginalMappedObject(Object originalMappedObject) {
        this.originalMappedObject = originalMappedObject;
    }

    public GeneMention() {
    }

    public GeneMention(GeneMention gm) {
        this.contextQuery = gm.contextQuery;
        this.docId = gm.docId;
        this.documentContext = gm.documentContext;
        this.geneDocument = gm.geneDocument;
        this.id = gm.id;
        this.normalizer = gm.normalizer;
        this.offsets = gm.offsets;
        this.tagger = gm.tagger;
        this.taxonomyCandidates = gm.taxonomyCandidates;
        this.taxonomyId = gm.taxonomyId;
        this.text = gm.text;
    }

    public GeneMention(String text) {
        this.text = text;
    }

    public GeneMention(String text, TermNormalizer normalizer) {
        this(text);
        this.setNormalizer(normalizer);
    }

    public GeneMention(String text, int begin, int end) {
        this(text);
        this.offsets = Range.between((Comparable)Integer.valueOf(begin), (Comparable)Integer.valueOf(end));
    }

    public String getGoldTaxonomyId() {
        return this.goldTaxonomyId;
    }

    public void setGoldTaxonomyId(String goldTaxonomyId) {
        this.goldTaxonomyId = goldTaxonomyId;
    }

    public void setTaxonomyScore(String tax, double score) {
        if (this.taxonomyScores == null) {
            this.taxonomyScores = new HashMap<String, Double>();
        }
        this.taxonomyScores.put(tax, score);
    }

    public double getTaxonomyScore(String taxonomyId) {
        return this.taxonomyScores == null ? 0.0 : this.taxonomyScores.getOrDefault(taxonomyId, 0.0);
    }

    public Map<String, Double> getTaxonomyScores() {
        return this.taxonomyScores;
    }

    public void setTaxonomyScores(Map<String, Double> taxonomyScores) {
        this.taxonomyScores = taxonomyScores;
    }

    public GeneSpeciesOccurrence getTaxonomyReliability() {
        return this.taxonomyReliability;
    }

    public void setTaxonomyReliability(GeneSpeciesOccurrence taxonomyReliability) {
        this.taxonomyReliability = taxonomyReliability;
    }

    public List<String> getTaggingModifiers() {
        return this.taggingModifiers;
    }

    public void acceptHighestScoringTaxForBestMappingCandidate() {
        String defaultSpecies;
        boolean foundCandidateWithDefaultTax;
        if (this.taxonomyScores == null || this.taxonomyScores.isEmpty()) {
            return;
        }
        PrerequisiteChecker.checkThat().notNull(new Object[]{this.mentionMappingResult}).supplyNotNull(new Supplier[]{() -> this.mentionMappingResult.bestCandidate}).withNames(new String[]{"taxonomy scores", "taxonomy scores", "mention mapping result", "mention mapping result"}).execute();
        double bestScore = 0.0;
        String bestTax = null;
        for (String taxId : this.taxonomyScores.keySet()) {
            Double score = this.taxonomyScores.get(taxId);
            if (!(score > bestScore)) continue;
            bestScore = score;
            bestTax = taxId;
        }
        boolean foundCandidateWithTax = this.setTaxonomyIdToMentionMappingResult(bestTax);
        if (!foundCandidateWithTax && !(foundCandidateWithDefaultTax = this.setTaxonomyIdToMentionMappingResult(defaultSpecies = this.getGeneDocument().getDefaultSpecies()))) {
            log.warn("Could not set the best scored taxonomy ID {} or the default taxonomy ID {} to the candidates of the gene mention because no candidate applies to one of those IDs. The gene mention is {}", new Object[]{bestTax, defaultSpecies, this});
        }
    }

    private boolean setTaxonomyIdToMentionMappingResult(String bestTax) {
        List<SynHit> bestCandidate = this.mentionMappingResult.bestCandidate;
        boolean foundCandidateWithTax = false;
        try {
            bestCandidate.get(0).setTaxId(bestTax);
            foundCandidateWithTax = true;
        }
        catch (IllegalArgumentException e) {
            for (int i = 0; i < this.mentionMappingResult.filteredCandidates.size(); ++i) {
                SynHit synHit = this.mentionMappingResult.filteredCandidates.get(i);
                try {
                    synHit.setTaxId(bestTax);
                    this.mentionMappingResult.bestCandidate.set(0, synHit);
                    foundCandidateWithTax = true;
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return foundCandidateWithTax;
    }

    public String getTaxonomyId() {
        return this.taxonomyId;
    }

    public void setTaxonomyId(String taxonomyId) {
        this.taxonomyId = taxonomyId;
    }

    public Set<String> getTaxonomyIds() {
        if (this.taxonomyCandidates != null) {
            return this.taxonomyCandidates.keySet();
        }
        if (this.taxonomyId != null) {
            return Collections.singleton(this.taxonomyId);
        }
        return Collections.emptySet();
    }

    public Multimap<String, GeneSpeciesOccurrence> getTaxonomyCandidates() {
        return this.taxonomyCandidates;
    }

    public void setTaxonomyCandidates(Multimap<String, GeneSpeciesOccurrence> taxonomyCandidates) {
        this.taxonomyCandidates = taxonomyCandidates;
    }

    public String getDocumentContext() {
        return this.documentContext;
    }

    public void setDocumentContext(String documentContext) {
        this.documentContext = documentContext;
    }

    public Query getContextQuery() {
        return this.contextQuery;
    }

    public void setContextQuery(Query contextQuery) {
        this.contextQuery = contextQuery;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.docId == null ? 0 : this.docId.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.offsets == null ? 0 : this.offsets.hashCode());
        result = 31 * result + (this.tagger == null ? 0 : this.tagger.hashCode());
        result = 31 * result + (this.taxonomyId == null ? 0 : this.taxonomyId.hashCode());
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeneMention other = (GeneMention)obj;
        if (this.docId == null ? other.docId != null : !this.docId.equals(other.docId)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.offsets == null ? other.offsets != null : !this.offsets.equals(other.offsets)) {
            return false;
        }
        if (this.tagger != other.tagger) {
            return false;
        }
        if (this.taxonomyId == null ? other.taxonomyId != null : !this.taxonomyId.equals(other.taxonomyId)) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }

    public int getBegin() {
        return (Integer)this.offsets.getMinimum();
    }

    public String getDocId() {
        return this.docId;
    }

    public void setDocId(String docId) {
        this.docId = docId;
    }

    public int getEnd() {
        return (Integer)this.offsets.getMaximum();
    }

    public GeneName getGeneName() {
        if (this.geneName == null && this.getNormalizer() == null) {
            throw new IllegalStateException("This GeneMention has not set a TermNormalizer and thus cannot create a GeneName instance.");
        }
        if (this.geneName == null) {
            this.geneName = new GeneName(this.text, this.normalizer);
        }
        return this.geneName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TermNormalizer getNormalizer() {
        return this.normalizer;
    }

    public void setNormalizer(TermNormalizer normalizer) {
        this.normalizer = normalizer;
    }

    public Range<Integer> getOffsets() {
        return this.offsets;
    }

    public void setOffsets(Range<Integer> offsets) {
        this.offsets = offsets;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        if (this.normalizer != null) {
            this.getGeneName().setText(text);
        }
    }

    public String toString() {
        return "GeneMention [text=" + this.text + ", offsets=" + this.offsets + ", docId=" + this.docId + ", id=" + this.id + ", taxonomyId=" + this.taxonomyId + ", tagger=" + this.tagger + "]";
    }

    public String getNormalizedText() {
        return this.getGeneName().getNormalizedText();
    }

    public List<String> getNormalizedTextVariant() {
        return this.getGeneName().getNormalizedTextVariant();
    }

    public GeneTagger getTagger() {
        return this.tagger;
    }

    public void setTagger(GeneTagger tagger) {
        this.tagger = tagger;
    }

    public MentionMappingResult getMentionMappingResult() {
        return this.mentionMappingResult;
    }

    public void setMentionMappingResult(MentionMappingResult mentionMappingResult) {
        this.mentionMappingResult = mentionMappingResult;
    }

    public GeneDocument getGeneDocument() {
        return this.geneDocument;
    }

    public void setGeneDocument(GeneDocument geneDocument) {
        this.geneDocument = geneDocument;
    }

    public GeneMention getParent() {
        return this.parent;
    }

    public void setParent(GeneMention parent) {
        this.parent = parent;
    }

    public void addTaggingModifier(String modifier) {
        if (this.taggingModifiers == null) {
            this.taggingModifiers = new ArrayList<String>();
        }
        this.taggingModifiers.add(modifier);
    }

    public List<PosTag> getPosTags() {
        return this.posTags;
    }

    public void setPosTags(List<PosTag> posTags) {
        this.posTags = posTags;
    }

    public SpecificType getSpecificType() {
        return this.specificType;
    }

    public void setSpecificType(SpecificType specificType) {
        this.specificType = specificType;
    }

    public FeatureVector getFeatureVector() {
        return this.featureVector;
    }

    public void setFeatureVector(FeatureVector featureVector) {
        this.featureVector = featureVector;
    }

    public double getSpecificTypeConfidence() {
        return this.specificTypeConfidence;
    }

    public void setSpecificTypeConfidence(double specificTypeConfidence) {
        this.specificTypeConfidence = specificTypeConfidence;
    }

    public String getReducedNameForExactMatch() {
        return this.reducedNameForExactMatch;
    }

    public void setReducedNameForExactMatch(String reducedNameForExactMatch) {
        this.reducedNameForExactMatch = reducedNameForExactMatch;
    }

    public static enum SpecificType {
        GENE,
        FAMILYNAME,
        DOMAINMOTIF;

    }

    public static enum GeneTagger {
        JNET,
        GAZETTEER,
        BANNER,
        GOLD;

    }
}

