/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jules.ae.genemapping.genemodel;

import de.julielab.java.utilities.spanutils.OffsetMap;
import de.julielab.java.utilities.spanutils.OffsetSet;
import de.julielab.java.utilities.spanutils.Span;
import de.julielab.jcore.types.Abbreviation;
import de.julielab.jcore.types.AbbreviationLongform;
import de.julielab.jcore.types.Chunk;
import de.julielab.jcore.types.EntityMention;
import de.julielab.jcore.types.Organism;
import de.julielab.jcore.types.POSTag;
import de.julielab.jcore.types.Sentence;
import de.julielab.jcore.types.Title;
import de.julielab.jcore.types.Token;
import de.julielab.jcore.types.pubmed.ManualDescriptor;
import de.julielab.jcore.utility.JCoReTools;
import de.julielab.jules.ae.genemapping.GeneMapping;
import de.julielab.jules.ae.genemapping.GeneMappingConfiguration;
import de.julielab.jules.ae.genemapping.genemodel.Acronym;
import de.julielab.jules.ae.genemapping.genemodel.AcronymLongform;
import de.julielab.jules.ae.genemapping.genemodel.GeneDocument;
import de.julielab.jules.ae.genemapping.genemodel.GeneMention;
import de.julielab.jules.ae.genemapping.genemodel.MeshHeading;
import de.julielab.jules.ae.genemapping.genemodel.PosTag;
import de.julielab.jules.ae.genemapping.genemodel.SpeciesCandidates;
import de.julielab.jules.ae.genemapping.genemodel.SpeciesMention;
import de.julielab.jules.ae.genemapping.utils.GeneMappingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.Type;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneDocumentFactory {
    private static final Logger log = LoggerFactory.getLogger(GeneDocumentFactory.class);
    private static GeneDocumentFactory instance;
    private final GeneMapping geneMapping;

    private GeneDocumentFactory(GeneMapping mapper) {
        GeneMappingConfiguration configuration = mapper.getConfiguration();
        this.geneMapping = mapper;
    }

    public static GeneDocumentFactory getInstance() {
        if (instance == null) {
            throw new IllegalStateException("The initialize(GeneMapper) method must be called before the factory can be used.");
        }
        return instance;
    }

    public static void initialize(GeneMapping mapper) throws GeneMappingException {
        instance = new GeneDocumentFactory(mapper);
    }

    public GeneDocument createGeneDocument(JCas jCas, Map<String, Matcher> entityMappingTypes, Function<EntityMention, Pair<String, BooleanQuery>> contextFun) throws AnalysisEngineProcessException {
        Optional<Title> titleOpt;
        GeneDocument doc = new GeneDocument();
        String docId = JCoReTools.getDocId((JCas)jCas);
        doc.setId(docId);
        Title documentTitle = null;
        Collection titles = JCasUtil.select((JCas)jCas, Title.class);
        if (titles != null && (titleOpt = titles.stream().filter(t -> t.getTitleType() != null).filter(t -> t.getTitleType().equals("document")).findAny()).isPresent()) {
            documentTitle = titleOpt.get();
            doc.setDocumentTitle(documentTitle.getCoveredText());
        }
        StringBuilder textBody = new StringBuilder(jCas.getDocumentText());
        if (doc.getDocumentTitle() != null) {
            textBody.delete(0, doc.getDocumentTitle().length());
        }
        doc.setDocumentText(textBody.toString());
        OffsetSet sentences = new OffsetSet();
        for (Sentence sentence : jCas.getAnnotationIndex(Sentence.type)) {
            sentences.add((Object)Range.between((Comparable)Integer.valueOf(sentence.getBegin()), (Comparable)Integer.valueOf(sentence.getEnd())));
        }
        doc.setSentences(sentences);
        ArrayList<PosTag> tags = new ArrayList<PosTag>();
        for (Token token : jCas.getAnnotationIndex(Token.type)) {
            if (token.getPosTag().size() <= 0) continue;
            POSTag uimaPosTag = token.getPosTag(0);
            PosTag posTag = new PosTag(uimaPosTag.getValue(), (Range<Integer>)Range.between((Comparable)Integer.valueOf(uimaPosTag.getBegin()), (Comparable)Integer.valueOf(uimaPosTag.getEnd())));
            tags.add(posTag);
        }
        doc.setPosTags(tags);
        OffsetMap chunks = new OffsetMap();
        for (Chunk chunk : jCas.getAnnotationIndex(Chunk.type)) {
            chunks.put((Object)Range.between((Comparable)Integer.valueOf(chunk.getBegin()), (Comparable)Integer.valueOf(chunk.getEnd())), (Object)chunk.getClass().getSimpleName().replace("Chunk", ""));
        }
        doc.setChunks((OffsetMap<String>)chunks);
        OffsetMap acronyms = new OffsetMap();
        for (Abbreviation abb : jCas.getAnnotationIndex(Abbreviation.type)) {
            AbbreviationLongform longform = abb.getTextReference();
            Acronym acronym = new Acronym(abb.getCoveredText(), abb.getBegin(), abb.getEnd(), new AcronymLongform(longform.getCoveredText(), longform.getBegin(), longform.getEnd()));
            acronyms.put((Span)acronym);
        }
        doc.setAcronyms((OffsetMap<Acronym>)acronyms);
        ArrayList<MeshHeading> mesh = new ArrayList<MeshHeading>();
        try {
            de.julielab.jcore.types.ManualDescriptor md = (de.julielab.jcore.types.ManualDescriptor)JCasUtil.selectSingle((JCas)jCas, de.julielab.jcore.types.ManualDescriptor.class);
            if (md instanceof ManualDescriptor) {
                ManualDescriptor pmMd = (ManualDescriptor)md;
                if (pmMd.getMeSHList() != null) {
                    for (int i = 0; i < pmMd.getMeSHList().size(); ++i) {
                        MeshHeading mh = new MeshHeading(pmMd.getMeSHList(i).getDescriptorName());
                        mesh.add(mh);
                    }
                }
                doc.setMeshHeadings(mesh);
            }
        }
        catch (IllegalArgumentException md) {
            // empty catch block
        }
        OffsetMap speciesMentions = new OffsetMap();
        for (Organism organism : jCas.getAnnotationIndex(Organism.type)) {
            if (organism.getResourceEntryList() == null || organism.getResourceEntryList().size() <= 0) continue;
            SpeciesMention speciesMention = new SpeciesMention(organism.getResourceEntryList(0).getEntryId(), organism.getCoveredText());
            speciesMentions.put((Object)Range.between((Comparable)Integer.valueOf(organism.getBegin()), (Comparable)Integer.valueOf(organism.getEnd())), (Object)speciesMention);
        }
        int titleBegin = documentTitle != null ? documentTitle.getBegin() : 0;
        int titleEnd = documentTitle != null ? documentTitle.getEnd() : 0;
        SpeciesCandidates speciesCandidates = new SpeciesCandidates(titleBegin, titleEnd, doc.getMeshHeadings().stream().map(MeshHeading::getTaxonomyIds).flatMap(Collection::stream).collect(Collectors.toSet()), (OffsetMap<SpeciesMention>)speciesMentions);
        doc.setSpecies(speciesCandidates);
        this.setGenesFromJCas(jCas, doc, entityMappingTypes, contextFun);
        return doc;
    }

    private void setGenesFromJCas(JCas aJCas, GeneDocument geneDocument, Map<String, Matcher> entityMappingTypes, Function<EntityMention, Pair<String, BooleanQuery>> contextFun) throws AnalysisEngineProcessException {
        for (String uimaEntityTypeName : entityMappingTypes.keySet()) {
            Type uimaEntityType = aJCas.getTypeSystem().getType(uimaEntityTypeName);
            if (uimaEntityType == null) {
                log.error("The entity mapping type {} is not contained in the current type system.", (Object)uimaEntityTypeName);
                throw new AnalysisEngineProcessException("JCAS_TYPENOTFOUND_ERROR", new Object[]{uimaEntityTypeName});
            }
            Matcher specTypeMatcher = entityMappingTypes.get(uimaEntityTypeName);
            for (Annotation a : aJCas.getAnnotationIndex(uimaEntityType)) {
                EntityMention em;
                try {
                    em = (EntityMention)a;
                }
                catch (ClassCastException e) {
                    String msg = "The passed entity type " + uimaEntityType + " is not a subclass of EntityMention. Only subclasses of EntityMention can take part in the ID mapping of this component.";
                    log.error(msg);
                    throw new AnalysisEngineProcessException((Throwable)new IllegalArgumentException(msg));
                }
                if (em.getSpecificType() != null && specTypeMatcher.reset(em.getSpecificType()).matches()) {
                    Pair<String, BooleanQuery> contextAndContextQuery = contextFun.apply(em);
                    if (contextAndContextQuery == null || contextAndContextQuery.getLeft() == null || contextAndContextQuery.getRight() == null) {
                        throw new AnalysisEngineProcessException((Throwable)new GeneMappingException("The context query for the entity " + em + " of document " + geneDocument.getId() + " could not be created."));
                    }
                    GeneMention gm = this.createGeneMentionFromUimaAnnotation(em, contextAndContextQuery);
                    geneDocument.addGene(gm);
                    continue;
                }
                if (em.getSpecificType() != null) continue;
                log.debug("Encountered an entity mention that has no specificType set. Such entities won't be mapped because they don't match any specificType regular expression (see annotator parameter EntityMappingTypes).");
            }
        }
        geneDocument.selectAllGenes();
    }

    private GeneMention createGeneMentionFromUimaAnnotation(EntityMention em, Pair<String, BooleanQuery> contextAndContextQuery) {
        GeneMention gm = new GeneMention(em.getCoveredText(), em.getBegin(), em.getEnd());
        gm.setNormalizer(this.geneMapping.getMappingCore().getTermNormalizer());
        gm.setDocumentContext((String)contextAndContextQuery.getLeft());
        gm.setContextQuery((Query)contextAndContextQuery.getRight());
        gm.setOriginalMappedObject(em);
        return gm;
    }
}

