/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jules.ae.genemapping.genemodel;

import com.fulmicoton.multiregexp.MultiPatternSearcher;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import com.lahodiuk.ahocorasick.AhoCorasickOptimized;
import de.julielab.java.utilities.FileUtilities;
import de.julielab.java.utilities.IOStreamUtilities;
import de.julielab.java.utilities.spanutils.OffsetMap;
import de.julielab.java.utilities.spanutils.OffsetSet;
import de.julielab.java.utilities.spanutils.OffsetSpanComparator;
import de.julielab.java.utilities.spanutils.Span;
import de.julielab.jules.ae.genemapping.genemodel.Acronym;
import de.julielab.jules.ae.genemapping.genemodel.AcronymLongform;
import de.julielab.jules.ae.genemapping.genemodel.GeneMention;
import de.julielab.jules.ae.genemapping.genemodel.GeneSet;
import de.julielab.jules.ae.genemapping.genemodel.GeneSets;
import de.julielab.jules.ae.genemapping.genemodel.GeneSpeciesOccurrence;
import de.julielab.jules.ae.genemapping.genemodel.MeshHeading;
import de.julielab.jules.ae.genemapping.genemodel.PosTag;
import de.julielab.jules.ae.genemapping.genemodel.SpeciesCandidates;
import de.julielab.jules.ae.genemapping.genemodel.SpeciesMention;
import de.julielab.jules.ae.genemapping.utils.norm.TermNormalizer;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneDocument {
    public static final Pattern ecNumberRegExp = Pattern.compile("EC\\s*([0-9]*\\.*)+");
    public static final Pattern lociRegExp = Pattern.compile("[0-9]+[Xqp][0-9.-]+");
    private static final Logger log = LoggerFactory.getLogger(GeneDocument.class);
    private final Matcher pluralMatcher = Pattern.compile("[A-Z]+s").matcher("");
    private OffsetMap<Acronym> acronyms;
    private OffsetMap<AcronymLongform> acronymLongforms;
    private OffsetMap<String> chunks;
    private OffsetMap<PosTag> posTags;
    private String documentText;
    private String documentTitle;
    private List<GeneMention> allGenes;
    private OffsetMap<List<GeneMention>> genes;
    private OffsetMap<List<GeneMention>> goldGenes;
    private GeneSets geneSets;
    private String id;
    private OffsetSet sentences;
    private SpeciesCandidates species;
    private AhoCorasickOptimized geneNameDictionary;
    private TermNormalizer termNormalizer;
    private Map<String, String> taxId2Prefix;
    private Map<String, String> prefix2TaxId;
    private Map<String, List<String>> meshHeadings2TaxId;
    private Collection<MeshHeading> meshHeadings;
    private String defaultSpecies;

    public GeneDocument() {
        this.readSpeciesPrefixes();
        this.readMeshHeadings2TaxIdMap();
    }

    public GeneDocument(String id) {
        this();
        this.id = id;
    }

    public GeneDocument(GeneDocument template) {
        this.acronyms = template.acronyms;
        this.acronymLongforms = template.acronymLongforms;
        this.chunks = template.chunks;
        this.posTags = template.posTags;
        this.documentText = template.documentText;
        this.documentTitle = template.documentTitle;
        TreeMap orgToNew = new TreeMap((g1, g2) -> Integer.compare(System.identityHashCode(g1), System.identityHashCode(g2)));
        template.allGenes.forEach(g -> orgToNew.put(g, new GeneMention((GeneMention)g)));
        this.allGenes = template.allGenes.stream().map(GeneMention::new).collect(Collectors.toList());
        this.genes = new OffsetMap();
        for (Map.Entry original : template.genes.entrySet()) {
            this.genes.put((Object)((Range)original.getKey()), ((List)original.getValue()).stream().map(orgToNew::get).collect(Collectors.toList()));
        }
        this.goldGenes = template.goldGenes;
        this.geneSets = new GeneSets();
        for (GeneSet gs : template.geneSets) {
            GeneSet newSet = new GeneSet();
            newSet.setFeatureVector(gs.getFeatureVector());
            newSet.setInstance(gs.getInstance());
            newSet.setSetId(gs.getSetId());
            newSet.setSpecificType(gs.getSpecificType());
            gs.forEach(g -> newSet.add((GeneMention)orgToNew.get(g)));
            this.geneSets.add(newSet);
        }
        this.id = template.id;
        this.sentences = template.sentences;
        this.species = template.species;
        this.geneNameDictionary = template.geneNameDictionary;
        this.termNormalizer = template.termNormalizer;
    }

    private void readMeshHeadings2TaxIdMap() {
        try {
            InputStream descriptorMapping = FileUtilities.findResource((String)"/desc2tax.gz");
            if (descriptorMapping == null) {
                descriptorMapping = FileUtilities.findResource((String)"/desc2tax");
            }
            this.meshHeadings2TaxId = IOStreamUtilities.getLinesFromInputStream((InputStream)descriptorMapping).stream().map(line -> line.split("\t")).collect(Collectors.groupingBy(split -> split[0], Collectors.mapping(split -> split[1], Collectors.toList())));
        }
        catch (IOException e) {
            log.warn("Could not read the mapping from descriptor names to taxonomy IDs at the classpath resource /desc2tax.gz or /desc2tax. Taxonomy ID recognition quality will be decreased.");
        }
    }

    private void readSpeciesPrefixes() {
        try {
            this.taxId2Prefix = IOStreamUtilities.getLinesFromInputStream((InputStream)this.getClass().getResourceAsStream("/speciesprefixes.map")).stream().map(line -> line.split("\t")).collect(Collectors.toMap(split -> split[1], split -> split[0]));
            this.prefix2TaxId = IOStreamUtilities.getLinesFromInputStream((InputStream)this.getClass().getResourceAsStream("/speciesprefixes.map")).stream().map(line -> line.split("\t")).collect(Collectors.toMap(split -> split[0], split -> split[1]));
            log.debug("Loaded species prefix map: {}", this.taxId2Prefix);
        }
        catch (IOException e) {
            log.warn("Could not read the species prefixes map which helps with species disambiguation. Species recognition performance will be somewhat lower. This is not a critical error, execution can continue.", (Throwable)e);
        }
    }

    public AcronymLongform getAcronymLongformAndOffsets(Acronym acronym) {
        AcronymLongform longform = acronym.getLongform();
        if (null == longform.getText()) {
            Range<Integer> range = longform.getOffsets();
            longform.setText(this.getDocumentText().substring((Integer)range.getMinimum(), (Integer)range.getMaximum()));
        }
        return longform;
    }

    public OffsetMap<Acronym> getAcronyms() {
        return this.acronyms;
    }

    public void setAcronyms(OffsetMap<Acronym> acronyms) {
        this.acronyms = acronyms;
    }

    public void setAcronyms(Acronym ... acronyms) {
        this.setAcronyms(Stream.of(acronyms));
    }

    public void setAcronyms(Collection<Acronym> acronyms) {
        this.setAcronyms(acronyms.stream());
    }

    public void setAcronyms(Stream<Acronym> acronyms) {
        this.acronyms = new OffsetMap();
        this.acronymLongforms = new OffsetMap();
        acronyms.forEach(a -> {
            this.acronyms.put(a.getOffsets(), a);
            this.acronymLongforms.put(a.getLongform().getOffsets(), (Object)a.getLongform());
        });
    }

    public OffsetMap<AcronymLongform> getAcronymLongforms() {
        return this.acronymLongforms;
    }

    public OffsetMap<String> getChunks() {
        return this.chunks;
    }

    public void setChunks(OffsetMap<String> chunks) {
        this.chunks = chunks;
    }

    public String getDocumentText() {
        return this.documentText;
    }

    public void setDocumentText(String documentText) {
        this.documentText = documentText;
    }

    public String getDocumentTitle() {
        return this.documentTitle;
    }

    public void setDocumentTitle(String documentTitle) {
        this.documentTitle = documentTitle;
    }

    public OffsetMap<List<GeneMention>> getGeneMap() {
        if (this.genes == null) {
            throw new IllegalStateException("The internal genes map has to be built first by calling an appropriate method after setting the original set of genes.");
        }
        return this.genes;
    }

    public Stream<GeneMention> getGeneMentionsAtOffsets(Range<Integer> offsets) {
        return this.getGenes().filter(g -> g.getOffsets().isOverlappedBy(offsets));
    }

    public Stream<GeneMention> getGenes() {
        if (this.genes == null) {
            throw new IllegalStateException("The internal genes map has to be built first by calling an appropriate method after setting the original set of genes.");
        }
        return this.genes.values().stream().flatMap(Collection::stream);
    }

    public void setGenes(GeneMention ... genes) {
        this.allGenes = new ArrayList<GeneMention>(genes.length);
        this.setGenes(Stream.of(genes));
    }

    public void setGenes(Stream<GeneMention> genes) {
        if (this.allGenes != null) {
            this.allGenes.clear();
        } else {
            this.allGenes = new ArrayList<GeneMention>();
        }
        genes.forEach(this.allGenes::add);
        this.allGenes.forEach(g -> g.setGeneDocument(this));
        this.allGenes.forEach(g -> g.setNormalizer(this.termNormalizer));
        this.allGenes.forEach(g -> {
            if (g.getTagger() == GeneMention.GeneTagger.GOLD) {
                this.putGoldGene((GeneMention)g);
            }
        });
    }

    public void setGenes(Collection<GeneMention> genes) {
        if (this.allGenes == null) {
            this.allGenes = new ArrayList<GeneMention>(genes.size());
        }
        this.setGenes(genes.stream());
    }

    public void addGene(GeneMention gene) {
        if (this.allGenes == null) {
            this.allGenes = new ArrayList<GeneMention>();
        }
        this.allGenes.add(gene);
        gene.setGeneDocument(this);
        gene.setNormalizer(this.termNormalizer);
        if (gene.getTagger() == GeneMention.GeneTagger.GOLD) {
            this.putGene(gene);
        }
    }

    public Iterable<GeneMention> getGenesIterable() {
        return () -> this.getGenes().iterator();
    }

    public Iterator<GeneMention> getGenesIterator() {
        return this.getGenes().iterator();
    }

    public GeneSets getGeneSets() {
        if (this.geneSets != null) {
            return this.geneSets;
        }
        GeneSets geneSets = new GeneSets();
        this.getGenes().forEach(gm -> {
            GeneSet geneSet = new GeneSet();
            geneSet.add(gm);
            this.getLastPosTag(gm.getOffsets(), Collections.emptySet()).ifPresent(tag -> geneSet.setPlural(tag.getTag().equals("NNS")));
            geneSets.add(geneSet);
        });
        this.geneSets = geneSets;
        return geneSets;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Collection<Acronym> getOverlappingAcronyms(Range<Integer> range) {
        return this.acronyms.getOverlapping(range).values();
    }

    public Collection<AcronymLongform> getOverlappingAcronymLongforms(Range<Integer> range) {
        return this.acronymLongforms.getOverlapping(range).values();
    }

    public Range<Integer> getovappingSentence(Span span) {
        return this.sentences.locate(span.getOffsets());
    }

    public Range<Integer> getovappingSentence(Range<Integer> range) {
        return this.sentences.locate(range);
    }

    public Set<Map.Entry<Range<Integer>, String>> getOverlappingChunks(Range<Integer> range) {
        return this.chunks.getOverlapping(range).entrySet();
    }

    public Set<Map.Entry<Range<Integer>, String>> getOverlappingChunks(Range<Integer> range, String chunkType) {
        return this.getOverlappingChunks(range).stream().filter(e -> ((String)e.getValue()).equals(chunkType)).collect(Collectors.toSet());
    }

    public Collection<PosTag> getOverlappingPosTags(Range<Integer> range) {
        if (this.posTags == null) {
            return Collections.emptyList();
        }
        return this.posTags.getOverlapping(range).values();
    }

    public Optional<PosTag> getLastPosTag(Range<Integer> range, Set<String> excludedTags) {
        List posList = this.getOverlappingPosTags(range).stream().collect(Collectors.toList());
        if (posList.isEmpty()) {
            return Optional.empty();
        }
        for (int i = posList.size() - 1; i >= 0; --i) {
            PosTag posTag = (PosTag)((Object)posList.get(i));
            if (excludedTags != null && !excludedTags.isEmpty() && excludedTags.contains(posTag.getTag())) continue;
            return Optional.of(posTag);
        }
        return Optional.empty();
    }

    public OffsetMap<PosTag> getPosTags() {
        return this.posTags;
    }

    public void setPosTags(Collection<PosTag> posTags) {
        this.setPosTags(posTags.stream());
    }

    public void setPosTags(Stream<PosTag> posTags) {
        this.posTags = new OffsetMap();
        posTags.map(pos -> {
            if (pos.getTag().equals("NN") && this.documentText != null && pos.getEnd() < this.documentText.length()) {
                String coveredText = this.getCoveredText((Span)pos);
                this.pluralMatcher.reset(coveredText);
                if (this.pluralMatcher.matches()) {
                    pos.setTag("NNS");
                }
            }
            return pos;
        }).forEach(arg_0 -> this.posTags.put(arg_0));
    }

    public Stream<GeneMention> getOverlappingGenes(Range<Integer> range) {
        return this.genes.getOverlapping(range).values().stream().flatMap(list -> list.stream());
    }

    public Stream<GeneMention> getOverlappingGoldGenes(Range<Integer> range) {
        if (this.goldGenes == null) {
            return Stream.empty();
        }
        return this.goldGenes.getOverlapping(range).values().stream().flatMap(list -> list.stream());
    }

    public NavigableSet<Range<Integer>> getSentences() {
        return this.sentences;
    }

    public void setSentences(OffsetSet sentences) {
        this.sentences = sentences;
    }

    public SpeciesCandidates getSpecies() {
        return this.species;
    }

    public void setSpecies(SpeciesCandidates species) {
        this.species = species;
    }

    public Multimap<String, GeneSpeciesOccurrence> setSpeciesHints(GeneMention gm) {
        OffsetMap<SpeciesMention> titleCandidates;
        List<String> meshTaxIds;
        Range<Integer> geneOffsets = gm.getOffsets();
        Range sentence = this.sentences.locate(geneOffsets);
        NavigableMap sentenceChunks = this.chunks.restrictTo(sentence);
        TreeMultimap mentions = TreeMultimap.create();
        OffsetMap<SpeciesMention> candidates = this.species.getTextCandidates();
        List<String> list = meshTaxIds = this.meshHeadings != null ? this.meshHeadings.stream().map(MeshHeading::getTaxonomyIds).flatMap(Collection::stream).collect(Collectors.toList()) : Collections.emptyList();
        if (null != candidates) {
            Range previousSentence;
            NavigableMap sentenceSpecies = candidates.restrictTo(sentence);
            mentions.putAll(this.speciesInNounPhrase(geneOffsets, sentenceSpecies, sentenceChunks));
            if (null == sentence || (previousSentence = (Range)this.sentences.lower((Object)sentence)) != null) {
                // empty if block
            }
        }
        if (!(titleCandidates = this.species.getTitleCandidates()).isEmpty()) {
            for (SpeciesMention speciesMention : titleCandidates.values()) {
                mentions.put((Object)speciesMention.getTaxId(), (Object)GeneSpeciesOccurrence.TITLE);
            }
        }
        if (null != candidates) {
            Range firstSentence = (Range)this.sentences.floor((Object)Range.between((Comparable)Integer.valueOf(this.documentTitle.length() + 1), (Comparable)Integer.valueOf(this.documentTitle.length() + 1)));
            if (firstSentence != null && firstSentence.equals(this.sentences.first())) {
                firstSentence = (Range)this.sentences.higher((Object)firstSentence);
            }
            if (firstSentence != null) {
                Multimap<String, GeneSpeciesOccurrence> speciesInFirstSentence = this.speciesInSentence(candidates, (Range<Integer>)firstSentence, GeneSpeciesOccurrence.FIRST);
                mentions.putAll(speciesInFirstSentence);
            }
            if (!candidates.isEmpty()) {
                for (SpeciesMention s : candidates.values()) {
                    mentions.put((Object)s.getTaxId(), (Object)GeneSpeciesOccurrence.ANYWHERE);
                }
            }
        }
        if (this.meshHeadings != null) {
            for (String meshTaxId : meshTaxIds) {
                mentions.put((Object)meshTaxId, (Object)GeneSpeciesOccurrence.MESH);
            }
        } else {
            for (String s : this.species.getMeshCandidates()) {
                mentions.put((Object)s, (Object)GeneSpeciesOccurrence.MESH);
            }
        }
        if (this.prefix2TaxId != null) {
            boolean hasSpeciesPrefix;
            String firstChar = String.valueOf(gm.getText().charAt(0));
            boolean bl = hasSpeciesPrefix = this.prefix2TaxId.containsKey(firstChar) && gm.getText().length() > 2 && Character.isUpperCase(gm.getText().charAt(1));
            if (hasSpeciesPrefix) {
                String taxId = this.prefix2TaxId.get(firstChar);
                mentions.put((Object)taxId, (Object)GeneSpeciesOccurrence.SPECIES_PREFIX);
            }
        }
        if (mentions.isEmpty() && !StringUtils.isBlank((CharSequence)this.defaultSpecies)) {
            mentions.put((Object)this.defaultSpecies, (Object)GeneSpeciesOccurrence.DEFAULT);
        }
        gm.setTaxonomyCandidates((Multimap<String, GeneSpeciesOccurrence>)mentions);
        return mentions;
    }

    public void removeGenesWithoutCandidates() {
        Iterator it = this.genes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            List gmList = (List)entry.getValue();
            Iterator genesIt = gmList.iterator();
            while (genesIt.hasNext()) {
                GeneMention gm = (GeneMention)genesIt.next();
                if (gm.getMentionMappingResult().originalCandidates != null && !gm.getMentionMappingResult().originalCandidates.isEmpty()) continue;
                genesIt.remove();
            }
            if (!gmList.isEmpty()) continue;
            it.remove();
        }
    }

    public void removeSpeciesMention(MultiPatternSearcher searcher) {
        this.allGenes.forEach(gm -> {
            int start;
            String text = gm.getText();
            MultiPatternSearcher.Cursor cursor = searcher.search((CharSequence)text);
            if (cursor.next() && (start = cursor.start()) == 0) {
                int end = cursor.end();
                gm.setText(text.substring(end));
                Range<Integer> offsets = gm.getOffsets();
                int newBegin = (Integer)offsets.getMinimum() + end;
                gm.setOffsets((Range<Integer>)Range.between((Comparable)Integer.valueOf(newBegin), (Comparable)((Integer)offsets.getMaximum())));
            }
        });
    }

    public void selectAllGenes() {
        this.genes = new OffsetMap();
        if (this.allGenes != null) {
            this.allGenes.forEach(g -> this.putGene((GeneMention)g));
        }
    }

    public void selectGeneMentionsByTagger(GeneMention.GeneTagger ... tagger) {
        this.genes = new OffsetMap();
        HashSet<GeneMention.GeneTagger> includedTaggers = new HashSet<GeneMention.GeneTagger>(Arrays.asList(tagger));
        Iterator<GeneMention> it = this.allGenes.iterator();
        while (it.hasNext()) {
            GeneMention g = it.next();
            if (g.getTagger() == null) {
                log.error("Gene {} in document {} does not have a tagger set", (Object)g.getText(), (Object)g.getDocId());
                it.remove();
                continue;
            }
            if (!includedTaggers.contains((Object)g.getTagger())) continue;
            this.putGene(g);
        }
    }

    public void allowGeneMentionsByRegularExpression(GeneMention.GeneTagger tagger, Pattern ... regExes) {
        Matcher[] ms = new Matcher[regExes.length];
        for (int i = 0; i < regExes.length; ++i) {
            ms[i] = regExes[i].matcher("");
        }
        for (GeneMention gm : this.allGenes) {
            if (tagger != null && gm.getTagger() != tagger) continue;
            boolean allowed = false;
            for (int i = 0; i < regExes.length && !allowed; ++i) {
                ms[i].reset(gm.getText());
                if (!ms[i].matches()) continue;
                allowed = true;
            }
            if (!allowed) continue;
            this.putGene(gm);
        }
    }

    private Multimap<String, GeneSpeciesOccurrence> speciesInNounPhrase(Range<Integer> geneOffsets, NavigableMap<Range<Integer>, SpeciesMention> sentenceSpecies, NavigableMap<Range<Integer>, String> sentenceChunks) {
        Range<Integer> candidate;
        TreeMultimap mentionMap = TreeMultimap.create();
        if (sentenceSpecies.isEmpty()) {
            return mentionMap;
        }
        SortedMap<Range<Integer>, SpeciesMention> speciesInMention = sentenceSpecies.subMap((Range<Integer>)Range.between((Comparable)((Integer)geneOffsets.getMinimum()), (Comparable)((Integer)geneOffsets.getMinimum())), (Range<Integer>)Range.between((Comparable)((Integer)geneOffsets.getMaximum()), (Comparable)((Integer)geneOffsets.getMaximum())));
        for (SpeciesMention speciesMention : speciesInMention.values()) {
            mentionMap.put((Object)speciesMention.getTaxId(), (Object)GeneSpeciesOccurrence.COMPOUND_PRECEED);
        }
        Range<Integer> enclosingChunk = sentenceChunks.floorKey(geneOffsets);
        if (enclosingChunk != null && enclosingChunk.isOverlappedBy(geneOffsets)) {
            NavigableMap<Range<Integer>, SpeciesMention> mentions = sentenceSpecies.subMap((Range<Integer>)Range.between((Comparable)((Integer)enclosingChunk.getMinimum()), (Comparable)((Integer)enclosingChunk.getMinimum())), true, (Range<Integer>)Range.between((Comparable)((Integer)geneOffsets.getMaximum()), (Comparable)((Integer)geneOffsets.getMaximum())), true);
            if (!mentions.isEmpty()) {
                for (SpeciesMention s : mentions.values()) {
                    mentionMap.put((Object)s.getTaxId(), (Object)GeneSpeciesOccurrence.COMPOUND_PRECEED);
                }
            }
            if (!(mentions = sentenceSpecies.subMap((Range<Integer>)Range.between((Comparable)((Integer)geneOffsets.getMinimum()), (Comparable)((Integer)geneOffsets.getMinimum())), true, (Range<Integer>)Range.between((Comparable)((Integer)enclosingChunk.getMaximum()), (Comparable)((Integer)enclosingChunk.getMaximum())), true)).isEmpty()) {
                for (SpeciesMention s : mentions.values()) {
                    mentionMap.put((Object)s.getTaxId(), (Object)GeneSpeciesOccurrence.COMPOUND_SUCCEED);
                }
            }
        }
        if (null == (candidate = sentenceSpecies.floorKey(geneOffsets))) {
            for (SpeciesMention s : sentenceSpecies.values()) {
                if (mentionMap.containsKey((Object)s.getTaxId())) continue;
                mentionMap.put((Object)s.getTaxId(), (Object)GeneSpeciesOccurrence.SENTENCE);
            }
        } else {
            NavigableMap<Range<Integer>, SpeciesMention> mentions;
            Map.Entry<Range<Integer>, String> chunk = sentenceChunks.floorEntry(geneOffsets);
            if (null == chunk) {
                chunk = sentenceChunks.firstEntry();
            }
            int start = -1;
            while (chunk.getValue().equals("ChunkNP")) {
                start = (Integer)chunk.getKey().getMinimum();
                if (null != (chunk = sentenceChunks.lowerEntry(chunk.getKey()))) continue;
            }
            if (start != -1) {
                mentions = sentenceSpecies.subMap((Range<Integer>)Range.between((Comparable)Integer.valueOf(start), (Comparable)Integer.valueOf(start)), true, (Range<Integer>)Range.between((Comparable)((Integer)geneOffsets.getMaximum()), (Comparable)((Integer)geneOffsets.getMaximum())), true);
                for (SpeciesMention s : mentions.values()) {
                    if (mentionMap.containsKey((Object)s.getTaxId())) continue;
                    mentionMap.put((Object)s.getTaxId(), (Object)GeneSpeciesOccurrence.PHRASE);
                }
            }
            mentions = sentenceSpecies.headMap((Range<Integer>)Range.between((Comparable)((Integer)geneOffsets.getMinimum()), (Comparable)((Integer)geneOffsets.getMinimum())), true);
            for (SpeciesMention s : mentions.values()) {
                if (mentionMap.containsKey((Object)s.getTaxId())) continue;
                mentionMap.put((Object)s.getTaxId(), (Object)GeneSpeciesOccurrence.SENTENCE);
            }
        }
        return mentionMap;
    }

    private Multimap<String, GeneSpeciesOccurrence> speciesInSentence(OffsetMap<SpeciesMention> speciesCandidates, Range<Integer> sentence, GeneSpeciesOccurrence order) {
        TreeMultimap mentionMap = TreeMultimap.create();
        if (speciesCandidates.isEmpty()) {
            return mentionMap;
        }
        NavigableMap candidatesInSentence = speciesCandidates.restrictTo(sentence);
        for (SpeciesMention s : candidatesInSentence.values()) {
            mentionMap.put((Object)s.getTaxId(), (Object)order);
        }
        return mentionMap;
    }

    public void unifyGeneMentionsAtEqualOffsets(GeneMention.GeneTagger ... taggerPriorities) {
        this.genes = new OffsetMap();
        HashMap priorities = new HashMap();
        IntStream.range(0, taggerPriorities.length).forEach(i -> priorities.put(taggerPriorities[i], i));
        for (GeneMention gm : this.allGenes) {
            List genesAtOffset = (List)this.genes.get(gm.getOffsets());
            if (genesAtOffset == null) {
                this.putGene(gm);
                continue;
            }
            for (GeneMention gmInMap : genesAtOffset) {
                int priorityInMap = priorities.getOrDefault((Object)gmInMap.getTagger(), Integer.MAX_VALUE);
                int gmPriority = priorities.getOrDefault((Object)gm.getTagger(), Integer.MAX_VALUE);
                if (gmPriority <= priorityInMap) continue;
                this.replaceGene(gmInMap, gm);
            }
        }
    }

    public void unifyAcronymsLongerFirst() {
        TreeSet<Span> unifiedSet = this.unifySpanLongerFirst(this.acronyms.values());
        this.acronyms = new OffsetMap();
        unifiedSet.forEach(g -> this.acronyms.put((Object)g.getOffsets(), (Object)((Acronym)g)));
    }

    public void unifyAllGenesLongerFirst() {
        TreeSet<Span> unifiedSet = this.unifySpanLongerFirst(this.allGenes);
        this.genes = new OffsetMap();
        unifiedSet.forEach(g -> this.putGene((GeneMention)g));
    }

    public void unifyAllGenesLongerFirst(GeneMention.GeneTagger ... taggers) {
        this.selectGeneMentionsByTagger(taggers);
        TreeSet<Span> unifiedSet = this.unifySpanLongerFirst(this.genes.values().stream().flatMap(list -> list.stream()).collect(Collectors.toList()));
        this.genes = new OffsetMap();
        unifiedSet.forEach(g -> this.putGene((GeneMention)g));
    }

    private TreeSet<Span> unifySpanLongerFirst(Collection<? extends Span> spans) {
        Span otherGene = null;
        TreeSet<Span> sortedGenes = new TreeSet<Span>((Comparator<Span>)new OffsetSpanComparator());
        for (Span span : spans) {
            int otherLength;
            int gmLength;
            if (sortedGenes.contains(span)) continue;
            otherGene = sortedGenes.floor(span);
            if (null != otherGene) {
                if (otherGene.getOffsets().isOverlappedBy(span.getOffsets())) {
                    gmLength = (Integer)span.getOffsets().getMaximum() - (Integer)span.getOffsets().getMinimum();
                    if (gmLength <= (otherLength = (Integer)otherGene.getOffsets().getMaximum() - (Integer)otherGene.getOffsets().getMinimum()) || !sortedGenes.remove(otherGene)) continue;
                    sortedGenes.add(span);
                    continue;
                }
                sortedGenes.add(span);
                continue;
            }
            otherGene = sortedGenes.ceiling(span);
            if (null != otherGene) {
                if (otherGene.getOffsets().isOverlappedBy(span.getOffsets())) {
                    gmLength = (Integer)span.getOffsets().getMaximum() - (Integer)span.getOffsets().getMinimum();
                    if (gmLength <= (otherLength = (Integer)otherGene.getOffsets().getMaximum() - (Integer)otherGene.getOffsets().getMinimum()) || !sortedGenes.remove(otherGene)) continue;
                    sortedGenes.add(span);
                    continue;
                }
                sortedGenes.add(span);
                continue;
            }
            sortedGenes.add(span);
        }
        return sortedGenes;
    }

    public void unifyGenesPrioritizeTagger(NavigableSet<GeneMention> sortedGenes, GeneMention.GeneTagger tagger) {
        this.allGenes.forEach(gm -> {
            GeneMention otherGene = null;
            if (sortedGenes.contains(gm)) {
                GeneMention.GeneTagger candidateTagger = gm.getTagger();
                if (candidateTagger == tagger && sortedGenes.remove(gm)) {
                    sortedGenes.add((GeneMention)gm);
                }
            } else {
                otherGene = sortedGenes.floor((GeneMention)gm);
                if (null != otherGene) {
                    if (otherGene.getOffsets().isOverlappedBy(gm.getOffsets())) {
                        GeneMention.GeneTagger candidateTagger = gm.getTagger();
                        if (candidateTagger == tagger && sortedGenes.remove(otherGene)) {
                            sortedGenes.add((GeneMention)gm);
                        }
                    } else {
                        sortedGenes.add((GeneMention)gm);
                    }
                } else {
                    otherGene = sortedGenes.ceiling((GeneMention)gm);
                    if (null != otherGene) {
                        if (otherGene.getOffsets().isOverlappedBy(gm.getOffsets())) {
                            GeneMention.GeneTagger candidateTagger = gm.getTagger();
                            if (candidateTagger == tagger && sortedGenes.remove(otherGene)) {
                                sortedGenes.add((GeneMention)gm);
                            }
                        } else {
                            sortedGenes.add((GeneMention)gm);
                        }
                    } else {
                        sortedGenes.add((GeneMention)gm);
                    }
                }
            }
        });
        this.genes = new OffsetMap();
        sortedGenes.forEach(g -> this.putGene((GeneMention)g));
    }

    public List<GeneMention> getAllGenes() {
        return this.allGenes;
    }

    private void putGene(GeneMention gm) {
        if (gm.getOffsets() == null) {
            throw new IllegalArgumentException("The passed gene mention does not specify text offsets: " + gm);
        }
        if (this.genes == null) {
            this.genes = new OffsetMap();
        }
        this.putGene(gm, this.genes);
    }

    public void putGoldGene(GeneMention gm) {
        if (gm.getOffsets() == null) {
            throw new IllegalArgumentException("The passed gene mention does not specify text offsets: " + gm);
        }
        if (this.goldGenes == null) {
            this.goldGenes = new OffsetMap();
        }
        this.putGene(gm, this.goldGenes);
    }

    private void putGene(GeneMention gm, OffsetMap<List<GeneMention>> geneMap) {
        assert (geneMap != null);
        if (gm.getOffsets() == null) {
            throw new IllegalArgumentException("The passed gene mention does not specify text offsets: " + gm);
        }
        ArrayList<GeneMention> gmList = (ArrayList<GeneMention>)geneMap.get(gm.getOffsets());
        if (gmList == null) {
            gmList = new ArrayList<GeneMention>();
            geneMap.put(gm.getOffsets(), gmList);
        }
        gmList.add(gm);
    }

    private void replaceGene(GeneMention gene, GeneMention replacement) {
        List gmList = (List)this.genes.get(gene.getOffsets());
        int index = gmList.indexOf(gene);
        gmList.set(index, replacement);
    }

    public String getCoveredText(Span span) {
        return this.getCoveredText((Range<Integer>)span.getOffsets());
    }

    public String getCoveredText(Range<Integer> range) {
        return this.getCoveredText((Integer)range.getMinimum(), (Integer)range.getMaximum());
    }

    public String getCoveredText(int begin, int end) {
        return this.documentText.substring(begin, end);
    }

    public void selectGene(GeneMention gm) {
        this.putGene(gm);
    }

    public TermNormalizer getTermNormalizer() {
        return this.termNormalizer;
    }

    public void setTermNormalizer(TermNormalizer termNormalizer) {
        this.termNormalizer = termNormalizer;
    }

    public void removeGene(GeneMention gm) {
        List genesAtOffset = (List)this.getGeneMap().get(gm.getOffsets());
        genesAtOffset.remove(gm);
        if (genesAtOffset.isEmpty()) {
            this.getGeneMap().remove(gm.getOffsets());
        }
    }

    public AhoCorasickOptimized getGeneNameDictionary() {
        return this.geneNameDictionary;
    }

    public AhoCorasickOptimized buildGeneNameTrie() {
        this.geneNameDictionary = new AhoCorasickOptimized(this.getGenes().map(GeneMention::getText).collect(Collectors.toList()));
        return this.geneNameDictionary;
    }

    public void agglomerateByAcronyms() {
        Collection docAcronyms = this.getAcronyms().values();
        if (docAcronyms.isEmpty()) {
            return;
        }
        HashMap geneSetMap = new HashMap();
        if (this.geneSets == null) {
            this.getGeneSets();
        }
        this.geneSets.stream().forEach(gs -> gs.forEach(gm -> geneSetMap.put(gm, gs)));
        HashMap<Range<Integer>, GeneSet> mergedSets = new HashMap<Range<Integer>, GeneSet>();
        for (Acronym acronym : this.getAcronyms().values()) {
            GeneSet to;
            GeneSet from;
            GeneMention longGm;
            Collection gms = this.getOverlappingGenes(acronym.getOffsets()).collect(Collectors.toList());
            if (gms.isEmpty()) continue;
            String acronymText = this.getCoveredText(acronym);
            GeneMention gm = (GeneMention)gms.stream().findFirst().get();
            AcronymLongform longform = acronym.getLongform();
            Collection longGms = this.getOverlappingGenes(longform.getOffsets()).collect(Collectors.toList());
            if (longGms.isEmpty() || gm.equals(longGm = (GeneMention)longGms.stream().findFirst().get()) || gm.getText().length() > acronymText.length() + 2 || !gm.getText().endsWith(acronymText) || gm.getText().length() != acronymText.length() && !Character.isLowerCase(gm.getText().charAt(0)) || longGm.getText().length() != longform.getEnd() - longform.getBegin()) continue;
            GeneSet gmSet = (GeneSet)mergedSets.get(gm.getOffsets());
            GeneSet longGmSet = (GeneSet)mergedSets.get(longGm.getOffsets());
            if (gmSet == null) {
                gmSet = (GeneSet)geneSetMap.get(gm);
            }
            if (longGmSet == null) {
                longGmSet = (GeneSet)geneSetMap.get(longGm);
            }
            if (gmSet.isPlural() ^ longGmSet.isPlural()) continue;
            if (gmSet.size() > longGmSet.size()) {
                from = longGmSet;
                to = gmSet;
            } else {
                from = gmSet;
                to = longGmSet;
            }
            if (from == to) continue;
            to.addAll(from);
            from.clear();
            mergedSets.put(longGm.getOffsets(), to);
            mergedSets.put(gm.getOffsets(), to);
            geneSetMap.remove(longGm);
            geneSetMap.remove(gm);
            this.geneSets.remove(longGmSet);
            this.geneSets.remove(gmSet);
        }
        this.geneSets.addAll(mergedSets.values());
    }

    public void agglomerateByNames() {
        HashMap geneSetMap = new HashMap();
        if (this.geneSets == null) {
            this.getGeneSets();
        }
        this.geneSets.stream().forEach(gs -> gs.forEach(gm -> geneSetMap.put(gm.getText(), gs)));
        ArrayList<GeneSet> geneSetList = new ArrayList<GeneSet>(this.geneSets);
        for (int i = 0; i < geneSetList.size() - 1; ++i) {
            for (int j = i + 1; j < geneSetList.size(); ++j) {
                GeneSet iSet = (GeneSet)geneSetList.get(i);
                GeneSet jSet = (GeneSet)geneSetList.get(j);
                if (iSet.isPlural() ^ jSet.isPlural() || Sets.intersection(iSet.stream().map(GeneMention::getText).collect(Collectors.toSet()), jSet.stream().map(GeneMention::getText).collect(Collectors.toSet())).isEmpty()) continue;
                iSet.addAll(jSet);
                jSet.clear();
                this.geneSets.remove(jSet);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeneDocument that = (GeneDocument)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public void setSpeciesMeshHeadings(Collection<MeshHeading> meshHeadings) {
        for (MeshHeading heading : meshHeadings) {
            String[] split;
            String name = heading.getHeading();
            for (String s : split = name.split(",\\s+")) {
                List<String> taxIds = this.meshHeadings2TaxId.get(s.trim());
                if (taxIds == null) continue;
                for (String taxId : taxIds) {
                    heading.addTaxonomyId(taxId);
                }
            }
        }
    }

    public Collection<MeshHeading> getMeshHeadings() {
        return this.meshHeadings != null ? this.meshHeadings : Collections.emptyList();
    }

    public void setMeshHeadings(Collection<MeshHeading> meshHeadings) {
        this.meshHeadings = meshHeadings;
        this.setSpeciesMeshHeadings(meshHeadings);
    }

    public Stream<GeneMention> getGenesWithText(String text) {
        return this.getGenes().filter(gm -> gm.getText().equals(text));
    }

    public String getDefaultSpecies() {
        return this.defaultSpecies;
    }

    public void setDefaultSpecies(String defaultSpecies) {
        this.defaultSpecies = defaultSpecies;
    }

    public Map.Entry<Range<Integer>, SpeciesMention> getNearestPreviousSpeciesMention(Range<Integer> range, String taxId) {
        OffsetMap<SpeciesMention> textCandidates = this.species.getTextCandidates();
        Map.Entry lower = textCandidates.lowerEntry(range);
        while (lower != null && !((SpeciesMention)lower.getValue()).getTaxId().equals(taxId)) {
            lower = textCandidates.lowerEntry((Object)((Range)lower.getKey()));
        }
        if (lower != null && !((SpeciesMention)lower.getValue()).getTaxId().equals(taxId)) {
            lower = null;
        }
        return lower;
    }

    public Map.Entry<Range<Integer>, SpeciesMention> getNearestNextSpeciesMention(Range<Integer> range, String taxId) {
        OffsetMap<SpeciesMention> textCandidates = this.species.getTextCandidates();
        Map.Entry higher = textCandidates.higherEntry(range);
        while (higher != null && !((SpeciesMention)higher.getValue()).getTaxId().equals(taxId)) {
            higher = textCandidates.higherEntry((Object)((Range)higher.getKey()));
        }
        if (higher != null && !((SpeciesMention)higher.getValue()).getTaxId().equals(taxId)) {
            higher = null;
        }
        return higher;
    }
}

