/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jules.ae.genemapping.disambig;

import de.julielab.jules.ae.genemapping.DocumentMappingResult;
import de.julielab.jules.ae.genemapping.GeneMappingConfiguration;
import de.julielab.jules.ae.genemapping.MentionMappingResult;
import de.julielab.jules.ae.genemapping.SynHit;
import de.julielab.jules.ae.genemapping.disambig.ContextItemsIndex;
import de.julielab.jules.ae.genemapping.disambig.DocumentDisambiguationData;
import de.julielab.jules.ae.genemapping.disambig.MentionDisambiguationData;
import de.julielab.jules.ae.genemapping.disambig.SemanticDisambiguation;
import de.julielab.jules.ae.genemapping.disambig.SemanticIndex;
import de.julielab.jules.ae.genemapping.disambig.WeepingTreeDocumentDisambiguationData;
import de.julielab.jules.ae.genemapping.disambig.WeepingTreeMentionDisambiguationData;
import de.julielab.jules.ae.genemapping.genemodel.GeneMention;
import de.julielab.jules.ae.genemapping.utils.GeneMappingException;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class WeepingTreeDisambiguation
implements SemanticDisambiguation {
    private final ContextItemsIndex contextItemsIndex;

    public WeepingTreeDisambiguation(GeneMappingConfiguration configuration) throws GeneMappingException {
        this.contextItemsIndex = new ContextItemsIndex(configuration);
    }

    @Override
    public MentionMappingResult disambiguateMention(MentionDisambiguationData disambiguationData) throws GeneMappingException {
        GeneMention gm = disambiguationData.getMention();
        MentionMappingResult mmr = gm.getMentionMappingResult();
        try {
            if (mmr.bestCandidate != null && !mmr.bestCandidate.isEmpty()) {
                String taxId;
                Map<String, Float> refSeqIdScores;
                Optional<Map.Entry> maxEntryOpt;
                SynHit bestSyn = mmr.bestCandidate.get(0);
                if (!bestSyn.isDisambiguated() && (maxEntryOpt = (refSeqIdScores = this.contextItemsIndex.getSynonymRefSeqScoresForTaxIds(bestSyn, Collections.singleton(taxId = bestSyn.getTaxId()))).entrySet().stream().max(Comparator.comparingDouble(e -> ((Float)e.getValue()).floatValue()))).isPresent()) {
                    String bestId = (String)maxEntryOpt.get().getKey();
                    bestSyn.setId(bestId);
                }
                mmr.resultEntries = Collections.singletonList(bestSyn);
                mmr.matchType = bestSyn.isExactMatch() ? MentionMappingResult.MatchType.EXACT : MentionMappingResult.MatchType.APPROX;
            }
        }
        catch (IOException e2) {
            throw new GeneMappingException(e2);
        }
        return mmr;
    }

    @Override
    public DocumentMappingResult disambiguateDocument(DocumentDisambiguationData disambiguationData) throws GeneMappingException {
        DocumentMappingResult documentMappingResult = new DocumentMappingResult();
        documentMappingResult.docId = disambiguationData.getDocument().getId();
        for (GeneMention gm : disambiguationData.getDocument().getGenesIterable()) {
            this.disambiguateMention(new WeepingTreeMentionDisambiguationData(gm, ((WeepingTreeDocumentDisambiguationData)disambiguationData).getTaxonomyIds()));
        }
        documentMappingResult.mentionResults = disambiguationData.getDocument().getGenes().map(GeneMention::getMentionMappingResult).collect(Collectors.toList());
        return documentMappingResult;
    }

    @Override
    public SemanticIndex getSemanticIndex() {
        return this.contextItemsIndex;
    }
}

