/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jules.ae.genemapping.disambig;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import de.julielab.jules.ae.genemapping.ContextItemsCacheKey;
import de.julielab.jules.ae.genemapping.GeneMappingConfiguration;
import de.julielab.jules.ae.genemapping.SynHit;
import de.julielab.jules.ae.genemapping.disambig.SemanticIndex;
import de.julielab.jules.ae.genemapping.utils.GeneMappingException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextItemsIndex
implements SemanticIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextItemsIndex.class);
    private static ConcurrentHashMap<String, LoadingCache<ContextItemsCacheKey, Collection<String>>> caches = new ConcurrentHashMap();
    public IndexSearcher searcher;
    private LoadingCache<ContextItemsCacheKey, Collection<String>> geneContextCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextItemsIndex(GeneMappingConfiguration configuration) throws GeneMappingException {
        String indexDirPath = configuration.getProperty("context_items_index");
        if (indexDirPath == null) {
            throw new GeneMappingException("context items index not specified in configuration file (critical).");
        }
        try {
            File indexDir = new File(indexDirPath);
            DirectoryReader reader = DirectoryReader.open((Directory)FSDirectory.open((Path)indexDir.toPath()));
            this.searcher = new IndexSearcher((IndexReader)reader);
            LOGGER.info("using " + indexDir.getAbsolutePath() + " as synonym disambiguation index with " + this.searcher.getIndexReader().numDocs() + " gene entries");
            String indexPath = indexDir.getCanonicalPath();
            ConcurrentHashMap<String, LoadingCache<ContextItemsCacheKey, Collection<String>>> concurrentHashMap = caches;
            synchronized (concurrentHashMap) {
                this.geneContextCache = caches.get(indexPath);
                if (this.geneContextCache == null) {
                    LOGGER.info("Creating new gene context cache for index {}", (Object)indexPath);
                    this.geneContextCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<ContextItemsCacheKey, Collection<String>>(){

                        public Collection<String> load(ContextItemsCacheKey contextItemsCacheKey) throws Exception {
                            return ContextItemsIndex.this.getContextItemsFromIndex(contextItemsCacheKey);
                        }
                    });
                    if (null != caches.put(indexPath, this.geneContextCache)) {
                        throw new IllegalStateException("There already is a candidate index for " + indexPath + " which points to a faulty concurrency implementation");
                    }
                } else {
                    LOGGER.info("Using existing gene context cache for index {}", (Object)indexPath);
                }
            }
        }
        catch (IOException e) {
            throw new GeneMappingException(e);
        }
    }

    public Collection<String> getContextItems(ContextItemsCacheKey key) throws ExecutionException {
        return (Collection)this.geneContextCache.get((Object)key);
    }

    public Collection<String> getContextItems(String geneId, String field) throws ExecutionException {
        return this.getContextItems(new ContextItemsCacheKey(geneId, field));
    }

    private Collection<String> getContextItemsFromIndex(ContextItemsCacheKey key) throws IOException {
        TermQuery termQuery = new TermQuery(new Term("indexed_id", key.getGeneId()));
        BooleanQuery filterQuery = new BooleanQuery.Builder().add(new BooleanClause((Query)termQuery, BooleanClause.Occur.FILTER)).build();
        TopDocs result = this.searcher.search((Query)filterQuery, 1);
        if (result.totalHits > 0L) {
            ArrayList<String> results = new ArrayList<String>();
            for (ScoreDoc scoreDoc : result.scoreDocs) {
                IndexableField[] fields;
                Document doc = this.searcher.doc(scoreDoc.doc);
                for (IndexableField f : fields = doc.getFields(key.getIndexField())) {
                    results.add(f.stringValue());
                }
            }
            return results;
        }
        return Collections.emptyList();
    }

    public Map<String, Float> getSynonymRefSeqScoresForTaxIds(SynHit synHit, Set<String> taxonomyIds) throws IOException {
        List idsForTaxIds = IntStream.range(0, synHit.getIds().size()).filter(i -> taxonomyIds.contains(synHit.getTaxIds().get(i))).mapToObj(i -> synHit.getIds().get(i)).collect(Collectors.toList());
        Stream<TermQuery> termQueryStream = idsForTaxIds.stream().map(id -> new TermQuery(new Term("indexed_id", id)));
        BooleanQuery.Builder filterQueryBuilder = new BooleanQuery.Builder();
        termQueryStream.forEach(q -> filterQueryBuilder.add(new BooleanClause((Query)q, BooleanClause.Occur.SHOULD)));
        BooleanQuery filterQuery = filterQueryBuilder.build();
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        queryBuilder.add(new BooleanClause((Query)filterQuery, BooleanClause.Occur.FILTER));
        PhraseQuery.Builder synonymQueryBuilder = new PhraseQuery.Builder().setSlop(0);
        Stream.of(synHit.getSynonym()).flatMap(s -> Stream.of(s.split("\\s+"))).forEach(t -> synonymQueryBuilder.add(new Term("generif", t)));
        PhraseQuery synonymPhraseQuery = synonymQueryBuilder.build();
        queryBuilder.add(new BooleanClause((Query)synonymPhraseQuery, BooleanClause.Occur.MUST));
        BooleanQuery query = queryBuilder.build();
        HashMap<String, Float> map = new HashMap<String, Float>();
        for (String geneId : idsForTaxIds) {
            map.put(geneId, Float.valueOf(0.0f));
        }
        TopDocs topDocs = this.searcher.search((Query)query, idsForTaxIds.size());
        if (topDocs.totalHits > 0L) {
            for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                Document doc = this.searcher.doc(scoreDoc.doc);
                String id2 = doc.get("indexed_id");
                float score = scoreDoc.score;
                map.put(id2, Float.valueOf(score));
            }
        }
        return map;
    }

    public IndexSearcher getContextItemsSearcher() {
        return this.searcher;
    }
}

