/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jules.ae.genemapping;

import de.julielab.jules.ae.genemapping.genemodel.GeneName;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class SynHit
implements Comparable<SynHit>,
Cloneable {
    int random;
    private String synonym;
    private double mentionScore;
    private double semanticScore;
    private double overallScore;
    private Map<String, Double> speciesMentionScores = new HashMap<String, Double>();
    private List<String> ids;
    private String[] taxonomySpecificIds;
    private String id;
    private String source;
    private String mappedMention;
    private CompareType compareType = CompareType.SCORE;
    private List<String> taxIds;
    private String taxId;
    private GeneName mappedGeneName;
    private List<Number> synonymPriorities;

    public SynHit(String synonym, double score, List<String> ids, String source, List<String> taxIds) {
        this.synonym = synonym;
        this.mentionScore = score;
        this.ids = ids;
        this.source = source;
        this.taxIds = taxIds;
    }

    public SynHit(String syn, double score, String xid, String source) {
        this.synonym = syn;
        this.mentionScore = score;
        this.ids = Arrays.asList(xid);
        this.source = source;
    }

    public Map<String, Double> getSpeciesMentionScores() {
        return this.speciesMentionScores;
    }

    public Double getSpeciesMentionScore(String taxId) {
        return this.speciesMentionScores.get(taxId);
    }

    public void setSpeciesMentionScore(String taxId, double speciesMentionScore) {
        this.speciesMentionScores.put(taxId, speciesMentionScore);
    }

    public void restrictToTaxId(String taxId) {
        this.id = null;
        this.taxId = null;
        for (int i = 0; i < this.ids.size(); ++i) {
            if (!this.taxIds.get(i).equals(taxId)) continue;
            this.id = this.ids.get(i);
            this.taxId = taxId;
        }
        if (this.id == null) {
            throw new IllegalArgumentException("This SynHit does not contain taxonomy ID " + taxId + ": " + this);
        }
    }

    public double getMentionScore() {
        return this.mentionScore;
    }

    public void setMentionScore(double score) {
        this.mentionScore = score;
    }

    public double getSemanticScore() {
        return this.semanticScore;
    }

    public void setSemanticScore(double score) {
        this.semanticScore = score;
    }

    public String getSynonym() {
        return this.synonym;
    }

    public void setSynonym(String syn) {
        this.synonym = syn;
    }

    public String toString() {
        DecimalFormat scoreFormat = new DecimalFormat("0.000");
        String result = "syn=" + this.synonym + "\tid=" + this.ids + "\tscore=" + scoreFormat.format(this.mentionScore) + "\tsemScore=" + scoreFormat.format(this.semanticScore) + "\ttaxId=" + this.taxIds;
        return result;
    }

    @Override
    public int compareTo(SynHit o) {
        int c = 0;
        if (this.compareType != o.compareType) {
            throw new IllegalStateException("Two SynHits are compared that don't use the same comparison type: " + this + ", " + o);
        }
        switch (this.compareType) {
            case RANDOM: {
                c = new Integer(o.random).compareTo(this.random);
                break;
            }
            case SCORE: {
                c = Double.compare(o.mentionScore, this.mentionScore);
                break;
            }
            case SEMSCORE: {
                c = new Double(o.semanticScore).compareTo(this.semanticScore);
            }
        }
        return c;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public CompareType getCompareType() {
        return this.compareType;
    }

    public void setCompareType(CompareType type) {
        this.compareType = type;
    }

    public String getMappedMention() {
        return this.mappedMention;
    }

    public void setMappedMention(String mappedSynonym) {
        this.mappedMention = mappedSynonym;
    }

    public boolean isExactMatch() {
        return this.mentionScore == 9999.0;
    }

    public SynHit clone() throws CloneNotSupportedException {
        SynHit h = (SynHit)super.clone();
        h.speciesMentionScores = new HashMap<String, Double>(this.speciesMentionScores);
        h.ids = new ArrayList<String>(this.ids);
        h.taxIds = new ArrayList<String>(this.getTaxIds());
        h.synonymPriorities = new ArrayList<Number>(this.synonymPriorities);
        return h;
    }

    public List<String> getIds() {
        return this.ids;
    }

    public void setIds(List<String> ids) {
        this.ids = ids;
    }

    public boolean isDisambiguated() {
        return this.id != null;
    }

    public boolean isAmbiguousInGeneral() {
        return this.ids.size() > 1;
    }

    public boolean isIntraSpeciesAmbiguousInGeneral() {
        HashSet<String> seenTaxIds = new HashSet<String>();
        boolean currentTaxIdWasNotYetSeen = false;
        for (int i = 0; i < this.taxIds.size() && (currentTaxIdWasNotYetSeen = seenTaxIds.add(this.taxIds.get(i))); ++i) {
        }
        return !currentTaxIdWasNotYetSeen;
    }

    public boolean isInterSpeciesAmbiguousInGeneral() {
        if (this.taxIds.size() <= 1) {
            return false;
        }
        HashSet<String> seenTaxIds = new HashSet<String>();
        seenTaxIds.add(this.taxIds.get(0));
        boolean currentTaxIdWasNotYetSeen = false;
        for (int i = 1; i < this.taxIds.size() && !(currentTaxIdWasNotYetSeen = seenTaxIds.add(this.taxIds.get(i))); ++i) {
        }
        return currentTaxIdWasNotYetSeen;
    }

    public String getId() {
        if (this.id == null) {
            if (this.taxonomySpecificIds != null && this.taxonomySpecificIds.length > 0) {
                return this.taxonomySpecificIds[0];
            }
            if (this.ids.size() == 1) {
                return this.ids.get(0);
            }
        }
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<String> getTaxIds() {
        return this.taxIds;
    }

    public void setTaxIds(List<String> taxIds) {
        this.taxIds = taxIds;
    }

    public double getOverallScore() {
        return this.overallScore;
    }

    public void setOverallScore(double overallScore) {
        this.overallScore = overallScore;
    }

    public GeneName getMappedGeneName() {
        return this.mappedGeneName;
    }

    public void setMappedGeneName(GeneName mappedGeneName) {
        this.mappedGeneName = mappedGeneName;
    }

    public String getTaxId() {
        return this.taxId;
    }

    public void setTaxId(String taxId) {
        int[] indices = IntStream.range(0, this.taxIds.size()).filter(i -> this.taxIds.get(i).equals(taxId)).toArray();
        if (indices.length == 0) {
            throw new IllegalArgumentException("Cannot set taxonomy ID '" + taxId + "' to this SynHit because this taxonomy ID does not occur for this SynHit.");
        }
        this.taxonomySpecificIds = (String[])IntStream.of(indices).mapToObj(i -> String.valueOf(this.ids.get(i))).toArray(String[]::new);
        if (indices.length == 1) {
            this.id = this.taxonomySpecificIds[0];
        }
        this.taxId = taxId;
    }

    public String[] getTaxonomySpecificIds() {
        return this.taxonomySpecificIds;
    }

    public List<Number> getPrioritiesOfIds(String[] idArray) {
        return this.getPrioritiesOfIds(Stream.of(idArray));
    }

    public List<Number> getPrioritiesOfIds(Stream<String> idStream) {
        Set idSet = idStream.collect(Collectors.toSet());
        return IntStream.range(0, this.ids.size()).filter(i -> idSet.contains(this.ids.get(i))).mapToObj(this.synonymPriorities::get).collect(Collectors.toList());
    }

    public boolean hasTaxId(String taxId) {
        return this.taxIds.indexOf(taxId) != -1;
    }

    public List<Number> getSynonymPriorities() {
        return this.synonymPriorities;
    }

    public void setSynonymPriorities(List<Number> synonymPriorities) {
        this.synonymPriorities = synonymPriorities;
    }

    public int getSynonymPriority() {
        return this.synonymPriorities.get(0).intValue();
    }

    public Stream<String> getGeneIdsOfTaxId(String taxId) {
        if (this.taxIds != null) {
            return IntStream.range(0, this.taxIds.size()).filter(i -> this.taxIds.get(i).equals(taxId)).mapToObj(this.ids::get);
        }
        return Stream.empty();
    }

    public static enum CompareType {
        RANDOM,
        SCORE,
        SEMSCORE;

    }
}

