/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jules.ae.genemapping;

import de.julielab.jules.ae.genemapping.CandidateCacheKey;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spell.SpellChecker;

public class QueryGenerator {
    public static BooleanQuery makeDisjunctiveQuery(String searchString) {
        return QueryGenerator.makeDisjunctiveQuery(searchString, "indexed_syn");
    }

    public static BooleanQuery makeDisjunctiveQuery(String searchString, String field) throws BooleanQuery.TooManyClauses {
        if (searchString == null) {
            return null;
        }
        String[] tokens = searchString.split(" ");
        BooleanQuery.Builder disjunctiveQuery = new BooleanQuery.Builder();
        for (int i = 0; i < tokens.length && i < 1024; ++i) {
            TermQuery q = new TermQuery(new Term(field, tokens[i]));
            disjunctiveQuery.add((Query)q, BooleanClause.Occur.SHOULD);
        }
        return disjunctiveQuery.build();
    }

    public static BooleanQuery makeConjunctiveQuery(String searchString, String field) {
        String[] tokens = searchString.split(" ");
        BooleanQuery.Builder disjunctiveQuery = new BooleanQuery.Builder();
        for (int i = 0; i < tokens.length; ++i) {
            TermQuery q = new TermQuery(new Term(field, tokens[i]));
            disjunctiveQuery.add((Query)q, BooleanClause.Occur.MUST);
        }
        return disjunctiveQuery.build();
    }

    public static Query makeDisjunctionMaxQuery(CandidateCacheKey key, SpellChecker spellingChecker) throws BooleanQuery.TooManyClauses, IOException {
        String originalName = key.geneName.getText().toLowerCase();
        String normalizedName = key.geneName.getNormalizedText();
        List<String> nameVariant = key.geneName.getNormalizedTextVariant();
        List<Object> disjuncts = new ArrayList<BooleanQuery>();
        BooleanQuery originalNameQueryDisjunctive = QueryGenerator.makeDisjunctiveQuery(originalName, "original_name");
        BooleanQuery normalizedNameQueryDisjunctive = QueryGenerator.makeDisjunctiveQuery(normalizedName, "indexed_syn");
        disjuncts.add(originalNameQueryDisjunctive);
        disjuncts.add(normalizedNameQueryDisjunctive);
        for (String variant : nameVariant) {
            if (variant.equals(originalName) || variant.equals(normalizedName)) continue;
            disjuncts.add(QueryGenerator.makeDisjunctiveQuery(variant, "variant_name"));
        }
        disjuncts = disjuncts.stream().filter(Objects::nonNull).collect(Collectors.toList());
        DisjunctionMaxQuery disjunctionMaxQuery = new DisjunctionMaxQuery(disjuncts, 0.0f);
        BooleanClause fc = null;
        BooleanQuery.Builder builder = new BooleanQuery.Builder().add((Query)disjunctionMaxQuery, BooleanClause.Occur.MUST);
        if (fc != null) {
            builder.add(fc);
        }
        if (!StringUtils.isBlank((CharSequence)key.taxId)) {
            builder.add((Query)new TermQuery(new Term("tax_id", key.taxId)), BooleanClause.Occur.FILTER).build();
        }
        return builder.build();
    }

    private static String applySpellingCorrection(String name, SpellChecker spellingChecker) throws IOException {
        if (spellingChecker == null) {
            return name;
        }
        if (name.trim().isEmpty()) {
            return null;
        }
        String[] split = name.split("\\s+");
        ArrayList<String> newName = new ArrayList<String>();
        for (int i = 0; i < split.length; ++i) {
            String token = split[i];
            if (token.length() > 2 && token.endsWith("s")) {
                if (!spellingChecker.exist(token)) {
                    String[] suggestions = spellingChecker.suggestSimilar(token, 5);
                    if (suggestions.length > 0) {
                        newName.add(suggestions[0]);
                        continue;
                    }
                    newName.add(token);
                    continue;
                }
                newName.add(token);
                continue;
            }
            newName.add(token);
        }
        return newName.stream().collect(Collectors.joining(" "));
    }
}

