/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jules.ae.genemapping;

import de.julielab.jcore.types.EntityMention;
import de.julielab.jcore.types.GeneResourceEntry;
import de.julielab.jcore.utility.JCoReTools;
import de.julielab.jules.ae.genemapping.GeneMapping;
import de.julielab.jules.ae.genemapping.MentionMappingResult;
import de.julielab.jules.ae.genemapping.SynHit;
import de.julielab.jules.ae.genemapping.genemodel.GeneDocument;
import de.julielab.jules.ae.genemapping.genemodel.GeneDocumentFactory;
import de.julielab.jules.ae.genemapping.genemodel.GeneMention;
import de.julielab.jules.ae.genemapping.utils.ContextUtils;
import de.julielab.jules.ae.genemapping.utils.GeneMapperRuntimeException;
import de.julielab.jules.ae.genemapping.utils.GeneMappingException;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.search.BooleanQuery;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneMappingAnnotator
extends JCasAnnotator_ImplBase {
    public static final String COMPONENT_ID = GeneMapping.class.getCanonicalName();
    public static final String CONTEXT_WINDOW_SIZE = "ContextWindowSize";
    public static final String TOKEN_CONTEXT = "TokenContext";
    public static final String ENTITY_MAPPING_TYPES = "EntityMappingTypes";
    public static final String MAPPER_CONFIG_FILE = "MapperConfigFile";
    private static final Logger log = LoggerFactory.getLogger(GeneMappingAnnotator.class);
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.000");
    @ConfigurationParameter(name="EntityMappingTypes", description="A list of fully qualified UIMA entity types and regexp patterns which will be applied to the specificType attribute. Each line in the string array is assumed to have the following format: <class-name-of-entity>=<specType regexes> where the specTypes should be delimited with a ''. An entity will be mapped as a gene/protein if any of the given regular expressions match its specificType feature value.")
    private String[] entityTypeMappings;
    @ConfigurationParameter(name="MapperConfigFile", description="A properties file containing configuration settings for the mapping.")
    private String mapperConfigFile;
    @ConfigurationParameter(name="TokenContext")
    private Boolean useTokenContext;
    @ConfigurationParameter(name="ContextWindowSize", description="The size - in the number of tokens - to be used for the window around an entity mention to be mapped.", mandatory=false)
    private Integer contextTokenWindowSize;
    private HashMap<String, Matcher> entityMappingTypes = null;
    private GeneMapping mapper = null;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.instantiateMapper(aContext);
        this.getEntityMappingTypes(aContext);
        this.useTokenContext = (Boolean)aContext.getConfigParameterValue(TOKEN_CONTEXT);
        this.contextTokenWindowSize = this.useTokenContext != false ? Optional.ofNullable((Integer)aContext.getConfigParameterValue(CONTEXT_WINDOW_SIZE)).orElse(50) : 0;
        try {
            GeneDocumentFactory.initialize(this.mapper);
        }
        catch (GeneMappingException e) {
            log.error("Could not initialize the GeneDocumentFactory", (Throwable)e);
            throw new ResourceInitializationException((Throwable)e);
        }
        this.logConfigurationParameters();
    }

    private void logConfigurationParameters() {
        log.info("{}: {}", (Object)CONTEXT_WINDOW_SIZE, (Object)this.contextTokenWindowSize);
        log.info("{}: {}", (Object)TOKEN_CONTEXT, (Object)this.useTokenContext);
        log.info("{}: {}", (Object)CONTEXT_WINDOW_SIZE, (Object)this.contextTokenWindowSize);
        log.info("{}: {}", (Object)MAPPER_CONFIG_FILE, (Object)this.mapperConfigFile);
    }

    private void getEntityMappingTypes(UimaContext aContext) throws ResourceInitializationException {
        this.entityTypeMappings = (String[])aContext.getConfigParameterValue(ENTITY_MAPPING_TYPES);
        if (this.entityTypeMappings != null) {
            this.entityMappingTypes = new HashMap();
            for (String entityTypeMapping : this.entityTypeMappings) {
                String[] entDefinition = entityTypeMapping.split("=");
                if (entDefinition.length != 2) {
                    log.error("EntityMappingTypes in wrong format: {}", (Object)entityTypeMapping);
                }
                String entName = entDefinition[0];
                Pattern entSpecificPattern = Pattern.compile(entDefinition[1]);
                this.entityMappingTypes.put(entName, entSpecificPattern.matcher(""));
            }
            if (log.isInfoEnabled()) {
                log.info("Entity types to be considered for mapping: {}", this.entityMappingTypes.keySet().stream().collect(Collectors.toMap(Function.identity(), key -> this.entityMappingTypes.get(key).pattern())));
            }
        } else {
            String msg = "No entity mapping types defined. Please check the value of the EntityMappingTypes parameter.";
            log.error(msg);
            throw new ResourceInitializationException((Throwable)new IllegalArgumentException(msg));
        }
    }

    private void instantiateMapper(UimaContext aContext) throws ResourceInitializationException {
        this.mapperConfigFile = (String)aContext.getConfigParameterValue(MAPPER_CONFIG_FILE);
        if (this.mapperConfigFile != null) {
            try {
                this.mapper = new GeneMapping(new File(this.mapperConfigFile));
            }
            catch (CorruptIndexException e) {
                log.error("Error initializing gene mapper: index corrupt.", (Throwable)e);
                throw new ResourceInitializationException((Throwable)e);
            }
            catch (Exception e) {
                log.error("Error initializing gene mapper.", (Throwable)e);
                throw new ResourceInitializationException((Throwable)e);
            }
        } else {
            String msg = "Error initializing gene mapper: no config file for mapper specified.";
            log.error("Error initializing gene mapper: no config file for mapper specified.");
            throw new ResourceInitializationException((Throwable)new IllegalArgumentException("Error initializing gene mapper: no config file for mapper specified."));
        }
    }

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        try {
            Function<EntityMention, Pair<String, BooleanQuery>> contextFun;
            if (!this.useTokenContext.booleanValue()) {
                BooleanQuery contextQuery = ContextUtils.makeContextQuery(aJCas);
                contextFun = em -> new ImmutablePair((Object)aJCas.getDocumentText(), (Object)contextQuery);
            } else {
                contextFun = em -> {
                    try {
                        String entityContext = ContextUtils.makeContext(aJCas, this.contextTokenWindowSize, em);
                        if (entityContext != null) {
                            entityContext = entityContext.trim();
                        }
                        BooleanQuery contextQuery = ContextUtils.makeContextQuery(entityContext);
                        return new ImmutablePair((Object)entityContext, (Object)contextQuery);
                    }
                    catch (IOException e) {
                        throw new GeneMapperRuntimeException(e);
                    }
                };
            }
            GeneDocument geneDocument = GeneDocumentFactory.getInstance().createGeneDocument(aJCas, this.entityMappingTypes, contextFun);
            this.doMapping(aJCas, geneDocument);
        }
        catch (IOException e) {
            String info = "Error generating the boolean context query";
            AnalysisEngineProcessException e1 = new AnalysisEngineProcessException((Throwable)e);
            log.error(info, (Throwable)e);
            throw e1;
        }
    }

    private void doMapping(JCas aJCas, GeneDocument geneDocument) throws AnalysisEngineProcessException {
        try {
            this.mapper.map(geneDocument);
        }
        catch (GeneMappingException e) {
            String msg = "Document with ID " + geneDocument.getId() + " could not be gene/protein ID-mapped.";
            log.error(msg, (Throwable)e);
            throw new AnalysisEngineProcessException((Throwable)new IllegalStateException(msg));
        }
        this.writeMappingsToCAS(aJCas, geneDocument);
    }

    private void writeMappingsToCAS(JCas aJCas, GeneDocument document) {
        if (document.getGenes().map(GeneMention::getMentionMappingResult).noneMatch(r -> r.resultEntries != MentionMappingResult.REJECTION)) {
            log.debug("No genes in document {} have been accepted or no gene mentions are present.", (Object)document.getId());
            return;
        }
        List mappedGenes = document.getGenes().filter(gm -> gm.getMentionMappingResult().resultEntries != MentionMappingResult.REJECTION).collect(Collectors.toList());
        for (GeneMention gm2 : mappedGenes) {
            List<SynHit> resultEntries = gm2.getMentionMappingResult().resultEntries;
            ArrayList<GeneResourceEntry> newResourceEntries = new ArrayList<GeneResourceEntry>(resultEntries.size());
            for (SynHit hit : resultEntries) {
                GeneResourceEntry resourceEntry = new GeneResourceEntry(aJCas);
                resourceEntry.setSource("WRITE SOURCE INTO INDEX");
                String geneId = hit.getId();
                resourceEntry.setEntryId(geneId);
                resourceEntry.setTaxonomyId(hit.getTaxId());
                resourceEntry.setBegin(gm2.getBegin());
                resourceEntry.setEnd(gm2.getEnd());
                resourceEntry.setComponentId(COMPONENT_ID);
                String confidence = DECIMAL_FORMAT.format(hit.getMentionScore()) + " / " + DECIMAL_FORMAT.format(hit.getSemanticScore());
                resourceEntry.setConfidence(confidence);
                resourceEntry.setId(gm2.getNormalizedText());
                resourceEntry.setSynonym(hit.getSynonym());
                newResourceEntries.add(resourceEntry);
            }
            EntityMention entity = (EntityMention)gm2.getOriginalMappedObject();
            FSArray resourceEntryList = entity.getResourceEntryList();
            if (null == resourceEntryList && newResourceEntries.size() > 0) {
                resourceEntryList = new FSArray(aJCas, newResourceEntries.size());
            }
            FSArray newEntryList = JCoReTools.addToFSArray((FSArray)resourceEntryList, newResourceEntries);
            entity.setResourceEntryList(newEntryList);
        }
    }
}

