/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jules.ae.genemapping;

import de.julielab.jules.ae.genemapping.CandidateFilter;
import de.julielab.jules.ae.genemapping.DocumentMappingResult;
import de.julielab.jules.ae.genemapping.GeneMappingConfiguration;
import de.julielab.jules.ae.genemapping.MentionMappingResult;
import de.julielab.jules.ae.genemapping.SynHit;
import de.julielab.jules.ae.genemapping.genemodel.GeneDocument;
import de.julielab.jules.ae.genemapping.genemodel.GeneMention;
import de.julielab.jules.ae.genemapping.mappingcores.MappingCore;
import de.julielab.jules.ae.genemapping.utils.GeneCandidateRetrievalException;
import de.julielab.jules.ae.genemapping.utils.GeneMappingException;
import de.julielab.jules.ae.genemapping.utils.SynHitUtils;
import de.julielab.jules.ae.genemapping.utils.norm.TermNormalizer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.search.BooleanQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneMapping {
    public static final boolean LEGACY_INDEX_SUPPORT = true;
    public static final String SOURCE_DEFINITION = "UniProt ID (any organism)";
    private static final Logger LOGGER = LoggerFactory.getLogger(GeneMapping.class);
    public static final int SIMPLE_SCORER = 0;
    public static final int TOKEN_JAROWINKLER_SCORER = 1;
    public static final int MAXENT_SCORER = 2;
    public static final int JAROWINKLER_SCORER = 3;
    public static final int LEVENSHTEIN_SCORER = 4;
    public static final int TFIDF = 5;
    public static final int LUCENE_SCORER = 10;
    @Deprecated
    public static final String MAPPING_CORE = "mapping_core";
    private MappingCore mappingCore;
    private GeneMappingConfiguration config;
    private static CandidateFilter candidateFilter;

    public GeneMapping(File propertiesFile) throws IOException, GeneMappingException {
        this(GeneMapping.loadConfigurationFile(propertiesFile));
    }

    public GeneMapping(GeneMappingConfiguration configuration) throws IOException, GeneMappingException {
        this.config = configuration;
        this.readProperties(configuration);
        candidateFilter = new CandidateFilter();
    }

    private static GeneMappingConfiguration loadConfigurationFile(File propertiesFile) throws IOException {
        GeneMappingConfiguration config = new GeneMappingConfiguration();
        try {
            config.load(new FileInputStream(propertiesFile));
        }
        catch (FileNotFoundException e) {
            LOGGER.error("specified properties file does not exist!");
            throw e;
        }
        return config;
    }

    private void readProperties(GeneMappingConfiguration config) throws GeneMappingException {
        String mappingCore = config.getProperty(MAPPING_CORE);
        if (mappingCore == null) {
            throw new GeneMappingException("Property mapping_core is undefined. The mapping core to be used must be specified.");
        }
        try {
            this.mappingCore = (MappingCore)Class.forName(mappingCore).getDeclaredConstructor(GeneMappingConfiguration.class).newInstance(config);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new GeneMappingException(e);
        }
    }

    public ArrayList<SynHit> mapTopN(String searchTerm, int topN) throws IOException, GeneCandidateRetrievalException {
        TermNormalizer normalizer = new TermNormalizer();
        String normalizedSearchTerm = normalizer.normalize(searchTerm);
        if ((normalizedSearchTerm = GeneMapping.removeModifiers(normalizedSearchTerm)).equals("")) {
            return null;
        }
        LOGGER.info("map() - searching for term: " + searchTerm + " as > " + normalizedSearchTerm + " <");
        List<SynHit> allHits = this.mappingCore.getCandidateRetrieval().getCandidates(normalizedSearchTerm);
        ArrayList<SynHit> topNHits = new ArrayList<SynHit>();
        for (int i = 0; i < Math.min(allHits.size(), topN); ++i) {
            SynHit synHit = allHits.get(i);
            if (candidateFilter.filterOut(normalizedSearchTerm, synHit.getSynonym())) continue;
            topNHits.add(allHits.get(i));
        }
        LOGGER.info("topN mapping found > " + topNHits.size() + " <  for candidate '" + searchTerm + "': " + SynHitUtils.showHitIDs(topNHits));
        return topNHits;
    }

    public List<SynHit> map(String searchTerm, BooleanQuery contextQuery) throws GeneMappingException {
        GeneMention predictedMention = new GeneMention(searchTerm);
        MentionMappingResult map = this.map(predictedMention, contextQuery, null);
        return map.resultEntries;
    }

    public MentionMappingResult map(GeneMention searchTerm, BooleanQuery contextQuery, String documentContext) throws GeneMappingException {
        return this.mappingCore.map(searchTerm);
    }

    public DocumentMappingResult map(GeneDocument document) throws GeneMappingException {
        return this.mappingCore.map(document);
    }

    public static String removeModifiers(String normalizedSearchTerm) {
        LOGGER.debug("TRYING to remove modifiers or even complete term: " + normalizedSearchTerm);
        Pattern p = GeneMapping.candidateFilter.patternUnspecifieds;
        Matcher m = p.matcher(normalizedSearchTerm);
        if (m.matches()) {
            LOGGER.debug("IS UNSPECIFIED: " + normalizedSearchTerm);
            normalizedSearchTerm = normalizedSearchTerm.replaceFirst(GeneMapping.candidateFilter.UNSPECIFIEDS, "");
            LOGGER.debug("UNSPECIFIED REMOVED: |" + normalizedSearchTerm + "|");
        }
        if ((m = (p = GeneMapping.candidateFilter.patternDomainFamilies).matcher(normalizedSearchTerm = normalizedSearchTerm.trim())).matches()) {
            LOGGER.debug("IS DOMAIN: " + normalizedSearchTerm);
            normalizedSearchTerm = normalizedSearchTerm.replaceFirst(GeneMapping.candidateFilter.DOMAIN_FAMILIES, "");
            LOGGER.debug("DOMAIN REMOVED: |" + normalizedSearchTerm + "|");
        }
        if ((m = (p = GeneMapping.candidateFilter.patternPreMods).matcher(normalizedSearchTerm = normalizedSearchTerm.trim())).matches()) {
            LOGGER.debug("PREMODIFIER: " + normalizedSearchTerm);
            normalizedSearchTerm = normalizedSearchTerm.replaceFirst(GeneMapping.candidateFilter.PREMODS, "");
        }
        if ((m = (p = GeneMapping.candidateFilter.patternNonDesc).matcher(normalizedSearchTerm = normalizedSearchTerm.trim())).matches()) {
            LOGGER.debug("IS NONDESC: " + normalizedSearchTerm);
            normalizedSearchTerm = normalizedSearchTerm.replaceFirst(GeneMapping.candidateFilter.NON_DESC, "");
            LOGGER.debug("NONDESC REMOVED: |" + normalizedSearchTerm + "|");
        }
        normalizedSearchTerm = normalizedSearchTerm.trim();
        p = null;
        m = null;
        return normalizedSearchTerm.trim();
    }

    public static String removeUnspecifieds(String normalizedSearchTerm) {
        Pattern p = GeneMapping.candidateFilter.patternUnspecifieds;
        Matcher m = p.matcher(normalizedSearchTerm);
        LOGGER.debug("TRYING to remove modifiers or even complete term: " + normalizedSearchTerm);
        if (m.matches()) {
            LOGGER.debug("IS UNSPECIFIED: " + normalizedSearchTerm);
            normalizedSearchTerm = normalizedSearchTerm.replaceFirst(GeneMapping.candidateFilter.UNSPECIFIEDS, "");
            LOGGER.debug("UNSPECIFIED REMOVED: |" + normalizedSearchTerm + "|");
        }
        return normalizedSearchTerm.trim();
    }

    public static String removeNondescriptives(String normalizedSearchTerm) {
        Pattern p = GeneMapping.candidateFilter.patternNonDesc;
        Matcher m = p.matcher(normalizedSearchTerm);
        if (m.find()) {
            LOGGER.debug("IS NONDESC: " + normalizedSearchTerm);
            normalizedSearchTerm = normalizedSearchTerm.replaceFirst(GeneMapping.candidateFilter.NON_DESC, "");
            LOGGER.debug("NONDESC REMOVED: |" + normalizedSearchTerm + "|");
        }
        return normalizedSearchTerm.trim();
    }

    public static String removeDomainFamilies(String normalizedSearchTerm) {
        Pattern p = GeneMapping.candidateFilter.patternDomainFamilies;
        Matcher m = p.matcher(normalizedSearchTerm);
        if (m.matches()) {
            LOGGER.debug("IS DOMAIN: " + normalizedSearchTerm);
            normalizedSearchTerm = normalizedSearchTerm.replaceFirst(GeneMapping.candidateFilter.DOMAIN_FAMILIES, "");
            LOGGER.debug("DOMAIN REMOVED: |" + normalizedSearchTerm + "|");
        }
        return normalizedSearchTerm.trim();
    }

    public static String removePremodifiers(String normalizedSearchTerm) {
        Pattern p = GeneMapping.candidateFilter.patternPreMods;
        Matcher m = p.matcher(normalizedSearchTerm);
        if (m.matches()) {
            LOGGER.debug("PREMODIFIER: " + normalizedSearchTerm);
            normalizedSearchTerm = normalizedSearchTerm.replaceFirst(GeneMapping.candidateFilter.PREMODS, "");
        }
        return normalizedSearchTerm.trim();
    }

    public MappingCore getMappingCore() {
        return this.mappingCore;
    }

    public void setMappingCore(MappingCore mappingCore) {
        this.mappingCore = mappingCore;
    }

    public MentionMappingResult map(String term, BooleanQuery contextQuery, String documentContext) throws GeneMappingException {
        return this.map(new GeneMention(term), contextQuery, documentContext);
    }

    public GeneMappingConfiguration getConfiguration() {
        return this.config;
    }
}

