/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.resources.ncbigene;

import com.google.common.collect.Sets;
import de.julielab.genemapper.resources.ncbigene.EntrezgeneProt;
import de.julielab.genemapper.resources.ncbigene.GeneXmlExtract;
import de.julielab.java.utilities.FileUtilities;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneXMLUtils {
    public static final String TAXIDS_FILENAME = "genexmldownloader.taxids.gz";
    public static final String EG2ENTREZGENE_PROT_FILENAME = "eg2entrezgene_prot-genexmldownloader.gz";
    public static final String EG2SUMMARY_FILENAME = "eg2summary-genexmldownloader.gz";
    private static final String EG2REFSEQ_AND_TRACK_STATUS_FILENAME = "eg2refseq_genetrack_status-genexmldownloader.gz";
    private static final String EG2EC_FILENAME = "eg2ecnumber-genexmldownloader.gz";
    private static final Logger log = LoggerFactory.getLogger(GeneXMLUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeGeneInfoToFile(List<GeneXmlExtract> geneExtractList, OutputStream osSummaries, OutputStream osProtnames, OutputStream osRefSeqAndTrackStatus, OutputStream osECNumbers) throws IOException {
        log.trace("Writing gene summaries of current XML batch.");
        OutputStream outputStream = osSummaries;
        synchronized (outputStream) {
            for (GeneXmlExtract extract : geneExtractList) {
                if (extract.summary == null) continue;
                IOUtils.write((String)(extract.geneId + "\t" + extract.summary + "\n"), (OutputStream)osSummaries, (String)"UTF-8");
            }
        }
        outputStream = osProtnames;
        synchronized (outputStream) {
            log.trace("Writing entrezgene_prot names of current XML batch.");
            for (GeneXmlExtract extract : geneExtractList) {
                if (extract.entrezgeneProt == null) continue;
                if (extract.entrezgeneProt.protrefName != null) {
                    for (String protName : extract.entrezgeneProt.protrefName) {
                        IOUtils.write((String)(extract.geneId + "\t" + protName + "\n"), (OutputStream)osProtnames, (String)"UTF-8");
                    }
                }
                if (null == extract.entrezgeneProt.protrefDesc) continue;
                IOUtils.write((String)(extract.geneId + "\t" + extract.entrezgeneProt.protrefDesc + "\n"), (OutputStream)osProtnames, (String)"UTF-8");
            }
        }
        outputStream = osRefSeqAndTrackStatus;
        synchronized (outputStream) {
            log.trace("Writing entrez gene RefSeq status entries of current XML batch");
            for (GeneXmlExtract extract : geneExtractList) {
                String refSeqStatus = extract.refSeqStatus != null ? extract.refSeqStatus : "<none given>";
                IOUtils.write((String)(extract.geneId + "\t" + refSeqStatus + "\t" + extract.geneTrackStatusValue + "\t" + extract.geneTrackStatus + "\n"), (OutputStream)osRefSeqAndTrackStatus, (String)"UTF-8");
            }
        }
        outputStream = osECNumbers;
        synchronized (outputStream) {
            log.trace("Writing EC numbers of current XML batch");
            for (GeneXmlExtract extract : geneExtractList) {
                if (extract.ecNumber == null) continue;
                IOUtils.write((String)(extract.geneId + "\t" + extract.ecNumber + "\n"), (OutputStream)osECNumbers, (String)"UTF-8");
            }
        }
    }

    public static List<GeneXmlExtract> extractGeneInfoFromXml(InputStream openStream) throws XMLStreamException, IOException {
        ArrayList<GeneXmlExtract> geneExtractList = new ArrayList<GeneXmlExtract>();
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader parser = factory.createXMLStreamReader(openStream);
        GeneXmlExtract currentXmlExtract = null;
        boolean inEntrezGeneSource = false;
        boolean inTaxonDbtag = false;
        boolean inRefSeqStatusCommentary = false;
        boolean inEntrezgene_comments = false;
        boolean inECNumber = false;
        while (parser.hasNext()) {
            block0 : switch (parser.getEventType()) {
                case 1: {
                    String currentTag;
                    switch (currentTag = parser.getLocalName()) {
                        case "Entrezgene": {
                            currentXmlExtract = new GeneXmlExtract();
                            break;
                        }
                        case "Entrezgene_prot": {
                            currentXmlExtract.entrezgeneProt = GeneXMLUtils.readEntrezgeneProtFromXml(parser);
                            break;
                        }
                        case "Gene-track_geneid": {
                            currentXmlExtract.geneId = parser.getElementText();
                            break;
                        }
                        case "Entrezgene_summary": {
                            currentXmlExtract.summary = parser.getElementText();
                            break;
                        }
                        case "Entrezgene_source": {
                            inEntrezGeneSource = true;
                            break;
                        }
                        case "Dbtag_db": {
                            if (!parser.getElementText().equals("taxon")) break;
                            inTaxonDbtag = true;
                            break;
                        }
                        case "Object-id_id": {
                            if (!inEntrezGeneSource || !inTaxonDbtag) break;
                            currentXmlExtract.taxId = parser.getElementText();
                            break;
                        }
                        case "Gene-commentary_heading": {
                            if (!parser.getElementText().equals("RefSeq Status")) break;
                            inRefSeqStatusCommentary = true;
                            break;
                        }
                        case "Entrezgene_comments": {
                            inEntrezgene_comments = true;
                            break;
                        }
                        case "Gene-commentary_label": {
                            String elementText = parser.getElementText();
                            if (inEntrezgene_comments && inRefSeqStatusCommentary) {
                                currentXmlExtract.refSeqStatus = elementText;
                                inRefSeqStatusCommentary = false;
                            }
                            if (!elementText.equals("EC")) break;
                            inECNumber = true;
                            break;
                        }
                        case "Gene-commentary_text": {
                            if (!inECNumber) break;
                            currentXmlExtract.ecNumber = parser.getElementText();
                            break;
                        }
                        case "Gene-track_status": {
                            currentXmlExtract.geneTrackStatusValue = parser.getAttributeValue("", "value");
                            currentXmlExtract.geneTrackStatus = parser.getElementText();
                        }
                    }
                    break;
                }
                case 2: {
                    String currentTag;
                    switch (currentTag = parser.getLocalName()) {
                        case "Entrezgene": {
                            geneExtractList.add(currentXmlExtract);
                            break block0;
                        }
                        case "Entrezgene_source": {
                            inEntrezGeneSource = false;
                            break block0;
                        }
                        case "Dbtag": {
                            inTaxonDbtag = false;
                            break block0;
                        }
                        case "Entrezgene_comments": {
                            inEntrezgene_comments = false;
                            break block0;
                        }
                        case "Gene-commentary": {
                            inECNumber = false;
                        }
                    }
                }
            }
            parser.next();
        }
        openStream.close();
        return geneExtractList;
    }

    private static EntrezgeneProt readEntrezgeneProtFromXml(XMLStreamReader parser) throws XMLStreamException {
        EntrezgeneProt prot = new EntrezgeneProt();
        String currentTag = parser.getLocalName();
        if (!currentTag.equals("Entrezgene_prot")) {
            throw new IllegalStateException("Expected the tag Entrezgene_prot to begin reading protein names but got " + currentTag);
        }
        block12: do {
            parser.next();
            switch (parser.getEventType()) {
                case 1: {
                    switch (currentTag = parser.getLocalName()) {
                        case "Prot-ref_name_E": {
                            prot.addProtrefName(parser.getElementText());
                            break;
                        }
                        case "Prot-ref_desc": {
                            prot.protrefDesc = parser.getElementText();
                        }
                    }
                    continue block12;
                }
                case 2: {
                    currentTag = parser.getLocalName();
                    break;
                }
            }
        } while (parser.getEventType() != 2 || !currentTag.equals("Entrezgene_prot"));
        return prot;
    }

    public static List<GeneXmlExtract> extractAndWriteGeneInfoToFile(OutputStream osSummaries, OutputStream osProtnames, OutputStream ofRefSeqAndTracStatus, OutputStream osECNumbers, InputStream is) throws XMLStreamException, IOException {
        List<GeneXmlExtract> geneExtractList = GeneXMLUtils.extractGeneInfoFromXml(is);
        GeneXMLUtils.writeGeneInfoToFile(geneExtractList, osSummaries, osProtnames, ofRefSeqAndTracStatus, osECNumbers);
        return geneExtractList;
    }

    public static Set<String> determineMissingTaxIds(File taxIdFile, File storageDirectory, File dbFile, File downloadedTaxIdsFile) throws IOException {
        Sets.SetView missingTaxIds;
        boolean dbFileIsNewer = !dbFile.exists() || downloadedTaxIdsFile.lastModified() < dbFile.lastModified();
        Sets.SetView taxIds = FileUtils.readLines((File)taxIdFile, (String)"UTF-8").stream().filter(line -> line.trim().length() != 0).collect(Collectors.toSet());
        if (!dbFileIsNewer) {
            Set downloadedTaxIds = downloadedTaxIdsFile.exists() ? FileUtilities.getReaderFromFile((File)downloadedTaxIdsFile).lines().filter(line -> line.trim().length() != 0).collect(Collectors.toSet()) : Collections.emptySet();
            log.debug("already created: {}", downloadedTaxIds);
            log.debug("requested: {}", taxIds);
            missingTaxIds = Sets.difference(taxIds, downloadedTaxIds);
            log.debug("difference: {}", (Object)missingTaxIds);
            if (missingTaxIds.isEmpty()) {
                log.info("Files for given taxonomy IDs have already been created created in {}", (Object)storageDirectory);
                System.exit(0);
            }
            log.info("Got {} taxonomy IDs for which gene meta information need to be downloaded and {} requested IDs already downloaded", (Object)missingTaxIds.size(), (Object)(taxIds.size() - missingTaxIds.size()));
        } else {
            String reason = dbFile.exists() ? "is newer than the existing meta data in " + storageDirectory.getAbsolutePath() : "does not exist";
            log.info("The given gene_info file {}. The data will be downloaded and created from scratch.", (Object)reason);
            missingTaxIds = taxIds;
        }
        return missingTaxIds;
    }

    public static List<File> getMetaFiles(File storageDirectory) {
        File summariesFile = new File(storageDirectory.getAbsolutePath() + File.separator + EG2SUMMARY_FILENAME);
        File proteinNamesFile = new File(storageDirectory.getAbsolutePath() + File.separator + EG2ENTREZGENE_PROT_FILENAME);
        File downloadedTaxIdsFile = new File(storageDirectory.getAbsolutePath() + File.separator + TAXIDS_FILENAME);
        File refseqStatusFile = new File(storageDirectory.getAbsolutePath() + File.separator + EG2REFSEQ_AND_TRACK_STATUS_FILENAME);
        File egNumbersFile = new File(storageDirectory.getAbsolutePath() + File.separator + EG2EC_FILENAME);
        List<File> geneXmlDownloaderFiles = Arrays.asList(summariesFile, proteinNamesFile, downloadedTaxIdsFile, refseqStatusFile, egNumbersFile);
        return geneXmlDownloaderFiles;
    }
}

