/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.resources;

import com.bluecast.xml.Piccolo;
import com.ximpleware.extended.AutoPilotHuge;
import com.ximpleware.extended.IByteBuffer;
import com.ximpleware.extended.NavExceptionHuge;
import com.ximpleware.extended.ParseExceptionHuge;
import com.ximpleware.extended.VTDGenHuge;
import com.ximpleware.extended.VTDNavHuge;
import com.ximpleware.extended.XPathEvalExceptionHuge;
import com.ximpleware.extended.XPathParseExceptionHuge;
import de.julielab.genemapper.resources.UniprotFreeTextHandler;
import de.julielab.xml.JulieXMLBuffer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class UniprotFreeTextExtractor {
    private static final double FILL_FACTOR = 13.5;
    private static final String FEATURE_NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    private static final String FEATURE_NAMESPACE = "http://xml.org/sax/features/namespaces";
    private static final Logger LOGGER = LoggerFactory.getLogger(UniprotFreeTextExtractor.class);

    public static void main(String[] args) throws ParseExceptionHuge, NavExceptionHuge, XPathParseExceptionHuge, XPathEvalExceptionHuge {
        if (args.length == 2) {
            UniprotFreeTextExtractor extractor = new UniprotFreeTextExtractor();
            File uniProt = new File(args[0]);
            if (uniProt.isFile() && args[0].length() > 0) {
                Piccolo xParser = new Piccolo();
                UniprotFreeTextHandler handler = new UniprotFreeTextHandler(args[1]);
                try {
                    xParser.setFeature(FEATURE_NAMESPACE, false);
                    xParser.setFeature(FEATURE_NAMESPACE_PREFIXES, true);
                }
                catch (SAXNotSupportedException e) {
                    e.printStackTrace();
                }
                catch (SAXNotRecognizedException e) {
                    e.printStackTrace();
                }
                xParser.setContentHandler((ContentHandler)handler);
                try {
                    extractor.fillMap(args[1], handler);
                    extractor.splitEntries(xParser, uniProt, handler);
                }
                catch (IOException io) {
                    io.printStackTrace();
                }
                catch (SAXException sax) {
                    sax.printStackTrace();
                }
            } else {
                System.out.println(args[0]);
                System.err.println("Could not find UniProt file!");
            }
        }
    }

    private void splitEntries(Piccolo xParser, File uniProt, UniprotFreeTextHandler handler) throws IOException, SAXException, XPathParseExceptionHuge, NavExceptionHuge, ParseExceptionHuge, XPathEvalExceptionHuge {
        JulieXMLBuffer buffer = new JulieXMLBuffer();
        buffer.readFile(uniProt.getAbsolutePath());
        VTDGenHuge vg = new VTDGenHuge();
        vg.setDoc((IByteBuffer)buffer);
        vg.parse(true);
        VTDNavHuge nav = vg.getNav();
        AutoPilotHuge ap = new AutoPilotHuge(nav);
        ap.selectXPath("/uniprot/entry");
        int counter = 0;
        while (ap.evalXPath() != -1) {
            long[] elementFragment = nav.getElementFragment();
            long offset = elementFragment[0];
            long length = elementFragment[1];
            String entryXml = new String(buffer.getFragment(offset, length), StandardCharsets.UTF_8);
            try {
                xParser.parse(new InputSource(new StringReader(entryXml)));
            }
            catch (SAXParseException sax) {
                if (sax.getMessage().equals("No corresponding ID!")) {
                    // empty if block
                }
            }
            if (++counter % 50000 != 0) continue;
            LOGGER.info(counter + " entries processed!");
        }
        this.closeFileHandles(handler);
    }

    private void closeFileHandles(UniprotFreeTextHandler handler) {
        for (String filename : handler.freetextFiles.keySet()) {
            BufferedWriter raf = handler.freetextFiles.get(filename);
            try {
                raf.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void fillMap(String string, UniprotFreeTextHandler handler) {
        File idFile = new File(string);
        long fileSize = idFile.length();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(idFile));
            HashMap<String, String[]> uniprot2EntrezMap = new HashMap<String, String[]>((int)((double)fileSize / 13.5));
            while ((line = br.readLine()) != null) {
                if (line.equals("")) continue;
                String[] entry = line.split("\t");
                String[] egIds = (String[])uniprot2EntrezMap.get(entry[0]);
                if (egIds == null) {
                    uniprot2EntrezMap.put(entry[0], new String[]{entry[1]});
                    continue;
                }
                String[] newArray = new String[egIds.length + 1];
                System.arraycopy(egIds, 0, newArray, 0, egIds.length);
                newArray[newArray.length - 1] = entry[1];
                uniprot2EntrezMap.put(entry[0], newArray);
            }
            System.out.println("ID map size: " + uniprot2EntrezMap.size());
            handler.uniprot2EntrezMap = uniprot2EntrezMap;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

