/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class UniprotDictCreator {
    private static final HashMap<String, ArrayList<String>> dictContent = new HashMap();

    public static void main(String[] args) {
        if (args.length == 2) {
            File inputFile = new File(args[0]);
            File outputFile = new File(args[1]);
            System.out.println("Reading UniProt XML from " + inputFile.getAbsolutePath() + " and writing dictionary to " + outputFile.getAbsolutePath());
            UniprotDictCreator dictCreator = new UniprotDictCreator();
            dictCreator.readEntries(inputFile);
            dictCreator.writeEntries(outputFile);
        } else {
            System.err.println("usage:\nUniProtDictCreator <inputFile> <outputFile>");
            System.exit(-1);
        }
    }

    public void readEntries(File inputFile) {
        String accession = "";
        ArrayList<CallSite> otherNames = new ArrayList<CallSite>();
        try {
            InputStream fis = new FileInputStream(inputFile);
            if (inputFile.getName().endsWith(".gz")) {
                fis = new GZIPInputStream(fis);
            }
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(fis);
            while (reader.hasNext()) {
                reader.next();
                if (reader.getEventType() != 1 || !reader.getLocalName().equals("entry")) continue;
                boolean isInEntry = true;
                boolean retrievedAccession = false;
                while (isInEntry && reader.hasNext()) {
                    reader.next();
                    if (reader.getEventType() == 1) {
                        String otherName;
                        String localName = reader.getLocalName();
                        if (localName.equals("accession") && !retrievedAccession) {
                            accession = reader.getElementText();
                            accession = accession.split(",", 2)[0];
                            retrievedAccession = true;
                            if (!accession.equals("P04578")) continue;
                            System.out.println("Found accession P04578");
                            continue;
                        }
                        if (localName.equals("recommendedName")) {
                            boolean isInRecommendedName = true;
                            while (isInRecommendedName && reader.hasNext()) {
                                reader.next();
                                if (reader.getEventType() == 2 && reader.getLocalName().equals("recommendedName")) {
                                    isInRecommendedName = false;
                                    continue;
                                }
                                if (reader.getEventType() != 1 || !reader.getLocalName().contains("Name")) continue;
                                otherName = reader.getElementText();
                                otherNames.add((CallSite)((Object)(otherName + "\t-1")));
                            }
                            continue;
                        }
                        if (localName.equals("alternativeName")) {
                            boolean isInAlternativeName = true;
                            while (isInAlternativeName && reader.hasNext()) {
                                reader.next();
                                if (reader.getEventType() == 2 && reader.getLocalName().equals("alternativeName")) {
                                    isInAlternativeName = false;
                                    continue;
                                }
                                if (reader.getEventType() != 1 || !reader.getLocalName().contains("Name")) continue;
                                otherName = reader.getElementText();
                                otherNames.add((CallSite)((Object)(otherName + "\t2")));
                            }
                            continue;
                        }
                        if (!localName.equals("gene")) continue;
                        boolean isInGene = true;
                        while (isInGene && reader.hasNext()) {
                            String type;
                            reader.next();
                            if (reader.getEventType() == 2 && reader.getLocalName().equals("gene")) {
                                isInGene = false;
                            }
                            if (reader.getEventType() != 1 || !reader.getLocalName().equals("name") || !(type = reader.getAttributeValue(null, "type")).equals("primary")) continue;
                            String otherName2 = reader.getElementText();
                            otherNames.add((CallSite)((Object)(otherName2 + "\t0")));
                            isInGene = false;
                            isInEntry = false;
                            dictContent.put(accession, new ArrayList(otherNames));
                            accession = "";
                            otherNames.clear();
                        }
                        continue;
                    }
                    if (reader.getEventType() != 2 || !reader.getLocalName().equals("entry") || accession.isBlank()) continue;
                }
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeEntries(File outputFile) {
        try (FileWriter writer = new FileWriter(outputFile);){
            for (String name : dictContent.keySet()) {
                if (name.equals("P04578")) {
                    System.out.println("Got key P04578 and writing its names to file");
                }
                for (String otherName : dictContent.get(name)) {
                    writer.write(otherName + "\t" + name + "\n");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

