/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.resources;

import de.julielab.java.utilities.FileUtilities;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Synonym2IdsDictionaryGenerator {
    private static final Logger log = LoggerFactory.getLogger(Synonym2IdsDictionaryGenerator.class);

    public static void main(String[] args) throws Exception {
        String synsWithIdDictPath = args[0];
        String geneInfo = args[1];
        String outputPath = args[2];
        Map<String, String> id2taxMap = Synonym2IdsDictionaryGenerator.readEgTaxMap(Path.of(geneInfo, new String[0]));
        Synonym2IdsDictionaryGenerator.writeDictionary(synsWithIdDictPath, id2taxMap, outputPath);
    }

    private static Map<String, String> readEgTaxMap(Path geneInfo) throws IOException {
        Map<String, String> id2tax;
        log.info("Reading file gene ID to taxonomy ID map from {}", (Object)geneInfo);
        try (BufferedReader br = FileUtilities.getReaderFromFile((File)geneInfo.toFile());){
            id2tax = br.lines().collect(Collectors.toMap(l -> l.split("\\t", 3)[1].intern(), l -> l.split("\\t", 3)[0].intern()));
        }
        return id2tax;
    }

    private static void writeDictionary(String synsWithIdDictPath, Map<String, String> id2taxMapPath, String outputPath) throws IOException {
        String lastSyn = null;
        try (BufferedReader br = FileUtilities.getReaderFromFile((File)new File(synsWithIdDictPath));
             BufferedWriter bw = FileUtilities.getWriterToFile((File)new File(outputPath));){
            String line;
            ArrayList<String[]> synIdAccumulator = new ArrayList<String[]>();
            while ((line = br.readLine()) != null) {
                String[] split = line.split("\\t");
                String synonym = split[0];
                String id = split[1];
                String priority = split[2];
                String taxId = id2taxMapPath.get(id);
                if (taxId == null) {
                    log.warn("Could not retrieve the taxonomy ID for gene ID {} for synonym '{}'. Skipping this entry.", (Object)id, (Object)synonym);
                    continue;
                }
                if (lastSyn != null && !lastSyn.equals(synonym)) {
                    Synonym2IdsDictionaryGenerator.writeAccumulator(bw, synIdAccumulator, lastSyn);
                    synIdAccumulator.clear();
                }
                synIdAccumulator.add(new String[]{id, taxId, priority});
                lastSyn = synonym;
            }
            Synonym2IdsDictionaryGenerator.writeAccumulator(bw, synIdAccumulator, lastSyn);
        }
    }

    private static void writeAccumulator(BufferedWriter bw, List<String[]> synIdAccumulator, String synonym) throws IOException {
        if (!synIdAccumulator.isEmpty()) {
            synIdAccumulator.sort(Comparator.comparingInt(a -> Integer.parseInt(a[2])));
            String output = synonym + "\t" + synIdAccumulator.stream().map(a -> String.join((CharSequence)":", a)).collect(Collectors.joining("|"));
            bw.write(output);
            bw.newLine();
        }
    }
}

