/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.resources;

import com.google.common.collect.Sets;
import de.julielab.genemapper.resources.ncbigene.GeneXMLUtils;
import de.julielab.genemapper.resources.util.UncheckedGeneMapperResourcesException;
import de.julielab.java.utilities.CLIInteractionUtilities;
import de.julielab.java.utilities.FileUtilities;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneXMLFromASN1Extractor {
    private static final Logger log = LoggerFactory.getLogger(GeneXMLFromASN1Extractor.class);

    public static void main(String[] args) throws Exception {
        boolean dbFileIsNewer;
        if (args.length != 4) {
            System.err.println("Usage: " + GeneXMLFromASN1Extractor.class.getSimpleName() + " <taxonomy ids file> <extracted information storage directory> <gzipped ASN1 file, e.g. All_Data.ags.gz> <path to gene2xml executable>");
            System.exit(0);
        }
        File taxIdFile = new File(args[0]);
        File storageDirectory = new File(args[1]);
        File asnFile = new File(args[2]);
        File gene2xml = new File(args[3]);
        log.info("Taxonomy ID file: {}", (Object)taxIdFile);
        log.info("Storage directory for created resource files: {}", (Object)storageDirectory);
        log.info("ASN.1 file to extract data from: {}", (Object)asnFile);
        log.info("gene2xml executable path: {}", (Object)gene2xml);
        if (!gene2xml.exists()) {
            throw new IllegalArgumentException("The gene2xml executable path " + gene2xml.getAbsolutePath() + " does not exist.");
        }
        if (!gene2xml.canExecute()) {
            throw new IllegalStateException("The gene2xml executable at " + gene2xml.getAbsolutePath() + " is not allowed to be executed by the current user. Set executable rights (the 'x' flag un *nix systems) and try again.");
        }
        List<File> geneXmlDownloaderFiles = GeneXMLUtils.getMetaFiles(storageDirectory);
        File downloadedTaxIdsFile = geneXmlDownloaderFiles.get(2);
        boolean bl = dbFileIsNewer = !asnFile.exists() || !downloadedTaxIdsFile.exists() || downloadedTaxIdsFile.lastModified() < asnFile.lastModified();
        if (dbFileIsNewer && downloadedTaxIdsFile.exists()) {
            if (!CLIInteractionUtilities.readYesNoFromStdInWithMessage((String)("The ASN.1 file at " + asnFile.getAbsolutePath() + " is newer than the meta cache files at " + storageDirectory.getAbsolutePath() + ". By continuing, the old cache will completely deleted and built from scratch for the taxonomy IDs given by " + taxIdFile.getAbsolutePath() + ". Do you wish to proceed?"), (boolean)true)) {
                log.info("Aborting due to user wish.");
                System.exit(2);
            }
            FileUtils.deleteDirectory((File)storageDirectory);
        }
        if (!storageDirectory.exists()) {
            log.info("Creating directory {}", (Object)storageDirectory);
            storageDirectory.mkdirs();
        }
        Set<String> missingTaxIds = GeneXMLUtils.determineMissingTaxIds(taxIdFile, storageDirectory, asnFile, downloadedTaxIdsFile);
        if (dbFileIsNewer || !missingTaxIds.isEmpty()) {
            if (!missingTaxIds.isEmpty()) {
                log.info("There are missing taxonomy IDs for which gene meta information needs to be extracted.");
            }
            if (dbFileIsNewer) {
                log.info("The {} file has been updated and is newer than the existing gene meta information. The old gene meta information cache has been deleted and is now built again.", (Object)asnFile);
            }
            log.info("Extracting gene meta information from {}. This will take a few hours.", (Object)asnFile);
            GeneXMLFromASN1Extractor.extractGeneInfoFromASN1(asnFile, geneXmlDownloaderFiles, taxIdFile, gene2xml);
            log.info("Finished gene meta information extraction.");
        } else {
            log.info("Gene meta information for all given taxonomy IDs has already been extracted. Nothing to do, exiting.");
        }
    }

    private static void extractGeneInfoFromASN1(File inputFile, List<File> geneXmlDownloaderFiles, File requestedTaxIdsFile, File gene2xml) throws IOException, XMLStreamException {
        Process proc = Runtime.getRuntime().exec(gene2xml.getAbsolutePath() + " -i " + inputFile + " -c -b");
        try (InputStream is = proc.getInputStream();
             BufferedOutputStream osSummaries = FileUtilities.getOutputStreamToFile((File)geneXmlDownloaderFiles.get(0));
             BufferedOutputStream osProtnames = FileUtilities.getOutputStreamToFile((File)geneXmlDownloaderFiles.get(1));
             BufferedOutputStream osRefSeqStatus = FileUtilities.getOutputStreamToFile((File)geneXmlDownloaderFiles.get(3));
             BufferedOutputStream osECNumbers = FileUtilities.getOutputStreamToFile((File)geneXmlDownloaderFiles.get(4));){
            GeneXMLUtils.extractAndWriteGeneInfoToFile(osSummaries, osProtnames, osRefSeqStatus, osECNumbers, is);
            File alreadyExtractedTaxIdList = geneXmlDownloaderFiles.get(2);
            Set alreadyExtractedTaxIds = alreadyExtractedTaxIdList.exists() ? FileUtilities.getReaderFromFile((File)alreadyExtractedTaxIdList).lines().filter(line -> line.trim().length() != 0).collect(Collectors.toSet()) : Collections.emptySet();
            Set requestedTaxIds = FileUtils.readLines((File)requestedTaxIdsFile, (String)"UTF-8").stream().filter(line -> line.trim().length() != 0).collect(Collectors.toSet());
            try (BufferedWriter bw = FileUtilities.getWriterToFile((File)alreadyExtractedTaxIdList);){
                Sets.union(alreadyExtractedTaxIds, requestedTaxIds).stream().forEach(t -> {
                    try {
                        bw.write((String)t);
                        bw.newLine();
                    }
                    catch (IOException e) {
                        throw new UncheckedGeneMapperResourcesException(e);
                    }
                });
            }
        }
    }
}

