/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.resources;

import de.julielab.geneexpbase.TermNormalizer;
import de.julielab.genemapper.resources.util.UncheckedGeneMapperResourcesException;
import de.julielab.java.utilities.FileUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextItemIndexGenerator {
    private static final Logger log = LoggerFactory.getLogger(ContextItemIndexGenerator.class);
    private final Directory indexDirectory;
    private final boolean normalizeContexts;
    private final String resourcesDir;

    public ContextItemIndexGenerator(File indexFile, String resourcesDir, boolean normalizeContexts) {
        this.resourcesDir = resourcesDir;
        this.indexDirectory = this.createIndexDirectory(indexFile);
        this.normalizeContexts = normalizeContexts;
    }

    public static void main(String[] args) {
        File egFile;
        File upFile;
        Object resPath;
        File resDir;
        boolean normalizeContexts;
        Object indexBaseDir;
        long s1 = System.currentTimeMillis();
        if (args.length != 3) {
            System.err.println("Usage: SynonymDisambiguationIndexGenerator <resourcesDirectory> <geneContextIndicesDirectory> <normalize contexts>");
            System.exit(-1);
        }
        if (!((String)(indexBaseDir = args[1])).endsWith(File.separator)) {
            indexBaseDir = (String)indexBaseDir + File.separator;
        }
        String nameSuffix = (normalizeContexts = Boolean.parseBoolean(args[2])) ? "Normalized" : "Original";
        File geneIndexDir = new File((String)indexBaseDir + "geneContextItemsIndex" + nameSuffix);
        File proteinIndexDir = new File((String)indexBaseDir + "proteinContextItemsIndex" + nameSuffix);
        if (geneIndexDir.exists()) {
            FileUtils.deleteQuietly((File)geneIndexDir);
        }
        if (proteinIndexDir.exists()) {
            FileUtils.deleteQuietly((File)proteinIndexDir);
        }
        if (!(resDir = new File((String)(resPath = args[0]))).isDirectory()) {
            System.err.println("Could not find resources directory");
            System.exit(-1);
        }
        if (!((String)resPath).endsWith(File.separator)) {
            resPath = (String)resPath + File.separator;
        }
        if (!(upFile = new File((String)resPath + "up.ids")).isFile()) {
            System.err.println("Could not find file uniprot.ids");
            System.exit(-1);
        }
        if (!(egFile = new File((String)resPath + "eg.ids")).isFile()) {
            System.err.println("Could not find file eg.ids");
            System.exit(-1);
        }
        try {
            ContextItemIndexGenerator indexGenerator = new ContextItemIndexGenerator(proteinIndexDir, (String)resPath, normalizeContexts);
            indexGenerator.createIndex("protein");
            indexGenerator = new ContextItemIndexGenerator(geneIndexDir, (String)resPath, normalizeContexts);
            indexGenerator.createIndex("gene");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        long s2 = System.currentTimeMillis();
        System.out.println("Indices created successfully! (" + (s2 - s1) / 1000L + " sec)");
    }

    public void createIndex(String idType) throws IOException {
        String typePrefix = idType.equals("gene") ? "eg" : "up";
        String upSrcTypePrefix = idType.equals("gene") ? "entrezgene_id" : "uniprot_id";
        File geneRifFile = Path.of(this.resourcesDir, typePrefix + "2generif").toFile();
        File interactionFile = Path.of(this.resourcesDir, typePrefix + "2interaction").toFile();
        File summaryFile = Path.of(this.resourcesDir, typePrefix + "2summary").toFile();
        File designationsFile = Path.of(this.resourcesDir, typePrefix + "2designation").toFile();
        File activityRegulationFile = Path.of(this.resourcesDir, upSrcTypePrefix + "2activity regulation").toFile();
        File chromosomeFile = Path.of(this.resourcesDir, upSrcTypePrefix + "2chromosome").toFile();
        File developmentalStageFile = Path.of(this.resourcesDir, upSrcTypePrefix + "2developmental stage").toFile();
        File diseaseFile = Path.of(this.resourcesDir, upSrcTypePrefix + "2disease").toFile();
        File domainFile = Path.of(this.resourcesDir, upSrcTypePrefix + "2domain").toFile();
        File functionFile = Path.of(this.resourcesDir, upSrcTypePrefix + "2function").toFile();
        File inductionFile = Path.of(this.resourcesDir, upSrcTypePrefix + "2induction").toFile();
        File keywordFile = Path.of(this.resourcesDir, upSrcTypePrefix + "2keyword").toFile();
        File miscellaneousFile = Path.of(this.resourcesDir, upSrcTypePrefix + "2miscellaneous").toFile();
        File pathwayFile = Path.of(this.resourcesDir, upSrcTypePrefix + "2pathway").toFile();
        File similarityFile = Path.of(this.resourcesDir, upSrcTypePrefix + "2similarity").toFile();
        File subcellularLocationFile = Path.of(this.resourcesDir, upSrcTypePrefix + "2subcellular location").toFile();
        File subunitFile = Path.of(this.resourcesDir, upSrcTypePrefix + "2subunit").toFile();
        File tissueFile = Path.of(this.resourcesDir, upSrcTypePrefix + "2tissue").toFile();
        File tissueSpecificityFile = Path.of(this.resourcesDir, upSrcTypePrefix + "2tissue specificity").toFile();
        TermNormalizer normalizer = new TermNormalizer();
        Function<String, String> contextTransformation = this.normalizeContexts ? context -> normalizer.normalize(context) : Function.identity();
        IndexWriterConfig iwc = new IndexWriterConfig((Analyzer)new WhitespaceAnalyzer());
        iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        AtomicInteger counter = new AtomicInteger();
        IndexWriter contextIndexWriter = new IndexWriter(this.indexDirectory, iwc);
        log.info("Writing index {}", (Object)this.indexDirectory);
        this.indexContextFile(activityRegulationFile, "activity_regulation", contextTransformation, counter, contextIndexWriter);
        this.indexContextFile(chromosomeFile, "chromosome", contextTransformation, counter, contextIndexWriter);
        this.indexContextFile(developmentalStageFile, "developmental_stage", contextTransformation, counter, contextIndexWriter);
        this.indexContextFile(designationsFile, "designation", contextTransformation, counter, contextIndexWriter);
        this.indexContextFile(diseaseFile, "disease", contextTransformation, counter, contextIndexWriter);
        this.indexContextFile(domainFile, "domain", contextTransformation, counter, contextIndexWriter);
        this.indexContextFile(functionFile, "function", contextTransformation, counter, contextIndexWriter);
        this.indexContextFile(geneRifFile, "generif", contextTransformation, counter, contextIndexWriter);
        this.indexContextFile(inductionFile, "induction", contextTransformation, counter, contextIndexWriter);
        this.indexContextFile(interactionFile, "interaction", contextTransformation, counter, contextIndexWriter);
        this.indexContextFile(keywordFile, "keyword", contextTransformation, counter, contextIndexWriter);
        this.indexContextFile(miscellaneousFile, "miscellaneous", contextTransformation, counter, contextIndexWriter);
        this.indexContextFile(pathwayFile, "pathway", contextTransformation, counter, contextIndexWriter);
        this.indexContextFile(similarityFile, "similarity", contextTransformation, counter, contextIndexWriter);
        this.indexContextFile(subcellularLocationFile, "subcellular_location", contextTransformation, counter, contextIndexWriter);
        this.indexContextFile(subunitFile, "subunit", contextTransformation, counter, contextIndexWriter);
        this.indexContextFile(summaryFile, "summary", contextTransformation, counter, contextIndexWriter);
        this.indexContextFile(tissueFile, "tissue", contextTransformation, counter, contextIndexWriter);
        this.indexContextFile(tissueSpecificityFile, "_tissue_specificity", contextTransformation, counter, contextIndexWriter);
        contextIndexWriter.forceMerge(4);
        log.info("Done writing context item index for {} ids.", (Object)counter);
    }

    private void indexContextFile(File contextFile, String contextType, Function<String, String> contextTransformation, AtomicInteger counter, IndexWriter contextIndexWriter) throws IOException {
        try (BufferedReader br = new BufferedReader(FileUtilities.getReaderFromFile((File)contextFile));){
            ((Stream)br.lines().parallel()).forEach(line -> {
                Document d = null;
                try {
                    String[] split = line.split("\t");
                    if (split.length != 2) {
                        log.error("Wrong format in file {}. Expected two columns but got {}. Critical line: {}", new Object[]{contextFile, split.length, line});
                    }
                    String id = split[0];
                    String contextItem = split[1];
                    StringField lookupIdField = new StringField("indexed_id", id, Field.Store.YES);
                    TextField lookupContextField = new TextField("contextitem", (String)contextTransformation.apply(contextItem), Field.Store.YES);
                    StringField contextTypeField = new StringField("itemtype", contextType, Field.Store.NO);
                    d = new Document();
                    d.add((IndexableField)lookupIdField);
                    d.add((IndexableField)lookupContextField);
                    d.add((IndexableField)contextTypeField);
                    contextIndexWriter.addDocument((Iterable)d);
                    counter.incrementAndGet();
                }
                catch (IOException e) {
                    log.error("Could not index document {}", d);
                    throw new UncheckedGeneMapperResourcesException(e);
                }
            });
        }
    }

    private FSDirectory createIndexDirectory(File indexFile) {
        FSDirectory fdir;
        try {
            boolean isWindows = System.getProperty("os.name").toLowerCase().contains("win");
            fdir = FSDirectory.open((Path)indexFile.toPath());
        }
        catch (IOException e) {
            log.error("Could not create index directory {}", (Object)indexFile, (Object)e);
            throw new UncheckedGeneMapperResourcesException(e);
        }
        return fdir;
    }
}

