/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.resources;

import de.julielab.genemapper.index.ContextGenerator;
import de.julielab.genemapper.utils.ContextUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class ContextIndexGenerator {
    private final File biothesaurusFile;
    private final String resourcesDir;
    Directory indexDirectory;
    private static final boolean debug = false;
    private static final boolean useContextTypes = false;

    public static void main(String[] args) {
        File egFile;
        File upFile;
        Object indexPath;
        long s1 = System.currentTimeMillis();
        if (args.length != 2) {
            System.err.println("Usage: ContextIndexGenerator <resourcesDirectory> <geneContextIndicesDirectory>");
            System.exit(-1);
        }
        if (!((String)(indexPath = args[1])).endsWith("/")) {
            indexPath = (String)indexPath + "/";
        }
        File geneIndexDir = new File((String)indexPath + "geneContextIndex");
        File proteinIndexDir = new File((String)indexPath + "proteinContextIndex");
        Object resPath = args[0];
        File resDir = new File((String)resPath);
        if (!resDir.isDirectory()) {
            System.err.println("Could not find resources directory");
            System.exit(-1);
        }
        if (!((String)resPath).endsWith("/")) {
            resPath = (String)resPath + "/";
        }
        if (!(upFile = new File((String)resPath + "up.ids")).isFile()) {
            System.err.println("Could not find file uniprot.ids");
            System.exit(-1);
        }
        if (!(egFile = new File((String)resPath + "eg.ids")).isFile()) {
            System.err.println("Could not find file eg.ids");
            System.exit(-1);
        }
        try {
            ContextIndexGenerator indexGenerator = new ContextIndexGenerator(upFile, proteinIndexDir, (String)resPath);
            indexGenerator.createIndex("protein");
            indexGenerator = new ContextIndexGenerator(egFile, geneIndexDir, (String)resPath);
            indexGenerator.createIndex("gene");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        long s2 = System.currentTimeMillis();
        System.out.println("Indices created successfully! (" + (s2 - s1) / 1000L + " sec)");
    }

    public ContextIndexGenerator(File biothesaurusFile, File indexFile, String resourcesDir) throws IOException {
        this.biothesaurusFile = biothesaurusFile;
        this.resourcesDir = resourcesDir;
        this.indexDirectory = this.createIndexDirectory(indexFile);
    }

    public void createIndex(String idType) throws IOException {
        ContextGenerator cg = new ContextGenerator(this.resourcesDir, idType);
        WhitespaceAnalyzer wsAnalyzer = new WhitespaceAnalyzer();
        IndexWriterConfig iwc = new IndexWriterConfig((Analyzer)wsAnalyzer);
        iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        IndexWriter contextIndexWriter = new IndexWriter(this.indexDirectory, iwc);
        int counter = 0;
        BufferedReader biothesaurusReader = new BufferedReader(new FileReader(this.biothesaurusFile));
        System.out.println("Generating index now. This may take quite a while (up to several hours when file is large) ...");
        try {
            String line = "";
            while ((line = biothesaurusReader.readLine()) != null) {
                String[] values = line.split("\t");
                if (values.length != 1) {
                    System.err.println("ERR: Input file not in expected format. \ncritical line: " + line);
                    System.exit(-1);
                }
                String id_org = values[0];
                this.showDebug(id_org);
                String context = cg.getContext(id_org);
                context = ContextUtils.makeContextTokenString((String)context);
                TextField lookupContextField = new TextField("indexed_context", context, Field.Store.YES);
                StringField lookupIdField = new StringField("indexed_id", id_org, Field.Store.YES);
                Document d = new Document();
                d.add((IndexableField)lookupContextField);
                d.add((IndexableField)lookupIdField);
                contextIndexWriter.addDocument((Iterable)d);
                if (++counter % 10000 != 0) continue;
                System.err.println("# entries processed: " + counter);
            }
            contextIndexWriter.close();
            biothesaurusReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private FSDirectory createIndexDirectory(File indexFile) {
        FSDirectory fdir = null;
        try {
            fdir = FSDirectory.open((Path)indexFile.toPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fdir;
    }

    private void showDebug(String s) {
    }
}

