#!/usr/bin/perl

use strict;
use warnings;

BEGIN 
{
    unshift @INC, '../../perl';
}

use JSON::JSON;
use URI::Escape;

my $json = '{"a":[0,1,2],"c":{"d":5,"e":"a"}}';
my $uri_encoded_json = '{%22a%22:[0,1,2],%22c%22:{%22d%22:5,%22e%22:%22a%22}}';

my $obj = JSON::from_json ('{"a":[0,1,2],"c":{"d":5,"e":"a"}}');

unless ($obj->{a}->[0] == 0) { die $!; }
unless ($obj->{a}->[1] == 1) { die $!; }
unless ($obj->{a}->[2] == 2) { die $!; }

unless ($obj->{c}->{d} == 5) { die $!; }
unless ($obj->{c}->{e} eq 'a') { die $!; }

my $uri_decoded_json = uri_unescape ($uri_encoded_json);
unless ($uri_decoded_json eq $json) { die $!; }
my $uri_encoded_json_0 = uri_escape ($uri_decoded_json);
unless ($uri_encoded_json eq $uri_encoded_json) { die $!; }
