/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.sequence;

import java.util.concurrent.atomic.AtomicInteger;

class IntCyclicRangeCounter {
    private final AtomicInteger counter;
    private final int min;
    private final int max;

    IntCyclicRangeCounter(int min2, int max) {
        this.min = min2;
        this.max = max;
        if (min2 >= max) {
            throw new IllegalArgumentException("min >= maxValue");
        }
        if (min2 < 0) {
            throw new IllegalArgumentException("min < 0");
        }
        this.counter = new AtomicInteger(min2);
    }

    int getAndIncrement() {
        int next;
        int current;
        while (!this.counter.compareAndSet(current, next = (current = this.counter.get()) == this.max ? this.min : current + 1)) {
        }
        return current;
    }
}

