/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.visitors;

import org.htmlparser.Node;
import org.htmlparser.Parser;
import org.htmlparser.Tag;
import org.htmlparser.tags.BodyTag;
import org.htmlparser.tags.TableTag;
import org.htmlparser.tags.TitleTag;
import org.htmlparser.util.NodeList;
import org.htmlparser.visitors.NodeVisitor;

public class HtmlPage
extends NodeVisitor {
    private String title = "";
    private NodeList nodesInBody = new NodeList();
    private NodeList tables = new NodeList();

    public HtmlPage(Parser parser2) {
        super(true);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void visitTag(Tag tag) {
        if (this.isTable(tag)) {
            this.tables.add(tag);
        } else if (this.isBodyTag(tag)) {
            this.nodesInBody = tag.getChildren();
        } else if (this.isTitleTag(tag)) {
            this.title = ((TitleTag)tag).getTitle();
        }
    }

    private boolean isTable(Tag tag) {
        return tag instanceof TableTag;
    }

    private boolean isBodyTag(Tag tag) {
        return tag instanceof BodyTag;
    }

    private boolean isTitleTag(Tag tag) {
        return tag instanceof TitleTag;
    }

    public NodeList getBody() {
        return this.nodesInBody;
    }

    public TableTag[] getTables() {
        Node[] tableArr = new TableTag[this.tables.size()];
        this.tables.copyToNodeArray(tableArr);
        return tableArr;
    }
}

