/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.util.sort;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.htmlparser.util.sort.Ordered;
import org.htmlparser.util.sort.Sortable;

public class Sort {
    private Sort() {
    }

    public static void QuickSort(Vector v) throws ClassCastException {
        Sort.QuickSort(v, 0, v.size() - 1);
    }

    public static void QuickSort(Vector v, int lo0, int hi0) throws ClassCastException {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            Ordered mid = (Ordered)v.elementAt((lo0 + hi0) / 2);
            while (lo <= hi) {
                while (lo < hi0 && 0 > ((Ordered)v.elementAt(lo)).compare(mid)) {
                    ++lo;
                }
                while (hi > lo0 && 0 < ((Ordered)v.elementAt(hi)).compare(mid)) {
                    --hi;
                }
                if (lo > hi) continue;
                Sort.swap(v, lo++, hi--);
            }
            if (lo0 < hi) {
                Sort.QuickSort(v, lo0, hi);
            }
            if (lo < hi0) {
                Sort.QuickSort(v, lo, hi0);
            }
        }
    }

    private static void swap(Vector v, int i, int j) {
        Object o = v.elementAt(i);
        v.setElementAt(v.elementAt(j), i);
        v.setElementAt(o, j);
    }

    public static void QuickSort(Ordered[] a) {
        Sort.QuickSort(a, 0, a.length - 1);
    }

    public static void QuickSort(Ordered[] a, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            Ordered mid = a[(lo0 + hi0) / 2];
            while (lo <= hi) {
                while (lo < hi0 && 0 > a[lo].compare(mid)) {
                    ++lo;
                }
                while (hi > lo0 && 0 < a[hi].compare(mid)) {
                    --hi;
                }
                if (lo > hi) continue;
                Sort.swap(a, lo++, hi--);
            }
            if (lo0 < hi) {
                Sort.QuickSort(a, lo0, hi);
            }
            if (lo < hi0) {
                Sort.QuickSort(a, lo, hi0);
            }
        }
    }

    private static void swap(Object[] a, int i, int j) {
        Object o = a[i];
        a[i] = a[j];
        a[j] = o;
    }

    public static void QuickSort(String[] a) {
        Sort.QuickSort(a, 0, a.length - 1);
    }

    public static void QuickSort(String[] a, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            String mid = a[(lo0 + hi0) / 2];
            while (lo <= hi) {
                while (lo < hi0 && 0 > a[lo].compareTo(mid)) {
                    ++lo;
                }
                while (hi > lo0 && 0 < a[hi].compareTo(mid)) {
                    --hi;
                }
                if (lo > hi) continue;
                Sort.swap(a, lo++, hi--);
            }
            if (lo0 < hi) {
                Sort.QuickSort(a, lo0, hi);
            }
            if (lo < hi0) {
                Sort.QuickSort(a, lo, hi0);
            }
        }
    }

    public static void QuickSort(Sortable sortable, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            Ordered mid = sortable.fetch((lo0 + hi0) / 2, null);
            Ordered test = null;
            while (lo <= hi) {
                while (lo < hi0 && 0 > (test = sortable.fetch(lo, test)).compare(mid)) {
                    ++lo;
                }
                while (hi > lo0 && 0 < (test = sortable.fetch(hi, test)).compare(mid)) {
                    --hi;
                }
                if (lo > hi) continue;
                sortable.swap(lo++, hi--);
            }
            if (lo0 < hi) {
                Sort.QuickSort(sortable, lo0, hi);
            }
            if (lo < hi0) {
                Sort.QuickSort(sortable, lo, hi0);
            }
        }
    }

    public static void QuickSort(Sortable sortable) {
        Sort.QuickSort(sortable, sortable.first(), sortable.last());
    }

    public static Object[] QuickSort(Hashtable h2) throws ClassCastException {
        Object[] ret = new Ordered[h2.size()];
        Enumeration e = h2.keys();
        boolean are_strings = true;
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = e.nextElement();
            if (!are_strings || ret[i] instanceof String) continue;
            are_strings = false;
        }
        if (are_strings) {
            Sort.QuickSort((String[])ret);
        } else {
            Sort.QuickSort((Ordered[])ret);
        }
        return ret;
    }

    public static int bsearch(Sortable set, Ordered ref, int lo, int hi) {
        int ret = -1;
        int num = hi - lo + 1;
        Ordered ordered = null;
        while (-1 == ret && lo <= hi) {
            int half = num / 2;
            int mid = lo + (0 != (num & 1) ? half : half - 1);
            ordered = set.fetch(mid, ordered);
            int result = ref.compare(ordered);
            if (0 == result) {
                ret = mid;
                continue;
            }
            if (0 > result) {
                hi = mid - 1;
                num = 0 != (num & 1) ? half : half - 1;
                continue;
            }
            lo = mid + 1;
            num = half;
        }
        if (-1 == ret) {
            ret = lo;
        }
        return ret;
    }

    public static int bsearch(Sortable set, Ordered ref) {
        return Sort.bsearch(set, ref, set.first(), set.last());
    }

    public static int bsearch(Vector vector, Ordered ref, int lo, int hi) {
        int ret = -1;
        int num = hi - lo + 1;
        while (-1 == ret && lo <= hi) {
            int half = num / 2;
            int mid = lo + (0 != (num & 1) ? half : half - 1);
            int result = ref.compare(vector.elementAt(mid));
            if (0 == result) {
                ret = mid;
                continue;
            }
            if (0 > result) {
                hi = mid - 1;
                num = 0 != (num & 1) ? half : half - 1;
                continue;
            }
            lo = mid + 1;
            num = half;
        }
        if (-1 == ret) {
            ret = lo;
        }
        return ret;
    }

    public static int bsearch(Vector vector, Ordered ref) {
        return Sort.bsearch(vector, ref, 0, vector.size() - 1);
    }

    public static int bsearch(Ordered[] array, Ordered ref, int lo, int hi) {
        int ret = -1;
        int num = hi - lo + 1;
        while (-1 == ret && lo <= hi) {
            int half = num / 2;
            int mid = lo + (0 != (num & 1) ? half : half - 1);
            int result = ref.compare(array[mid]);
            if (0 == result) {
                ret = mid;
                continue;
            }
            if (0 > result) {
                hi = mid - 1;
                num = 0 != (num & 1) ? half : half - 1;
                continue;
            }
            lo = mid + 1;
            num = half;
        }
        if (-1 == ret) {
            ret = lo;
        }
        return ret;
    }

    public static int bsearch(Ordered[] array, Ordered ref) {
        return Sort.bsearch(array, ref, 0, array.length - 1);
    }
}

