/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.scanners;

import java.util.Vector;
import org.htmlparser.Attribute;
import org.htmlparser.Node;
import org.htmlparser.Tag;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.Page;
import org.htmlparser.scanners.Scanner;
import org.htmlparser.scanners.TagScanner;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;

public class CompositeTagScanner
extends TagScanner {
    private static final boolean mUseJVMStack = false;
    private static final boolean mLeaveEnds = false;

    public Tag scan(Tag tag, Lexer lexer2, NodeList stack) throws ParserException {
        Tag ret = tag;
        if (ret.isEmptyXmlTag()) {
            ret.setEndTag(ret);
        } else {
            Node node;
            do {
                int depth;
                Scanner scanner;
                if (null != (node = lexer2.nextNode(false))) {
                    if (node instanceof Tag) {
                        Tag next = (Tag)node;
                        String name = next.getTagName();
                        if (next.isEndTag() && name.equals(ret.getTagName())) {
                            ret.setEndTag(next);
                            node = null;
                        } else if (this.isTagToBeEndedFor(ret, next)) {
                            lexer2.setPosition(next.getStartPosition());
                            node = null;
                        } else if (!next.isEndTag()) {
                            scanner = next.getThisScanner();
                            if (null != scanner) {
                                if (scanner == this) {
                                    if (next.isEmptyXmlTag()) {
                                        next.setEndTag(next);
                                        this.finishTag(next, lexer2);
                                        this.addChild(ret, next);
                                    } else {
                                        stack.add(ret);
                                        ret = next;
                                    }
                                } else {
                                    node = scanner.scan(next, lexer2, stack);
                                    this.addChild(ret, node);
                                }
                            } else {
                                this.addChild(ret, next);
                            }
                        } else {
                            Vector<Attribute> attributes = new Vector<Attribute>();
                            attributes.addElement(new Attribute(name, null));
                            Tag opener = lexer2.getNodeFactory().createTagNode(lexer2.getPage(), next.getStartPosition(), next.getEndPosition(), attributes);
                            scanner = opener.getThisScanner();
                            if (null != scanner && scanner == this) {
                                int i;
                                int index = -1;
                                for (i = stack.size() - 1; -1 == index && i >= 0; --i) {
                                    Tag boffo = (Tag)stack.elementAt(i);
                                    if (name.equals(boffo.getTagName())) {
                                        index = i;
                                        continue;
                                    }
                                    if (!this.isTagToBeEndedFor(boffo, next)) continue;
                                    index = i;
                                }
                                if (-1 != index) {
                                    this.finishTag(ret, lexer2);
                                    this.addChild((Tag)stack.elementAt(stack.size() - 1), ret);
                                    for (i = stack.size() - 1; i > index; --i) {
                                        Tag fred = (Tag)stack.remove(i);
                                        this.finishTag(fred, lexer2);
                                        this.addChild((Tag)stack.elementAt(i - 1), fred);
                                    }
                                    ret = (Tag)stack.remove(index);
                                    node = null;
                                } else {
                                    this.addChild(ret, next);
                                }
                            } else {
                                this.addChild(ret, next);
                            }
                        }
                    } else {
                        this.addChild(ret, node);
                        node.doSemanticAction();
                    }
                }
                if (null != node || 0 == (depth = stack.size())) continue;
                node = stack.elementAt(depth - 1);
                if (node instanceof Tag) {
                    Tag precursor = (Tag)node;
                    scanner = precursor.getThisScanner();
                    if (scanner == this) {
                        stack.remove(depth - 1);
                        this.finishTag(ret, lexer2);
                        this.addChild(precursor, ret);
                        ret = precursor;
                        continue;
                    }
                    node = null;
                    continue;
                }
                node = null;
            } while (null != node);
        }
        this.finishTag(ret, lexer2);
        return ret;
    }

    protected void addChild(Tag parent, Node child) {
        if (null == parent.getChildren()) {
            parent.setChildren(new NodeList());
        }
        child.setParent(parent);
        parent.getChildren().add(child);
    }

    protected void finishTag(Tag tag, Lexer lexer2) throws ParserException {
        if (null == tag.getEndTag()) {
            tag.setEndTag(this.createVirtualEndTag(tag, lexer2, lexer2.getPage(), lexer2.getCursor().getPosition()));
        }
        tag.getEndTag().setParent(tag);
        tag.doSemanticAction();
    }

    protected Tag createVirtualEndTag(Tag tag, Lexer lexer2, Page page, int position) throws ParserException {
        String name = "/" + tag.getRawTagName();
        Vector<Attribute> attributes = new Vector<Attribute>();
        attributes.addElement(new Attribute(name, null));
        Tag ret = lexer2.getNodeFactory().createTagNode(page, position, position, attributes);
        return ret;
    }

    public final boolean isTagToBeEndedFor(Tag current, Tag tag) {
        boolean ret = false;
        String name = tag.getTagName();
        String[] ends = tag.isEndTag() ? current.getEndTagEnders() : current.getEnders();
        for (int i = 0; i < ends.length; ++i) {
            if (!name.equalsIgnoreCase(ends[i])) continue;
            ret = true;
            break;
        }
        return ret;
    }
}

