/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.lexer;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.util.Vector;
import org.htmlparser.Node;
import org.htmlparser.NodeFactory;
import org.htmlparser.Remark;
import org.htmlparser.Tag;
import org.htmlparser.Text;
import org.htmlparser.http.ConnectionManager;
import org.htmlparser.lexer.Cursor;
import org.htmlparser.lexer.Page;
import org.htmlparser.lexer.PageAttribute;
import org.htmlparser.nodes.RemarkNode;
import org.htmlparser.nodes.TagNode;
import org.htmlparser.nodes.TextNode;
import org.htmlparser.util.ParserException;

public class Lexer
implements Serializable,
NodeFactory {
    public static final double VERSION_NUMBER = 1.6;
    public static final String VERSION_TYPE = "Release Build";
    public static final String VERSION_DATE = "Jun 10, 2006";
    public static final String VERSION_STRING = "1.6 (Release Build Jun 10, 2006)";
    public static boolean STRICT_REMARKS = true;
    protected Page mPage;
    protected Cursor mCursor;
    protected NodeFactory mFactory;
    protected static int mDebugLineTrigger = -1;

    public static String getVersion() {
        return VERSION_STRING;
    }

    public Lexer() {
        this(new Page(""));
    }

    public Lexer(Page page) {
        this.setPage(page);
        this.setCursor(new Cursor(page, 0));
        this.setNodeFactory(this);
    }

    public Lexer(String text) {
        this(new Page(text));
    }

    public Lexer(URLConnection connection) throws ParserException {
        this(new Page(connection));
    }

    public Page getPage() {
        return this.mPage;
    }

    public void setPage(Page page) {
        if (null == page) {
            throw new IllegalArgumentException("page cannot be null");
        }
        this.mPage = page;
    }

    public Cursor getCursor() {
        return this.mCursor;
    }

    public void setCursor(Cursor cursor) {
        if (null == cursor) {
            throw new IllegalArgumentException("cursor cannot be null");
        }
        this.mCursor = cursor;
    }

    public NodeFactory getNodeFactory() {
        return this.mFactory;
    }

    public void setNodeFactory(NodeFactory factory) {
        if (null == factory) {
            throw new IllegalArgumentException("node factory cannot be null");
        }
        this.mFactory = factory;
    }

    public int getPosition() {
        return this.getCursor().getPosition();
    }

    public void setPosition(int position) {
        this.getCursor().setPosition(position);
    }

    public int getCurrentLineNumber() {
        return this.getPage().row(this.getCursor());
    }

    public String getCurrentLine() {
        return this.getPage().getLine(this.getCursor());
    }

    public void reset() {
        this.getPage().reset();
        this.setCursor(new Cursor(this.getPage(), 0));
    }

    public Node nextNode() throws ParserException {
        return this.nextNode(false);
    }

    public Node nextNode(boolean quotesmart) throws ParserException {
        Node ret;
        Page page;
        int lineno;
        if (-1 != mDebugLineTrigger && mDebugLineTrigger < (lineno = (page = this.getPage()).row(this.mCursor))) {
            mDebugLineTrigger = lineno + 1;
        }
        int start = this.mCursor.getPosition();
        char ch = this.mPage.getCharacter(this.mCursor);
        switch (ch) {
            case '\uffff': {
                ret = null;
                break;
            }
            case '<': {
                ch = this.mPage.getCharacter(this.mCursor);
                if ('\uffff' == ch) {
                    ret = this.makeString(start, this.mCursor.getPosition());
                    break;
                }
                if ('%' == ch) {
                    this.mPage.ungetCharacter(this.mCursor);
                    ret = this.parseJsp(start);
                    break;
                }
                if ('?' == ch) {
                    this.mPage.ungetCharacter(this.mCursor);
                    ret = this.parsePI(start);
                    break;
                }
                if ('/' == ch || '%' == ch || Character.isLetter(ch)) {
                    this.mPage.ungetCharacter(this.mCursor);
                    ret = this.parseTag(start);
                    break;
                }
                if ('!' == ch) {
                    ch = this.mPage.getCharacter(this.mCursor);
                    if ('\uffff' == ch) {
                        ret = this.makeString(start, this.mCursor.getPosition());
                        break;
                    }
                    if ('>' == ch) {
                        ret = this.makeRemark(start, this.mCursor.getPosition());
                        break;
                    }
                    this.mPage.ungetCharacter(this.mCursor);
                    if ('-' == ch) {
                        ret = this.parseRemark(start, quotesmart);
                        break;
                    }
                    this.mPage.ungetCharacter(this.mCursor);
                    ret = this.parseTag(start);
                    break;
                }
                ret = this.parseString(start, quotesmart);
                break;
            }
            default: {
                this.mPage.ungetCharacter(this.mCursor);
                ret = this.parseString(start, quotesmart);
            }
        }
        return ret;
    }

    public Node parseCDATA() throws ParserException {
        return this.parseCDATA(false);
    }

    public Node parseCDATA(boolean quotesmart) throws ParserException {
        int start = this.mCursor.getPosition();
        int state = 0;
        boolean done = false;
        char quote = '\u0000';
        boolean comment = false;
        block20: while (!done) {
            char ch = this.mPage.getCharacter(this.mCursor);
            switch (state) {
                case 0: {
                    switch (ch) {
                        case '\uffff': {
                            done = true;
                            continue block20;
                        }
                        case '\'': {
                            if (!quotesmart || comment) continue block20;
                            if ('\u0000' == quote) {
                                quote = '\'';
                                continue block20;
                            }
                            if (39 != quote) continue block20;
                            quote = '\u0000';
                            continue block20;
                        }
                        case '\"': {
                            if (!quotesmart || comment) continue block20;
                            if ('\u0000' == quote) {
                                quote = '\"';
                                continue block20;
                            }
                            if (34 != quote) continue block20;
                            quote = '\u0000';
                            continue block20;
                        }
                        case '\\': {
                            if (!quotesmart || false == quote) continue block20;
                            ch = this.mPage.getCharacter(this.mCursor);
                            if ('\uffff' == ch) {
                                done = true;
                                continue block20;
                            }
                            if (ch == '\\' || ch == quote) continue block20;
                            this.mPage.ungetCharacter(this.mCursor);
                            continue block20;
                        }
                        case '/': {
                            if (!quotesmart || false != quote) continue block20;
                            ch = this.mPage.getCharacter(this.mCursor);
                            if ('\uffff' == ch) {
                                done = true;
                                continue block20;
                            }
                            if ('/' == ch) {
                                comment = true;
                                continue block20;
                            }
                            if ('*' == ch) {
                                while (true) {
                                    if ('\uffff' != (ch = this.mPage.getCharacter(this.mCursor)) && '*' != ch) {
                                        continue;
                                    }
                                    ch = this.mPage.getCharacter(this.mCursor);
                                    if (ch == '*') {
                                        this.mPage.ungetCharacter(this.mCursor);
                                    }
                                    if ('\uffff' == ch || '/' == ch) break;
                                }
                                continue block20;
                            }
                            this.mPage.ungetCharacter(this.mCursor);
                            continue block20;
                        }
                        case '\n': {
                            comment = false;
                            continue block20;
                        }
                        case '<': {
                            if (quotesmart) {
                                if (false != quote) continue block20;
                                state = 1;
                                continue block20;
                            }
                            state = 1;
                            continue block20;
                        }
                    }
                    continue block20;
                }
                case 1: {
                    switch (ch) {
                        case '\uffff': {
                            done = true;
                            continue block20;
                        }
                        case '/': {
                            state = 2;
                            continue block20;
                        }
                        case '!': {
                            ch = this.mPage.getCharacter(this.mCursor);
                            if ('\uffff' == ch) {
                                done = true;
                                continue block20;
                            }
                            if ('-' == ch) {
                                ch = this.mPage.getCharacter(this.mCursor);
                                if ('\uffff' == ch) {
                                    done = true;
                                    continue block20;
                                }
                                if ('-' == ch) {
                                    state = 3;
                                    continue block20;
                                }
                                state = 0;
                                continue block20;
                            }
                            state = 0;
                            continue block20;
                        }
                    }
                    state = 0;
                    continue block20;
                }
                case 2: {
                    comment = false;
                    if ('\uffff' == ch) {
                        done = true;
                        continue block20;
                    }
                    if (Character.isLetter(ch)) {
                        done = true;
                        this.mPage.ungetCharacter(this.mCursor);
                        this.mPage.ungetCharacter(this.mCursor);
                        this.mPage.ungetCharacter(this.mCursor);
                        continue block20;
                    }
                    state = 0;
                    continue block20;
                }
                case 3: {
                    comment = false;
                    if ('\uffff' == ch) {
                        done = true;
                        continue block20;
                    }
                    if ('-' != ch) continue block20;
                    ch = this.mPage.getCharacter(this.mCursor);
                    if ('\uffff' == ch) {
                        done = true;
                        continue block20;
                    }
                    if ('-' == ch) {
                        ch = this.mPage.getCharacter(this.mCursor);
                        if ('\uffff' == ch) {
                            done = true;
                            continue block20;
                        }
                        if ('>' == ch) {
                            state = 0;
                            continue block20;
                        }
                        this.mPage.ungetCharacter(this.mCursor);
                        this.mPage.ungetCharacter(this.mCursor);
                        continue block20;
                    }
                    this.mPage.ungetCharacter(this.mCursor);
                    continue block20;
                }
            }
            throw new IllegalStateException("how the fuck did we get in state " + state);
        }
        int end = this.mCursor.getPosition();
        return this.makeString(start, end);
    }

    public Text createStringNode(Page page, int start, int end) {
        return new TextNode(page, start, end);
    }

    public Remark createRemarkNode(Page page, int start, int end) {
        return new RemarkNode(page, start, end);
    }

    public Tag createTagNode(Page page, int start, int end, Vector attributes) {
        return new TagNode(page, start, end, attributes);
    }

    protected void scanJIS(Cursor cursor) throws ParserException {
        boolean done = false;
        int state = 0;
        block5: while (!done) {
            char ch = this.mPage.getCharacter(cursor);
            if ('\uffff' == ch) {
                done = true;
                continue;
            }
            switch (state) {
                case 0: {
                    if ('\u001b' != ch) continue block5;
                    state = 1;
                    continue block5;
                }
                case 1: {
                    if ('(' == ch) {
                        state = 2;
                        continue block5;
                    }
                    state = 0;
                    continue block5;
                }
                case 2: {
                    if ('J' == ch) {
                        done = true;
                        continue block5;
                    }
                    state = 0;
                    continue block5;
                }
            }
            throw new IllegalStateException("state " + state);
        }
    }

    protected Node parseString(int start, boolean quotesmart) throws ParserException {
        boolean done = false;
        char quote = '\u0000';
        while (!done) {
            char ch = this.mPage.getCharacter(this.mCursor);
            if ('\uffff' == ch) {
                done = true;
                continue;
            }
            if ('\u001b' == ch) {
                ch = this.mPage.getCharacter(this.mCursor);
                if ('\uffff' == ch) {
                    done = true;
                    continue;
                }
                if ('$' == ch) {
                    ch = this.mPage.getCharacter(this.mCursor);
                    if ('\uffff' == ch) {
                        done = true;
                        continue;
                    }
                    if ('B' == ch) {
                        this.scanJIS(this.mCursor);
                        continue;
                    }
                    this.mPage.ungetCharacter(this.mCursor);
                    this.mPage.ungetCharacter(this.mCursor);
                    continue;
                }
                this.mPage.ungetCharacter(this.mCursor);
                continue;
            }
            if (quotesmart && '\u0000' == quote && ('\'' == ch || '\"' == ch)) {
                quote = ch;
                continue;
            }
            if (quotesmart && '\u0000' != quote && '\\' == ch) {
                ch = this.mPage.getCharacter(this.mCursor);
                if ('\uffff' == ch || '\\' == ch || ch == quote) continue;
                this.mPage.ungetCharacter(this.mCursor);
                continue;
            }
            if (quotesmart && ch == quote) {
                quote = '\u0000';
                continue;
            }
            if (quotesmart && '\u0000' == quote && ch == '/') {
                ch = this.mPage.getCharacter(this.mCursor);
                if ('\uffff' == ch) {
                    done = true;
                    continue;
                }
                if ('/' == ch) {
                    while ('\uffff' != (ch = this.mPage.getCharacter(this.mCursor)) && '\n' != ch) {
                    }
                    continue;
                }
                if ('*' == ch) {
                    while (true) {
                        if ('\uffff' != (ch = this.mPage.getCharacter(this.mCursor)) && '*' != ch) {
                            continue;
                        }
                        ch = this.mPage.getCharacter(this.mCursor);
                        if (ch == '*') {
                            this.mPage.ungetCharacter(this.mCursor);
                        }
                        if ('\uffff' == ch || '/' == ch) break;
                    }
                    continue;
                }
                this.mPage.ungetCharacter(this.mCursor);
                continue;
            }
            if ('\u0000' != quote || '<' != ch) continue;
            ch = this.mPage.getCharacter(this.mCursor);
            if ('\uffff' == ch) {
                done = true;
                continue;
            }
            if ('/' == ch || Character.isLetter(ch) || '!' == ch || '%' == ch || '?' == ch) {
                done = true;
                this.mPage.ungetCharacter(this.mCursor);
                this.mPage.ungetCharacter(this.mCursor);
                continue;
            }
            this.mPage.ungetCharacter(this.mCursor);
        }
        return this.makeString(start, this.mCursor.getPosition());
    }

    protected Node makeString(int start, int end) throws ParserException {
        int length = end - start;
        Text ret = 0 != length ? this.getNodeFactory().createStringNode(this.getPage(), start, end) : null;
        return ret;
    }

    private void whitespace(Vector attributes, int[] bookmarks) {
        if (bookmarks[1] > bookmarks[0]) {
            attributes.addElement(new PageAttribute(this.mPage, -1, -1, bookmarks[0], bookmarks[1], '\u0000'));
        }
    }

    private void standalone(Vector attributes, int[] bookmarks) {
        attributes.addElement(new PageAttribute(this.mPage, bookmarks[1], bookmarks[2], -1, -1, '\u0000'));
    }

    private void empty(Vector attributes, int[] bookmarks) {
        attributes.addElement(new PageAttribute(this.mPage, bookmarks[1], bookmarks[2], bookmarks[2] + 1, -1, '\u0000'));
    }

    private void naked(Vector attributes, int[] bookmarks) {
        attributes.addElement(new PageAttribute(this.mPage, bookmarks[1], bookmarks[2], bookmarks[3], bookmarks[4], '\u0000'));
    }

    private void single_quote(Vector attributes, int[] bookmarks) {
        attributes.addElement(new PageAttribute(this.mPage, bookmarks[1], bookmarks[2], bookmarks[4] + 1, bookmarks[5], '\''));
    }

    private void double_quote(Vector attributes, int[] bookmarks) {
        attributes.addElement(new PageAttribute(this.mPage, bookmarks[1], bookmarks[2], bookmarks[5] + 1, bookmarks[6], '\"'));
    }

    protected Node parseTag(int start) throws ParserException {
        boolean done = false;
        Vector attributes = new Vector();
        int state = 0;
        int[] bookmarks = new int[8];
        bookmarks[0] = this.mCursor.getPosition();
        block9: while (!done) {
            bookmarks[state + 1] = this.mCursor.getPosition();
            char ch = this.mPage.getCharacter(this.mCursor);
            switch (state) {
                case 0: {
                    if ('\uffff' == ch || '>' == ch || '<' == ch) {
                        if ('<' == ch) {
                            this.mPage.ungetCharacter(this.mCursor);
                            bookmarks[state + 1] = this.mCursor.getPosition();
                        }
                        this.whitespace(attributes, bookmarks);
                        done = true;
                        continue block9;
                    }
                    if (Character.isWhitespace(ch)) continue block9;
                    this.whitespace(attributes, bookmarks);
                    state = 1;
                    continue block9;
                }
                case 1: {
                    if ('\uffff' == ch || '>' == ch || '<' == ch) {
                        if ('<' == ch) {
                            this.mPage.ungetCharacter(this.mCursor);
                            bookmarks[state + 1] = this.mCursor.getPosition();
                        }
                        this.standalone(attributes, bookmarks);
                        done = true;
                        continue block9;
                    }
                    if (Character.isWhitespace(ch)) {
                        bookmarks[6] = bookmarks[2];
                        state = 6;
                        continue block9;
                    }
                    if ('=' != ch) continue block9;
                    state = 2;
                    continue block9;
                }
                case 2: {
                    if ('\uffff' == ch || '>' == ch) {
                        this.empty(attributes, bookmarks);
                        done = true;
                        continue block9;
                    }
                    if ('\'' == ch) {
                        state = 4;
                        bookmarks[4] = bookmarks[3];
                        continue block9;
                    }
                    if ('\"' == ch) {
                        state = 5;
                        bookmarks[5] = bookmarks[3];
                        continue block9;
                    }
                    if (Character.isWhitespace(ch)) continue block9;
                    state = 3;
                    continue block9;
                }
                case 3: {
                    if ('\uffff' == ch || '>' == ch) {
                        this.naked(attributes, bookmarks);
                        done = true;
                        continue block9;
                    }
                    if (!Character.isWhitespace(ch)) continue block9;
                    this.naked(attributes, bookmarks);
                    bookmarks[0] = bookmarks[4];
                    state = 0;
                    continue block9;
                }
                case 4: {
                    if ('\uffff' == ch) {
                        this.single_quote(attributes, bookmarks);
                        done = true;
                        continue block9;
                    }
                    if ('\'' != ch) continue block9;
                    this.single_quote(attributes, bookmarks);
                    bookmarks[0] = bookmarks[5] + 1;
                    state = 0;
                    continue block9;
                }
                case 5: {
                    if ('\uffff' == ch) {
                        this.double_quote(attributes, bookmarks);
                        done = true;
                        continue block9;
                    }
                    if ('\"' != ch) continue block9;
                    this.double_quote(attributes, bookmarks);
                    bookmarks[0] = bookmarks[6] + 1;
                    state = 0;
                    continue block9;
                }
                case 6: {
                    if ('\uffff' == ch) {
                        this.standalone(attributes, bookmarks);
                        bookmarks[0] = bookmarks[6];
                        this.mPage.ungetCharacter(this.mCursor);
                        state = 0;
                        continue block9;
                    }
                    if (Character.isWhitespace(ch)) continue block9;
                    if ('=' == ch) {
                        bookmarks[2] = bookmarks[6];
                        bookmarks[3] = bookmarks[7];
                        state = 2;
                        continue block9;
                    }
                    this.standalone(attributes, bookmarks);
                    bookmarks[0] = bookmarks[6];
                    this.mPage.ungetCharacter(this.mCursor);
                    state = 0;
                    continue block9;
                }
            }
            throw new IllegalStateException("how the fuck did we get in state " + state);
        }
        return this.makeTag(start, this.mCursor.getPosition(), attributes);
    }

    protected Node makeTag(int start, int end, Vector attributes) throws ParserException {
        Tag ret;
        int length = end - start;
        if (0 != length) {
            if (2 > length) {
                return this.makeString(start, end);
            }
            ret = this.getNodeFactory().createTagNode(this.getPage(), start, end, attributes);
        } else {
            ret = null;
        }
        return ret;
    }

    protected Node parseRemark(int start, boolean quotesmart) throws ParserException {
        boolean done = false;
        int state = 0;
        block7: while (!done) {
            char ch = this.mPage.getCharacter(this.mCursor);
            if ('\uffff' == ch) {
                done = true;
                continue;
            }
            switch (state) {
                case 0: {
                    if ('>' == ch) {
                        done = true;
                    }
                    if ('-' == ch) {
                        state = 1;
                        continue block7;
                    }
                    return this.parseString(start, quotesmart);
                }
                case 1: {
                    if ('-' == ch) {
                        ch = this.mPage.getCharacter(this.mCursor);
                        if ('\uffff' == ch) {
                            done = true;
                            continue block7;
                        }
                        if ('>' == ch) {
                            done = true;
                            continue block7;
                        }
                        this.mPage.ungetCharacter(this.mCursor);
                        state = 2;
                        continue block7;
                    }
                    return this.parseString(start, quotesmart);
                }
                case 2: {
                    if ('-' == ch) {
                        state = 3;
                        continue block7;
                    }
                    if ('\uffff' != ch) continue block7;
                    return this.parseString(start, quotesmart);
                }
                case 3: {
                    if ('-' == ch) {
                        state = 4;
                        continue block7;
                    }
                    state = 2;
                    continue block7;
                }
                case 4: {
                    if ('>' == ch) {
                        done = true;
                        continue block7;
                    }
                    if (Character.isWhitespace(ch) || !STRICT_REMARKS && ('-' == ch || '!' == ch)) continue block7;
                    state = 2;
                    continue block7;
                }
            }
            throw new IllegalStateException("how the fuck did we get in state " + state);
        }
        return this.makeRemark(start, this.mCursor.getPosition());
    }

    protected Node makeRemark(int start, int end) throws ParserException {
        Remark ret;
        int length = end - start;
        if (0 != length) {
            if (2 > length) {
                return this.makeString(start, end);
            }
            ret = this.getNodeFactory().createRemarkNode(this.getPage(), start, end);
        } else {
            ret = null;
        }
        return ret;
    }

    protected Node parseJsp(int start) throws ParserException {
        boolean done = false;
        int state = 0;
        int code = 0;
        Vector<PageAttribute> attributes = new Vector<PageAttribute>();
        block33: while (!done) {
            char ch = this.mPage.getCharacter(this.mCursor);
            switch (state) {
                case 0: {
                    switch (ch) {
                        case '%': {
                            state = 1;
                            continue block33;
                        }
                    }
                    done = true;
                    continue block33;
                }
                case 1: {
                    switch (ch) {
                        case '>': 
                        case '\uffff': {
                            done = true;
                            continue block33;
                        }
                        case '=': 
                        case '@': {
                            code = this.mCursor.getPosition();
                            attributes.addElement(new PageAttribute(this.mPage, start + 1, code, -1, -1, '\u0000'));
                            state = 2;
                            continue block33;
                        }
                    }
                    code = this.mCursor.getPosition() - 1;
                    attributes.addElement(new PageAttribute(this.mPage, start + 1, code, -1, -1, '\u0000'));
                    state = 2;
                    continue block33;
                }
                case 2: {
                    switch (ch) {
                        case '>': 
                        case '\uffff': {
                            done = true;
                            continue block33;
                        }
                        case '\"': 
                        case '\'': {
                            state = ch;
                            continue block33;
                        }
                        case '%': {
                            state = 3;
                            continue block33;
                        }
                        case '/': {
                            ch = this.mPage.getCharacter(this.mCursor);
                            if (ch == '/') {
                                do {
                                    if ((ch = this.mPage.getCharacter(this.mCursor)) != '\uffff') continue;
                                    done = true;
                                    continue block33;
                                } while (ch != '\n' && ch != '\r');
                                continue block33;
                            }
                            if (ch == '*') {
                                while (true) {
                                    if ('\uffff' != (ch = this.mPage.getCharacter(this.mCursor)) && '*' != ch) continue;
                                    ch = this.mPage.getCharacter(this.mCursor);
                                    if (ch == '*') {
                                        this.mPage.ungetCharacter(this.mCursor);
                                    }
                                    if ('\uffff' == ch || '/' == ch) break;
                                }
                                continue block33;
                            }
                            this.mPage.ungetCharacter(this.mCursor);
                            continue block33;
                        }
                    }
                    continue block33;
                }
                case 3: {
                    switch (ch) {
                        case '\uffff': {
                            done = true;
                            continue block33;
                        }
                        case '>': {
                            state = 4;
                            done = true;
                            continue block33;
                        }
                    }
                    state = 2;
                    continue block33;
                }
                case 34: {
                    switch (ch) {
                        case '\uffff': {
                            done = true;
                            continue block33;
                        }
                        case '\"': {
                            state = 2;
                            continue block33;
                        }
                    }
                    continue block33;
                }
                case 39: {
                    switch (ch) {
                        case '\uffff': {
                            done = true;
                            continue block33;
                        }
                        case '\'': {
                            state = 2;
                            continue block33;
                        }
                    }
                    continue block33;
                }
            }
            throw new IllegalStateException("how the fuck did we get in state " + state);
        }
        if (4 == state) {
            if (0 == code) {
                throw new IllegalStateException("jsp with no code!");
            }
        } else {
            return this.parseString(start, true);
        }
        state = this.mCursor.getPosition() - 2;
        attributes.addElement(new PageAttribute(this.mPage, code, state, -1, -1, '\u0000'));
        attributes.addElement(new PageAttribute(this.mPage, state, state + 1, -1, -1, '\u0000'));
        return this.makeTag(start, this.mCursor.getPosition(), attributes);
    }

    protected Node parsePI(int start) throws ParserException {
        boolean done = false;
        int state = 0;
        int code = 0;
        Vector<PageAttribute> attributes = new Vector<PageAttribute>();
        block27: while (!done) {
            char ch = this.mPage.getCharacter(this.mCursor);
            switch (state) {
                case 0: {
                    switch (ch) {
                        case '?': {
                            code = this.mCursor.getPosition();
                            attributes.addElement(new PageAttribute(this.mPage, start + 1, code, -1, -1, '\u0000'));
                            state = 1;
                            continue block27;
                        }
                    }
                    done = true;
                    continue block27;
                }
                case 1: {
                    switch (ch) {
                        case '>': 
                        case '\uffff': {
                            done = true;
                            continue block27;
                        }
                        case '\"': 
                        case '\'': {
                            state = ch;
                            continue block27;
                        }
                        case '?': {
                            state = 2;
                            continue block27;
                        }
                    }
                    continue block27;
                }
                case 2: {
                    switch (ch) {
                        case '\uffff': {
                            done = true;
                            continue block27;
                        }
                        case '>': {
                            state = 3;
                            done = true;
                            continue block27;
                        }
                    }
                    state = 1;
                    continue block27;
                }
                case 34: {
                    switch (ch) {
                        case '\uffff': {
                            done = true;
                            continue block27;
                        }
                        case '\"': {
                            state = 1;
                            continue block27;
                        }
                    }
                    continue block27;
                }
                case 39: {
                    switch (ch) {
                        case '\uffff': {
                            done = true;
                            continue block27;
                        }
                        case '\'': {
                            state = 1;
                            continue block27;
                        }
                    }
                    continue block27;
                }
            }
            throw new IllegalStateException("how the fuck did we get in state " + state);
        }
        if (3 == state) {
            if (0 == code) {
                throw new IllegalStateException("processing instruction with no content");
            }
        } else {
            return this.parseString(start, true);
        }
        state = this.mCursor.getPosition() - 2;
        attributes.addElement(new PageAttribute(this.mPage, code, state, -1, -1, '\u0000'));
        attributes.addElement(new PageAttribute(this.mPage, state, state + 1, -1, -1, '\u0000'));
        return this.makeTag(start, this.mCursor.getPosition(), attributes);
    }

    public static void main(String[] args) throws MalformedURLException, ParserException {
        block5: {
            if (0 >= args.length) {
                System.out.println("HTML Lexer v" + Lexer.getVersion() + "\n");
                System.out.println();
                System.out.println("usage: java -jar htmllexer.jar <url>");
            } else {
                try {
                    Node node;
                    ConnectionManager manager = Page.getConnectionManager();
                    Lexer lexer2 = new Lexer(manager.openConnection(args[0]));
                    while (null != (node = lexer2.nextNode(false))) {
                        System.out.println(((Object)node).toString());
                    }
                }
                catch (ParserException pe) {
                    System.out.println(pe.getMessage());
                    if (null == pe.getThrowable()) break block5;
                    System.out.println(pe.getThrowable().getMessage());
                }
            }
        }
    }
}

