/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.http;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.htmlparser.http.ConnectionMonitor;
import org.htmlparser.http.Cookie;
import org.htmlparser.util.ParserException;

public class ConnectionManager {
    protected static Hashtable mDefaultRequestProperties = new Hashtable();
    private static final String[] FOUR_OH_FOUR;
    private static final char[] BASE64_CHAR_TABLE;
    protected Hashtable mRequestProperties;
    protected String mProxyHost;
    protected int mProxyPort;
    protected String mProxyUser;
    protected String mProxyPassword;
    protected String mUser;
    protected String mPassword;
    protected Hashtable mCookieJar;
    protected ConnectionMonitor mMonitor;
    protected boolean mRedirectionProcessingEnabled;
    protected static SimpleDateFormat mFormat;

    public ConnectionManager() {
        this(ConnectionManager.getDefaultRequestProperties());
    }

    public ConnectionManager(Hashtable properties) {
        this.mRequestProperties = properties;
        this.mProxyHost = null;
        this.mProxyPort = 0;
        this.mProxyUser = null;
        this.mProxyPassword = null;
        this.mUser = null;
        this.mPassword = null;
        this.mCookieJar = null;
        this.mMonitor = null;
        this.mRedirectionProcessingEnabled = false;
    }

    public static Hashtable getDefaultRequestProperties() {
        return mDefaultRequestProperties;
    }

    public static void setDefaultRequestProperties(Hashtable properties) {
        mDefaultRequestProperties = properties;
    }

    public Hashtable getRequestProperties() {
        return this.mRequestProperties;
    }

    public void setRequestProperties(Hashtable properties) {
        this.mRequestProperties = properties;
    }

    public String getProxyHost() {
        return this.mProxyHost;
    }

    public void setProxyHost(String host) {
        this.mProxyHost = host;
    }

    public int getProxyPort() {
        return this.mProxyPort;
    }

    public void setProxyPort(int port) {
        this.mProxyPort = port;
    }

    public String getProxyUser() {
        return this.mProxyUser;
    }

    public void setProxyUser(String user) {
        this.mProxyUser = user;
    }

    public String getProxyPassword() {
        return this.mProxyPassword;
    }

    public void setProxyPassword(String password) {
        this.mProxyPassword = password;
    }

    public String getUser() {
        return this.mUser;
    }

    public void setUser(String user) {
        this.mUser = user;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public void setPassword(String password) {
        this.mPassword = password;
    }

    public boolean getCookieProcessingEnabled() {
        return null != this.mCookieJar;
    }

    public void setCookieProcessingEnabled(boolean enable) {
        this.mCookieJar = enable ? (null == this.mCookieJar ? new Hashtable() : this.mCookieJar) : null;
    }

    public void setCookie(Cookie cookie, String domain) {
        Vector<Cookie> cookies;
        if (null != cookie.getDomain()) {
            domain = cookie.getDomain();
        }
        String path = cookie.getPath();
        if (null == this.mCookieJar) {
            this.mCookieJar = new Hashtable();
        }
        if (null != (cookies = (Vector<Cookie>)this.mCookieJar.get(domain))) {
            boolean found = false;
            for (int j = 0; j < cookies.size(); ++j) {
                Cookie probe = (Cookie)cookies.elementAt(j);
                if (!probe.getName().equalsIgnoreCase(cookie.getName())) continue;
                if (probe.getPath().equals(path)) {
                    cookies.setElementAt(cookie, j);
                    found = true;
                    break;
                }
                if (!path.startsWith(probe.getPath())) continue;
                cookies.insertElementAt(cookie, j);
                found = true;
                break;
            }
            if (!found) {
                cookies.addElement(cookie);
            }
        } else {
            cookies = new Vector<Cookie>();
            cookies.addElement(cookie);
            this.mCookieJar.put(domain, cookies);
        }
    }

    public ConnectionMonitor getMonitor() {
        return this.mMonitor;
    }

    public void setMonitor(ConnectionMonitor monitor) {
        this.mMonitor = monitor;
    }

    public boolean getRedirectionProcessingEnabled() {
        return this.mRedirectionProcessingEnabled;
    }

    public void setRedirectionProcessingEnabled(boolean enabled) {
        this.mRedirectionProcessingEnabled = enabled;
    }

    protected String getLocation(HttpURLConnection http) {
        String value;
        String ret = null;
        int i = 0;
        while (null == ret && null != (value = http.getHeaderField(i))) {
            String key = http.getHeaderFieldKey(i);
            if (null != key && key.equalsIgnoreCase("Location")) {
                ret = value;
            }
            ++i;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URLConnection openConnection(URL url) throws ParserException {
        URLConnection ret;
        boolean repeat;
        String set = null;
        String host = null;
        String port = null;
        String host2 = null;
        String port2 = null;
        int repeated = 0;
        do {
            repeat = false;
            try {
                Object var23_20;
                Properties sysprops;
                try {
                    block42: {
                        HttpURLConnection http;
                        if (null != this.getProxyHost() && 0 != this.getProxyPort()) {
                            sysprops = System.getProperties();
                            set = ((Hashtable)sysprops).put("proxySet", "true");
                            host = ((Hashtable)sysprops).put("proxyHost", this.getProxyHost());
                            port = ((Hashtable)sysprops).put("proxyPort", Integer.toString(this.getProxyPort()));
                            host2 = ((Hashtable)sysprops).put("http.proxyHost", this.getProxyHost());
                            port2 = ((Hashtable)sysprops).put("http.proxyPort", Integer.toString(this.getProxyPort()));
                            System.setProperties(sysprops);
                        }
                        if ((ret = url.openConnection()) instanceof HttpURLConnection) {
                            String encoded;
                            String auth;
                            Hashtable properties;
                            http = (HttpURLConnection)ret;
                            if (this.getRedirectionProcessingEnabled()) {
                                http.setInstanceFollowRedirects(false);
                            }
                            if (null != (properties = this.getRequestProperties())) {
                                Enumeration enumeration = properties.keys();
                                while (enumeration.hasMoreElements()) {
                                    String key = (String)enumeration.nextElement();
                                    String value = (String)properties.get(key);
                                    ret.setRequestProperty(key, value);
                                }
                            }
                            if (null != this.getProxyUser() && null != this.getProxyPassword()) {
                                auth = this.getProxyUser() + ":" + this.getProxyPassword();
                                encoded = ConnectionManager.encode(auth.getBytes("ISO-8859-1"));
                                ret.setRequestProperty("Proxy-Authorization", encoded);
                            }
                            if (null != this.getUser() && null != this.getPassword()) {
                                auth = this.getUser() + ":" + this.getPassword();
                                encoded = ConnectionManager.encode(auth.getBytes("ISO-8859-1"));
                                ret.setRequestProperty("Authorization", "Basic " + encoded);
                            }
                            if (this.getCookieProcessingEnabled()) {
                                this.addCookies(ret);
                            }
                            if (null != this.getMonitor()) {
                                this.getMonitor().preConnect(http);
                            }
                        } else {
                            http = null;
                        }
                        try {
                            String uri;
                            int code;
                            ret.connect();
                            if (null == http) break block42;
                            if (null != this.getMonitor()) {
                                this.getMonitor().postConnect(http);
                            }
                            if (this.getCookieProcessingEnabled()) {
                                this.parseCookies(ret);
                            }
                            if (3 == (code = http.getResponseCode()) / 100 && repeated < 20 && null != (uri = this.getLocation(http))) {
                                url = new URL(uri);
                                repeat = true;
                                ++repeated;
                            }
                        }
                        catch (UnknownHostException uhe) {
                            int message = (int)(Math.random() * (double)FOUR_OH_FOUR.length);
                            throw new ParserException(FOUR_OH_FOUR[message], uhe);
                        }
                        catch (IOException ioe) {
                            throw new ParserException(ioe.getMessage(), ioe);
                        }
                    }
                    var23_20 = null;
                    if (null == this.getProxyHost() || 0 == this.getProxyPort()) continue;
                }
                catch (Throwable throwable) {
                    var23_20 = null;
                    if (null != this.getProxyHost() && 0 != this.getProxyPort()) {
                        sysprops = System.getProperties();
                        if (null != set) {
                            ((Hashtable)sysprops).put("proxySet", set);
                        } else {
                            ((Hashtable)sysprops).remove("proxySet");
                        }
                        if (null != host) {
                            ((Hashtable)sysprops).put("proxyHost", host);
                        } else {
                            ((Hashtable)sysprops).remove("proxyHost");
                        }
                        if (null != port) {
                            ((Hashtable)sysprops).put("proxyPort", port);
                        } else {
                            ((Hashtable)sysprops).remove("proxyPort");
                        }
                        if (null != host2) {
                            ((Hashtable)sysprops).put("http.proxyHost", host2);
                        } else {
                            ((Hashtable)sysprops).remove("http.proxyHost");
                        }
                        if (null != port2) {
                            ((Hashtable)sysprops).put("http.proxyPort", port2);
                        } else {
                            ((Hashtable)sysprops).remove("http.proxyPort");
                        }
                        System.setProperties(sysprops);
                    }
                    throw throwable;
                }
                sysprops = System.getProperties();
                if (null != set) {
                    ((Hashtable)sysprops).put("proxySet", set);
                } else {
                    ((Hashtable)sysprops).remove("proxySet");
                }
                if (null != host) {
                    ((Hashtable)sysprops).put("proxyHost", host);
                } else {
                    ((Hashtable)sysprops).remove("proxyHost");
                }
                if (null != port) {
                    ((Hashtable)sysprops).put("proxyPort", port);
                } else {
                    ((Hashtable)sysprops).remove("proxyPort");
                }
                if (null != host2) {
                    ((Hashtable)sysprops).put("http.proxyHost", host2);
                } else {
                    ((Hashtable)sysprops).remove("http.proxyHost");
                }
                if (null != port2) {
                    ((Hashtable)sysprops).put("http.proxyPort", port2);
                } else {
                    ((Hashtable)sysprops).remove("http.proxyPort");
                }
                System.setProperties(sysprops);
            }
            catch (IOException ioe) {
                String msg = "Error in opening a connection to " + url.toExternalForm();
                ParserException ex = new ParserException(msg, ioe);
                throw ex;
            }
        } while (repeat);
        return ret;
    }

    public static final String encode(byte[] array) {
        String ret;
        if (null != array && 0 != array.length) {
            int last = array.length - 1;
            int count = last / 3 + 1 << 2;
            int separators = (count - 1) / 76;
            int length = count + separators;
            char[] encoded = new char[length];
            int index = 0;
            separators = 0;
            for (int i = 0; i <= last; i += 3) {
                int left = last - i;
                int end = left > 1 ? 2 : left;
                int block = 0;
                int r = 16;
                for (int j = 0; j <= end; ++j) {
                    int n = array[i + j];
                    block += (n < 0 ? n + 256 : n) << r;
                    r -= 8;
                }
                encoded[index++] = BASE64_CHAR_TABLE[block >>> 18 & 0x3F];
                encoded[index++] = BASE64_CHAR_TABLE[block >>> 12 & 0x3F];
                encoded[index++] = left > 0 ? BASE64_CHAR_TABLE[block >>> 6 & 0x3F] : 61;
                int n = encoded[index++] = left > 1 ? BASE64_CHAR_TABLE[block & 0x3F] : 61;
                if (0 != (index - separators) % 76 || index >= length) continue;
                encoded[index++] = 10;
                ++separators;
            }
            ret = new String(encoded);
        } else {
            ret = "";
        }
        return ret;
    }

    public String fixSpaces(String url) {
        int index = url.indexOf(32);
        if (-1 != index) {
            int length = url.length();
            StringBuffer buffer = new StringBuffer(length * 3);
            buffer.append(url.substring(0, index));
            for (int i = index; i < length; ++i) {
                char ch = url.charAt(i);
                if (ch == ' ') {
                    buffer.append("%20");
                    continue;
                }
                buffer.append(ch);
            }
            url = buffer.toString();
        }
        return url;
    }

    public URLConnection openConnection(String string) throws ParserException {
        URLConnection ret;
        String prefix = "file://localhost";
        try {
            URL url = new URL(this.fixSpaces(string));
            ret = this.openConnection(url);
        }
        catch (MalformedURLException murle) {
            try {
                File file = new File(string);
                String resource = file.getCanonicalPath();
                StringBuffer buffer = new StringBuffer("file://localhost".length() + resource.length());
                buffer.append("file://localhost");
                if (!resource.startsWith("/")) {
                    buffer.append("/");
                }
                buffer.append(resource);
                URL url = new URL(this.fixSpaces(buffer.toString()));
                ret = this.openConnection(url);
            }
            catch (MalformedURLException murle2) {
                String msg = "Error in opening a connection to " + string;
                ParserException ex = new ParserException(msg, murle2);
                throw ex;
            }
            catch (IOException ioe) {
                String msg = "Error in opening a connection to " + string;
                ParserException ex = new ParserException(msg, ioe);
                throw ex;
            }
        }
        return ret;
    }

    public void addCookies(URLConnection connection) {
        if (null != this.mCookieJar) {
            Vector list = null;
            URL url = connection.getURL();
            String host = url.getHost();
            String path = url.getPath();
            if (0 == path.length()) {
                path = "/";
            }
            if (null != host) {
                list = this.addCookies((Vector)this.mCookieJar.get(host), path, list);
                String domain = this.getDomain(host);
                list = null != domain ? this.addCookies((Vector)this.mCookieJar.get(domain), path, list) : this.addCookies((Vector)this.mCookieJar.get("." + host), path, list);
            }
            if (null != list) {
                connection.setRequestProperty("Cookie", this.generateCookieProperty(list));
            }
        }
    }

    protected Vector addCookies(Vector cookies, String path, Vector list) {
        if (null != cookies) {
            Date now = new Date();
            for (int i = 0; i < cookies.size(); ++i) {
                Cookie cookie = (Cookie)cookies.elementAt(i);
                Date expires = cookie.getExpiryDate();
                if (null != expires && expires.before(now)) {
                    cookies.remove(i);
                    --i;
                    continue;
                }
                if (!path.startsWith(cookie.getPath())) continue;
                if (null == list) {
                    list = new Vector<Cookie>();
                }
                list.addElement(cookie);
            }
        }
        return list;
    }

    protected String getDomain(String host) {
        String ret = null;
        StringTokenizer tokenizer = new StringTokenizer(host, ".");
        int count = tokenizer.countTokens();
        if (3 <= count) {
            int length = host.length();
            boolean ok = false;
            for (int i = 0; i < length && !ok; ++i) {
                char c = host.charAt(i);
                if (Character.isDigit(c) || c == '.') continue;
                ok = true;
            }
            if (ok) {
                String server = tokenizer.nextToken();
                length = server.length();
                ret = host.substring(length);
            }
        }
        return ret;
    }

    protected String generateCookieProperty(Vector cookies) {
        int i;
        String ret = null;
        StringBuffer buffer = new StringBuffer();
        int version2 = 0;
        for (i = 0; i < cookies.size(); ++i) {
            version2 = Math.max(version2, ((Cookie)cookies.elementAt(i)).getVersion());
        }
        if (0 != version2) {
            buffer.append("$Version=\"");
            buffer.append(version2);
            buffer.append("\"");
        }
        for (i = 0; i < cookies.size(); ++i) {
            Cookie cookie = (Cookie)cookies.elementAt(i);
            if (0 != buffer.length()) {
                buffer.append("; ");
            }
            buffer.append(cookie.getName());
            buffer.append(cookie.getName().equals("") ? "" : "=");
            if (0 != version2) {
                buffer.append("\"");
            }
            buffer.append(cookie.getValue());
            if (0 != version2) {
                buffer.append("\"");
            }
            if (0 == version2) continue;
            if (null != cookie.getPath() && 0 != cookie.getPath().length()) {
                buffer.append("; $Path=\"");
                buffer.append(cookie.getPath());
                buffer.append("\"");
            }
            if (null == cookie.getDomain() || 0 == cookie.getDomain().length()) continue;
            buffer.append("; $Domain=\"");
            buffer.append(cookie.getDomain());
            buffer.append("\"");
        }
        if (0 != buffer.length()) {
            ret = buffer.toString();
        }
        return ret;
    }

    public void parseCookies(URLConnection connection) {
        String string = connection.getHeaderField("Set-Cookie");
        if (null != string) {
            Vector<Cookie> cookies = new Vector<Cookie>();
            StringTokenizer tokenizer = new StringTokenizer(string, ";,", true);
            Cookie cookie = null;
            while (tokenizer.hasMoreTokens()) {
                String key;
                String value;
                String name;
                String token = tokenizer.nextToken().trim();
                if (token.equals(";")) continue;
                if (token.equals(",")) {
                    cookie = null;
                    continue;
                }
                int index = token.indexOf(61);
                if (-1 == index) {
                    if (null == cookie) {
                        name = "";
                        value = token;
                        key = name;
                    } else {
                        name = token;
                        value = null;
                        key = name.toLowerCase();
                    }
                } else {
                    name = token.substring(0, index);
                    value = token.substring(index + 1);
                    key = name.toLowerCase();
                }
                if (null == cookie) {
                    try {
                        cookie = new Cookie(name, value);
                        cookies.addElement(cookie);
                        continue;
                    }
                    catch (IllegalArgumentException iae) {
                        break;
                    }
                }
                if (key.equals("expires")) {
                    String comma = tokenizer.nextToken();
                    String rest = tokenizer.nextToken();
                    try {
                        Date date = mFormat.parse(value + comma + rest);
                        cookie.setExpiryDate(date);
                    }
                    catch (ParseException pe) {
                        cookie.setExpiryDate(null);
                    }
                    continue;
                }
                if (key.equals("domain")) {
                    cookie.setDomain(value);
                    continue;
                }
                if (key.equals("path")) {
                    cookie.setPath(value);
                    continue;
                }
                if (key.equals("secure")) {
                    cookie.setSecure(true);
                    continue;
                }
                if (key.equals("comment")) {
                    cookie.setComment(value);
                    continue;
                }
                if (key.equals("version")) {
                    cookie.setVersion(Integer.parseInt(value));
                    continue;
                }
                if (key.equals("max-age")) {
                    Date date = new Date();
                    long then = date.getTime() + (long)(Integer.parseInt(value) * 1000);
                    date.setTime(then);
                    cookie.setExpiryDate(date);
                    continue;
                }
                try {
                    cookie = new Cookie(name, value);
                    cookies.addElement(cookie);
                }
                catch (IllegalArgumentException iae) {
                    // empty catch block
                    break;
                }
            }
            if (0 != cookies.size()) {
                this.saveCookies(cookies, connection);
            }
        }
    }

    protected void saveCookies(Vector list, URLConnection connection) {
        for (int i = 0; i < list.size(); ++i) {
            Cookie cookie = (Cookie)list.elementAt(i);
            String domain = cookie.getDomain();
            if (null == domain) {
                domain = connection.getURL().getHost();
            }
            this.setCookie(cookie, domain);
        }
    }

    static {
        mDefaultRequestProperties.put("User-Agent", "HTMLParser/1.6");
        mDefaultRequestProperties.put("Accept-Encoding", "gzip, deflate");
        FOUR_OH_FOUR = new String[]{"The web site you seek cannot be located, but countless more exist", "You step in the stream, but the water has moved on. This page is not here.", "Yesterday the page existed. Today it does not. The internet is like that.", "That page was so big. It might have been very useful. But now it is gone.", "Three things are certain: death, taxes and broken links. Guess which has occured.", "Chaos reigns within. Reflect, repent and enter the correct URL. Order shall return.", "Stay the patient course. Of little worth is your ire. The page is not found.", "A non-existant URL reduces your expensive computer to a simple stone.", "Many people have visited that page. Today, you are not one of the lucky ones.", "Cutting the wind with a knife. Bookmarking a URL. Both are ephemeral."};
        BASE64_CHAR_TABLE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        mFormat = new SimpleDateFormat("EEE, dd-MMM-yy kk:mm:ss z");
    }
}

