/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml.provider;

import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import org.ehcache.config.Configuration;
import org.ehcache.config.FluentConfigurationBuilder;
import org.ehcache.core.spi.service.ServiceUtils;
import org.ehcache.spi.service.ServiceCreationConfiguration;
import org.ehcache.xml.CoreServiceCreationConfigurationParser;
import org.ehcache.xml.model.ConfigType;

class SimpleCoreServiceCreationConfigurationParser<T, U extends ServiceCreationConfiguration<?, ?>>
implements CoreServiceCreationConfigurationParser {
    private final Class<U> configType;
    private final Function<ConfigType, T> getter;
    private final BiConsumer<ConfigType, T> setter;
    private final Parser<T, U> parser;
    private final Function<U, T> unparser;
    private final BinaryOperator<T> merger;

    SimpleCoreServiceCreationConfigurationParser(Class<U> configType, Function<ConfigType, T> getter, BiConsumer<ConfigType, T> setter, Function<T, U> parser2, Function<U, T> unparser) {
        this(configType, getter, setter, (T config, ClassLoader loader) -> (ServiceCreationConfiguration)parser2.apply(config), unparser, (a, b) -> {
            throw new IllegalStateException();
        });
    }

    SimpleCoreServiceCreationConfigurationParser(Class<U> configType, Function<ConfigType, T> getter, BiConsumer<ConfigType, T> setter, Function<T, U> parser2, Function<U, T> unparser, BinaryOperator<T> merger) {
        this(configType, getter, setter, (T config, ClassLoader loader) -> (ServiceCreationConfiguration)parser2.apply(config), unparser, merger);
    }

    SimpleCoreServiceCreationConfigurationParser(Class<U> configType, Function<ConfigType, T> getter, BiConsumer<ConfigType, T> setter, Parser<T, U> parser2, Function<U, T> unparser) {
        this(configType, getter, setter, parser2, unparser, (a, b) -> {
            throw new IllegalStateException();
        });
    }

    SimpleCoreServiceCreationConfigurationParser(Class<U> configType, Function<ConfigType, T> getter, BiConsumer<ConfigType, T> setter, Parser<T, U> parser2, Function<U, T> unparser, BinaryOperator<T> merger) {
        this.configType = configType;
        this.getter = getter;
        this.setter = setter;
        this.parser = parser2;
        this.unparser = unparser;
        this.merger = merger;
    }

    @Override
    public final FluentConfigurationBuilder<?> parseServiceCreationConfiguration(ConfigType root, ClassLoader classLoader, FluentConfigurationBuilder<?> builder) throws ClassNotFoundException {
        T config = this.getter.apply(root);
        if (config == null) {
            return builder;
        }
        return builder.withService((ServiceCreationConfiguration<?, ?>)this.parser.parse(config, classLoader));
    }

    @Override
    public ConfigType unparseServiceCreationConfiguration(Configuration configuration, ConfigType configType) {
        ServiceCreationConfiguration config = (ServiceCreationConfiguration)ServiceUtils.findSingletonAmongst(this.configType, configuration.getServiceCreationConfigurations());
        if (config == null) {
            return configType;
        }
        T foo = this.getter.apply(configType);
        if (foo == null) {
            this.setter.accept(configType, (ConfigType)this.unparser.apply(config));
        } else {
            this.setter.accept(configType, (ConfigType)this.merger.apply(foo, this.unparser.apply(config)));
        }
        return configType;
    }

    @FunctionalInterface
    static interface Parser<T, U extends ServiceCreationConfiguration<?, ?>> {
        public U parse(T var1, ClassLoader var2) throws ClassNotFoundException;
    }
}

