/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.ehcache.config.Configuration;
import org.ehcache.config.FluentConfigurationBuilder;
import org.ehcache.spi.service.ServiceCreationConfiguration;
import org.ehcache.xml.CacheManagerServiceConfigurationParser;
import org.ehcache.xml.CoreServiceCreationConfigurationParser;
import org.ehcache.xml.model.ConfigType;
import org.ehcache.xml.model.ServiceType;
import org.ehcache.xml.provider.CacheEventDispatcherFactoryConfigurationParser;
import org.ehcache.xml.provider.CacheManagerPersistenceConfigurationParser;
import org.ehcache.xml.provider.DefaultCopyProviderConfigurationParser;
import org.ehcache.xml.provider.DefaultSerializationProviderConfigurationParser;
import org.ehcache.xml.provider.DefaultSizeOfEngineProviderConfigurationParser;
import org.ehcache.xml.provider.OffHeapDiskStoreProviderConfigurationParser;
import org.ehcache.xml.provider.PooledExecutionServiceConfigurationParser;
import org.ehcache.xml.provider.WriteBehindProviderConfigurationParser;
import org.w3c.dom.Element;

public class ServiceCreationConfigurationParser {
    static final Collection<CoreServiceCreationConfigurationParser> CORE_SERVICE_CREATION_CONFIGURATION_PARSERS = Arrays.asList(new DefaultCopyProviderConfigurationParser(), new DefaultSerializationProviderConfigurationParser(), new OffHeapDiskStoreProviderConfigurationParser(), new CacheEventDispatcherFactoryConfigurationParser(), new DefaultSizeOfEngineProviderConfigurationParser(), new CacheManagerPersistenceConfigurationParser(), new PooledExecutionServiceConfigurationParser(), new WriteBehindProviderConfigurationParser());
    private final Map<Class<?>, CacheManagerServiceConfigurationParser<?>> extensionParsers;

    public ServiceCreationConfigurationParser(Map<Class<?>, CacheManagerServiceConfigurationParser<?>> extensionParsers) {
        this.extensionParsers = extensionParsers;
    }

    FluentConfigurationBuilder<?> parseServiceCreationConfiguration(ConfigType configRoot, ClassLoader classLoader, FluentConfigurationBuilder<?> managerBuilder) throws ClassNotFoundException {
        for (CoreServiceCreationConfigurationParser parser2 : CORE_SERVICE_CREATION_CONFIGURATION_PARSERS) {
            managerBuilder = parser2.parseServiceCreationConfiguration(configRoot, classLoader, managerBuilder);
        }
        Map parsers = this.extensionParsers.values().stream().collect(Collectors.toMap(CacheManagerServiceConfigurationParser::getNamespace, Function.identity()));
        for (ServiceType serviceType : configRoot.getService()) {
            Element element = serviceType.getServiceCreationConfiguration();
            URI namespace = URI.create(element.getNamespaceURI());
            CacheManagerServiceConfigurationParser cacheManagerServiceConfigurationParser = (CacheManagerServiceConfigurationParser)parsers.get(namespace);
            if (cacheManagerServiceConfigurationParser == null) {
                throw new IllegalArgumentException("Can't find parser for namespace: " + namespace);
            }
            ServiceCreationConfiguration serviceConfiguration = cacheManagerServiceConfigurationParser.parseServiceCreationConfiguration(element, classLoader);
            managerBuilder = managerBuilder.withService(serviceConfiguration);
        }
        return managerBuilder;
    }

    ConfigType unparseServiceCreationConfiguration(Configuration configuration, ConfigType configType) {
        for (CoreServiceCreationConfigurationParser parser2 : CORE_SERVICE_CREATION_CONFIGURATION_PARSERS) {
            parser2.unparseServiceCreationConfiguration(configuration, configType);
        }
        List<ServiceType> services = configType.getService();
        configuration.getServiceCreationConfigurations().forEach(config -> {
            CacheManagerServiceConfigurationParser<?> parser2 = this.extensionParsers.get(config.getServiceType());
            if (parser2 != null) {
                ServiceType serviceType = new ServiceType();
                Element element = parser2.unparseServiceCreationConfiguration((ServiceCreationConfiguration<?, ?>)config);
                serviceType.setServiceCreationConfiguration(element);
                services.add(serviceType);
            }
        });
        return configType;
    }
}

