/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.shadow.org.terracotta.offheapstore.disk.persistent;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.ehcache.shadow.org.terracotta.offheapstore.Segment;
import org.ehcache.shadow.org.terracotta.offheapstore.concurrent.AbstractConcurrentOffHeapMap;
import org.ehcache.shadow.org.terracotta.offheapstore.disk.persistent.Persistent;
import org.ehcache.shadow.org.terracotta.offheapstore.util.Factory;

public abstract class AbstractPersistentConcurrentOffHeapMap<K, V>
extends AbstractConcurrentOffHeapMap<K, V>
implements Persistent {
    private static final int MAGIC = 1463898952;

    public AbstractPersistentConcurrentOffHeapMap(Factory<? extends Segment<K, V>> segmentFactory) {
        super(segmentFactory);
    }

    public AbstractPersistentConcurrentOffHeapMap(Factory<? extends Segment<K, V>> segmentFactory, int concurrency) {
        super(segmentFactory, concurrency);
    }

    @Override
    public void flush() throws IOException {
        for (Segment s2 : this.segments) {
            ((Persistent)((Object)s2)).flush();
        }
    }

    @Override
    public void persist(ObjectOutput output) throws IOException {
        output.writeInt(1463898952);
        output.writeInt(this.segments.length);
        for (Segment s2 : this.segments) {
            ((Persistent)((Object)s2)).persist(output);
        }
    }

    @Override
    public void close() throws IOException {
        for (Segment s2 : this.segments) {
            ((Persistent)((Object)s2)).close();
        }
    }

    @Override
    public void bootstrap(ObjectInput input) throws IOException {
        for (Segment s2 : this.segments) {
            ((Persistent)((Object)s2)).bootstrap(input);
        }
    }

    protected static int readSegmentCount(ObjectInput input) throws IOException {
        if (input.readInt() != 1463898952) {
            throw new IOException("Wrong magic number");
        }
        return input.readInt();
    }
}

