/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.shadow.org.terracotta.context.extractor;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ehcache.shadow.org.terracotta.context.ContextElement;
import org.ehcache.shadow.org.terracotta.context.annotations.ContextAttribute;
import org.ehcache.shadow.org.terracotta.context.extractor.AttributeGetter;
import org.ehcache.shadow.org.terracotta.context.extractor.DirectAttributeGetter;
import org.ehcache.shadow.org.terracotta.context.extractor.LazyContextElement;
import org.ehcache.shadow.org.terracotta.context.extractor.WeakAttributeGetter;
import org.ehcache.shadow.org.terracotta.context.extractor.WeakFieldAttributeGetter;
import org.ehcache.shadow.org.terracotta.context.extractor.WeakMethodAttributeGetter;

public final class ObjectContextExtractor {
    private ObjectContextExtractor() {
    }

    public static ContextElement extract(Object from) {
        HashMap<? extends String, AttributeGetter<Object>> attributes = new HashMap<String, AttributeGetter<Object>>();
        attributes.putAll(ObjectContextExtractor.extractInstanceAttribute(from));
        attributes.putAll(ObjectContextExtractor.extractMethodAttributes(from));
        attributes.putAll(ObjectContextExtractor.extractFieldAttributes(from));
        return new LazyContextElement(from.getClass(), attributes);
    }

    private static Map<? extends String, ? extends AttributeGetter<Object>> extractInstanceAttribute(Object from) {
        ContextAttribute annotation = from.getClass().getAnnotation(ContextAttribute.class);
        if (annotation == null) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(annotation.value(), new WeakAttributeGetter<Object>(from));
    }

    private static Map<String, AttributeGetter<Object>> extractMethodAttributes(Object from) {
        HashMap<String, AttributeGetter<Object>> attributes = new HashMap<String, AttributeGetter<Object>>();
        for (Method m3 : from.getClass().getMethods()) {
            ContextAttribute annotation;
            if (m3.getParameterTypes().length != 0 || m3.getReturnType() == Void.TYPE || (annotation = m3.getAnnotation(ContextAttribute.class)) == null) continue;
            attributes.put(annotation.value(), new WeakMethodAttributeGetter(from, m3));
        }
        return attributes;
    }

    private static Map<String, AttributeGetter<Object>> extractFieldAttributes(Object from) {
        HashMap<String, AttributeGetter<Object>> attributes = new HashMap<String, AttributeGetter<Object>>();
        for (Class<?> c = from.getClass(); c != null; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                ContextAttribute annotation = f.getAnnotation(ContextAttribute.class);
                if (annotation == null) continue;
                attributes.put(annotation.value(), ObjectContextExtractor.createFieldAttributeGetter(from, f));
            }
        }
        return attributes;
    }

    private static AttributeGetter<Object> createFieldAttributeGetter(Object from, Field f) {
        f.setAccessible(true);
        if (Modifier.isFinal(f.getModifiers())) {
            try {
                return new DirectAttributeGetter<Object>(f.get(from));
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new RuntimeException(ex);
            }
        }
        return new WeakFieldAttributeGetter<Object>(from, f);
    }
}

