/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.heap;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.ehcache.Cache;
import org.ehcache.config.Eviction;
import org.ehcache.config.EvictionAdvisor;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.ResourceType;
import org.ehcache.config.SizedResourcePool;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.core.CacheConfigurationChangeEvent;
import org.ehcache.core.CacheConfigurationChangeListener;
import org.ehcache.core.CacheConfigurationProperty;
import org.ehcache.core.collections.ConcurrentWeakIdentityHashMap;
import org.ehcache.core.config.ExpiryUtils;
import org.ehcache.core.events.NullStoreEventDispatcher;
import org.ehcache.core.events.StoreEventDispatcher;
import org.ehcache.core.events.StoreEventSink;
import org.ehcache.core.exceptions.StorePassThroughException;
import org.ehcache.core.spi.service.StatisticsService;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.events.StoreEventSource;
import org.ehcache.core.spi.store.heap.LimitExceededException;
import org.ehcache.core.spi.store.heap.SizeOfEngine;
import org.ehcache.core.spi.store.heap.SizeOfEngineProvider;
import org.ehcache.core.spi.store.tiering.CachingTier;
import org.ehcache.core.spi.store.tiering.HigherCachingTier;
import org.ehcache.core.spi.time.TimeSource;
import org.ehcache.core.spi.time.TimeSourceService;
import org.ehcache.core.statistics.CachingTierOperationOutcomes;
import org.ehcache.core.statistics.HigherCachingTierOperationOutcomes;
import org.ehcache.core.statistics.OperationObserver;
import org.ehcache.core.statistics.OperationStatistic;
import org.ehcache.core.statistics.StoreOperationOutcomes;
import org.ehcache.core.statistics.TierOperationOutcomes;
import org.ehcache.expiry.ExpiryPolicy;
import org.ehcache.impl.copy.IdentityCopier;
import org.ehcache.impl.copy.SerializingCopier;
import org.ehcache.impl.internal.concurrent.ConcurrentHashMap;
import org.ehcache.impl.internal.concurrent.EvictingConcurrentMap;
import org.ehcache.impl.internal.sizeof.NoopSizeOfEngine;
import org.ehcache.impl.internal.store.BinaryValueHolder;
import org.ehcache.impl.internal.store.heap.Backend;
import org.ehcache.impl.internal.store.heap.KeyCopyBackend;
import org.ehcache.impl.internal.store.heap.OnHeapStrategy;
import org.ehcache.impl.internal.store.heap.SimpleBackend;
import org.ehcache.impl.internal.store.heap.holders.CopiedOnHeapValueHolder;
import org.ehcache.impl.internal.store.heap.holders.OnHeapValueHolder;
import org.ehcache.impl.internal.store.heap.holders.SerializedOnHeapValueHolder;
import org.ehcache.impl.serialization.TransientStateRepository;
import org.ehcache.impl.store.BaseStore;
import org.ehcache.impl.store.DefaultStoreEventDispatcher;
import org.ehcache.impl.store.HashUtils;
import org.ehcache.sizeof.annotations.IgnoreSizeOf;
import org.ehcache.spi.copy.Copier;
import org.ehcache.spi.copy.CopyProvider;
import org.ehcache.spi.resilience.StoreAccessException;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.serialization.StatefulSerializer;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceDependencies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.model.stats.StatisticType;

public class OnHeapStore<K, V>
extends BaseStore<K, V>
implements HigherCachingTier<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(OnHeapStore.class);
    private static final int ATTEMPT_RATIO = 4;
    private static final int EVICTION_RATIO = 2;
    private static final EvictionAdvisor<Object, OnHeapValueHolder<?>> EVICTION_ADVISOR = (key, value) -> value.evictionAdvice();
    private static final Comparator<Store.ValueHolder<?>> EVICTION_PRIORITIZER = (t, u) -> {
        if (t instanceof Fault) {
            return -1;
        }
        if (u instanceof Fault) {
            return 1;
        }
        return Long.signum(u.lastAccessTime() - t.lastAccessTime());
    };
    private static final CachingTier.InvalidationListener<?, ?> NULL_INVALIDATION_LISTENER = (key, valueHolder) -> {};
    static final int SAMPLE_SIZE = 8;
    private final Backend<K, V> map;
    private final Copier<V> valueCopier;
    private final SizeOfEngine sizeOfEngine;
    private final OnHeapStrategy<K, V> strategy;
    private volatile long capacity;
    private final EvictionAdvisor<? super K, ? super V> evictionAdvisor;
    private final ExpiryPolicy<? super K, ? super V> expiry;
    private final TimeSource timeSource;
    private final StoreEventDispatcher<K, V> storeEventDispatcher;
    private volatile CachingTier.InvalidationListener<K, V> invalidationListener = NULL_INVALIDATION_LISTENER;
    private final CacheConfigurationChangeListener cacheConfigurationChangeListener = new CacheConfigurationChangeListener(){

        @Override
        public void cacheConfigurationChange(CacheConfigurationChangeEvent event) {
            if (event.getProperty().equals((Object)CacheConfigurationProperty.UPDATE_SIZE)) {
                ResourcePools updatedPools = (ResourcePools)event.getNewValue();
                ResourcePools configuredPools = (ResourcePools)event.getOldValue();
                if (updatedPools.getPoolForResource(ResourceType.Core.HEAP).getSize() != configuredPools.getPoolForResource(ResourceType.Core.HEAP).getSize()) {
                    LOG.info("Updating size to: {}", (Object)updatedPools.getPoolForResource(ResourceType.Core.HEAP).getSize());
                    SizedResourcePool pool = updatedPools.getPoolForResource(ResourceType.Core.HEAP);
                    if (pool.getUnit() instanceof MemoryUnit) {
                        OnHeapStore.this.capacity = ((MemoryUnit)pool.getUnit()).toBytes(pool.getSize());
                    } else {
                        OnHeapStore.this.capacity = pool.getSize();
                    }
                }
            }
        }
    };
    private final OperationObserver<StoreOperationOutcomes.GetOutcome> getObserver;
    private final OperationObserver<StoreOperationOutcomes.PutOutcome> putObserver;
    private final OperationObserver<StoreOperationOutcomes.RemoveOutcome> removeObserver;
    private final OperationObserver<StoreOperationOutcomes.PutIfAbsentOutcome> putIfAbsentObserver;
    private final OperationObserver<StoreOperationOutcomes.ConditionalRemoveOutcome> conditionalRemoveObserver;
    private final OperationObserver<StoreOperationOutcomes.ReplaceOutcome> replaceObserver;
    private final OperationObserver<StoreOperationOutcomes.ConditionalReplaceOutcome> conditionalReplaceObserver;
    private final OperationObserver<StoreOperationOutcomes.ComputeOutcome> computeObserver;
    private final OperationObserver<StoreOperationOutcomes.ComputeIfAbsentOutcome> computeIfAbsentObserver;
    private final OperationObserver<StoreOperationOutcomes.EvictionOutcome> evictionObserver;
    private final OperationObserver<StoreOperationOutcomes.ExpirationOutcome> expirationObserver;
    private final OperationObserver<CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome> getOrComputeIfAbsentObserver;
    private final OperationObserver<CachingTierOperationOutcomes.InvalidateOutcome> invalidateObserver;
    private final OperationObserver<CachingTierOperationOutcomes.InvalidateAllOutcome> invalidateAllObserver;
    private final OperationObserver<CachingTierOperationOutcomes.InvalidateAllWithHashOutcome> invalidateAllWithHashObserver;
    private final OperationObserver<HigherCachingTierOperationOutcomes.SilentInvalidateOutcome> silentInvalidateObserver;
    private final OperationObserver<HigherCachingTierOperationOutcomes.SilentInvalidateAllOutcome> silentInvalidateAllObserver;
    private final OperationObserver<HigherCachingTierOperationOutcomes.SilentInvalidateAllWithHashOutcome> silentInvalidateAllWithHashObserver;
    private static final Supplier<Boolean> REPLACE_EQUALS_TRUE = () -> Boolean.TRUE;

    public OnHeapStore(Store.Configuration<K, V> config, TimeSource timeSource, Copier<K> keyCopier, Copier<V> valueCopier, SizeOfEngine sizeOfEngine, StoreEventDispatcher<K, V> eventDispatcher, StatisticsService statisticsService) {
        this(config, timeSource, keyCopier, valueCopier, sizeOfEngine, eventDispatcher, ConcurrentHashMap::new, statisticsService);
    }

    public OnHeapStore(Store.Configuration<K, V> config, TimeSource timeSource, Copier<K> keyCopier, Copier<V> valueCopier, SizeOfEngine sizeOfEngine, StoreEventDispatcher<K, V> eventDispatcher, Supplier<EvictingConcurrentMap<?, ?>> backingMapSupplier, StatisticsService statisticsService) {
        super(config, statisticsService);
        Objects.requireNonNull(keyCopier, "keyCopier must not be null");
        this.valueCopier = Objects.requireNonNull(valueCopier, "valueCopier must not be null");
        this.timeSource = Objects.requireNonNull(timeSource, "timeSource must not be null");
        this.sizeOfEngine = Objects.requireNonNull(sizeOfEngine, "sizeOfEngine must not be null");
        SizedResourcePool heapPool = config.getResourcePools().getPoolForResource(ResourceType.Core.HEAP);
        if (heapPool == null) {
            throw new IllegalArgumentException("OnHeap store must be configured with a resource of type 'heap'");
        }
        boolean byteSized = !(this.sizeOfEngine instanceof NoopSizeOfEngine);
        this.capacity = byteSized ? ((MemoryUnit)heapPool.getUnit()).toBytes(heapPool.getSize()) : heapPool.getSize();
        this.evictionAdvisor = config.getEvictionAdvisor() == null ? Eviction.noAdvice() : config.getEvictionAdvisor();
        this.expiry = config.getExpiry();
        this.storeEventDispatcher = eventDispatcher;
        this.map = keyCopier instanceof IdentityCopier ? new SimpleBackend(byteSized, this.castBackend(backingMapSupplier)) : new KeyCopyBackend(byteSized, keyCopier, this.castBackend(backingMapSupplier));
        this.strategy = OnHeapStrategy.strategy(this, this.expiry, timeSource);
        this.getObserver = this.createObserver("get", StoreOperationOutcomes.GetOutcome.class, true);
        this.putObserver = this.createObserver("put", StoreOperationOutcomes.PutOutcome.class, true);
        this.removeObserver = this.createObserver("remove", StoreOperationOutcomes.RemoveOutcome.class, true);
        this.putIfAbsentObserver = this.createObserver("putIfAbsent", StoreOperationOutcomes.PutIfAbsentOutcome.class, true);
        this.conditionalRemoveObserver = this.createObserver("conditionalRemove", StoreOperationOutcomes.ConditionalRemoveOutcome.class, true);
        this.replaceObserver = this.createObserver("replace", StoreOperationOutcomes.ReplaceOutcome.class, true);
        this.conditionalReplaceObserver = this.createObserver("conditionalReplace", StoreOperationOutcomes.ConditionalReplaceOutcome.class, true);
        this.computeObserver = this.createObserver("compute", StoreOperationOutcomes.ComputeOutcome.class, true);
        this.computeIfAbsentObserver = this.createObserver("computeIfAbsent", StoreOperationOutcomes.ComputeIfAbsentOutcome.class, true);
        this.evictionObserver = this.createObserver("eviction", StoreOperationOutcomes.EvictionOutcome.class, false);
        this.expirationObserver = this.createObserver("expiration", StoreOperationOutcomes.ExpirationOutcome.class, false);
        this.getOrComputeIfAbsentObserver = this.createObserver("getOrComputeIfAbsent", CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.class, true);
        this.invalidateObserver = this.createObserver("invalidate", CachingTierOperationOutcomes.InvalidateOutcome.class, true);
        this.invalidateAllObserver = this.createObserver("invalidateAll", CachingTierOperationOutcomes.InvalidateAllOutcome.class, true);
        this.invalidateAllWithHashObserver = this.createObserver("invalidateAllWithHash", CachingTierOperationOutcomes.InvalidateAllWithHashOutcome.class, true);
        this.silentInvalidateObserver = this.createObserver("silentInvalidate", HigherCachingTierOperationOutcomes.SilentInvalidateOutcome.class, true);
        this.silentInvalidateAllObserver = this.createObserver("silentInvalidateAll", HigherCachingTierOperationOutcomes.SilentInvalidateAllOutcome.class, true);
        this.silentInvalidateAllWithHashObserver = this.createObserver("silentInvalidateAllWithHash", HigherCachingTierOperationOutcomes.SilentInvalidateAllWithHashOutcome.class, true);
        HashSet<String> tags = new HashSet<String>(Arrays.asList(this.getStatisticsTag(), "tier"));
        this.registerStatistic("mappings", StatisticType.COUNTER, tags, () -> this.map.mappingCount());
        if (byteSized) {
            this.registerStatistic("occupiedMemory", StatisticType.GAUGE, tags, () -> this.map.byteSize());
        }
    }

    @Override
    protected String getStatisticsTag() {
        return "OnHeap";
    }

    private <L, M> Supplier<EvictingConcurrentMap<L, M>> castBackend(Supplier<EvictingConcurrentMap<?, ?>> backingMap) {
        return backingMap;
    }

    @Override
    public Store.ValueHolder<V> get(K key) throws StoreAccessException {
        this.checkKey(key);
        this.getObserver.begin();
        try {
            OnHeapValueHolder<V> mapping = this.getQuiet(key);
            if (mapping == null) {
                this.getObserver.end(StoreOperationOutcomes.GetOutcome.MISS);
                return null;
            }
            this.strategy.setAccessAndExpiryTimeWhenCallerOutsideLock(key, mapping, this.timeSource.getTimeMillis());
            this.getObserver.end(StoreOperationOutcomes.GetOutcome.HIT);
            return mapping;
        }
        catch (RuntimeException re) {
            throw StorePassThroughException.handleException(re);
        }
    }

    private OnHeapValueHolder<V> getQuiet(K key) throws StoreAccessException {
        try {
            OnHeapValueHolder<V> mapping = this.map.get(key);
            if (mapping == null) {
                return null;
            }
            if (this.strategy.isExpired(mapping)) {
                this.expireMappingUnderLock(key, mapping);
                return null;
            }
            return mapping;
        }
        catch (RuntimeException re) {
            throw StorePassThroughException.handleException(re);
        }
    }

    @Override
    public boolean containsKey(K key) throws StoreAccessException {
        this.checkKey(key);
        return this.getQuiet(key) != null;
    }

    @Override
    public Store.PutStatus put(K key, V value) throws StoreAccessException {
        this.checkKey(key);
        this.checkValue(value);
        this.putObserver.begin();
        long now = this.timeSource.getTimeMillis();
        AtomicReference<StoreOperationOutcomes.PutOutcome> statOutcome = new AtomicReference<StoreOperationOutcomes.PutOutcome>(StoreOperationOutcomes.PutOutcome.NOOP);
        StoreEventSink<K, V> eventSink = this.storeEventDispatcher.eventSink();
        try {
            this.map.compute(key, (mappedKey, mappedValue) -> {
                OnHeapValueHolder<Object> newValue;
                long delta = 0L;
                if (mappedValue != null && mappedValue.isExpired(now)) {
                    delta -= mappedValue.size();
                    mappedValue = null;
                }
                if (mappedValue == null) {
                    newValue = this.newCreateValueHolder(key, value, now, eventSink);
                    if (newValue != null) {
                        delta += newValue.size();
                        statOutcome.set(StoreOperationOutcomes.PutOutcome.PUT);
                    }
                } else {
                    newValue = this.newUpdateValueHolder(key, (OnHeapValueHolder<V>)mappedValue, value, now, eventSink);
                    delta = newValue != null ? (delta += newValue.size() - mappedValue.size()) : (delta -= mappedValue.size());
                    statOutcome.set(StoreOperationOutcomes.PutOutcome.PUT);
                }
                this.updateUsageInBytesIfRequired(delta);
                return newValue;
            });
            this.storeEventDispatcher.releaseEventSink(eventSink);
            this.enforceCapacity();
            StoreOperationOutcomes.PutOutcome outcome = statOutcome.get();
            this.putObserver.end(outcome);
            switch (outcome) {
                case PUT: {
                    return Store.PutStatus.PUT;
                }
                case NOOP: {
                    return Store.PutStatus.NOOP;
                }
            }
            throw new AssertionError((Object)("Unknown enum value " + outcome));
        }
        catch (RuntimeException re) {
            this.storeEventDispatcher.releaseEventSinkAfterFailure(eventSink, re);
            this.putObserver.end(StoreOperationOutcomes.PutOutcome.FAILURE);
            throw StorePassThroughException.handleException(re);
        }
    }

    @Override
    public boolean remove(K key) throws StoreAccessException {
        this.checkKey(key);
        this.removeObserver.begin();
        StoreEventSink<K, V> eventSink = this.storeEventDispatcher.eventSink();
        long now = this.timeSource.getTimeMillis();
        try {
            AtomicReference<StoreOperationOutcomes.RemoveOutcome> statisticOutcome = new AtomicReference<StoreOperationOutcomes.RemoveOutcome>(StoreOperationOutcomes.RemoveOutcome.MISS);
            this.map.computeIfPresent(key, (mappedKey, mappedValue) -> {
                this.updateUsageInBytesIfRequired(-mappedValue.size());
                if (mappedValue.isExpired(now)) {
                    this.fireOnExpirationEvent((K)mappedKey, (Store.ValueHolder<V>)mappedValue, eventSink);
                    return null;
                }
                statisticOutcome.set(StoreOperationOutcomes.RemoveOutcome.REMOVED);
                eventSink.removed((K)mappedKey, (Supplier<V>)mappedValue);
                return null;
            });
            this.storeEventDispatcher.releaseEventSink(eventSink);
            StoreOperationOutcomes.RemoveOutcome outcome = statisticOutcome.get();
            this.removeObserver.end(outcome);
            switch (outcome) {
                case REMOVED: {
                    return true;
                }
                case MISS: {
                    return false;
                }
            }
            throw new AssertionError((Object)("Unknown enum value " + outcome));
        }
        catch (RuntimeException re) {
            this.storeEventDispatcher.releaseEventSinkAfterFailure(eventSink, re);
            throw StorePassThroughException.handleException(re);
        }
    }

    @Override
    public Store.ValueHolder<V> putIfAbsent(K key, V value, Consumer<Boolean> put) throws StoreAccessException {
        this.checkKey(key);
        this.checkValue(value);
        this.putIfAbsentObserver.begin();
        AtomicReference<Object> returnValue = new AtomicReference<Object>(null);
        AtomicBoolean entryActuallyAdded = new AtomicBoolean();
        long now = this.timeSource.getTimeMillis();
        StoreEventSink<K, V> eventSink = this.storeEventDispatcher.eventSink();
        try {
            this.map.compute(key, (mappedKey, mappedValue) -> {
                OnHeapValueHolder<Object> holder;
                long delta = 0L;
                if (mappedValue == null || mappedValue.isExpired(now)) {
                    if (mappedValue != null) {
                        delta -= mappedValue.size();
                        this.fireOnExpirationEvent((K)mappedKey, (Store.ValueHolder<V>)mappedValue, eventSink);
                    }
                    if ((holder = this.newCreateValueHolder(key, value, now, eventSink)) != null) {
                        delta += holder.size();
                    }
                    entryActuallyAdded.set(holder != null);
                } else {
                    returnValue.set(mappedValue);
                    holder = this.strategy.setAccessAndExpiryWhenCallerlUnderLock(key, (OnHeapValueHolder<V>)mappedValue, now, (StoreEventSink<Object, V>)eventSink);
                    if (holder == null) {
                        delta -= mappedValue.size();
                    }
                }
                this.updateUsageInBytesIfRequired(delta);
                return holder;
            });
            this.storeEventDispatcher.releaseEventSink(eventSink);
            if (entryActuallyAdded.get()) {
                this.enforceCapacity();
                this.putIfAbsentObserver.end(StoreOperationOutcomes.PutIfAbsentOutcome.PUT);
            } else {
                this.putIfAbsentObserver.end(StoreOperationOutcomes.PutIfAbsentOutcome.HIT);
            }
        }
        catch (RuntimeException re) {
            this.storeEventDispatcher.releaseEventSinkAfterFailure(eventSink, re);
            throw StorePassThroughException.handleException(re);
        }
        return returnValue.get();
    }

    @Override
    public Store.RemoveStatus remove(K key, V value) throws StoreAccessException {
        this.checkKey(key);
        this.checkValue(value);
        this.conditionalRemoveObserver.begin();
        AtomicReference<Store.RemoveStatus> outcome = new AtomicReference<Store.RemoveStatus>(Store.RemoveStatus.KEY_MISSING);
        StoreEventSink<K, V> eventSink = this.storeEventDispatcher.eventSink();
        try {
            this.map.computeIfPresent(key, (mappedKey, mappedValue) -> {
                long now = this.timeSource.getTimeMillis();
                if (mappedValue.isExpired(now)) {
                    this.updateUsageInBytesIfRequired(-mappedValue.size());
                    this.fireOnExpirationEvent((K)mappedKey, (Store.ValueHolder<V>)mappedValue, eventSink);
                    return null;
                }
                if (value.equals(mappedValue.get())) {
                    this.updateUsageInBytesIfRequired(-mappedValue.size());
                    eventSink.removed((K)mappedKey, (Supplier<V>)mappedValue);
                    outcome.set(Store.RemoveStatus.REMOVED);
                    return null;
                }
                outcome.set(Store.RemoveStatus.KEY_PRESENT);
                OnHeapValueHolder<V> holder = this.strategy.setAccessAndExpiryWhenCallerlUnderLock(key, (OnHeapValueHolder<V>)mappedValue, now, (StoreEventSink<Object, V>)eventSink);
                if (holder == null) {
                    this.updateUsageInBytesIfRequired(-mappedValue.size());
                }
                return holder;
            });
            this.storeEventDispatcher.releaseEventSink(eventSink);
            Store.RemoveStatus removeStatus = outcome.get();
            switch (removeStatus) {
                case REMOVED: {
                    this.conditionalRemoveObserver.end(StoreOperationOutcomes.ConditionalRemoveOutcome.REMOVED);
                    break;
                }
                case KEY_MISSING: 
                case KEY_PRESENT: {
                    this.conditionalRemoveObserver.end(StoreOperationOutcomes.ConditionalRemoveOutcome.MISS);
                    break;
                }
            }
            return removeStatus;
        }
        catch (RuntimeException re) {
            this.storeEventDispatcher.releaseEventSinkAfterFailure(eventSink, re);
            throw StorePassThroughException.handleException(re);
        }
    }

    @Override
    public Store.ValueHolder<V> replace(K key, V value) throws StoreAccessException {
        this.checkKey(key);
        this.checkValue(value);
        this.replaceObserver.begin();
        AtomicReference<Object> returnValue = new AtomicReference<Object>(null);
        StoreEventSink<K, V> eventSink = this.storeEventDispatcher.eventSink();
        try {
            this.map.computeIfPresent(key, (mappedKey, mappedValue) -> {
                long now = this.timeSource.getTimeMillis();
                if (mappedValue.isExpired(now)) {
                    this.updateUsageInBytesIfRequired(-mappedValue.size());
                    this.fireOnExpirationEvent((K)mappedKey, (Store.ValueHolder<V>)mappedValue, eventSink);
                    return null;
                }
                returnValue.set(mappedValue);
                OnHeapValueHolder<Object> holder = this.newUpdateValueHolder(key, (OnHeapValueHolder<V>)mappedValue, value, now, eventSink);
                if (holder != null) {
                    this.updateUsageInBytesIfRequired(holder.size() - mappedValue.size());
                } else {
                    this.updateUsageInBytesIfRequired(-mappedValue.size());
                }
                return holder;
            });
            OnHeapValueHolder valueHolder = returnValue.get();
            this.storeEventDispatcher.releaseEventSink(eventSink);
            this.enforceCapacity();
            if (valueHolder != null) {
                this.replaceObserver.end(StoreOperationOutcomes.ReplaceOutcome.REPLACED);
            } else {
                this.replaceObserver.end(StoreOperationOutcomes.ReplaceOutcome.MISS);
            }
        }
        catch (RuntimeException re) {
            this.storeEventDispatcher.releaseEventSinkAfterFailure(eventSink, re);
            throw StorePassThroughException.handleException(re);
        }
        return returnValue.get();
    }

    @Override
    public Store.ReplaceStatus replace(K key, V oldValue, V newValue) throws StoreAccessException {
        this.checkKey(key);
        this.checkValue(oldValue);
        this.checkValue(newValue);
        this.conditionalReplaceObserver.begin();
        StoreEventSink<K, V> eventSink = this.storeEventDispatcher.eventSink();
        AtomicReference<Store.ReplaceStatus> outcome = new AtomicReference<Store.ReplaceStatus>(Store.ReplaceStatus.MISS_NOT_PRESENT);
        try {
            this.map.computeIfPresent(key, (mappedKey, mappedValue) -> {
                long now = this.timeSource.getTimeMillis();
                Object existingValue = mappedValue.get();
                if (mappedValue.isExpired(now)) {
                    this.fireOnExpirationEvent((K)mappedKey, (Store.ValueHolder<V>)mappedValue, eventSink);
                    this.updateUsageInBytesIfRequired(-mappedValue.size());
                    return null;
                }
                if (oldValue.equals(existingValue)) {
                    outcome.set(Store.ReplaceStatus.HIT);
                    OnHeapValueHolder<Object> holder = this.newUpdateValueHolder(key, (OnHeapValueHolder<V>)mappedValue, newValue, now, eventSink);
                    if (holder != null) {
                        this.updateUsageInBytesIfRequired(holder.size() - mappedValue.size());
                    } else {
                        this.updateUsageInBytesIfRequired(-mappedValue.size());
                    }
                    return holder;
                }
                outcome.set(Store.ReplaceStatus.MISS_PRESENT);
                OnHeapValueHolder<V> holder = this.strategy.setAccessAndExpiryWhenCallerlUnderLock(key, (OnHeapValueHolder<V>)mappedValue, now, (StoreEventSink<Object, V>)eventSink);
                if (holder == null) {
                    this.updateUsageInBytesIfRequired(-mappedValue.size());
                }
                return holder;
            });
            this.storeEventDispatcher.releaseEventSink(eventSink);
            this.enforceCapacity();
            Store.ReplaceStatus replaceStatus = outcome.get();
            switch (replaceStatus) {
                case HIT: {
                    this.conditionalReplaceObserver.end(StoreOperationOutcomes.ConditionalReplaceOutcome.REPLACED);
                    break;
                }
                case MISS_PRESENT: 
                case MISS_NOT_PRESENT: {
                    this.conditionalReplaceObserver.end(StoreOperationOutcomes.ConditionalReplaceOutcome.MISS);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown enum value " + (Object)((Object)replaceStatus)));
                }
            }
            return replaceStatus;
        }
        catch (RuntimeException re) {
            this.storeEventDispatcher.releaseEventSinkAfterFailure(eventSink, re);
            throw StorePassThroughException.handleException(re);
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>> iterator() {
        final Iterator<Map.Entry<K, OnHeapValueHolder<V>>> iterator = this.map.entrySetIterator();
        return new Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>>(){
            private Cache.Entry<K, Store.ValueHolder<V>> prefetched = this.advance();

            @Override
            public boolean hasNext() {
                return this.prefetched != null;
            }

            @Override
            public Cache.Entry<K, Store.ValueHolder<V>> next() throws StoreAccessException {
                if (this.prefetched == null) {
                    throw new NoSuchElementException();
                }
                Cache.Entry next = this.prefetched;
                this.prefetched = this.advance();
                return next;
            }

            private Cache.Entry<K, Store.ValueHolder<V>> advance() {
                while (iterator.hasNext()) {
                    final Map.Entry next = (Map.Entry)iterator.next();
                    if (OnHeapStore.this.strategy.isExpired((OnHeapValueHolder)next.getValue())) {
                        OnHeapStore.this.expireMappingUnderLock(next.getKey(), (Store.ValueHolder)next.getValue());
                        continue;
                    }
                    return new Cache.Entry<K, Store.ValueHolder<V>>(){

                        @Override
                        public K getKey() {
                            return next.getKey();
                        }

                        @Override
                        public Store.ValueHolder<V> getValue() {
                            return (Store.ValueHolder)next.getValue();
                        }
                    };
                }
                return null;
            }
        };
    }

    @Override
    public Store.ValueHolder<V> getOrComputeIfAbsent(K key, Function<K, Store.ValueHolder<V>> source) throws StoreAccessException {
        try {
            Fault fault;
            this.getOrComputeIfAbsentObserver.begin();
            Backend backEnd = this.map;
            OnHeapValueHolder<V> cachedValue = backEnd.get(key);
            long now = this.timeSource.getTimeMillis();
            if (cachedValue == null && (cachedValue = backEnd.putIfAbsent(key, fault = new Fault(() -> (Store.ValueHolder)source.apply(key)))) == null) {
                return this.resolveFault(key, backEnd, now, fault);
            }
            if (!(cachedValue instanceof Fault)) {
                if (cachedValue.isExpired(now)) {
                    this.expireMappingUnderLock(key, cachedValue);
                    fault = new Fault(() -> (Store.ValueHolder)source.apply(key));
                    cachedValue = backEnd.putIfAbsent(key, fault);
                    if (cachedValue == null) {
                        return this.resolveFault(key, backEnd, now, fault);
                    }
                } else {
                    this.strategy.setAccessAndExpiryTimeWhenCallerOutsideLock(key, cachedValue, now);
                }
            }
            this.getOrComputeIfAbsentObserver.end(CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.HIT);
            return this.getValue(cachedValue);
        }
        catch (RuntimeException re) {
            throw StorePassThroughException.handleException(re);
        }
    }

    @Override
    public Store.ValueHolder<V> getOrDefault(K key, Function<K, Store.ValueHolder<V>> source) throws StoreAccessException {
        try {
            Backend<K, V> backEnd = this.map;
            OnHeapValueHolder<V> cachedValue = backEnd.get(key);
            if (cachedValue == null) {
                return source.apply(key);
            }
            if (!(cachedValue instanceof Fault) && cachedValue.isExpired(this.timeSource.getTimeMillis())) {
                this.expireMappingUnderLock(key, cachedValue);
                return null;
            }
            return this.getValue(cachedValue);
        }
        catch (RuntimeException re) {
            throw StorePassThroughException.handleException(re);
        }
    }

    private Store.ValueHolder<V> resolveFault(K key, Backend<K, V> backEnd, long now, Fault<V> fault) throws StoreAccessException {
        try {
            OnHeapValueHolder<V> newValue;
            Store.ValueHolder value = ((Fault)fault).getValueHolder();
            if (value != null) {
                newValue = this.importValueFromLowerTier(key, value, now, backEnd, fault);
                if (newValue == null) {
                    backEnd.remove(key, fault);
                    this.getOrComputeIfAbsentObserver.end(CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.FAULT_FAILED);
                    return value;
                }
            } else {
                backEnd.remove(key, fault);
                this.getOrComputeIfAbsentObserver.end(CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.MISS);
                return null;
            }
            if (backEnd.replace(key, fault, newValue)) {
                this.getOrComputeIfAbsentObserver.end(CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.FAULTED);
                this.updateUsageInBytesIfRequired(newValue.size());
                this.enforceCapacity();
                return newValue;
            }
            AtomicReference invalidatedValue = new AtomicReference();
            backEnd.computeIfPresent(key, (mappedKey, mappedValue) -> {
                this.notifyInvalidation(key, (Store.ValueHolder<V>)mappedValue);
                invalidatedValue.set(mappedValue);
                this.updateUsageInBytesIfRequired(mappedValue.size());
                return null;
            });
            Store.ValueHolder<V> p = this.getValue((Store.ValueHolder)invalidatedValue.get());
            if (p != null) {
                if (p.isExpired(now)) {
                    this.getOrComputeIfAbsentObserver.end(CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.FAULT_FAILED_MISS);
                    return null;
                }
                this.getOrComputeIfAbsentObserver.end(CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.FAULT_FAILED);
                return p;
            }
            this.getOrComputeIfAbsentObserver.end(CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.FAULT_FAILED);
            return newValue;
        }
        catch (Throwable e) {
            backEnd.remove(key, fault);
            throw new StoreAccessException(e);
        }
    }

    private void invalidateInGetOrComputeIfAbsent(Backend<K, V> map, K key, Store.ValueHolder<V> value, Fault<V> fault, long now, Duration expiration) {
        map.computeIfPresent(key, (mappedKey, mappedValue) -> {
            if (mappedValue.equals(fault)) {
                try {
                    this.invalidationListener.onInvalidation(key, this.cloneValueHolder(key, value, now, expiration, false));
                }
                catch (LimitExceededException ex) {
                    throw new AssertionError((Object)"Sizing is not expected to happen.");
                }
                return null;
            }
            return mappedValue;
        });
    }

    @Override
    public void invalidate(K key) throws StoreAccessException {
        this.checkKey(key);
        this.invalidateObserver.begin();
        try {
            AtomicReference<CachingTierOperationOutcomes.InvalidateOutcome> outcome = new AtomicReference<CachingTierOperationOutcomes.InvalidateOutcome>(CachingTierOperationOutcomes.InvalidateOutcome.MISS);
            this.map.computeIfPresent(key, (k, present) -> {
                if (!(present instanceof Fault)) {
                    this.notifyInvalidation(key, (Store.ValueHolder<V>)present);
                    outcome.set(CachingTierOperationOutcomes.InvalidateOutcome.REMOVED);
                }
                this.updateUsageInBytesIfRequired(-present.size());
                return null;
            });
            this.invalidateObserver.end((CachingTierOperationOutcomes.InvalidateOutcome)((Enum)outcome.get()));
        }
        catch (RuntimeException re) {
            throw StorePassThroughException.handleException(re);
        }
    }

    @Override
    public void silentInvalidate(K key, Function<Store.ValueHolder<V>, Void> function) throws StoreAccessException {
        this.checkKey(key);
        this.silentInvalidateObserver.begin();
        try {
            AtomicReference<HigherCachingTierOperationOutcomes.SilentInvalidateOutcome> outcome = new AtomicReference<HigherCachingTierOperationOutcomes.SilentInvalidateOutcome>(HigherCachingTierOperationOutcomes.SilentInvalidateOutcome.MISS);
            this.map.compute(key, (mappedKey, mappedValue) -> {
                long size = 0L;
                OnHeapValueHolder holderToPass = null;
                if (mappedValue != null) {
                    size = mappedValue.size();
                    if (!(mappedValue instanceof Fault)) {
                        holderToPass = mappedValue;
                        outcome.set(HigherCachingTierOperationOutcomes.SilentInvalidateOutcome.REMOVED);
                    }
                }
                function.apply(holderToPass);
                this.updateUsageInBytesIfRequired(-size);
                return null;
            });
            this.silentInvalidateObserver.end((HigherCachingTierOperationOutcomes.SilentInvalidateOutcome)((Enum)outcome.get()));
        }
        catch (RuntimeException re) {
            throw StorePassThroughException.handleException(re);
        }
    }

    @Override
    public void invalidateAll() throws StoreAccessException {
        this.invalidateAllObserver.begin();
        long errorCount = 0L;
        StoreAccessException firstException = null;
        for (K key : this.map.keySet()) {
            try {
                this.invalidate(key);
            }
            catch (StoreAccessException cae) {
                ++errorCount;
                if (firstException != null) continue;
                firstException = cae;
            }
        }
        if (firstException != null) {
            this.invalidateAllObserver.end(CachingTierOperationOutcomes.InvalidateAllOutcome.FAILURE);
            throw new StoreAccessException("Error(s) during invalidation - count is " + errorCount, firstException);
        }
        this.clear();
        this.invalidateAllObserver.end(CachingTierOperationOutcomes.InvalidateAllOutcome.SUCCESS);
    }

    @Override
    public void silentInvalidateAll(BiFunction<K, Store.ValueHolder<V>, Void> biFunction) throws StoreAccessException {
        this.silentInvalidateAllObserver.begin();
        StoreAccessException exception = null;
        long errorCount = 0L;
        for (Object k : this.map.keySet()) {
            try {
                this.silentInvalidate(k, mappedValue -> {
                    biFunction.apply(k, (Store.ValueHolder)mappedValue);
                    return null;
                });
            }
            catch (StoreAccessException e) {
                ++errorCount;
                if (exception != null) continue;
                exception = e;
            }
        }
        if (exception != null) {
            this.silentInvalidateAllObserver.end(HigherCachingTierOperationOutcomes.SilentInvalidateAllOutcome.FAILURE);
            throw new StoreAccessException("silentInvalidateAll failed - error count: " + errorCount, exception);
        }
        this.silentInvalidateAllObserver.end(HigherCachingTierOperationOutcomes.SilentInvalidateAllOutcome.SUCCESS);
    }

    @Override
    public void silentInvalidateAllWithHash(long hash, BiFunction<K, Store.ValueHolder<V>, Void> biFunction) {
        this.silentInvalidateAllWithHashObserver.begin();
        int intHash3 = HashUtils.longHashToInt(hash);
        Collection<Map.Entry<K, OnHeapValueHolder<V>>> removed = this.map.removeAllWithHash(intHash3);
        for (Map.Entry<K, OnHeapValueHolder<V>> entry : removed) {
            biFunction.apply(entry.getKey(), entry.getValue());
        }
        this.silentInvalidateAllWithHashObserver.end(HigherCachingTierOperationOutcomes.SilentInvalidateAllWithHashOutcome.SUCCESS);
    }

    private void notifyInvalidation(K key, Store.ValueHolder<V> p) {
        CachingTier.InvalidationListener<K, V> invalidationListener = this.invalidationListener;
        if (invalidationListener != null) {
            invalidationListener.onInvalidation(key, p);
        }
    }

    @Override
    public void setInvalidationListener(CachingTier.InvalidationListener<K, V> providedInvalidationListener) {
        this.invalidationListener = (key, valueHolder) -> {
            if (!(valueHolder instanceof Fault)) {
                providedInvalidationListener.onInvalidation(key, valueHolder);
            }
        };
    }

    @Override
    public void invalidateAllWithHash(long hash) {
        this.invalidateAllWithHashObserver.begin();
        int intHash3 = HashUtils.longHashToInt(hash);
        Collection<Map.Entry<K, OnHeapValueHolder<V>>> removed = this.map.removeAllWithHash(intHash3);
        for (Map.Entry<K, OnHeapValueHolder<V>> entry : removed) {
            this.notifyInvalidation(entry.getKey(), entry.getValue());
        }
        LOG.debug("CLIENT: onheap store removed all with hash {}", (Object)intHash3);
        this.invalidateAllWithHashObserver.end(CachingTierOperationOutcomes.InvalidateAllWithHashOutcome.SUCCESS);
    }

    private Store.ValueHolder<V> getValue(Store.ValueHolder<V> cachedValue) {
        if (cachedValue instanceof Fault) {
            return ((Fault)cachedValue).getValueHolder();
        }
        return cachedValue;
    }

    private long getSizeOfKeyValuePairs(K key, OnHeapValueHolder<V> holder) throws LimitExceededException {
        return this.sizeOfEngine.sizeof(key, holder);
    }

    @Override
    public Store.ValueHolder<V> getAndCompute(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction) throws StoreAccessException {
        this.checkKey(key);
        this.computeObserver.begin();
        long now = this.timeSource.getTimeMillis();
        StoreEventSink<K, V> eventSink = this.storeEventDispatcher.eventSink();
        try {
            AtomicReference oldValue = new AtomicReference();
            AtomicReference<StoreOperationOutcomes.ComputeOutcome> outcome = new AtomicReference<StoreOperationOutcomes.ComputeOutcome>(StoreOperationOutcomes.ComputeOutcome.MISS);
            this.map.compute(key, (mappedKey, mappedValue) -> {
                OnHeapValueHolder holder;
                Object computedValue;
                Object existingValue;
                long delta = 0L;
                if (mappedValue != null && mappedValue.isExpired(now)) {
                    this.fireOnExpirationEvent((K)mappedKey, (Store.ValueHolder<V>)mappedValue, eventSink);
                    delta -= mappedValue.size();
                    mappedValue = null;
                }
                Object u = existingValue = mappedValue == null ? null : (Object)mappedValue.get();
                if (mappedValue != null) {
                    oldValue.set(mappedValue);
                }
                if ((computedValue = mappingFunction.apply((K)mappedKey, (V)existingValue)) == null) {
                    if (existingValue != null) {
                        eventSink.removed((K)mappedKey, (Supplier<V>)mappedValue);
                        outcome.set(StoreOperationOutcomes.ComputeOutcome.REMOVED);
                        delta -= mappedValue.size();
                    }
                    holder = null;
                } else {
                    this.checkValue(computedValue);
                    if (mappedValue != null) {
                        outcome.set(StoreOperationOutcomes.ComputeOutcome.PUT);
                        holder = this.newUpdateValueHolder(key, (OnHeapValueHolder<V>)mappedValue, (V)computedValue, now, eventSink);
                        delta -= mappedValue.size();
                        if (holder != null) {
                            delta += holder.size();
                        }
                    } else {
                        holder = this.newCreateValueHolder(key, computedValue, now, eventSink);
                        if (holder != null) {
                            outcome.set(StoreOperationOutcomes.ComputeOutcome.PUT);
                            delta += holder.size();
                        }
                    }
                }
                this.updateUsageInBytesIfRequired(delta);
                return holder;
            });
            this.storeEventDispatcher.releaseEventSink(eventSink);
            this.enforceCapacity();
            this.computeObserver.end((StoreOperationOutcomes.ComputeOutcome)((Enum)outcome.get()));
            return (Store.ValueHolder)oldValue.get();
        }
        catch (RuntimeException re) {
            this.storeEventDispatcher.releaseEventSinkAfterFailure(eventSink, re);
            throw StorePassThroughException.handleException(re);
        }
    }

    @Override
    public Store.ValueHolder<V> computeAndGet(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction, Supplier<Boolean> replaceEqual, Supplier<Boolean> invokeWriter) throws StoreAccessException {
        this.checkKey(key);
        this.computeObserver.begin();
        long now = this.timeSource.getTimeMillis();
        StoreEventSink<K, V> eventSink = this.storeEventDispatcher.eventSink();
        try {
            AtomicReference valueHeld = new AtomicReference();
            AtomicReference<StoreOperationOutcomes.ComputeOutcome> outcome = new AtomicReference<StoreOperationOutcomes.ComputeOutcome>(StoreOperationOutcomes.ComputeOutcome.MISS);
            OnHeapValueHolder computeResult = this.map.compute(key, (mappedKey, mappedValue) -> {
                OnHeapValueHolder<Object> holder;
                Object existingValue;
                Object computedValue;
                long delta = 0L;
                if (mappedValue != null && mappedValue.isExpired(now)) {
                    this.fireOnExpirationEvent((K)mappedKey, (Store.ValueHolder<V>)mappedValue, eventSink);
                    delta -= mappedValue.size();
                    mappedValue = null;
                }
                if ((computedValue = mappingFunction.apply((K)mappedKey, (V)(existingValue = mappedValue == null ? null : (Object)mappedValue.get()))) == null) {
                    if (existingValue != null) {
                        eventSink.removed((K)mappedKey, (Supplier<V>)mappedValue);
                        outcome.set(StoreOperationOutcomes.ComputeOutcome.REMOVED);
                        delta -= mappedValue.size();
                    }
                    holder = null;
                } else if (Objects.equals(existingValue, computedValue) && !((Boolean)replaceEqual.get()).booleanValue() && mappedValue != null) {
                    holder = this.strategy.setAccessAndExpiryWhenCallerlUnderLock(key, (OnHeapValueHolder<V>)mappedValue, now, (StoreEventSink<Object, V>)eventSink);
                    outcome.set(StoreOperationOutcomes.ComputeOutcome.HIT);
                    if (holder == null) {
                        valueHeld.set(mappedValue);
                        delta -= mappedValue.size();
                    }
                } else {
                    this.checkValue(computedValue);
                    if (mappedValue != null) {
                        outcome.set(StoreOperationOutcomes.ComputeOutcome.PUT);
                        long expirationTime = mappedValue.expirationTime();
                        holder = this.newUpdateValueHolder(key, (OnHeapValueHolder<V>)mappedValue, (V)computedValue, now, eventSink);
                        delta -= mappedValue.size();
                        if (holder == null) {
                            try {
                                valueHeld.set(this.makeValue(key, computedValue, now, expirationTime, this.valueCopier, false));
                            }
                            catch (LimitExceededException limitExceededException) {}
                        } else {
                            delta += holder.size();
                        }
                    } else {
                        holder = this.newCreateValueHolder(key, computedValue, now, eventSink);
                        if (holder != null) {
                            outcome.set(StoreOperationOutcomes.ComputeOutcome.PUT);
                            delta += holder.size();
                        }
                    }
                }
                this.updateUsageInBytesIfRequired(delta);
                return holder;
            });
            if (computeResult == null && valueHeld.get() != null) {
                computeResult = (OnHeapValueHolder)valueHeld.get();
            }
            this.storeEventDispatcher.releaseEventSink(eventSink);
            this.enforceCapacity();
            this.computeObserver.end((StoreOperationOutcomes.ComputeOutcome)((Enum)outcome.get()));
            return computeResult;
        }
        catch (RuntimeException re) {
            this.storeEventDispatcher.releaseEventSinkAfterFailure(eventSink, re);
            throw StorePassThroughException.handleException(re);
        }
    }

    @Override
    public Store.ValueHolder<V> computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) throws StoreAccessException {
        this.checkKey(key);
        this.computeIfAbsentObserver.begin();
        StoreEventSink<K, V> eventSink = this.storeEventDispatcher.eventSink();
        try {
            long now = this.timeSource.getTimeMillis();
            AtomicReference previousValue = new AtomicReference();
            AtomicReference<StoreOperationOutcomes.ComputeIfAbsentOutcome> outcome = new AtomicReference<StoreOperationOutcomes.ComputeIfAbsentOutcome>(StoreOperationOutcomes.ComputeIfAbsentOutcome.NOOP);
            OnHeapValueHolder<V> computeResult = this.map.compute(key, (mappedKey, mappedValue) -> {
                OnHeapValueHolder<Object> holder;
                long delta = 0L;
                if (mappedValue == null || mappedValue.isExpired(now)) {
                    Object computedValue;
                    if (mappedValue != null) {
                        delta -= mappedValue.size();
                        this.fireOnExpirationEvent((K)mappedKey, (Store.ValueHolder<V>)mappedValue, eventSink);
                    }
                    if ((computedValue = mappingFunction.apply((K)mappedKey)) == null) {
                        holder = null;
                    } else {
                        this.checkValue(computedValue);
                        holder = this.newCreateValueHolder(key, computedValue, now, eventSink);
                        if (holder != null) {
                            outcome.set(StoreOperationOutcomes.ComputeIfAbsentOutcome.PUT);
                            delta += holder.size();
                        }
                    }
                } else {
                    previousValue.set(mappedValue);
                    outcome.set(StoreOperationOutcomes.ComputeIfAbsentOutcome.HIT);
                    holder = this.strategy.setAccessAndExpiryWhenCallerlUnderLock(key, (OnHeapValueHolder<V>)mappedValue, now, (StoreEventSink<Object, V>)eventSink);
                    if (holder == null) {
                        delta -= mappedValue.size();
                    }
                }
                this.updateUsageInBytesIfRequired(delta);
                return holder;
            });
            OnHeapValueHolder previousValueHolder = (OnHeapValueHolder)previousValue.get();
            this.storeEventDispatcher.releaseEventSink(eventSink);
            if (computeResult != null) {
                this.enforceCapacity();
            }
            this.computeIfAbsentObserver.end((StoreOperationOutcomes.ComputeIfAbsentOutcome)((Enum)outcome.get()));
            if (computeResult == null && previousValueHolder != null) {
                return previousValueHolder;
            }
            return computeResult;
        }
        catch (RuntimeException re) {
            this.storeEventDispatcher.releaseEventSinkAfterFailure(eventSink, re);
            throw StorePassThroughException.handleException(re);
        }
    }

    @Override
    public Map<K, Store.ValueHolder<V>> bulkComputeIfAbsent(Set<? extends K> keys, Function<Iterable<? extends K>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> mappingFunction) throws StoreAccessException {
        HashMap<K, Store.ValueHolder<Object>> result = new HashMap<K, Store.ValueHolder<Object>>(keys.size());
        for (K key : keys) {
            Store.ValueHolder<Object> newValue = this.computeIfAbsent(key, k -> {
                Set<Object> keySet = Collections.singleton(k);
                Iterable entries = (Iterable)mappingFunction.apply(keySet);
                Iterator iterator = entries.iterator();
                Map.Entry next = (Map.Entry)iterator.next();
                Object computedKey = next.getKey();
                this.checkKey(computedKey);
                Object computedValue = next.getValue();
                if (computedValue == null) {
                    return null;
                }
                this.checkValue(computedValue);
                return computedValue;
            });
            result.put(key, newValue);
        }
        return result;
    }

    @Override
    public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
        ArrayList<CacheConfigurationChangeListener> configurationChangeListenerList = new ArrayList<CacheConfigurationChangeListener>();
        configurationChangeListenerList.add(this.cacheConfigurationChangeListener);
        return configurationChangeListenerList;
    }

    @Override
    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction) throws StoreAccessException {
        return this.bulkCompute(keys, remappingFunction, REPLACE_EQUALS_TRUE);
    }

    @Override
    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction, Supplier<Boolean> replaceEqual) throws StoreAccessException {
        HashMap<K, Store.ValueHolder<Object>> result = new HashMap<K, Store.ValueHolder<Object>>();
        for (K key : keys) {
            this.checkKey(key);
            Store.ValueHolder<Object> newValue = this.computeAndGet(key, (k, oldValue) -> {
                Set<Map.Entry<Object, Object>> entrySet = Collections.singletonMap(k, oldValue).entrySet();
                Iterable entries = (Iterable)remappingFunction.apply(entrySet);
                Iterator iterator = entries.iterator();
                Map.Entry next = (Map.Entry)iterator.next();
                Object key1 = next.getKey();
                Object value = next.getValue();
                this.checkKey(key1);
                if (value != null) {
                    this.checkValue(value);
                }
                return value;
            }, replaceEqual, () -> false);
            result.put(key, newValue);
        }
        return result;
    }

    @Override
    public StoreEventSource<K, V> getStoreEventSource() {
        return this.storeEventDispatcher;
    }

    void expireMappingUnderLock(K key, Store.ValueHolder<V> value) {
        StoreEventSink<K, V> eventSink = this.storeEventDispatcher.eventSink();
        try {
            this.map.computeIfPresent(key, (mappedKey, mappedValue) -> {
                if (mappedValue.equals(value)) {
                    this.fireOnExpirationEvent(key, value, eventSink);
                    this.updateUsageInBytesIfRequired(-mappedValue.size());
                    return null;
                }
                return mappedValue;
            });
            this.storeEventDispatcher.releaseEventSink(eventSink);
        }
        catch (RuntimeException re) {
            this.storeEventDispatcher.releaseEventSinkAfterFailure(eventSink, re);
            throw re;
        }
    }

    private OnHeapValueHolder<V> newUpdateValueHolder(K key, OnHeapValueHolder<V> oldValue, V newValue, long now, StoreEventSink<K, V> eventSink) {
        Objects.requireNonNull(oldValue);
        Objects.requireNonNull(newValue);
        Duration duration = this.strategy.getUpdateDuration(key, oldValue, newValue);
        if (Duration.ZERO.equals(duration)) {
            eventSink.updated(key, oldValue, newValue);
            eventSink.expired(key, () -> newValue);
            return null;
        }
        long expirationTime = duration == null ? oldValue.expirationTime() : (ExpiryUtils.isExpiryDurationInfinite(duration) ? -1L : ExpiryUtils.getExpirationMillis(now, duration));
        OnHeapValueHolder<V> holder = null;
        try {
            holder = this.makeValue(key, newValue, now, expirationTime, this.valueCopier);
            eventSink.updated(key, oldValue, newValue);
        }
        catch (LimitExceededException e) {
            LOG.warn(e.getMessage());
            eventSink.removed(key, oldValue);
        }
        return holder;
    }

    private OnHeapValueHolder<V> newCreateValueHolder(K key, V value, long now, StoreEventSink<K, V> eventSink) {
        Objects.requireNonNull(value);
        Duration duration = ExpiryUtils.getExpiryForCreation(key, value, this.expiry);
        if (duration.isZero()) {
            return null;
        }
        long expirationTime = ExpiryUtils.isExpiryDurationInfinite(duration) ? -1L : ExpiryUtils.getExpirationMillis(now, duration);
        OnHeapValueHolder<V> holder = null;
        try {
            holder = this.makeValue(key, value, now, expirationTime, this.valueCopier);
            eventSink.created(key, value);
        }
        catch (LimitExceededException e) {
            LOG.warn(e.getMessage());
        }
        return holder;
    }

    private OnHeapValueHolder<V> importValueFromLowerTier(K key, Store.ValueHolder<V> valueHolder, long now, Backend<K, V> backEnd, Fault<V> fault) {
        Duration expiration = this.strategy.getAccessDuration(key, valueHolder);
        if (Duration.ZERO.equals(expiration)) {
            this.invalidateInGetOrComputeIfAbsent(backEnd, key, valueHolder, fault, now, Duration.ZERO);
            this.getOrComputeIfAbsentObserver.end(CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.FAULT_FAILED);
            return null;
        }
        try {
            return this.cloneValueHolder(key, valueHolder, now, expiration, true);
        }
        catch (LimitExceededException e) {
            LOG.warn(e.getMessage());
            this.invalidateInGetOrComputeIfAbsent(backEnd, key, valueHolder, fault, now, expiration);
            this.getOrComputeIfAbsentObserver.end(CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.FAULT_FAILED);
            return null;
        }
    }

    private OnHeapValueHolder<V> cloneValueHolder(K key, Store.ValueHolder<V> valueHolder, long now, Duration expiration, boolean sizingEnabled) throws LimitExceededException {
        V realValue = valueHolder.get();
        boolean evictionAdvice = this.checkEvictionAdvice(key, realValue);
        OnHeapValueHolder clonedValueHolder = this.valueCopier instanceof SerializingCopier ? (valueHolder instanceof BinaryValueHolder && ((BinaryValueHolder)((Object)valueHolder)).isBinaryValueAvailable() ? new SerializedOnHeapValueHolder<V>(valueHolder, ((BinaryValueHolder)((Object)valueHolder)).getBinaryValue(), evictionAdvice, ((SerializingCopier)this.valueCopier).getSerializer(), now, expiration) : new SerializedOnHeapValueHolder<V>(valueHolder, realValue, evictionAdvice, ((SerializingCopier)this.valueCopier).getSerializer(), now, expiration)) : new CopiedOnHeapValueHolder<V>(valueHolder, realValue, evictionAdvice, this.valueCopier, now, expiration);
        if (sizingEnabled) {
            clonedValueHolder.setSize(this.getSizeOfKeyValuePairs(key, clonedValueHolder));
        }
        return clonedValueHolder;
    }

    private OnHeapValueHolder<V> makeValue(K key, V value, long creationTime, long expirationTime, Copier<V> valueCopier) throws LimitExceededException {
        return this.makeValue(key, value, creationTime, expirationTime, valueCopier, true);
    }

    private OnHeapValueHolder<V> makeValue(K key, V value, long creationTime, long expirationTime, Copier<V> valueCopier, boolean size) throws LimitExceededException {
        boolean evictionAdvice = this.checkEvictionAdvice(key, value);
        OnHeapValueHolder valueHolder = valueCopier instanceof SerializingCopier ? new SerializedOnHeapValueHolder<V>(value, creationTime, expirationTime, evictionAdvice, ((SerializingCopier)valueCopier).getSerializer()) : new CopiedOnHeapValueHolder<V>(value, creationTime, expirationTime, evictionAdvice, valueCopier);
        if (size) {
            valueHolder.setSize(this.getSizeOfKeyValuePairs(key, valueHolder));
        }
        return valueHolder;
    }

    private boolean checkEvictionAdvice(K key, V value) {
        try {
            return this.evictionAdvisor.adviseAgainstEviction(key, value);
        }
        catch (Exception e) {
            LOG.error("Exception raised while running eviction advisor - Eviction will assume entry is NOT advised against eviction", e);
            return false;
        }
    }

    private void updateUsageInBytesIfRequired(long delta) {
        this.map.updateUsageInBytesIfRequired(delta);
    }

    protected long byteSized() {
        return this.map.byteSize();
    }

    @SuppressFBWarnings(value={"QF_QUESTIONABLE_FOR_LOOP"})
    protected void enforceCapacity() {
        StoreEventSink<K, V> eventSink = this.storeEventDispatcher.eventSink();
        try {
            int evicted = 0;
            for (int attempts = 0; attempts < 4 && evicted < 2 && this.capacity < this.map.naturalSize(); ++attempts) {
                if (!this.evict(eventSink)) continue;
                ++evicted;
            }
            this.storeEventDispatcher.releaseEventSink(eventSink);
        }
        catch (RuntimeException re) {
            this.storeEventDispatcher.releaseEventSinkAfterFailure(eventSink, re);
            throw re;
        }
    }

    boolean evict(StoreEventSink<K, V> eventSink) {
        this.evictionObserver.begin();
        Random random = new Random();
        Map.Entry<K, OnHeapValueHolder<V>> candidate = this.map.getEvictionCandidate(random, 8, EVICTION_PRIORITIZER, EVICTION_ADVISOR);
        if (candidate == null) {
            candidate = this.map.getEvictionCandidate(random, 8, EVICTION_PRIORITIZER, Eviction.noAdvice());
        }
        if (candidate == null) {
            return false;
        }
        Map.Entry<K, OnHeapValueHolder<V>> evictionCandidate = candidate;
        AtomicBoolean removed = new AtomicBoolean(false);
        this.map.computeIfPresent(evictionCandidate.getKey(), (mappedKey, mappedValue) -> {
            if (mappedValue.equals(evictionCandidate.getValue())) {
                removed.set(true);
                if (!(evictionCandidate.getValue() instanceof Fault)) {
                    eventSink.evicted(evictionCandidate.getKey(), (Supplier)evictionCandidate.getValue());
                    this.invalidationListener.onInvalidation(mappedKey, (Store.ValueHolder)evictionCandidate.getValue());
                }
                this.updateUsageInBytesIfRequired(-mappedValue.size());
                return null;
            }
            return mappedValue;
        });
        if (removed.get()) {
            this.evictionObserver.end(StoreOperationOutcomes.EvictionOutcome.SUCCESS);
            return true;
        }
        this.evictionObserver.end(StoreOperationOutcomes.EvictionOutcome.FAILURE);
        return false;
    }

    void fireOnExpirationEvent(K mappedKey, Store.ValueHolder<V> mappedValue, StoreEventSink<K, V> eventSink) {
        this.expirationObserver.begin();
        this.expirationObserver.end(StoreOperationOutcomes.ExpirationOutcome.SUCCESS);
        eventSink.expired(mappedKey, mappedValue);
        this.invalidationListener.onInvalidation(mappedKey, mappedValue);
    }

    @ServiceDependencies(value={TimeSourceService.class, CopyProvider.class, SizeOfEngineProvider.class})
    public static class Provider
    extends BaseStore.BaseStoreProvider
    implements CachingTier.Provider,
    HigherCachingTier.Provider {
        private final Map<Store<?, ?>, List<Copier<?>>> createdStores = new ConcurrentWeakIdentityHashMap();
        private final Map<OnHeapStore<?, ?>, OperationStatistic<?>[]> tierOperationStatistics = new ConcurrentWeakIdentityHashMap();

        protected ResourceType<SizedResourcePool> getResourceType() {
            return ResourceType.Core.HEAP;
        }

        @Override
        public int rank(Set<ResourceType<?>> resourceTypes, Collection<ServiceConfiguration<?, ?>> serviceConfigs) {
            return resourceTypes.equals(Collections.singleton(this.getResourceType())) ? 1 : 0;
        }

        @Override
        public int rankCachingTier(Set<ResourceType<?>> resourceTypes, Collection<ServiceConfiguration<?, ?>> serviceConfigs) {
            return this.rank(resourceTypes, serviceConfigs);
        }

        public <K, V> OnHeapStore<K, V> createStore(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?, ?> ... serviceConfigs) {
            OnHeapStore<K, V> store = this.createStoreInternal(storeConfig, new DefaultStoreEventDispatcher(storeConfig.getDispatcherConcurrency()), serviceConfigs);
            this.tierOperationStatistics.put(store, new OperationStatistic[]{this.createTranslatedStatistic(store, "get", TierOperationOutcomes.GET_TRANSLATION, "get"), this.createTranslatedStatistic(store, "eviction", TierOperationOutcomes.EVICTION_TRANSLATION, "eviction")});
            return store;
        }

        public <K, V> OnHeapStore<K, V> createStoreInternal(Store.Configuration<K, V> storeConfig, StoreEventDispatcher<K, V> eventDispatcher, ServiceConfiguration<?, ?> ... serviceConfigs) {
            TimeSource timeSource = this.getServiceProvider().getService(TimeSourceService.class).getTimeSource();
            CopyProvider copyProvider = this.getServiceProvider().getService(CopyProvider.class);
            Copier<K> keyCopier = copyProvider.createKeyCopier(storeConfig.getKeyType(), storeConfig.getKeySerializer(), serviceConfigs);
            Copier<V> valueCopier = copyProvider.createValueCopier(storeConfig.getValueType(), storeConfig.getValueSerializer(), serviceConfigs);
            List<Copier> copiers = Arrays.asList(keyCopier, valueCopier);
            SizeOfEngineProvider sizeOfEngineProvider = this.getServiceProvider().getService(SizeOfEngineProvider.class);
            SizeOfEngine sizeOfEngine = sizeOfEngineProvider.createSizeOfEngine(storeConfig.getResourcePools().getPoolForResource(ResourceType.Core.HEAP).getUnit(), serviceConfigs);
            OnHeapStore<K, V> onHeapStore = new OnHeapStore<K, V>(storeConfig, timeSource, keyCopier, valueCopier, sizeOfEngine, eventDispatcher, ConcurrentHashMap::new, this.getServiceProvider().getService(StatisticsService.class));
            this.createdStores.put(onHeapStore, copiers);
            return onHeapStore;
        }

        @Override
        public void releaseStore(Store<?, ?> resource) {
            List<Copier<?>> copiers = this.createdStores.remove(resource);
            if (copiers == null) {
                throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
            }
            OnHeapStore onHeapStore = (OnHeapStore)resource;
            Provider.close(onHeapStore);
            this.getServiceProvider().getService(StatisticsService.class).cleanForNode(onHeapStore);
            this.tierOperationStatistics.remove(onHeapStore);
            CopyProvider copyProvider = this.getServiceProvider().getService(CopyProvider.class);
            for (Copier<?> copier : copiers) {
                try {
                    copyProvider.releaseCopier(copier);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Exception while releasing Copier instance.", e);
                }
            }
        }

        static void close(OnHeapStore<?, ?> onHeapStore) {
            onHeapStore.clear();
        }

        @Override
        public void initStore(Store<?, ?> resource) {
            this.checkResource(resource);
            List<Copier<?>> copiers = this.createdStores.get(resource);
            for (Copier<?> copier : copiers) {
                Serializer serializer;
                if (!(copier instanceof SerializingCopier) || !((serializer = ((SerializingCopier)copier).getSerializer()) instanceof StatefulSerializer)) continue;
                ((StatefulSerializer)serializer).init(new TransientStateRepository());
            }
        }

        private void checkResource(Object resource) {
            if (!this.createdStores.containsKey(resource)) {
                throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
            }
        }

        @Override
        public void stop() {
            try {
                this.createdStores.clear();
            }
            finally {
                super.stop();
            }
        }

        @Override
        public <K, V> CachingTier<K, V> createCachingTier(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?, ?> ... serviceConfigs) {
            OnHeapStore<K, V> cachingTier = this.createStoreInternal(storeConfig, NullStoreEventDispatcher.nullStoreEventDispatcher(), serviceConfigs);
            this.tierOperationStatistics.put(cachingTier, new OperationStatistic[]{this.createTranslatedStatistic(cachingTier, "get", TierOperationOutcomes.GET_OR_COMPUTEIFABSENT_TRANSLATION, "getOrComputeIfAbsent"), this.createTranslatedStatistic(cachingTier, "eviction", TierOperationOutcomes.EVICTION_TRANSLATION, "eviction")});
            return cachingTier;
        }

        @Override
        public void releaseCachingTier(CachingTier<?, ?> resource) {
            this.checkResource(resource);
            try {
                resource.invalidateAll();
            }
            catch (StoreAccessException e) {
                LOG.warn("Invalidation failure while releasing caching tier", e);
            }
            this.releaseStore((Store)((Object)resource));
        }

        @Override
        public void initCachingTier(CachingTier<?, ?> resource) {
            this.checkResource(resource);
        }

        @Override
        public <K, V> HigherCachingTier<K, V> createHigherCachingTier(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?, ?> ... serviceConfigs) {
            OnHeapStore<K, V> higherCachingTier = this.createStoreInternal(storeConfig, new DefaultStoreEventDispatcher(storeConfig.getDispatcherConcurrency()), serviceConfigs);
            this.tierOperationStatistics.put(higherCachingTier, new OperationStatistic[]{this.createTranslatedStatistic(higherCachingTier, "get", TierOperationOutcomes.GET_OR_COMPUTEIFABSENT_TRANSLATION, "getOrComputeIfAbsent"), this.createTranslatedStatistic(higherCachingTier, "eviction", TierOperationOutcomes.EVICTION_TRANSLATION, "eviction")});
            return higherCachingTier;
        }

        @Override
        public void releaseHigherCachingTier(HigherCachingTier<?, ?> resource) {
            this.releaseCachingTier(resource);
        }

        @Override
        public void initHigherCachingTier(HigherCachingTier<?, ?> resource) {
            this.checkResource(resource);
        }
    }

    private static class Fault<V>
    extends OnHeapValueHolder<V> {
        private static final int FAULT_ID = -1;
        @IgnoreSizeOf
        private final Supplier<Store.ValueHolder<V>> source;
        private Store.ValueHolder<V> value;
        private Throwable throwable;
        private boolean complete;

        public Fault(Supplier<Store.ValueHolder<V>> source) {
            super(-1L, 0L, true);
            this.source = source;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void complete(Store.ValueHolder<V> value) {
            Fault fault = this;
            synchronized (fault) {
                this.value = value;
                this.complete = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Store.ValueHolder<V> getValueHolder() {
            Fault fault = this;
            synchronized (fault) {
                if (!this.complete) {
                    try {
                        this.complete(this.source.get());
                    }
                    catch (Throwable e) {
                        this.fail(e);
                    }
                }
            }
            return this.throwOrReturn();
        }

        @Override
        public long getId() {
            throw new UnsupportedOperationException("You should NOT call that?!");
        }

        private Store.ValueHolder<V> throwOrReturn() {
            if (this.throwable != null) {
                if (this.throwable instanceof RuntimeException) {
                    throw (RuntimeException)this.throwable;
                }
                throw new RuntimeException("Faulting from repository failed", this.throwable);
            }
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fail(Throwable t) {
            Fault fault = this;
            synchronized (fault) {
                this.throwable = t;
                this.complete = true;
                this.notifyAll();
            }
            this.throwOrReturn();
        }

        @Override
        public V get() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long creationTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setExpirationTime(long expirationTime) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long expirationTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isExpired(long expirationTime) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long lastAccessTime() {
            return Long.MAX_VALUE;
        }

        @Override
        public void setLastAccessTime(long lastAccessTime) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSize(long size) {
            throw new UnsupportedOperationException("Faults should not be sized");
        }

        @Override
        public long size() {
            return 0L;
        }

        @Override
        public String toString() {
            return "[Fault : " + (this.complete ? (this.throwable == null ? String.valueOf(this.value) : this.throwable.getMessage()) : "???") + "]";
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }
    }
}

